"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exec = void 0;
const child_process_1 = require("child_process");
/**
 * Our own execute function which doesn't use shells and strings.
 */
function exec(commandLine, options = {}) {
    const proc = (0, child_process_1.spawnSync)(commandLine[0], commandLine.slice(1), {
        stdio: ['ignore', 'pipe', options.verbose ? 'inherit' : 'pipe'],
        env: {
            ...process.env,
            ...options.env,
        },
        cwd: options.cwd,
    });
    if (proc.error) {
        throw proc.error;
    }
    // cfn-guard uses 5 when there are policy validation failures
    if (proc.status !== 0 && proc.status !== 5) {
        if (process.stderr) { // will be 'null' in verbose mode
            process.stderr.write(proc.stderr);
        }
        throw new Error(`Command exited with ${proc.status ? `status ${proc.status}` : `signal ${proc.signal}`}`);
    }
    const output = proc.stdout.toString('utf-8').trim();
    try {
        if (options.json) {
            if (output.length === 0) {
                return {};
            }
            return JSON.parse(output);
        }
        return output;
    }
    catch (e) {
        // eslint-disable-next-line no-console
        console.error('Not JSON: ' + output);
        throw new Error('Command output is not JSON');
    }
}
exports.exec = exec;
//# sourceMappingURL=data:application/json;base64,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