"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cxapi = require("@aws-cdk/cx-api");
const hosted_zone_1 = require("./hosted-zone");
const DEFAULT_HOSTED_ZONE = {
    Id: '/hostedzone/DUMMY',
    Name: 'example.com',
};
/**
 * Context provider that will lookup the Hosted Zone ID for the given arguments
 */
class HostedZoneProvider {
    constructor(context, props) {
        this.provider = new cdk.ContextProvider(context, cxapi.HOSTED_ZONE_PROVIDER, props);
    }
    /**
     * This method calls `findHostedZone` and returns the imported hosted zone
     */
    findAndImport(scope, id) {
        return hosted_zone_1.HostedZone.import(scope, id, this.findHostedZone());
    }
    /**
     * Return the hosted zone meeting the filter
     */
    findHostedZone() {
        const zone = this.provider.getValue(DEFAULT_HOSTED_ZONE);
        // CDK handles the '.' at the end, so remove it here
        if (zone.Name.endsWith('.')) {
            zone.Name = zone.Name.substring(0, zone.Name.length - 1);
        }
        return {
            hostedZoneId: zone.Id,
            zoneName: zone.Name,
        };
    }
}
exports.HostedZoneProvider = HostedZoneProvider;
//# sourceMappingURL=data:application/json;base64,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