"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Route53 requires the record names are specified as fully qualified names, but this
 * forces lots of redundant work on the user (repeating the zone name over and over).
 * This function allows the user to be lazier and offers a nicer experience, by
 * qualifying relative names appropriately:
 *
 * @param providedName the user-specified name of the record.
 * @param zoneName   the fully-qualified name of the zone the record will be created in.
 *
 * @returns <ul>
 *        <li>If +providedName+ ends with a +.+, use it as-is</li>
 *        <li>If +providedName+ ends with +zoneName+, append a trailing +.+</li>
 *        <li>Otherwise, append +.+, +zoneName+ and a trailing +.+</li>
 *      </ul>
 */
function determineFullyQualifiedDomainName(providedName, hostedZone) {
    if (providedName.endsWith('.')) {
        return providedName;
    }
    const suffix = `.${hostedZone.zoneName}`;
    if (providedName.endsWith(suffix)) {
        return `${providedName}.`;
    }
    return `${providedName}${suffix}.`;
}
exports.determineFullyQualifiedDomainName = determineFullyQualifiedDomainName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3V0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBOzs7Ozs7Ozs7Ozs7OztHQWNHO0FBQ0gsU0FBZ0IsaUNBQWlDLENBQUMsWUFBb0IsRUFBRSxVQUF1QjtJQUM3RixJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFDOUIsT0FBTyxZQUFZLENBQUM7S0FDckI7SUFFRCxNQUFNLE1BQU0sR0FBRyxJQUFJLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUN6QyxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDakMsT0FBTyxHQUFHLFlBQVksR0FBRyxDQUFDO0tBQzNCO0lBRUQsT0FBTyxHQUFHLFlBQVksR0FBRyxNQUFNLEdBQUcsQ0FBQztBQUNyQyxDQUFDO0FBWEQsOEVBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJSG9zdGVkWm9uZSB9IGZyb20gJy4uL2hvc3RlZC16b25lLXJlZic7XG5cbi8qKlxuICogUm91dGU1MyByZXF1aXJlcyB0aGUgcmVjb3JkIG5hbWVzIGFyZSBzcGVjaWZpZWQgYXMgZnVsbHkgcXVhbGlmaWVkIG5hbWVzLCBidXQgdGhpc1xuICogZm9yY2VzIGxvdHMgb2YgcmVkdW5kYW50IHdvcmsgb24gdGhlIHVzZXIgKHJlcGVhdGluZyB0aGUgem9uZSBuYW1lIG92ZXIgYW5kIG92ZXIpLlxuICogVGhpcyBmdW5jdGlvbiBhbGxvd3MgdGhlIHVzZXIgdG8gYmUgbGF6aWVyIGFuZCBvZmZlcnMgYSBuaWNlciBleHBlcmllbmNlLCBieVxuICogcXVhbGlmeWluZyByZWxhdGl2ZSBuYW1lcyBhcHByb3ByaWF0ZWx5OlxuICpcbiAqIEBwYXJhbSBwcm92aWRlZE5hbWUgdGhlIHVzZXItc3BlY2lmaWVkIG5hbWUgb2YgdGhlIHJlY29yZC5cbiAqIEBwYXJhbSB6b25lTmFtZSAgIHRoZSBmdWxseS1xdWFsaWZpZWQgbmFtZSBvZiB0aGUgem9uZSB0aGUgcmVjb3JkIHdpbGwgYmUgY3JlYXRlZCBpbi5cbiAqXG4gKiBAcmV0dXJucyA8dWw+XG4gKiAgICAgICAgPGxpPklmICtwcm92aWRlZE5hbWUrIGVuZHMgd2l0aCBhICsuKywgdXNlIGl0IGFzLWlzPC9saT5cbiAqICAgICAgICA8bGk+SWYgK3Byb3ZpZGVkTmFtZSsgZW5kcyB3aXRoICt6b25lTmFtZSssIGFwcGVuZCBhIHRyYWlsaW5nICsuKzwvbGk+XG4gKiAgICAgICAgPGxpPk90aGVyd2lzZSwgYXBwZW5kICsuKywgK3pvbmVOYW1lKyBhbmQgYSB0cmFpbGluZyArLis8L2xpPlxuICogICAgICA8L3VsPlxuICovXG5leHBvcnQgZnVuY3Rpb24gZGV0ZXJtaW5lRnVsbHlRdWFsaWZpZWREb21haW5OYW1lKHByb3ZpZGVkTmFtZTogc3RyaW5nLCBob3N0ZWRab25lOiBJSG9zdGVkWm9uZSk6IHN0cmluZyB7XG4gIGlmIChwcm92aWRlZE5hbWUuZW5kc1dpdGgoJy4nKSkge1xuICAgIHJldHVybiBwcm92aWRlZE5hbWU7XG4gIH1cblxuICBjb25zdCBzdWZmaXggPSBgLiR7aG9zdGVkWm9uZS56b25lTmFtZX1gO1xuICBpZiAocHJvdmlkZWROYW1lLmVuZHNXaXRoKHN1ZmZpeCkpIHtcbiAgICByZXR1cm4gYCR7cHJvdmlkZWROYW1lfS5gO1xuICB9XG5cbiAgcmV0dXJuIGAke3Byb3ZpZGVkTmFtZX0ke3N1ZmZpeH0uYDtcbn1cbiJdfQ==