"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const route53_generated_1 = require("../route53.generated");
const _util_1 = require("./_util");
/**
 * A Route53 alias record
 */
class AliasRecord extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new route53_generated_1.CfnRecordSet(this, 'Resource', {
            hostedZoneId: props.zone.hostedZoneId,
            name: _util_1.determineFullyQualifiedDomainName(props.recordName, props.zone),
            type: 'A',
            aliasTarget: props.target.asAliasRecordTarget()
        });
    }
}
exports.AliasRecord = AliasRecord;
//# sourceMappingURL=data:application/json;base64,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