import { Construct } from '@aws-cdk/cdk';
import { IHostedZone } from '../hosted-zone-ref';
export interface CnameRecordProps {
    /**
     * The hosted zone in which to define the new TXT record.
     */
    readonly zone: IHostedZone;
    /**
     * The domain name for this record set.
     */
    readonly recordName: string;
    /**
     * The value for this record set.
     */
    readonly recordValue: string;
    /**
     * The resource record cache time to live (TTL) in seconds.
     *
     * @default 1800 seconds
     */
    readonly ttl?: number;
}
/**
 * A DNS CNAME record
 */
export declare class CnameRecord extends Construct {
    constructor(scope: Construct, id: string, props: CnameRecordProps);
}
