"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Validates a zone name is valid by Route53 specifc naming rules,
 * and that there is no trailing dot in the name.
 *
 * @param zoneName the zone name to be validated.
 * @returns +zoneName+
 * @throws ValidationError if the name is not valid.
 */
function validateZoneName(zoneName) {
    if (zoneName.endsWith('.')) {
        throw new ValidationError('zone name must not end with a trailing dot');
    }
    if (zoneName.length > 255) {
        throw new ValidationError('zone name cannot be more than 255 bytes long');
    }
    if (zoneName.split('.').find(label => label.length > 63)) {
        throw new ValidationError('zone name labels cannot be more than 63 bytes long');
    }
    if (!zoneName.match(/^[a-z0-9!"#$%&'()*+,/:;<=>?@[\\\]^_`{|}~.-]+$/i)) {
        throw new ValidationError('zone names can only contain a-z, 0-9, -, ! " # $ % & \' ( ) * + , - / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ .');
    }
}
exports.validateZoneName = validateZoneName;
class ValidationError extends Error {
    constructor(message) {
        super(message);
    }
}
//# sourceMappingURL=data:application/json;base64,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