"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'test alias record'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        const zone = new lib_1.PublicHostedZone(stack, 'HostedZone', { zoneName: 'test.public' });
        const target = {
            asAliasRecordTarget: () => {
                return {
                    hostedZoneId: 'Z2P70J7EXAMPLE',
                    dnsName: 'foo.example.com'
                };
            }
        };
        // WHEN
        new lib_1.AliasRecord(zone, 'Alias', {
            zone,
            recordName: '_foo',
            target
        });
        // THEN - stack contains a record set
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Route53::RecordSet', {
            Name: '_foo.test.public.',
            HostedZoneId: {
                Ref: 'HostedZoneDB99F866'
            },
            Type: 'A',
            AliasTarget: {
                HostedZoneId: 'Z2P70J7EXAMPLE',
                DNSName: 'foo.example.com',
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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