from .mixin import TemplateRendererMixin
from .__version__ import get_version
from argparse import ArgumentParser


class BareMakefile(TemplateRendererMixin):

    @classmethod
    def template(cls) -> str:
        return f"# Generated by fmojinja version {get_version()}" + """
{% set rx_val = right_extension.strip(".") | upper -%}
{% set lx_val = left_extension.strip(".") | upper -%}
{{ rx_val }} := $(wildcard *{{ right_extension }})
{{ lx_val }} := $({{ rx_val }}:%{{ right_extension }}=%{{ left_extension }})

.PHONY: run
run: $({{ lx_val }})

%{{ left_extension }}: %{{ right_extension }}
\t{{ " ".join(CMD) }}

.PHONY: clean
clean:
\t rm *{{ lx_val }}

"""

    @classmethod
    def set_arguments(cls, p: ArgumentParser) -> ArgumentParser:
        p = super(BareMakefile, cls).set_arguments(p)
        p.add_argument("-lx", "--left-extension", required=True, help="e.g. .ajf")
        p.add_argument("-rx", "--right-extension", required=True, help="e.g. .pdb")
        p.add_argument("CMD", default="echo $@ will be made from $<", help="command", nargs="+")
        return p


if __name__ == '__main__':
    p = ArgumentParser()
    p = BareMakefile.set_arguments(p)
    a = p.parse_args()
    BareMakefile.main_proc(**vars(a))
