from ...mixin import TemplateRendererMixin
from ...__version__ import get_version
from argparse import ArgumentParser
from pathlib import Path


class MaskPdb(TemplateRendererMixin):

    @classmethod
    def template(cls) -> str:
        return f"# Generated by fmojinja version {get_version()}" + """
PREFIX := {{ prefix }}
PRMTOP := {{ prmtop }}
TRAJIN :={% for path in trajin %} {{ path }}{% endfor %}
MASK := {{ mask if mask else "" }}
CPPTRAJIN := $(addsuffix .cpptrajin, $(addprefix $(PREFIX), $(basename $(notdir $(TRAJIN)))))
PDB := $(CPPTRAJIN:%.cpptrajin=%.pdb)

.PHONY: run
run: gen $(PDB)

.PHONY: gen
gen: $(PREFIX) $(CPPTRAJIN)

$(PREFIX):
\tmkdir $(PREFIX)

%.pdb: %.cpptrajin
\tcpptraj < $< | tee $(<:%.cpptrajin=%.cpptrajout)
\tmv $@.1 $@

define expr
$(PREFIX)$(basename $(notdir $(1))).cpptrajin: $(1)
\techo parm $(PRMTOP) > $(PREFIX)$(basename $(notdir $(1))).cpptrajin
\techo trajin $(1) >> $(PREFIX)$(basename $(notdir $(1))).cpptrajin
\techo reference $(1) >> $(PREFIX)$(basename $(notdir $(1))).cpptrajin
\techo 'mask "$(MASK)" maskpdb $(PREFIX)$(basename $(notdir $(1))).pdb' >> $(PREFIX)$(basename $(notdir $(1))).cpptrajin
\techo run >>$(PREFIX)$(basename $(notdir $(1))).cpptrajin
endef
$(foreach i, $(TRAJIN), $(eval $(call expr, $(i))))


.PHONY: clean
clean:
\trm $(PREFIX)*

"""

    @classmethod
    def set_arguments(cls, p: ArgumentParser) -> ArgumentParser:
        p = super(MaskPdb, cls).set_arguments(p)
        p.add_argument("-P", "--prefix", default="maskpdb/")
        p.add_argument("-p", "--prmtop", type=Path, required=True)
        p.add_argument("-y", "--trajin", type=Path, nargs="+", required=True)
        p.add_argument("-m", "--mask", help="e.g. \"(:1-390<:8.0)|@NA\"")
        return p
