from ..mixin import CpptrajMixin
from ..__version__ import get_version


class Snapshot(CpptrajMixin):

    @classmethod
    def template(cls) -> str:
        return f"# Generated by fmojinja version {get_version()}" + """
parm {{ parm }}
{%- for path in trajin %}
trajin {{ path }} lastframe
{%- endfor %}
autoimage anchor {{ anchor }} origin
align {{ align_mask }} {{ "ref {}".format(ref) if ref else "first" }}
{% for path in trajin %}
trajout {{ prefix ~ path.stem }}.rst onlyframes {{ loop.index }}
{% endfor %}
run
"""

    @classmethod
    def set_arguments(cls, p):
        p.add_argument("-P", "--prefix", default="snapshots/")
        return super(cls, cls).set_arguments(p)
