from jinja2 import Environment
from ..mixin import TemplateRendererMixin
from ..jinja_filters import digit2letter
from ..__version__ import get_version


class Split(TemplateRendererMixin):

    @classmethod
    def template(cls) -> str:
        return f"# Generated by fmojinja version {get_version()}" + """
parm {{ prmtop }}
trajin {{ trajin }}
{% for i in range(nframes // offset) %}
{%- set start = i * offset + 1 %}
{%- set end = (i + 1) * offset %}
trajout {{ prefix }}.{{ (end * time_per_frame) | int | digit2letter }}.{{ (end * time_per_frame) | int }}.crd onlyframes {{ start }}-{{ end }}
{%- endfor %}
{% if nframes % offset != 0 %}
{%- set start = (nframes // offset) * offset  + 1 %}
{%- set end = nframes -%}
trajout {{ prefix }}.{{ (end * time_per_frame) | int | digit2letter }}.{{ (end * time_per_frame) | int }}.crd onlyframes {{ start }}-{{ end }}
{%- endif %}
run


"""

    @classmethod
    def render(cls, **kwargs) -> str:
        env = Environment()
        env.filters["digit2letter"] = digit2letter
        return env.from_string(cls.template()).render(**kwargs)

    @classmethod
    def set_arguments(cls, p):
        p.add_argument("-P", "--prefix", default="split/data")
        p.add_argument("-p", "--prmtop", required=True)
        p.add_argument("-y", "--trajin", required=True)
        p.add_argument("--offset", default=10, type=int)
        p.add_argument("-nf", "--nframes", type=int, required=True, help="by $cpptraj -p prmtop -y traj -tl")
        p.add_argument("-tpf", "--time-per-frame", default=1.0, type=float)
        return super(Split, cls).set_arguments(p)
