from unittest import TestCase
from argparse import ArgumentParser
from fmojinja.cpptraj.hbond import Hbond
from fmojinja.__version__ import get_version


class TestHbond(TestCase):
    test = Hbond()

    def test_simple_1(self):
        """
        simple test 1 for Hbond
        i.e. python -m fmojinja.cpptraj hbond -p test.prm -y test.crd --prefix hbond/
        :return: None
        """
        p = self.test.set_arguments(ArgumentParser())
        a = p.parse_args("-p test.prm -y test.crd --prefix hbond/".split())
        lines = self.test.render(**vars(a)).splitlines()
        self.assertEqual(lines[0], f"# Generated by fmojinja version {get_version()}")
        self.assertEqual(lines[1], 'parm test.prm')
        self.assertEqual(lines[2], 'trajin test.crd 1 last 1')
        self.assertEqual(lines[3], 'hbond BB  dist 6.0 avgout hbond/test.dat')
        self.assertEqual(lines[4], 'run')
