from unittest import TestCase
from fmojinja.__version__ import get_version
from fmojinja.cpptraj.reduce_frames import ReduceFrames
from pathlib import Path


class TestReduceFrames(TestCase):
    test = ReduceFrames()

    def test_simple_1(self):
        """
        simple test 1 for reduce_frames
        i.e. python -m fmojinja.cpptraj reduce_frames -p test.prm -y test.crd --prefix reduced/
        :return: None
        """
        lines = self.test.render(
            trajin=[Path("test.crd")],
            parm=Path("test.prm"),
            offset=10,
            prefix="reduced/",
        ).splitlines()
        self.assertEqual(lines[0], f"# Generated by fmojinja version {get_version()}")
        self.assertEqual(lines[1], "parm test.prm", "check parm")
        self.assertEqual(lines[2], "trajin test.crd", "check trajin")
        self.assertEqual(lines[3], "trajout reduced/test.crd offset 10", "trajout with offset")
        self.assertEqual(lines[4], "run", "check trajin")

    def test_simple_2(self):
        lines = self.test.render(
            trajin=[Path("test1.crd"), Path("test2.crd")],
            parm=Path("test.prm"),
            offset=10,
            prefix="reduced/"
        ).splitlines()
        self.assertEqual(lines[5], 'clear trajin', "clear trajin data before next trajin.")
        self.assertEqual(lines[6], 'trajin test2.crd', "process the second trajin.")
