from unittest import TestCase
from fmojinja.cpptraj.rmsd import Rmsd
from fmojinja.__version__ import get_version
from pathlib import Path


class TestRmsd(TestCase):
    test = Rmsd()

    def test_simple_1(self):
        """
        simple test 1 for Rmsd
        i.e. python -m fmojinja.cpptraj rmsd -p test.prm -y test.crd -ml :C,CA,N :1 :2
        :return: None
        """
        lines = self.test.render(
            trajin=[Path("test.crd")],
            parm=Path("test.prm"),
            mask_list=[":C,CA,N", ":1", ":2"],
        ).splitlines()
        self.assertEqual(lines[0], f"# Generated by fmojinja version {get_version()}")
        self.assertEqual(lines[1], "parm test.prm")
        self.assertEqual(lines[2], "trajin test.crd 1 last")
        self.assertEqual(lines[4], "autoimage anchor  origin")
        self.assertEqual(lines[5], "align   first")
        self.assertEqual(lines[6], "rmsd rmsd_align  out  nofit first")
        self.assertEqual(lines[7], "rmsd rmsd_:C,CA,N :C,CA,N out  nofit first")
        self.assertEqual(lines[8], "rmsd rmsd_:1 :1 out  nofit first")
        self.assertEqual(lines[9], "rmsd rmsd_:2 :2 out  nofit first")

    def test_simple_2(self):
        """
        simple test 2 for Rmsd
        i.e. python -m fmojinja.cpptraj rmsd -reference test.ref -p test.prm -y test1.crd test2.crd -ml :C,CA,N :1 :2
        :return: None
        """
        lines = self.test.render(
            trajin=[Path("test1.crd"), Path("test2.crd")],
            parm=Path("test.prm"),
            ref=Path("test.ref"),
            mask_list=[":C,CA,N", ":1", ":2"],
        ).splitlines()
        self.assertEqual(lines[2], "trajin test1.crd 1 last")
        self.assertEqual(lines[3], "trajin test2.crd 1 last")
        self.assertEqual(lines[7], "rmsd rmsd_align  out  nofit reference")
        self.assertEqual(lines[8], "rmsd rmsd_:C,CA,N :C,CA,N out  nofit reference")
        self.assertEqual(lines[9], "rmsd rmsd_:1 :1 out  nofit reference")

    def test_simple_3(self):
        """
        simple test 3 for Rmsd
        i.e. python -m fmojinja.cpptraj rmsd -reference test.ref -p test.prm \
        -y test1.crd test2.crd -ml :C,CA,N :1 :2 --offset 10
        :return: None
        """
        lines = self.test.render(
            trajin=[Path("test1.crd"), Path("test2.crd")],
            parm=Path("test.prm"),
            ref=Path("test.ref"),
            mask_list=[":C,CA,N", ":1", ":2"],
        ).splitlines()
        self.assertEqual(lines[2], "trajin test1.crd 1 last")
        self.assertEqual(lines[3], "trajin test2.crd 1 last")
        self.assertEqual(lines[7], "rmsd rmsd_align  out  nofit reference")
        self.assertEqual(lines[8], "rmsd rmsd_:C,CA,N :C,CA,N out  nofit reference")
        self.assertEqual(lines[9], "rmsd rmsd_:1 :1 out  nofit reference")
