from ..mixin import SanderMixin
from ..__version__ import get_version
from argparse import ArgumentParser


class Min(SanderMixin):
    """
    e.g. python -m fmojinja.sander min > $*.in; sander -O -i $*.in -o $*.mdout -r $*.rst_opt -p $*.parm -c $< -ref $<
    """

    @classmethod
    def template(cls):
        return "{{ title }}" + f" !Generated by fmojinja version {get_version()}" + """ 
&cntrl
  imin=1, 
  cut={{ cut_off }},
  maxcyc={{ maxcyc }}, 
  ncyc=3000,
  drms={{ drms }},
{%- if restraint_mask == None or restraint_mask == "" %}
  ntr=0,
{%- else %}
  ntr=1,
  restraintmask="{{ restraint_mask }}",
  restraint_wt={{ restraint_wt }},
{%- endif %}
  ig={{ seed }},
/

"""

    @classmethod
    def set_arguments(cls, p: ArgumentParser) -> ArgumentParser:
        p = super(Min, cls).set_arguments(p)
        p.add_argument("-mc", "--maxcyc", default=10000)
        p.add_argument("-drms", default=1e-4)
        return p
