from ..mixin import TemplateRendererMixin
from ..__version__ import get_version
from argparse import ArgumentParser
import subprocess
from subprocess import PIPE

class Solvate(TemplateRendererMixin):
    @classmethod
    def template(cls) -> str:
        return f"# Generated by fmojinja version {get_version()}" + """
verbosity {{ verbosity }}

{% for i in leaprc %}source leaprc.{{ i }}
{% endfor %}
addPdbResMap { { "LI+" "LI" } { "NA+" "NA" } { "MG2" "MG" } { "CL-" "CL" } { "K+" "K" } { "RB+" "RB" } { "CS+" "CS" } }
addPdbAtomMap { { "LI+" "LI" } { "NA+" "NA" } { "MG2" "MG" } { "CL-" "CL" } { "K+" "K" } { "RB+" "RB" } { "CS+" "CS" } }

com = createUnit com
{{ title }} = loadpdb {{ pdb }}
{{ title }} = combine { com {{ title }} }
{% if counter_anion %}addIons2 {{ title }} {{ counter_anion }} {{ counter_anion_charge }}{% endif %}
{% if counter_cation %}addIons2 {{ title }} {{ counter_cation }} {{ counter_cation_charge }}{% endif %}
savePdb {{ title }} {{ pdb.replace(".pdb", "_slvd.pdb") }}
{{ solvate_method }} {{ title }} {{ solvate_name }}{% for i in solvate_param %} {{ i }}{% endfor %}
saveAmberParm {{ title }} {{ pdb.replace(".pdb", ".top") }} {{ pdb.replace(".pdb", ".crd") }}
quit

"""

    @classmethod
    def set_arguments(cls, p: ArgumentParser) -> ArgumentParser:
        p = super(Solvate, cls).set_arguments(p)
        leaprc = subprocess.run(
            "ls $(tleap -h | grep -- -I: | awk ' $3 ~ \"cmd$\" { print $3 }') | grep leaprc | sed -e s/leaprc.//g",
            shell=True, stdout=PIPE, stderr=PIPE, text=True).stdout.strip().split("\n")
        p.add_argument("--verbosity", default=2)
        p.add_argument("-lrc", "--leaprc", nargs="+", required=True, help="leaprc command. Default commands are " + f"{leaprc}")
        p.add_argument("-t", "--title", default="mol")
        p.add_argument("-sm", "--solvate-method", default="solvateBox")
        tleap_lib = subprocess.run(
            "tleap -h | grep -- -I: | awk ' $3 ~ \"lib$\" { print $3 }'",
            shell=True, stdout=PIPE, stderr=PIPE, text=True).stdout.strip()
        sn = [i.strip(' "') for i in subprocess.run(
            f"ls {tleap_lib} | grep .off | xargs -i head -n2 {tleap_lib}/" + "{} | grep -v '!'",
            shell=True, stdout=PIPE, stderr=PIPE, text=True).stdout.strip().split("\n")]
        p.add_argument("-sn", "--solvate-name", default="TIP3PBOX", help="solvent name. Defaults are " + f"{sn}")
        p.add_argument("-sp", "--solvate-param", default=[10], nargs="+")
        p.add_argument("-cc", "--counter-cation", default="Na+")
        p.add_argument("-ccc", "--counter-cation-charge", default=0)
        p.add_argument("-ca", "--counter-anion", default="Cl+")
        p.add_argument("-cac", "--counter-anion-charge", default=0)
        p.add_argument("pdb")
        return p