
# Description

This library uses `ffmpeg` to check if a file (such as an mkv video) is corrupt.  Any errors generated by `ffmpeg` when reading the file are assumed to be caused by file corruption.

# Installation

    pip3 install mediachecker

The `ffmpeg` command must also be available on your system (and `PATH`).

# Usage

    from mediachecker import AVFile
    
    f = AVFile('some_file_to_check.mp4')
    file_is_good = f.is_good()

By default, we only scan the first audio track of the file.  This should be relatively fast.  Alternatively, you can do:

    file_is_good = f.is_good(method='full')

which will probably be slower.

If you want to see the output that was generated by `ffmpeg`, you can use `write_log`:

    file_is_good = f.is_good(write_log=True)
    
This will save any errors to `some_file_to_check.mp4.log`.

## CLI

Installing the `mediachecker` package also creates a command-line tool called `check_media`.

Run `check_media -h` for help using it.  Example usage:

    $ check_media -r -l /path/to/my/media/

That will recursively search for media in `/path/to/my/media/`, scan
each file (using the default method), and write logs for all of them.

# TODO

* Add more command line options

* Add more tests

* Enable HW acceleration, e.g. `ffmpeg -hwaccel cuda ...`

* Enable debug statements regarding progress, etc.
