###
### This file was automatically generated
###

from archinfo.arch import register_arch, Endness, Register

from .common import ArchPcode


class ArchPcode_RISCV_LE_32_RV32IC(ArchPcode):
    name = 'RISCV:LE:32:RV32IC'
    pcode_arch = 'RISCV:LE:32:RV32IC'
    description = 'RISC-V 32 little base compressed'
    bits = 32
    ip_offset = 0x1000
    sp_offset = 0x2008
    bp_offset = sp_offset
    instruction_endness = Endness.LE
    register_list = [
        Register('pc', 4, 0x1000, alias_names=('ip',)),
        Register('reserve_address', 4, 0x1010),
        Register('reserve', 1, 0x1018),
        Register('reserve_length', 1, 0x101c),
        Register('zero', 4, 0x2000),
        Register('ra', 4, 0x2004),
        Register('sp', 4, 0x2008),
        Register('gp', 4, 0x200c),
        Register('tp', 4, 0x2010),
        Register('t0', 4, 0x2014),
        Register('t1', 4, 0x2018),
        Register('t2', 4, 0x201c),
        Register('s0', 4, 0x2020),
        Register('s1', 4, 0x2024),
        Register('a0', 4, 0x2028),
        Register('a1', 4, 0x202c),
        Register('a2', 4, 0x2030),
        Register('a3', 4, 0x2034),
        Register('a4', 4, 0x2038),
        Register('a5', 4, 0x203c),
        Register('a6', 4, 0x2040),
        Register('a7', 4, 0x2044),
        Register('s2', 4, 0x2048),
        Register('s3', 4, 0x204c),
        Register('s4', 4, 0x2050),
        Register('s5', 4, 0x2054),
        Register('s6', 4, 0x2058),
        Register('s7', 4, 0x205c),
        Register('s8', 4, 0x2060),
        Register('s9', 4, 0x2064),
        Register('s10', 4, 0x2068),
        Register('s11', 4, 0x206c),
        Register('t3', 4, 0x2070),
        Register('t4', 4, 0x2074),
        Register('t5', 4, 0x2078),
        Register('t6', 4, 0x207c),
        Register('ft0', 8, 0x3000),
        Register('ft1', 8, 0x3008),
        Register('ft2', 8, 0x3010),
        Register('ft3', 8, 0x3018),
        Register('ft4', 8, 0x3020),
        Register('ft5', 8, 0x3028),
        Register('ft6', 8, 0x3030),
        Register('ft7', 8, 0x3038),
        Register('fs0', 8, 0x3040),
        Register('fs1', 8, 0x3048),
        Register('fa0', 8, 0x3050),
        Register('fa1', 8, 0x3058),
        Register('fa2', 8, 0x3060),
        Register('fa3', 8, 0x3068),
        Register('fa4', 8, 0x3070),
        Register('fa5', 8, 0x3078),
        Register('fa6', 8, 0x3080),
        Register('fa7', 8, 0x3088),
        Register('fs2', 8, 0x3090),
        Register('fs3', 8, 0x3098),
        Register('fs4', 8, 0x30a0),
        Register('fs5', 8, 0x30a8),
        Register('fs6', 8, 0x30b0),
        Register('fs7', 8, 0x30b8),
        Register('fs8', 8, 0x30c0),
        Register('fs9', 8, 0x30c8),
        Register('fs10', 8, 0x30d0),
        Register('fs11', 8, 0x30d8),
        Register('ft8', 8, 0x30e0),
        Register('ft9', 8, 0x30e8),
        Register('ft10', 8, 0x30f0),
        Register('ft11', 8, 0x30f8),
        Register('v0', 256, 0x4000),
        Register('v1', 256, 0x4100),
        Register('v2', 256, 0x4200),
        Register('v3', 256, 0x4300),
        Register('v4', 256, 0x4400),
        Register('v5', 256, 0x4500),
        Register('v6', 256, 0x4600),
        Register('v7', 256, 0x4700),
        Register('v8', 256, 0x4800),
        Register('v9', 256, 0x4900),
        Register('v10', 256, 0x4a00),
        Register('v11', 256, 0x4b00),
        Register('v12', 256, 0x4c00),
        Register('v13', 256, 0x4d00),
        Register('v14', 256, 0x4e00),
        Register('v15', 256, 0x4f00),
        Register('v16', 256, 0x5000),
        Register('v17', 256, 0x5100),
        Register('v18', 256, 0x5200),
        Register('v19', 256, 0x5300),
        Register('v20', 256, 0x5400),
        Register('v21', 256, 0x5500),
        Register('v22', 256, 0x5600),
        Register('v23', 256, 0x5700),
        Register('v24', 256, 0x5800),
        Register('v25', 256, 0x5900),
        Register('v26', 256, 0x5a00),
        Register('v27', 256, 0x5b00),
        Register('v28', 256, 0x5c00),
        Register('v29', 256, 0x5d00),
        Register('v30', 256, 0x5e00),
        Register('v31', 256, 0x5f00),
        Register('ustatus', 4, 0x90000000),
        Register('fflags', 4, 0x90000004),
        Register('frm', 4, 0x90000008),
        Register('fcsr', 4, 0x9000000c),
        Register('uie', 4, 0x90000010),
        Register('utvec', 4, 0x90000014),
        Register('csr006', 4, 0x90000018),
        Register('csr007', 4, 0x9000001c),
        Register('vstart', 4, 0x90000020),
        Register('vxsat', 4, 0x90000024),
        Register('vxrm', 4, 0x90000028),
        Register('csr00b', 4, 0x9000002c),
        Register('csr00c', 4, 0x90000030),
        Register('csr00d', 4, 0x90000034),
        Register('csr00e', 4, 0x90000038),
        Register('vcsr', 4, 0x9000003c),
        Register('csr010', 4, 0x90000040),
        Register('csr011', 4, 0x90000044),
        Register('csr012', 4, 0x90000048),
        Register('csr013', 4, 0x9000004c),
        Register('csr014', 4, 0x90000050),
        Register('csr015', 4, 0x90000054),
        Register('csr016', 4, 0x90000058),
        Register('csr017', 4, 0x9000005c),
        Register('csr018', 4, 0x90000060),
        Register('csr019', 4, 0x90000064),
        Register('csr01a', 4, 0x90000068),
        Register('csr01b', 4, 0x9000006c),
        Register('csr01c', 4, 0x90000070),
        Register('csr01d', 4, 0x90000074),
        Register('csr01e', 4, 0x90000078),
        Register('csr01f', 4, 0x9000007c),
        Register('csr020', 4, 0x90000080),
        Register('csr021', 4, 0x90000084),
        Register('csr022', 4, 0x90000088),
        Register('csr023', 4, 0x9000008c),
        Register('csr024', 4, 0x90000090),
        Register('csr025', 4, 0x90000094),
        Register('csr026', 4, 0x90000098),
        Register('csr027', 4, 0x9000009c),
        Register('csr028', 4, 0x900000a0),
        Register('csr029', 4, 0x900000a4),
        Register('csr02a', 4, 0x900000a8),
        Register('csr02b', 4, 0x900000ac),
        Register('csr02c', 4, 0x900000b0),
        Register('csr02d', 4, 0x900000b4),
        Register('csr02e', 4, 0x900000b8),
        Register('csr02f', 4, 0x900000bc),
        Register('csr030', 4, 0x900000c0),
        Register('csr031', 4, 0x900000c4),
        Register('csr032', 4, 0x900000c8),
        Register('csr033', 4, 0x900000cc),
        Register('csr034', 4, 0x900000d0),
        Register('csr035', 4, 0x900000d4),
        Register('csr036', 4, 0x900000d8),
        Register('csr037', 4, 0x900000dc),
        Register('csr038', 4, 0x900000e0),
        Register('csr039', 4, 0x900000e4),
        Register('csr03a', 4, 0x900000e8),
        Register('csr03b', 4, 0x900000ec),
        Register('csr03c', 4, 0x900000f0),
        Register('csr03d', 4, 0x900000f4),
        Register('csr03e', 4, 0x900000f8),
        Register('csr03f', 4, 0x900000fc),
        Register('uscratch', 4, 0x90000100),
        Register('uepc', 4, 0x90000104),
        Register('ucause', 4, 0x90000108),
        Register('utval', 4, 0x9000010c),
        Register('uip', 4, 0x90000110),
        Register('csr045', 4, 0x90000114),
        Register('csr046', 4, 0x90000118),
        Register('csr047', 4, 0x9000011c),
        Register('csr048', 4, 0x90000120),
        Register('csr049', 4, 0x90000124),
        Register('csr04a', 4, 0x90000128),
        Register('csr04b', 4, 0x9000012c),
        Register('csr04c', 4, 0x90000130),
        Register('csr04d', 4, 0x90000134),
        Register('csr04e', 4, 0x90000138),
        Register('csr04f', 4, 0x9000013c),
        Register('csr050', 4, 0x90000140),
        Register('csr051', 4, 0x90000144),
        Register('csr052', 4, 0x90000148),
        Register('csr053', 4, 0x9000014c),
        Register('csr054', 4, 0x90000150),
        Register('csr055', 4, 0x90000154),
        Register('csr056', 4, 0x90000158),
        Register('csr057', 4, 0x9000015c),
        Register('csr058', 4, 0x90000160),
        Register('csr059', 4, 0x90000164),
        Register('csr05a', 4, 0x90000168),
        Register('csr05b', 4, 0x9000016c),
        Register('csr05c', 4, 0x90000170),
        Register('csr05d', 4, 0x90000174),
        Register('csr05e', 4, 0x90000178),
        Register('csr05f', 4, 0x9000017c),
        Register('csr060', 4, 0x90000180),
        Register('csr061', 4, 0x90000184),
        Register('csr062', 4, 0x90000188),
        Register('csr063', 4, 0x9000018c),
        Register('csr064', 4, 0x90000190),
        Register('csr065', 4, 0x90000194),
        Register('csr066', 4, 0x90000198),
        Register('csr067', 4, 0x9000019c),
        Register('csr068', 4, 0x900001a0),
        Register('csr069', 4, 0x900001a4),
        Register('csr06a', 4, 0x900001a8),
        Register('csr06b', 4, 0x900001ac),
        Register('csr06c', 4, 0x900001b0),
        Register('csr06d', 4, 0x900001b4),
        Register('csr06e', 4, 0x900001b8),
        Register('csr06f', 4, 0x900001bc),
        Register('csr070', 4, 0x900001c0),
        Register('csr071', 4, 0x900001c4),
        Register('csr072', 4, 0x900001c8),
        Register('csr073', 4, 0x900001cc),
        Register('csr074', 4, 0x900001d0),
        Register('csr075', 4, 0x900001d4),
        Register('csr076', 4, 0x900001d8),
        Register('csr077', 4, 0x900001dc),
        Register('csr078', 4, 0x900001e0),
        Register('csr079', 4, 0x900001e4),
        Register('csr07a', 4, 0x900001e8),
        Register('csr07b', 4, 0x900001ec),
        Register('csr07c', 4, 0x900001f0),
        Register('csr07d', 4, 0x900001f4),
        Register('csr07e', 4, 0x900001f8),
        Register('csr07f', 4, 0x900001fc),
        Register('csr080', 4, 0x90000200),
        Register('csr081', 4, 0x90000204),
        Register('csr082', 4, 0x90000208),
        Register('csr083', 4, 0x9000020c),
        Register('csr084', 4, 0x90000210),
        Register('csr085', 4, 0x90000214),
        Register('csr086', 4, 0x90000218),
        Register('csr087', 4, 0x9000021c),
        Register('csr088', 4, 0x90000220),
        Register('csr089', 4, 0x90000224),
        Register('csr08a', 4, 0x90000228),
        Register('csr08b', 4, 0x9000022c),
        Register('csr08c', 4, 0x90000230),
        Register('csr08d', 4, 0x90000234),
        Register('csr08e', 4, 0x90000238),
        Register('csr08f', 4, 0x9000023c),
        Register('csr090', 4, 0x90000240),
        Register('csr091', 4, 0x90000244),
        Register('csr092', 4, 0x90000248),
        Register('csr093', 4, 0x9000024c),
        Register('csr094', 4, 0x90000250),
        Register('csr095', 4, 0x90000254),
        Register('csr096', 4, 0x90000258),
        Register('csr097', 4, 0x9000025c),
        Register('csr098', 4, 0x90000260),
        Register('csr099', 4, 0x90000264),
        Register('csr09a', 4, 0x90000268),
        Register('csr09b', 4, 0x9000026c),
        Register('csr09c', 4, 0x90000270),
        Register('csr09d', 4, 0x90000274),
        Register('csr09e', 4, 0x90000278),
        Register('csr09f', 4, 0x9000027c),
        Register('csr0a0', 4, 0x90000280),
        Register('csr0a1', 4, 0x90000284),
        Register('csr0a2', 4, 0x90000288),
        Register('csr0a3', 4, 0x9000028c),
        Register('csr0a4', 4, 0x90000290),
        Register('csr0a5', 4, 0x90000294),
        Register('csr0a6', 4, 0x90000298),
        Register('csr0a7', 4, 0x9000029c),
        Register('csr0a8', 4, 0x900002a0),
        Register('csr0a9', 4, 0x900002a4),
        Register('csr0aa', 4, 0x900002a8),
        Register('csr0ab', 4, 0x900002ac),
        Register('csr0ac', 4, 0x900002b0),
        Register('csr0ad', 4, 0x900002b4),
        Register('csr0ae', 4, 0x900002b8),
        Register('csr0af', 4, 0x900002bc),
        Register('csr0b0', 4, 0x900002c0),
        Register('csr0b1', 4, 0x900002c4),
        Register('csr0b2', 4, 0x900002c8),
        Register('csr0b3', 4, 0x900002cc),
        Register('csr0b4', 4, 0x900002d0),
        Register('csr0b5', 4, 0x900002d4),
        Register('csr0b6', 4, 0x900002d8),
        Register('csr0b7', 4, 0x900002dc),
        Register('csr0b8', 4, 0x900002e0),
        Register('csr0b9', 4, 0x900002e4),
        Register('csr0ba', 4, 0x900002e8),
        Register('csr0bb', 4, 0x900002ec),
        Register('csr0bc', 4, 0x900002f0),
        Register('csr0bd', 4, 0x900002f4),
        Register('csr0be', 4, 0x900002f8),
        Register('csr0bf', 4, 0x900002fc),
        Register('csr0c0', 4, 0x90000300),
        Register('csr0c1', 4, 0x90000304),
        Register('csr0c2', 4, 0x90000308),
        Register('csr0c3', 4, 0x9000030c),
        Register('csr0c4', 4, 0x90000310),
        Register('csr0c5', 4, 0x90000314),
        Register('csr0c6', 4, 0x90000318),
        Register('csr0c7', 4, 0x9000031c),
        Register('csr0c8', 4, 0x90000320),
        Register('csr0c9', 4, 0x90000324),
        Register('csr0ca', 4, 0x90000328),
        Register('csr0cb', 4, 0x9000032c),
        Register('csr0cc', 4, 0x90000330),
        Register('csr0cd', 4, 0x90000334),
        Register('csr0ce', 4, 0x90000338),
        Register('csr0cf', 4, 0x9000033c),
        Register('csr0d0', 4, 0x90000340),
        Register('csr0d1', 4, 0x90000344),
        Register('csr0d2', 4, 0x90000348),
        Register('csr0d3', 4, 0x9000034c),
        Register('csr0d4', 4, 0x90000350),
        Register('csr0d5', 4, 0x90000354),
        Register('csr0d6', 4, 0x90000358),
        Register('csr0d7', 4, 0x9000035c),
        Register('csr0d8', 4, 0x90000360),
        Register('csr0d9', 4, 0x90000364),
        Register('csr0da', 4, 0x90000368),
        Register('csr0db', 4, 0x9000036c),
        Register('csr0dc', 4, 0x90000370),
        Register('csr0dd', 4, 0x90000374),
        Register('csr0de', 4, 0x90000378),
        Register('csr0df', 4, 0x9000037c),
        Register('csr0e0', 4, 0x90000380),
        Register('csr0e1', 4, 0x90000384),
        Register('csr0e2', 4, 0x90000388),
        Register('csr0e3', 4, 0x9000038c),
        Register('csr0e4', 4, 0x90000390),
        Register('csr0e5', 4, 0x90000394),
        Register('csr0e6', 4, 0x90000398),
        Register('csr0e7', 4, 0x9000039c),
        Register('csr0e8', 4, 0x900003a0),
        Register('csr0e9', 4, 0x900003a4),
        Register('csr0ea', 4, 0x900003a8),
        Register('csr0eb', 4, 0x900003ac),
        Register('csr0ec', 4, 0x900003b0),
        Register('csr0ed', 4, 0x900003b4),
        Register('csr0ee', 4, 0x900003b8),
        Register('csr0ef', 4, 0x900003bc),
        Register('csr0f0', 4, 0x900003c0),
        Register('csr0f1', 4, 0x900003c4),
        Register('csr0f2', 4, 0x900003c8),
        Register('csr0f3', 4, 0x900003cc),
        Register('csr0f4', 4, 0x900003d0),
        Register('csr0f5', 4, 0x900003d4),
        Register('csr0f6', 4, 0x900003d8),
        Register('csr0f7', 4, 0x900003dc),
        Register('csr0f8', 4, 0x900003e0),
        Register('csr0f9', 4, 0x900003e4),
        Register('csr0fa', 4, 0x900003e8),
        Register('csr0fb', 4, 0x900003ec),
        Register('csr0fc', 4, 0x900003f0),
        Register('csr0fd', 4, 0x900003f4),
        Register('csr0fe', 4, 0x900003f8),
        Register('csr0ff', 4, 0x900003fc),
        Register('sstatus', 4, 0x90000400),
        Register('csr101', 4, 0x90000404),
        Register('sedeleg', 4, 0x90000408),
        Register('sideleg', 4, 0x9000040c),
        Register('sie', 4, 0x90000410),
        Register('stvec', 4, 0x90000414),
        Register('scounteren', 4, 0x90000418),
        Register('csr107', 4, 0x9000041c),
        Register('csr108', 4, 0x90000420),
        Register('csr109', 4, 0x90000424),
        Register('csr10a', 4, 0x90000428),
        Register('csr10b', 4, 0x9000042c),
        Register('csr10c', 4, 0x90000430),
        Register('csr10d', 4, 0x90000434),
        Register('csr10e', 4, 0x90000438),
        Register('csr10f', 4, 0x9000043c),
        Register('csr110', 4, 0x90000440),
        Register('csr111', 4, 0x90000444),
        Register('csr112', 4, 0x90000448),
        Register('csr113', 4, 0x9000044c),
        Register('csr114', 4, 0x90000450),
        Register('csr115', 4, 0x90000454),
        Register('csr116', 4, 0x90000458),
        Register('csr117', 4, 0x9000045c),
        Register('csr118', 4, 0x90000460),
        Register('csr119', 4, 0x90000464),
        Register('csr11a', 4, 0x90000468),
        Register('csr11b', 4, 0x9000046c),
        Register('csr11c', 4, 0x90000470),
        Register('csr11d', 4, 0x90000474),
        Register('csr11e', 4, 0x90000478),
        Register('csr11f', 4, 0x9000047c),
        Register('csr120', 4, 0x90000480),
        Register('csr121', 4, 0x90000484),
        Register('csr122', 4, 0x90000488),
        Register('csr123', 4, 0x9000048c),
        Register('csr124', 4, 0x90000490),
        Register('csr125', 4, 0x90000494),
        Register('csr126', 4, 0x90000498),
        Register('csr127', 4, 0x9000049c),
        Register('csr128', 4, 0x900004a0),
        Register('csr129', 4, 0x900004a4),
        Register('csr12a', 4, 0x900004a8),
        Register('csr12b', 4, 0x900004ac),
        Register('csr12c', 4, 0x900004b0),
        Register('csr12d', 4, 0x900004b4),
        Register('csr12e', 4, 0x900004b8),
        Register('csr12f', 4, 0x900004bc),
        Register('csr130', 4, 0x900004c0),
        Register('csr131', 4, 0x900004c4),
        Register('csr132', 4, 0x900004c8),
        Register('csr133', 4, 0x900004cc),
        Register('csr134', 4, 0x900004d0),
        Register('csr135', 4, 0x900004d4),
        Register('csr136', 4, 0x900004d8),
        Register('csr137', 4, 0x900004dc),
        Register('csr138', 4, 0x900004e0),
        Register('csr139', 4, 0x900004e4),
        Register('csr13a', 4, 0x900004e8),
        Register('csr13b', 4, 0x900004ec),
        Register('csr13c', 4, 0x900004f0),
        Register('csr13d', 4, 0x900004f4),
        Register('csr13e', 4, 0x900004f8),
        Register('csr13f', 4, 0x900004fc),
        Register('sscratch', 4, 0x90000500),
        Register('sepc', 4, 0x90000504),
        Register('scause', 4, 0x90000508),
        Register('stval', 4, 0x9000050c),
        Register('sip', 4, 0x90000510),
        Register('csr145', 4, 0x90000514),
        Register('csr146', 4, 0x90000518),
        Register('csr147', 4, 0x9000051c),
        Register('csr148', 4, 0x90000520),
        Register('csr149', 4, 0x90000524),
        Register('csr14a', 4, 0x90000528),
        Register('csr14b', 4, 0x9000052c),
        Register('csr14c', 4, 0x90000530),
        Register('csr14d', 4, 0x90000534),
        Register('csr14e', 4, 0x90000538),
        Register('csr14f', 4, 0x9000053c),
        Register('csr150', 4, 0x90000540),
        Register('csr151', 4, 0x90000544),
        Register('csr152', 4, 0x90000548),
        Register('csr153', 4, 0x9000054c),
        Register('csr154', 4, 0x90000550),
        Register('csr155', 4, 0x90000554),
        Register('csr156', 4, 0x90000558),
        Register('csr157', 4, 0x9000055c),
        Register('csr158', 4, 0x90000560),
        Register('csr159', 4, 0x90000564),
        Register('csr15a', 4, 0x90000568),
        Register('csr15b', 4, 0x9000056c),
        Register('csr15c', 4, 0x90000570),
        Register('csr15d', 4, 0x90000574),
        Register('csr15e', 4, 0x90000578),
        Register('csr15f', 4, 0x9000057c),
        Register('csr160', 4, 0x90000580),
        Register('csr161', 4, 0x90000584),
        Register('csr162', 4, 0x90000588),
        Register('csr163', 4, 0x9000058c),
        Register('csr164', 4, 0x90000590),
        Register('csr165', 4, 0x90000594),
        Register('csr166', 4, 0x90000598),
        Register('csr167', 4, 0x9000059c),
        Register('csr168', 4, 0x900005a0),
        Register('csr169', 4, 0x900005a4),
        Register('csr16a', 4, 0x900005a8),
        Register('csr16b', 4, 0x900005ac),
        Register('csr16c', 4, 0x900005b0),
        Register('csr16d', 4, 0x900005b4),
        Register('csr16e', 4, 0x900005b8),
        Register('csr16f', 4, 0x900005bc),
        Register('csr170', 4, 0x900005c0),
        Register('csr171', 4, 0x900005c4),
        Register('csr172', 4, 0x900005c8),
        Register('csr173', 4, 0x900005cc),
        Register('csr174', 4, 0x900005d0),
        Register('csr175', 4, 0x900005d4),
        Register('csr176', 4, 0x900005d8),
        Register('csr177', 4, 0x900005dc),
        Register('csr178', 4, 0x900005e0),
        Register('csr179', 4, 0x900005e4),
        Register('csr17a', 4, 0x900005e8),
        Register('csr17b', 4, 0x900005ec),
        Register('csr17c', 4, 0x900005f0),
        Register('csr17d', 4, 0x900005f4),
        Register('csr17e', 4, 0x900005f8),
        Register('csr17f', 4, 0x900005fc),
        Register('satp', 4, 0x90000600),
        Register('csr181', 4, 0x90000604),
        Register('csr182', 4, 0x90000608),
        Register('csr183', 4, 0x9000060c),
        Register('csr184', 4, 0x90000610),
        Register('csr185', 4, 0x90000614),
        Register('csr186', 4, 0x90000618),
        Register('csr187', 4, 0x9000061c),
        Register('csr188', 4, 0x90000620),
        Register('csr189', 4, 0x90000624),
        Register('csr18a', 4, 0x90000628),
        Register('csr18b', 4, 0x9000062c),
        Register('csr18c', 4, 0x90000630),
        Register('csr18d', 4, 0x90000634),
        Register('csr18e', 4, 0x90000638),
        Register('csr18f', 4, 0x9000063c),
        Register('csr190', 4, 0x90000640),
        Register('csr191', 4, 0x90000644),
        Register('csr192', 4, 0x90000648),
        Register('csr193', 4, 0x9000064c),
        Register('csr194', 4, 0x90000650),
        Register('csr195', 4, 0x90000654),
        Register('csr196', 4, 0x90000658),
        Register('csr197', 4, 0x9000065c),
        Register('csr198', 4, 0x90000660),
        Register('csr199', 4, 0x90000664),
        Register('csr19a', 4, 0x90000668),
        Register('csr19b', 4, 0x9000066c),
        Register('csr19c', 4, 0x90000670),
        Register('csr19d', 4, 0x90000674),
        Register('csr19e', 4, 0x90000678),
        Register('csr19f', 4, 0x9000067c),
        Register('csr1a0', 4, 0x90000680),
        Register('csr1a1', 4, 0x90000684),
        Register('csr1a2', 4, 0x90000688),
        Register('csr1a3', 4, 0x9000068c),
        Register('csr1a4', 4, 0x90000690),
        Register('csr1a5', 4, 0x90000694),
        Register('csr1a6', 4, 0x90000698),
        Register('csr1a7', 4, 0x9000069c),
        Register('csr1a8', 4, 0x900006a0),
        Register('csr1a9', 4, 0x900006a4),
        Register('csr1aa', 4, 0x900006a8),
        Register('csr1ab', 4, 0x900006ac),
        Register('csr1ac', 4, 0x900006b0),
        Register('csr1ad', 4, 0x900006b4),
        Register('csr1ae', 4, 0x900006b8),
        Register('csr1af', 4, 0x900006bc),
        Register('csr1b0', 4, 0x900006c0),
        Register('csr1b1', 4, 0x900006c4),
        Register('csr1b2', 4, 0x900006c8),
        Register('csr1b3', 4, 0x900006cc),
        Register('csr1b4', 4, 0x900006d0),
        Register('csr1b5', 4, 0x900006d4),
        Register('csr1b6', 4, 0x900006d8),
        Register('csr1b7', 4, 0x900006dc),
        Register('csr1b8', 4, 0x900006e0),
        Register('csr1b9', 4, 0x900006e4),
        Register('csr1ba', 4, 0x900006e8),
        Register('csr1bb', 4, 0x900006ec),
        Register('csr1bc', 4, 0x900006f0),
        Register('csr1bd', 4, 0x900006f4),
        Register('csr1be', 4, 0x900006f8),
        Register('csr1bf', 4, 0x900006fc),
        Register('csr1c0', 4, 0x90000700),
        Register('csr1c1', 4, 0x90000704),
        Register('csr1c2', 4, 0x90000708),
        Register('csr1c3', 4, 0x9000070c),
        Register('csr1c4', 4, 0x90000710),
        Register('csr1c5', 4, 0x90000714),
        Register('csr1c6', 4, 0x90000718),
        Register('csr1c7', 4, 0x9000071c),
        Register('csr1c8', 4, 0x90000720),
        Register('csr1c9', 4, 0x90000724),
        Register('csr1ca', 4, 0x90000728),
        Register('csr1cb', 4, 0x9000072c),
        Register('csr1cc', 4, 0x90000730),
        Register('csr1cd', 4, 0x90000734),
        Register('csr1ce', 4, 0x90000738),
        Register('csr1cf', 4, 0x9000073c),
        Register('csr1d0', 4, 0x90000740),
        Register('csr1d1', 4, 0x90000744),
        Register('csr1d2', 4, 0x90000748),
        Register('csr1d3', 4, 0x9000074c),
        Register('csr1d4', 4, 0x90000750),
        Register('csr1d5', 4, 0x90000754),
        Register('csr1d6', 4, 0x90000758),
        Register('csr1d7', 4, 0x9000075c),
        Register('csr1d8', 4, 0x90000760),
        Register('csr1d9', 4, 0x90000764),
        Register('csr1da', 4, 0x90000768),
        Register('csr1db', 4, 0x9000076c),
        Register('csr1dc', 4, 0x90000770),
        Register('csr1dd', 4, 0x90000774),
        Register('csr1de', 4, 0x90000778),
        Register('csr1df', 4, 0x9000077c),
        Register('csr1e0', 4, 0x90000780),
        Register('csr1e1', 4, 0x90000784),
        Register('csr1e2', 4, 0x90000788),
        Register('csr1e3', 4, 0x9000078c),
        Register('csr1e4', 4, 0x90000790),
        Register('csr1e5', 4, 0x90000794),
        Register('csr1e6', 4, 0x90000798),
        Register('csr1e7', 4, 0x9000079c),
        Register('csr1e8', 4, 0x900007a0),
        Register('csr1e9', 4, 0x900007a4),
        Register('csr1ea', 4, 0x900007a8),
        Register('csr1eb', 4, 0x900007ac),
        Register('csr1ec', 4, 0x900007b0),
        Register('csr1ed', 4, 0x900007b4),
        Register('csr1ee', 4, 0x900007b8),
        Register('csr1ef', 4, 0x900007bc),
        Register('csr1f0', 4, 0x900007c0),
        Register('csr1f1', 4, 0x900007c4),
        Register('csr1f2', 4, 0x900007c8),
        Register('csr1f3', 4, 0x900007cc),
        Register('csr1f4', 4, 0x900007d0),
        Register('csr1f5', 4, 0x900007d4),
        Register('csr1f6', 4, 0x900007d8),
        Register('csr1f7', 4, 0x900007dc),
        Register('csr1f8', 4, 0x900007e0),
        Register('csr1f9', 4, 0x900007e4),
        Register('csr1fa', 4, 0x900007e8),
        Register('csr1fb', 4, 0x900007ec),
        Register('csr1fc', 4, 0x900007f0),
        Register('csr1fd', 4, 0x900007f4),
        Register('csr1fe', 4, 0x900007f8),
        Register('csr1ff', 4, 0x900007fc),
        Register('vsstatus', 4, 0x90000800),
        Register('csr201', 4, 0x90000804),
        Register('csr202', 4, 0x90000808),
        Register('csr203', 4, 0x9000080c),
        Register('vsie', 4, 0x90000810),
        Register('vstvec', 4, 0x90000814),
        Register('csr206', 4, 0x90000818),
        Register('csr207', 4, 0x9000081c),
        Register('csr208', 4, 0x90000820),
        Register('csr209', 4, 0x90000824),
        Register('csr20a', 4, 0x90000828),
        Register('csr20b', 4, 0x9000082c),
        Register('csr20c', 4, 0x90000830),
        Register('csr20d', 4, 0x90000834),
        Register('csr20e', 4, 0x90000838),
        Register('csr20f', 4, 0x9000083c),
        Register('csr210', 4, 0x90000840),
        Register('csr211', 4, 0x90000844),
        Register('csr212', 4, 0x90000848),
        Register('csr213', 4, 0x9000084c),
        Register('csr214', 4, 0x90000850),
        Register('csr215', 4, 0x90000854),
        Register('csr216', 4, 0x90000858),
        Register('csr217', 4, 0x9000085c),
        Register('csr218', 4, 0x90000860),
        Register('csr219', 4, 0x90000864),
        Register('csr21a', 4, 0x90000868),
        Register('csr21b', 4, 0x9000086c),
        Register('csr21c', 4, 0x90000870),
        Register('csr21d', 4, 0x90000874),
        Register('csr21e', 4, 0x90000878),
        Register('csr21f', 4, 0x9000087c),
        Register('csr220', 4, 0x90000880),
        Register('csr221', 4, 0x90000884),
        Register('csr222', 4, 0x90000888),
        Register('csr223', 4, 0x9000088c),
        Register('csr224', 4, 0x90000890),
        Register('csr225', 4, 0x90000894),
        Register('csr226', 4, 0x90000898),
        Register('csr227', 4, 0x9000089c),
        Register('csr228', 4, 0x900008a0),
        Register('csr229', 4, 0x900008a4),
        Register('csr22a', 4, 0x900008a8),
        Register('csr22b', 4, 0x900008ac),
        Register('csr22c', 4, 0x900008b0),
        Register('csr22d', 4, 0x900008b4),
        Register('csr22e', 4, 0x900008b8),
        Register('csr22f', 4, 0x900008bc),
        Register('csr230', 4, 0x900008c0),
        Register('csr231', 4, 0x900008c4),
        Register('csr232', 4, 0x900008c8),
        Register('csr233', 4, 0x900008cc),
        Register('csr234', 4, 0x900008d0),
        Register('csr235', 4, 0x900008d4),
        Register('csr236', 4, 0x900008d8),
        Register('csr237', 4, 0x900008dc),
        Register('csr238', 4, 0x900008e0),
        Register('csr239', 4, 0x900008e4),
        Register('csr23a', 4, 0x900008e8),
        Register('csr23b', 4, 0x900008ec),
        Register('csr23c', 4, 0x900008f0),
        Register('csr23d', 4, 0x900008f4),
        Register('csr23e', 4, 0x900008f8),
        Register('csr23f', 4, 0x900008fc),
        Register('vsscratch', 4, 0x90000900),
        Register('vsepc', 4, 0x90000904),
        Register('vscause', 4, 0x90000908),
        Register('vstval', 4, 0x9000090c),
        Register('vsip', 4, 0x90000910),
        Register('csr245', 4, 0x90000914),
        Register('csr246', 4, 0x90000918),
        Register('csr247', 4, 0x9000091c),
        Register('csr248', 4, 0x90000920),
        Register('csr249', 4, 0x90000924),
        Register('csr24a', 4, 0x90000928),
        Register('csr24b', 4, 0x9000092c),
        Register('csr24c', 4, 0x90000930),
        Register('csr24d', 4, 0x90000934),
        Register('csr24e', 4, 0x90000938),
        Register('csr24f', 4, 0x9000093c),
        Register('csr250', 4, 0x90000940),
        Register('csr251', 4, 0x90000944),
        Register('csr252', 4, 0x90000948),
        Register('csr253', 4, 0x9000094c),
        Register('csr254', 4, 0x90000950),
        Register('csr255', 4, 0x90000954),
        Register('csr256', 4, 0x90000958),
        Register('csr257', 4, 0x9000095c),
        Register('csr258', 4, 0x90000960),
        Register('csr259', 4, 0x90000964),
        Register('csr25a', 4, 0x90000968),
        Register('csr25b', 4, 0x9000096c),
        Register('csr25c', 4, 0x90000970),
        Register('csr25d', 4, 0x90000974),
        Register('csr25e', 4, 0x90000978),
        Register('csr25f', 4, 0x9000097c),
        Register('csr260', 4, 0x90000980),
        Register('csr261', 4, 0x90000984),
        Register('csr262', 4, 0x90000988),
        Register('csr263', 4, 0x9000098c),
        Register('csr264', 4, 0x90000990),
        Register('csr265', 4, 0x90000994),
        Register('csr266', 4, 0x90000998),
        Register('csr267', 4, 0x9000099c),
        Register('csr268', 4, 0x900009a0),
        Register('csr269', 4, 0x900009a4),
        Register('csr26a', 4, 0x900009a8),
        Register('csr26b', 4, 0x900009ac),
        Register('csr26c', 4, 0x900009b0),
        Register('csr26d', 4, 0x900009b4),
        Register('csr26e', 4, 0x900009b8),
        Register('csr26f', 4, 0x900009bc),
        Register('csr270', 4, 0x900009c0),
        Register('csr271', 4, 0x900009c4),
        Register('csr272', 4, 0x900009c8),
        Register('csr273', 4, 0x900009cc),
        Register('csr274', 4, 0x900009d0),
        Register('csr275', 4, 0x900009d4),
        Register('csr276', 4, 0x900009d8),
        Register('csr277', 4, 0x900009dc),
        Register('csr278', 4, 0x900009e0),
        Register('csr279', 4, 0x900009e4),
        Register('csr27a', 4, 0x900009e8),
        Register('csr27b', 4, 0x900009ec),
        Register('csr27c', 4, 0x900009f0),
        Register('csr27d', 4, 0x900009f4),
        Register('csr27e', 4, 0x900009f8),
        Register('csr27f', 4, 0x900009fc),
        Register('vsatp', 4, 0x90000a00),
        Register('csr281', 4, 0x90000a04),
        Register('csr282', 4, 0x90000a08),
        Register('csr283', 4, 0x90000a0c),
        Register('csr284', 4, 0x90000a10),
        Register('csr285', 4, 0x90000a14),
        Register('csr286', 4, 0x90000a18),
        Register('csr287', 4, 0x90000a1c),
        Register('csr288', 4, 0x90000a20),
        Register('csr289', 4, 0x90000a24),
        Register('csr28a', 4, 0x90000a28),
        Register('csr28b', 4, 0x90000a2c),
        Register('csr28c', 4, 0x90000a30),
        Register('csr28d', 4, 0x90000a34),
        Register('csr28e', 4, 0x90000a38),
        Register('csr28f', 4, 0x90000a3c),
        Register('csr290', 4, 0x90000a40),
        Register('csr291', 4, 0x90000a44),
        Register('csr292', 4, 0x90000a48),
        Register('csr293', 4, 0x90000a4c),
        Register('csr294', 4, 0x90000a50),
        Register('csr295', 4, 0x90000a54),
        Register('csr296', 4, 0x90000a58),
        Register('csr297', 4, 0x90000a5c),
        Register('csr298', 4, 0x90000a60),
        Register('csr299', 4, 0x90000a64),
        Register('csr29a', 4, 0x90000a68),
        Register('csr29b', 4, 0x90000a6c),
        Register('csr29c', 4, 0x90000a70),
        Register('csr29d', 4, 0x90000a74),
        Register('csr29e', 4, 0x90000a78),
        Register('csr29f', 4, 0x90000a7c),
        Register('csr2a0', 4, 0x90000a80),
        Register('csr2a1', 4, 0x90000a84),
        Register('csr2a2', 4, 0x90000a88),
        Register('csr2a3', 4, 0x90000a8c),
        Register('csr2a4', 4, 0x90000a90),
        Register('csr2a5', 4, 0x90000a94),
        Register('csr2a6', 4, 0x90000a98),
        Register('csr2a7', 4, 0x90000a9c),
        Register('csr2a8', 4, 0x90000aa0),
        Register('csr2a9', 4, 0x90000aa4),
        Register('csr2aa', 4, 0x90000aa8),
        Register('csr2ab', 4, 0x90000aac),
        Register('csr2ac', 4, 0x90000ab0),
        Register('csr2ad', 4, 0x90000ab4),
        Register('csr2ae', 4, 0x90000ab8),
        Register('csr2af', 4, 0x90000abc),
        Register('csr2b0', 4, 0x90000ac0),
        Register('csr2b1', 4, 0x90000ac4),
        Register('csr2b2', 4, 0x90000ac8),
        Register('csr2b3', 4, 0x90000acc),
        Register('csr2b4', 4, 0x90000ad0),
        Register('csr2b5', 4, 0x90000ad4),
        Register('csr2b6', 4, 0x90000ad8),
        Register('csr2b7', 4, 0x90000adc),
        Register('csr2b8', 4, 0x90000ae0),
        Register('csr2b9', 4, 0x90000ae4),
        Register('csr2ba', 4, 0x90000ae8),
        Register('csr2bb', 4, 0x90000aec),
        Register('csr2bc', 4, 0x90000af0),
        Register('csr2bd', 4, 0x90000af4),
        Register('csr2be', 4, 0x90000af8),
        Register('csr2bf', 4, 0x90000afc),
        Register('csr2c0', 4, 0x90000b00),
        Register('csr2c1', 4, 0x90000b04),
        Register('csr2c2', 4, 0x90000b08),
        Register('csr2c3', 4, 0x90000b0c),
        Register('csr2c4', 4, 0x90000b10),
        Register('csr2c5', 4, 0x90000b14),
        Register('csr2c6', 4, 0x90000b18),
        Register('csr2c7', 4, 0x90000b1c),
        Register('csr2c8', 4, 0x90000b20),
        Register('csr2c9', 4, 0x90000b24),
        Register('csr2ca', 4, 0x90000b28),
        Register('csr2cb', 4, 0x90000b2c),
        Register('csr2cc', 4, 0x90000b30),
        Register('csr2cd', 4, 0x90000b34),
        Register('csr2ce', 4, 0x90000b38),
        Register('csr2cf', 4, 0x90000b3c),
        Register('csr2d0', 4, 0x90000b40),
        Register('csr2d1', 4, 0x90000b44),
        Register('csr2d2', 4, 0x90000b48),
        Register('csr2d3', 4, 0x90000b4c),
        Register('csr2d4', 4, 0x90000b50),
        Register('csr2d5', 4, 0x90000b54),
        Register('csr2d6', 4, 0x90000b58),
        Register('csr2d7', 4, 0x90000b5c),
        Register('csr2d8', 4, 0x90000b60),
        Register('csr2d9', 4, 0x90000b64),
        Register('csr2da', 4, 0x90000b68),
        Register('csr2db', 4, 0x90000b6c),
        Register('csr2dc', 4, 0x90000b70),
        Register('csr2dd', 4, 0x90000b74),
        Register('csr2de', 4, 0x90000b78),
        Register('csr2df', 4, 0x90000b7c),
        Register('csr2e0', 4, 0x90000b80),
        Register('csr2e1', 4, 0x90000b84),
        Register('csr2e2', 4, 0x90000b88),
        Register('csr2e3', 4, 0x90000b8c),
        Register('csr2e4', 4, 0x90000b90),
        Register('csr2e5', 4, 0x90000b94),
        Register('csr2e6', 4, 0x90000b98),
        Register('csr2e7', 4, 0x90000b9c),
        Register('csr2e8', 4, 0x90000ba0),
        Register('csr2e9', 4, 0x90000ba4),
        Register('csr2ea', 4, 0x90000ba8),
        Register('csr2eb', 4, 0x90000bac),
        Register('csr2ec', 4, 0x90000bb0),
        Register('csr2ed', 4, 0x90000bb4),
        Register('csr2ee', 4, 0x90000bb8),
        Register('csr2ef', 4, 0x90000bbc),
        Register('csr2f0', 4, 0x90000bc0),
        Register('csr2f1', 4, 0x90000bc4),
        Register('csr2f2', 4, 0x90000bc8),
        Register('csr2f3', 4, 0x90000bcc),
        Register('csr2f4', 4, 0x90000bd0),
        Register('csr2f5', 4, 0x90000bd4),
        Register('csr2f6', 4, 0x90000bd8),
        Register('csr2f7', 4, 0x90000bdc),
        Register('csr2f8', 4, 0x90000be0),
        Register('csr2f9', 4, 0x90000be4),
        Register('csr2fa', 4, 0x90000be8),
        Register('csr2fb', 4, 0x90000bec),
        Register('csr2fc', 4, 0x90000bf0),
        Register('csr2fd', 4, 0x90000bf4),
        Register('csr2fe', 4, 0x90000bf8),
        Register('csr2ff', 4, 0x90000bfc),
        Register('mstatus', 4, 0x90000c00),
        Register('misa', 4, 0x90000c04),
        Register('medeleg', 4, 0x90000c08),
        Register('mideleg', 4, 0x90000c0c),
        Register('mie', 4, 0x90000c10),
        Register('mtvec', 4, 0x90000c14),
        Register('mcounteren', 4, 0x90000c18),
        Register('csr307', 4, 0x90000c1c),
        Register('csr308', 4, 0x90000c20),
        Register('csr309', 4, 0x90000c24),
        Register('csr30a', 4, 0x90000c28),
        Register('csr30b', 4, 0x90000c2c),
        Register('csr30c', 4, 0x90000c30),
        Register('csr30d', 4, 0x90000c34),
        Register('csr30e', 4, 0x90000c38),
        Register('csr30f', 4, 0x90000c3c),
        Register('mstatush', 4, 0x90000c40),
        Register('csr311', 4, 0x90000c44),
        Register('csr312', 4, 0x90000c48),
        Register('csr313', 4, 0x90000c4c),
        Register('csr314', 4, 0x90000c50),
        Register('csr315', 4, 0x90000c54),
        Register('csr316', 4, 0x90000c58),
        Register('csr317', 4, 0x90000c5c),
        Register('csr318', 4, 0x90000c60),
        Register('csr319', 4, 0x90000c64),
        Register('csr31a', 4, 0x90000c68),
        Register('csr31b', 4, 0x90000c6c),
        Register('csr31c', 4, 0x90000c70),
        Register('csr31d', 4, 0x90000c74),
        Register('csr31e', 4, 0x90000c78),
        Register('csr31f', 4, 0x90000c7c),
        Register('mcountinhibit', 4, 0x90000c80),
        Register('csr321', 4, 0x90000c84),
        Register('csr322', 4, 0x90000c88),
        Register('mhpmevent3', 4, 0x90000c8c),
        Register('mhpmevent4', 4, 0x90000c90),
        Register('mhpmevent5', 4, 0x90000c94),
        Register('mhpmevent6', 4, 0x90000c98),
        Register('mhpmevent7', 4, 0x90000c9c),
        Register('mhpmevent8', 4, 0x90000ca0),
        Register('mhpmevent9', 4, 0x90000ca4),
        Register('mhpmevent10', 4, 0x90000ca8),
        Register('mhpmevent11', 4, 0x90000cac),
        Register('mhpmevent12', 4, 0x90000cb0),
        Register('mhpmevent13', 4, 0x90000cb4),
        Register('mhpmevent14', 4, 0x90000cb8),
        Register('mhpmevent15', 4, 0x90000cbc),
        Register('mhpmevent16', 4, 0x90000cc0),
        Register('mhpmevent17', 4, 0x90000cc4),
        Register('mhpmevent18', 4, 0x90000cc8),
        Register('mhpmevent19', 4, 0x90000ccc),
        Register('mhpmevent20', 4, 0x90000cd0),
        Register('mhpmevent21', 4, 0x90000cd4),
        Register('mhpmevent22', 4, 0x90000cd8),
        Register('mhpmevent23', 4, 0x90000cdc),
        Register('mhpmevent24', 4, 0x90000ce0),
        Register('mhpmevent25', 4, 0x90000ce4),
        Register('mhpmevent26', 4, 0x90000ce8),
        Register('mhpmevent27', 4, 0x90000cec),
        Register('mhpmevent28', 4, 0x90000cf0),
        Register('mhpmevent29', 4, 0x90000cf4),
        Register('mhpmevent30', 4, 0x90000cf8),
        Register('mhpmevent31', 4, 0x90000cfc),
        Register('mscratch', 4, 0x90000d00),
        Register('mepc', 4, 0x90000d04),
        Register('mcause', 4, 0x90000d08),
        Register('mtval', 4, 0x90000d0c),
        Register('mip', 4, 0x90000d10),
        Register('csr345', 4, 0x90000d14),
        Register('csr346', 4, 0x90000d18),
        Register('csr347', 4, 0x90000d1c),
        Register('csr348', 4, 0x90000d20),
        Register('csr349', 4, 0x90000d24),
        Register('mtinst', 4, 0x90000d28),
        Register('mtval2', 4, 0x90000d2c),
        Register('csr34c', 4, 0x90000d30),
        Register('csr34d', 4, 0x90000d34),
        Register('csr34e', 4, 0x90000d38),
        Register('csr34f', 4, 0x90000d3c),
        Register('csr350', 4, 0x90000d40),
        Register('csr351', 4, 0x90000d44),
        Register('csr352', 4, 0x90000d48),
        Register('csr353', 4, 0x90000d4c),
        Register('csr354', 4, 0x90000d50),
        Register('csr355', 4, 0x90000d54),
        Register('csr356', 4, 0x90000d58),
        Register('csr357', 4, 0x90000d5c),
        Register('csr358', 4, 0x90000d60),
        Register('csr359', 4, 0x90000d64),
        Register('csr35a', 4, 0x90000d68),
        Register('csr35b', 4, 0x90000d6c),
        Register('csr35c', 4, 0x90000d70),
        Register('csr35d', 4, 0x90000d74),
        Register('csr35e', 4, 0x90000d78),
        Register('csr35f', 4, 0x90000d7c),
        Register('csr360', 4, 0x90000d80),
        Register('csr361', 4, 0x90000d84),
        Register('csr362', 4, 0x90000d88),
        Register('csr363', 4, 0x90000d8c),
        Register('csr364', 4, 0x90000d90),
        Register('csr365', 4, 0x90000d94),
        Register('csr366', 4, 0x90000d98),
        Register('csr367', 4, 0x90000d9c),
        Register('csr368', 4, 0x90000da0),
        Register('csr369', 4, 0x90000da4),
        Register('csr36a', 4, 0x90000da8),
        Register('csr36b', 4, 0x90000dac),
        Register('csr36c', 4, 0x90000db0),
        Register('csr36d', 4, 0x90000db4),
        Register('csr36e', 4, 0x90000db8),
        Register('csr36f', 4, 0x90000dbc),
        Register('csr370', 4, 0x90000dc0),
        Register('csr371', 4, 0x90000dc4),
        Register('csr372', 4, 0x90000dc8),
        Register('csr373', 4, 0x90000dcc),
        Register('csr374', 4, 0x90000dd0),
        Register('csr375', 4, 0x90000dd4),
        Register('csr376', 4, 0x90000dd8),
        Register('csr377', 4, 0x90000ddc),
        Register('csr378', 4, 0x90000de0),
        Register('csr379', 4, 0x90000de4),
        Register('csr37a', 4, 0x90000de8),
        Register('csr37b', 4, 0x90000dec),
        Register('csr37c', 4, 0x90000df0),
        Register('csr37d', 4, 0x90000df4),
        Register('csr37e', 4, 0x90000df8),
        Register('csr37f', 4, 0x90000dfc),
        Register('mbase', 4, 0x90000e00),
        Register('mbound', 4, 0x90000e04),
        Register('mibase', 4, 0x90000e08),
        Register('mibound', 4, 0x90000e0c),
        Register('mdbase', 4, 0x90000e10),
        Register('mdbound', 4, 0x90000e14),
        Register('csr386', 4, 0x90000e18),
        Register('csr387', 4, 0x90000e1c),
        Register('csr388', 4, 0x90000e20),
        Register('csr389', 4, 0x90000e24),
        Register('csr38a', 4, 0x90000e28),
        Register('csr38b', 4, 0x90000e2c),
        Register('csr38c', 4, 0x90000e30),
        Register('csr38d', 4, 0x90000e34),
        Register('csr38e', 4, 0x90000e38),
        Register('csr38f', 4, 0x90000e3c),
        Register('csr390', 4, 0x90000e40),
        Register('csr391', 4, 0x90000e44),
        Register('csr392', 4, 0x90000e48),
        Register('csr393', 4, 0x90000e4c),
        Register('csr394', 4, 0x90000e50),
        Register('csr395', 4, 0x90000e54),
        Register('csr396', 4, 0x90000e58),
        Register('csr397', 4, 0x90000e5c),
        Register('csr398', 4, 0x90000e60),
        Register('csr399', 4, 0x90000e64),
        Register('csr39a', 4, 0x90000e68),
        Register('csr39b', 4, 0x90000e6c),
        Register('csr39c', 4, 0x90000e70),
        Register('csr39d', 4, 0x90000e74),
        Register('csr39e', 4, 0x90000e78),
        Register('csr39f', 4, 0x90000e7c),
        Register('pmpcfg0', 4, 0x90000e80),
        Register('pmpcfg1', 4, 0x90000e84),
        Register('pmpcfg2', 4, 0x90000e88),
        Register('pmpcfg3', 4, 0x90000e8c),
        Register('pmpcfg4', 4, 0x90000e90),
        Register('pmpcfg5', 4, 0x90000e94),
        Register('pmpcfg6', 4, 0x90000e98),
        Register('pmpcfg7', 4, 0x90000e9c),
        Register('pmpcfg8', 4, 0x90000ea0),
        Register('pmpcfg9', 4, 0x90000ea4),
        Register('pmpcfg10', 4, 0x90000ea8),
        Register('pmpcfg11', 4, 0x90000eac),
        Register('pmpcfg12', 4, 0x90000eb0),
        Register('pmpcfg13', 4, 0x90000eb4),
        Register('pmpcfg14', 4, 0x90000eb8),
        Register('pmpcfg15', 4, 0x90000ebc),
        Register('pmpaddr0', 4, 0x90000ec0),
        Register('pmpaddr1', 4, 0x90000ec4),
        Register('pmpaddr2', 4, 0x90000ec8),
        Register('pmpaddr3', 4, 0x90000ecc),
        Register('pmpaddr4', 4, 0x90000ed0),
        Register('pmpaddr5', 4, 0x90000ed4),
        Register('pmpaddr6', 4, 0x90000ed8),
        Register('pmpaddr7', 4, 0x90000edc),
        Register('pmpaddr8', 4, 0x90000ee0),
        Register('pmpaddr9', 4, 0x90000ee4),
        Register('pmpaddr10', 4, 0x90000ee8),
        Register('pmpaddr11', 4, 0x90000eec),
        Register('pmpaddr12', 4, 0x90000ef0),
        Register('pmpaddr13', 4, 0x90000ef4),
        Register('pmpaddr14', 4, 0x90000ef8),
        Register('pmpaddr15', 4, 0x90000efc),
        Register('pmpaddr16', 4, 0x90000f00),
        Register('pmpaddr17', 4, 0x90000f04),
        Register('pmpaddr18', 4, 0x90000f08),
        Register('pmpaddr19', 4, 0x90000f0c),
        Register('pmpaddr20', 4, 0x90000f10),
        Register('pmpaddr21', 4, 0x90000f14),
        Register('pmpaddr22', 4, 0x90000f18),
        Register('pmpaddr23', 4, 0x90000f1c),
        Register('pmpaddr24', 4, 0x90000f20),
        Register('pmpaddr25', 4, 0x90000f24),
        Register('pmpaddr26', 4, 0x90000f28),
        Register('pmpaddr27', 4, 0x90000f2c),
        Register('pmpaddr28', 4, 0x90000f30),
        Register('pmpaddr29', 4, 0x90000f34),
        Register('pmpaddr30', 4, 0x90000f38),
        Register('pmpaddr31', 4, 0x90000f3c),
        Register('pmpaddr32', 4, 0x90000f40),
        Register('pmpaddr33', 4, 0x90000f44),
        Register('pmpaddr34', 4, 0x90000f48),
        Register('pmpaddr35', 4, 0x90000f4c),
        Register('pmpaddr36', 4, 0x90000f50),
        Register('pmpaddr37', 4, 0x90000f54),
        Register('pmpaddr38', 4, 0x90000f58),
        Register('pmpaddr39', 4, 0x90000f5c),
        Register('pmpaddr40', 4, 0x90000f60),
        Register('pmpaddr41', 4, 0x90000f64),
        Register('pmpaddr42', 4, 0x90000f68),
        Register('pmpaddr43', 4, 0x90000f6c),
        Register('pmpaddr44', 4, 0x90000f70),
        Register('pmpaddr45', 4, 0x90000f74),
        Register('pmpaddr46', 4, 0x90000f78),
        Register('pmpaddr47', 4, 0x90000f7c),
        Register('pmpaddr48', 4, 0x90000f80),
        Register('pmpaddr49', 4, 0x90000f84),
        Register('pmpaddr50', 4, 0x90000f88),
        Register('pmpaddr51', 4, 0x90000f8c),
        Register('pmpaddr52', 4, 0x90000f90),
        Register('pmpaddr53', 4, 0x90000f94),
        Register('pmpaddr54', 4, 0x90000f98),
        Register('pmpaddr55', 4, 0x90000f9c),
        Register('pmpaddr56', 4, 0x90000fa0),
        Register('pmpaddr57', 4, 0x90000fa4),
        Register('pmpaddr58', 4, 0x90000fa8),
        Register('pmpaddr59', 4, 0x90000fac),
        Register('pmpaddr60', 4, 0x90000fb0),
        Register('pmpaddr61', 4, 0x90000fb4),
        Register('pmpaddr62', 4, 0x90000fb8),
        Register('pmpaddr63', 4, 0x90000fbc),
        Register('csr3f0', 4, 0x90000fc0),
        Register('csr3f1', 4, 0x90000fc4),
        Register('csr3f2', 4, 0x90000fc8),
        Register('csr3f3', 4, 0x90000fcc),
        Register('csr3f4', 4, 0x90000fd0),
        Register('csr3f5', 4, 0x90000fd4),
        Register('csr3f6', 4, 0x90000fd8),
        Register('csr3f7', 4, 0x90000fdc),
        Register('csr3f8', 4, 0x90000fe0),
        Register('csr3f9', 4, 0x90000fe4),
        Register('csr3fa', 4, 0x90000fe8),
        Register('csr3fb', 4, 0x90000fec),
        Register('csr3fc', 4, 0x90000ff0),
        Register('csr3fd', 4, 0x90000ff4),
        Register('csr3fe', 4, 0x90000ff8),
        Register('csr3ff', 4, 0x90000ffc),
        Register('csr400', 4, 0x90001000),
        Register('csr401', 4, 0x90001004),
        Register('csr402', 4, 0x90001008),
        Register('csr403', 4, 0x9000100c),
        Register('csr404', 4, 0x90001010),
        Register('csr405', 4, 0x90001014),
        Register('csr406', 4, 0x90001018),
        Register('csr407', 4, 0x9000101c),
        Register('csr408', 4, 0x90001020),
        Register('csr409', 4, 0x90001024),
        Register('csr40a', 4, 0x90001028),
        Register('csr40b', 4, 0x9000102c),
        Register('csr40c', 4, 0x90001030),
        Register('csr40d', 4, 0x90001034),
        Register('csr40e', 4, 0x90001038),
        Register('csr40f', 4, 0x9000103c),
        Register('csr410', 4, 0x90001040),
        Register('csr411', 4, 0x90001044),
        Register('csr412', 4, 0x90001048),
        Register('csr413', 4, 0x9000104c),
        Register('csr414', 4, 0x90001050),
        Register('csr415', 4, 0x90001054),
        Register('csr416', 4, 0x90001058),
        Register('csr417', 4, 0x9000105c),
        Register('csr418', 4, 0x90001060),
        Register('csr419', 4, 0x90001064),
        Register('csr41a', 4, 0x90001068),
        Register('csr41b', 4, 0x9000106c),
        Register('csr41c', 4, 0x90001070),
        Register('csr41d', 4, 0x90001074),
        Register('csr41e', 4, 0x90001078),
        Register('csr41f', 4, 0x9000107c),
        Register('csr420', 4, 0x90001080),
        Register('csr421', 4, 0x90001084),
        Register('csr422', 4, 0x90001088),
        Register('csr423', 4, 0x9000108c),
        Register('csr424', 4, 0x90001090),
        Register('csr425', 4, 0x90001094),
        Register('csr426', 4, 0x90001098),
        Register('csr427', 4, 0x9000109c),
        Register('csr428', 4, 0x900010a0),
        Register('csr429', 4, 0x900010a4),
        Register('csr42a', 4, 0x900010a8),
        Register('csr42b', 4, 0x900010ac),
        Register('csr42c', 4, 0x900010b0),
        Register('csr42d', 4, 0x900010b4),
        Register('csr42e', 4, 0x900010b8),
        Register('csr42f', 4, 0x900010bc),
        Register('csr430', 4, 0x900010c0),
        Register('csr431', 4, 0x900010c4),
        Register('csr432', 4, 0x900010c8),
        Register('csr433', 4, 0x900010cc),
        Register('csr434', 4, 0x900010d0),
        Register('csr435', 4, 0x900010d4),
        Register('csr436', 4, 0x900010d8),
        Register('csr437', 4, 0x900010dc),
        Register('csr438', 4, 0x900010e0),
        Register('csr439', 4, 0x900010e4),
        Register('csr43a', 4, 0x900010e8),
        Register('csr43b', 4, 0x900010ec),
        Register('csr43c', 4, 0x900010f0),
        Register('csr43d', 4, 0x900010f4),
        Register('csr43e', 4, 0x900010f8),
        Register('csr43f', 4, 0x900010fc),
        Register('csr440', 4, 0x90001100),
        Register('csr441', 4, 0x90001104),
        Register('csr442', 4, 0x90001108),
        Register('csr443', 4, 0x9000110c),
        Register('csr444', 4, 0x90001110),
        Register('csr445', 4, 0x90001114),
        Register('csr446', 4, 0x90001118),
        Register('csr447', 4, 0x9000111c),
        Register('csr448', 4, 0x90001120),
        Register('csr449', 4, 0x90001124),
        Register('csr44a', 4, 0x90001128),
        Register('csr44b', 4, 0x9000112c),
        Register('csr44c', 4, 0x90001130),
        Register('csr44d', 4, 0x90001134),
        Register('csr44e', 4, 0x90001138),
        Register('csr44f', 4, 0x9000113c),
        Register('csr450', 4, 0x90001140),
        Register('csr451', 4, 0x90001144),
        Register('csr452', 4, 0x90001148),
        Register('csr453', 4, 0x9000114c),
        Register('csr454', 4, 0x90001150),
        Register('csr455', 4, 0x90001154),
        Register('csr456', 4, 0x90001158),
        Register('csr457', 4, 0x9000115c),
        Register('csr458', 4, 0x90001160),
        Register('csr459', 4, 0x90001164),
        Register('csr45a', 4, 0x90001168),
        Register('csr45b', 4, 0x9000116c),
        Register('csr45c', 4, 0x90001170),
        Register('csr45d', 4, 0x90001174),
        Register('csr45e', 4, 0x90001178),
        Register('csr45f', 4, 0x9000117c),
        Register('csr460', 4, 0x90001180),
        Register('csr461', 4, 0x90001184),
        Register('csr462', 4, 0x90001188),
        Register('csr463', 4, 0x9000118c),
        Register('csr464', 4, 0x90001190),
        Register('csr465', 4, 0x90001194),
        Register('csr466', 4, 0x90001198),
        Register('csr467', 4, 0x9000119c),
        Register('csr468', 4, 0x900011a0),
        Register('csr469', 4, 0x900011a4),
        Register('csr46a', 4, 0x900011a8),
        Register('csr46b', 4, 0x900011ac),
        Register('csr46c', 4, 0x900011b0),
        Register('csr46d', 4, 0x900011b4),
        Register('csr46e', 4, 0x900011b8),
        Register('csr46f', 4, 0x900011bc),
        Register('csr470', 4, 0x900011c0),
        Register('csr471', 4, 0x900011c4),
        Register('csr472', 4, 0x900011c8),
        Register('csr473', 4, 0x900011cc),
        Register('csr474', 4, 0x900011d0),
        Register('csr475', 4, 0x900011d4),
        Register('csr476', 4, 0x900011d8),
        Register('csr477', 4, 0x900011dc),
        Register('csr478', 4, 0x900011e0),
        Register('csr479', 4, 0x900011e4),
        Register('csr47a', 4, 0x900011e8),
        Register('csr47b', 4, 0x900011ec),
        Register('csr47c', 4, 0x900011f0),
        Register('csr47d', 4, 0x900011f4),
        Register('csr47e', 4, 0x900011f8),
        Register('csr47f', 4, 0x900011fc),
        Register('csr480', 4, 0x90001200),
        Register('csr481', 4, 0x90001204),
        Register('csr482', 4, 0x90001208),
        Register('csr483', 4, 0x9000120c),
        Register('csr484', 4, 0x90001210),
        Register('csr485', 4, 0x90001214),
        Register('csr486', 4, 0x90001218),
        Register('csr487', 4, 0x9000121c),
        Register('csr488', 4, 0x90001220),
        Register('csr489', 4, 0x90001224),
        Register('csr48a', 4, 0x90001228),
        Register('csr48b', 4, 0x9000122c),
        Register('csr48c', 4, 0x90001230),
        Register('csr48d', 4, 0x90001234),
        Register('csr48e', 4, 0x90001238),
        Register('csr48f', 4, 0x9000123c),
        Register('csr490', 4, 0x90001240),
        Register('csr491', 4, 0x90001244),
        Register('csr492', 4, 0x90001248),
        Register('csr493', 4, 0x9000124c),
        Register('csr494', 4, 0x90001250),
        Register('csr495', 4, 0x90001254),
        Register('csr496', 4, 0x90001258),
        Register('csr497', 4, 0x9000125c),
        Register('csr498', 4, 0x90001260),
        Register('csr499', 4, 0x90001264),
        Register('csr49a', 4, 0x90001268),
        Register('csr49b', 4, 0x9000126c),
        Register('csr49c', 4, 0x90001270),
        Register('csr49d', 4, 0x90001274),
        Register('csr49e', 4, 0x90001278),
        Register('csr49f', 4, 0x9000127c),
        Register('csr4a0', 4, 0x90001280),
        Register('csr4a1', 4, 0x90001284),
        Register('csr4a2', 4, 0x90001288),
        Register('csr4a3', 4, 0x9000128c),
        Register('csr4a4', 4, 0x90001290),
        Register('csr4a5', 4, 0x90001294),
        Register('csr4a6', 4, 0x90001298),
        Register('csr4a7', 4, 0x9000129c),
        Register('csr4a8', 4, 0x900012a0),
        Register('csr4a9', 4, 0x900012a4),
        Register('csr4aa', 4, 0x900012a8),
        Register('csr4ab', 4, 0x900012ac),
        Register('csr4ac', 4, 0x900012b0),
        Register('csr4ad', 4, 0x900012b4),
        Register('csr4ae', 4, 0x900012b8),
        Register('csr4af', 4, 0x900012bc),
        Register('csr4b0', 4, 0x900012c0),
        Register('csr4b1', 4, 0x900012c4),
        Register('csr4b2', 4, 0x900012c8),
        Register('csr4b3', 4, 0x900012cc),
        Register('csr4b4', 4, 0x900012d0),
        Register('csr4b5', 4, 0x900012d4),
        Register('csr4b6', 4, 0x900012d8),
        Register('csr4b7', 4, 0x900012dc),
        Register('csr4b8', 4, 0x900012e0),
        Register('csr4b9', 4, 0x900012e4),
        Register('csr4ba', 4, 0x900012e8),
        Register('csr4bb', 4, 0x900012ec),
        Register('csr4bc', 4, 0x900012f0),
        Register('csr4bd', 4, 0x900012f4),
        Register('csr4be', 4, 0x900012f8),
        Register('csr4bf', 4, 0x900012fc),
        Register('csr4c0', 4, 0x90001300),
        Register('csr4c1', 4, 0x90001304),
        Register('csr4c2', 4, 0x90001308),
        Register('csr4c3', 4, 0x9000130c),
        Register('csr4c4', 4, 0x90001310),
        Register('csr4c5', 4, 0x90001314),
        Register('csr4c6', 4, 0x90001318),
        Register('csr4c7', 4, 0x9000131c),
        Register('csr4c8', 4, 0x90001320),
        Register('csr4c9', 4, 0x90001324),
        Register('csr4ca', 4, 0x90001328),
        Register('csr4cb', 4, 0x9000132c),
        Register('csr4cc', 4, 0x90001330),
        Register('csr4cd', 4, 0x90001334),
        Register('csr4ce', 4, 0x90001338),
        Register('csr4cf', 4, 0x9000133c),
        Register('csr4d0', 4, 0x90001340),
        Register('csr4d1', 4, 0x90001344),
        Register('csr4d2', 4, 0x90001348),
        Register('csr4d3', 4, 0x9000134c),
        Register('csr4d4', 4, 0x90001350),
        Register('csr4d5', 4, 0x90001354),
        Register('csr4d6', 4, 0x90001358),
        Register('csr4d7', 4, 0x9000135c),
        Register('csr4d8', 4, 0x90001360),
        Register('csr4d9', 4, 0x90001364),
        Register('csr4da', 4, 0x90001368),
        Register('csr4db', 4, 0x9000136c),
        Register('csr4dc', 4, 0x90001370),
        Register('csr4dd', 4, 0x90001374),
        Register('csr4de', 4, 0x90001378),
        Register('csr4df', 4, 0x9000137c),
        Register('csr4e0', 4, 0x90001380),
        Register('csr4e1', 4, 0x90001384),
        Register('csr4e2', 4, 0x90001388),
        Register('csr4e3', 4, 0x9000138c),
        Register('csr4e4', 4, 0x90001390),
        Register('csr4e5', 4, 0x90001394),
        Register('csr4e6', 4, 0x90001398),
        Register('csr4e7', 4, 0x9000139c),
        Register('csr4e8', 4, 0x900013a0),
        Register('csr4e9', 4, 0x900013a4),
        Register('csr4ea', 4, 0x900013a8),
        Register('csr4eb', 4, 0x900013ac),
        Register('csr4ec', 4, 0x900013b0),
        Register('csr4ed', 4, 0x900013b4),
        Register('csr4ee', 4, 0x900013b8),
        Register('csr4ef', 4, 0x900013bc),
        Register('csr4f0', 4, 0x900013c0),
        Register('csr4f1', 4, 0x900013c4),
        Register('csr4f2', 4, 0x900013c8),
        Register('csr4f3', 4, 0x900013cc),
        Register('csr4f4', 4, 0x900013d0),
        Register('csr4f5', 4, 0x900013d4),
        Register('csr4f6', 4, 0x900013d8),
        Register('csr4f7', 4, 0x900013dc),
        Register('csr4f8', 4, 0x900013e0),
        Register('csr4f9', 4, 0x900013e4),
        Register('csr4fa', 4, 0x900013e8),
        Register('csr4fb', 4, 0x900013ec),
        Register('csr4fc', 4, 0x900013f0),
        Register('csr4fd', 4, 0x900013f4),
        Register('csr4fe', 4, 0x900013f8),
        Register('csr4ff', 4, 0x900013fc),
        Register('csr500', 4, 0x90001400),
        Register('csr501', 4, 0x90001404),
        Register('csr502', 4, 0x90001408),
        Register('csr503', 4, 0x9000140c),
        Register('csr504', 4, 0x90001410),
        Register('csr505', 4, 0x90001414),
        Register('csr506', 4, 0x90001418),
        Register('csr507', 4, 0x9000141c),
        Register('csr508', 4, 0x90001420),
        Register('csr509', 4, 0x90001424),
        Register('csr50a', 4, 0x90001428),
        Register('csr50b', 4, 0x9000142c),
        Register('csr50c', 4, 0x90001430),
        Register('csr50d', 4, 0x90001434),
        Register('csr50e', 4, 0x90001438),
        Register('csr50f', 4, 0x9000143c),
        Register('csr510', 4, 0x90001440),
        Register('csr511', 4, 0x90001444),
        Register('csr512', 4, 0x90001448),
        Register('csr513', 4, 0x9000144c),
        Register('csr514', 4, 0x90001450),
        Register('csr515', 4, 0x90001454),
        Register('csr516', 4, 0x90001458),
        Register('csr517', 4, 0x9000145c),
        Register('csr518', 4, 0x90001460),
        Register('csr519', 4, 0x90001464),
        Register('csr51a', 4, 0x90001468),
        Register('csr51b', 4, 0x9000146c),
        Register('csr51c', 4, 0x90001470),
        Register('csr51d', 4, 0x90001474),
        Register('csr51e', 4, 0x90001478),
        Register('csr51f', 4, 0x9000147c),
        Register('csr520', 4, 0x90001480),
        Register('csr521', 4, 0x90001484),
        Register('csr522', 4, 0x90001488),
        Register('csr523', 4, 0x9000148c),
        Register('csr524', 4, 0x90001490),
        Register('csr525', 4, 0x90001494),
        Register('csr526', 4, 0x90001498),
        Register('csr527', 4, 0x9000149c),
        Register('csr528', 4, 0x900014a0),
        Register('csr529', 4, 0x900014a4),
        Register('csr52a', 4, 0x900014a8),
        Register('csr52b', 4, 0x900014ac),
        Register('csr52c', 4, 0x900014b0),
        Register('csr52d', 4, 0x900014b4),
        Register('csr52e', 4, 0x900014b8),
        Register('csr52f', 4, 0x900014bc),
        Register('csr530', 4, 0x900014c0),
        Register('csr531', 4, 0x900014c4),
        Register('csr532', 4, 0x900014c8),
        Register('csr533', 4, 0x900014cc),
        Register('csr534', 4, 0x900014d0),
        Register('csr535', 4, 0x900014d4),
        Register('csr536', 4, 0x900014d8),
        Register('csr537', 4, 0x900014dc),
        Register('csr538', 4, 0x900014e0),
        Register('csr539', 4, 0x900014e4),
        Register('csr53a', 4, 0x900014e8),
        Register('csr53b', 4, 0x900014ec),
        Register('csr53c', 4, 0x900014f0),
        Register('csr53d', 4, 0x900014f4),
        Register('csr53e', 4, 0x900014f8),
        Register('csr53f', 4, 0x900014fc),
        Register('csr540', 4, 0x90001500),
        Register('csr541', 4, 0x90001504),
        Register('csr542', 4, 0x90001508),
        Register('csr543', 4, 0x9000150c),
        Register('csr544', 4, 0x90001510),
        Register('csr545', 4, 0x90001514),
        Register('csr546', 4, 0x90001518),
        Register('csr547', 4, 0x9000151c),
        Register('csr548', 4, 0x90001520),
        Register('csr549', 4, 0x90001524),
        Register('csr54a', 4, 0x90001528),
        Register('csr54b', 4, 0x9000152c),
        Register('csr54c', 4, 0x90001530),
        Register('csr54d', 4, 0x90001534),
        Register('csr54e', 4, 0x90001538),
        Register('csr54f', 4, 0x9000153c),
        Register('csr550', 4, 0x90001540),
        Register('csr551', 4, 0x90001544),
        Register('csr552', 4, 0x90001548),
        Register('csr553', 4, 0x9000154c),
        Register('csr554', 4, 0x90001550),
        Register('csr555', 4, 0x90001554),
        Register('csr556', 4, 0x90001558),
        Register('csr557', 4, 0x9000155c),
        Register('csr558', 4, 0x90001560),
        Register('csr559', 4, 0x90001564),
        Register('csr55a', 4, 0x90001568),
        Register('csr55b', 4, 0x9000156c),
        Register('csr55c', 4, 0x90001570),
        Register('csr55d', 4, 0x90001574),
        Register('csr55e', 4, 0x90001578),
        Register('csr55f', 4, 0x9000157c),
        Register('csr560', 4, 0x90001580),
        Register('csr561', 4, 0x90001584),
        Register('csr562', 4, 0x90001588),
        Register('csr563', 4, 0x9000158c),
        Register('csr564', 4, 0x90001590),
        Register('csr565', 4, 0x90001594),
        Register('csr566', 4, 0x90001598),
        Register('csr567', 4, 0x9000159c),
        Register('csr568', 4, 0x900015a0),
        Register('csr569', 4, 0x900015a4),
        Register('csr56a', 4, 0x900015a8),
        Register('csr56b', 4, 0x900015ac),
        Register('csr56c', 4, 0x900015b0),
        Register('csr56d', 4, 0x900015b4),
        Register('csr56e', 4, 0x900015b8),
        Register('csr56f', 4, 0x900015bc),
        Register('csr570', 4, 0x900015c0),
        Register('csr571', 4, 0x900015c4),
        Register('csr572', 4, 0x900015c8),
        Register('csr573', 4, 0x900015cc),
        Register('csr574', 4, 0x900015d0),
        Register('csr575', 4, 0x900015d4),
        Register('csr576', 4, 0x900015d8),
        Register('csr577', 4, 0x900015dc),
        Register('csr578', 4, 0x900015e0),
        Register('csr579', 4, 0x900015e4),
        Register('csr57a', 4, 0x900015e8),
        Register('csr57b', 4, 0x900015ec),
        Register('csr57c', 4, 0x900015f0),
        Register('csr57d', 4, 0x900015f4),
        Register('csr57e', 4, 0x900015f8),
        Register('csr57f', 4, 0x900015fc),
        Register('csr580', 4, 0x90001600),
        Register('csr581', 4, 0x90001604),
        Register('csr582', 4, 0x90001608),
        Register('csr583', 4, 0x9000160c),
        Register('csr584', 4, 0x90001610),
        Register('csr585', 4, 0x90001614),
        Register('csr586', 4, 0x90001618),
        Register('csr587', 4, 0x9000161c),
        Register('csr588', 4, 0x90001620),
        Register('csr589', 4, 0x90001624),
        Register('csr58a', 4, 0x90001628),
        Register('csr58b', 4, 0x9000162c),
        Register('csr58c', 4, 0x90001630),
        Register('csr58d', 4, 0x90001634),
        Register('csr58e', 4, 0x90001638),
        Register('csr58f', 4, 0x9000163c),
        Register('csr590', 4, 0x90001640),
        Register('csr591', 4, 0x90001644),
        Register('csr592', 4, 0x90001648),
        Register('csr593', 4, 0x9000164c),
        Register('csr594', 4, 0x90001650),
        Register('csr595', 4, 0x90001654),
        Register('csr596', 4, 0x90001658),
        Register('csr597', 4, 0x9000165c),
        Register('csr598', 4, 0x90001660),
        Register('csr599', 4, 0x90001664),
        Register('csr59a', 4, 0x90001668),
        Register('csr59b', 4, 0x9000166c),
        Register('csr59c', 4, 0x90001670),
        Register('csr59d', 4, 0x90001674),
        Register('csr59e', 4, 0x90001678),
        Register('csr59f', 4, 0x9000167c),
        Register('csr5a0', 4, 0x90001680),
        Register('csr5a1', 4, 0x90001684),
        Register('csr5a2', 4, 0x90001688),
        Register('csr5a3', 4, 0x9000168c),
        Register('csr5a4', 4, 0x90001690),
        Register('csr5a5', 4, 0x90001694),
        Register('csr5a6', 4, 0x90001698),
        Register('csr5a7', 4, 0x9000169c),
        Register('scontext', 4, 0x900016a0),
        Register('csr5a9', 4, 0x900016a4),
        Register('csr5aa', 4, 0x900016a8),
        Register('csr5ab', 4, 0x900016ac),
        Register('csr5ac', 4, 0x900016b0),
        Register('csr5ad', 4, 0x900016b4),
        Register('csr5ae', 4, 0x900016b8),
        Register('csr5af', 4, 0x900016bc),
        Register('csr5b0', 4, 0x900016c0),
        Register('csr5b1', 4, 0x900016c4),
        Register('csr5b2', 4, 0x900016c8),
        Register('csr5b3', 4, 0x900016cc),
        Register('csr5b4', 4, 0x900016d0),
        Register('csr5b5', 4, 0x900016d4),
        Register('csr5b6', 4, 0x900016d8),
        Register('csr5b7', 4, 0x900016dc),
        Register('csr5b8', 4, 0x900016e0),
        Register('csr5b9', 4, 0x900016e4),
        Register('csr5ba', 4, 0x900016e8),
        Register('csr5bb', 4, 0x900016ec),
        Register('csr5bc', 4, 0x900016f0),
        Register('csr5bd', 4, 0x900016f4),
        Register('csr5be', 4, 0x900016f8),
        Register('csr5bf', 4, 0x900016fc),
        Register('csr5c0', 4, 0x90001700),
        Register('csr5c1', 4, 0x90001704),
        Register('csr5c2', 4, 0x90001708),
        Register('csr5c3', 4, 0x9000170c),
        Register('csr5c4', 4, 0x90001710),
        Register('csr5c5', 4, 0x90001714),
        Register('csr5c6', 4, 0x90001718),
        Register('csr5c7', 4, 0x9000171c),
        Register('csr5c8', 4, 0x90001720),
        Register('csr5c9', 4, 0x90001724),
        Register('csr5ca', 4, 0x90001728),
        Register('csr5cb', 4, 0x9000172c),
        Register('csr5cc', 4, 0x90001730),
        Register('csr5cd', 4, 0x90001734),
        Register('csr5ce', 4, 0x90001738),
        Register('csr5cf', 4, 0x9000173c),
        Register('csr5d0', 4, 0x90001740),
        Register('csr5d1', 4, 0x90001744),
        Register('csr5d2', 4, 0x90001748),
        Register('csr5d3', 4, 0x9000174c),
        Register('csr5d4', 4, 0x90001750),
        Register('csr5d5', 4, 0x90001754),
        Register('csr5d6', 4, 0x90001758),
        Register('csr5d7', 4, 0x9000175c),
        Register('csr5d8', 4, 0x90001760),
        Register('csr5d9', 4, 0x90001764),
        Register('csr5da', 4, 0x90001768),
        Register('csr5db', 4, 0x9000176c),
        Register('csr5dc', 4, 0x90001770),
        Register('csr5dd', 4, 0x90001774),
        Register('csr5de', 4, 0x90001778),
        Register('csr5df', 4, 0x9000177c),
        Register('csr5e0', 4, 0x90001780),
        Register('csr5e1', 4, 0x90001784),
        Register('csr5e2', 4, 0x90001788),
        Register('csr5e3', 4, 0x9000178c),
        Register('csr5e4', 4, 0x90001790),
        Register('csr5e5', 4, 0x90001794),
        Register('csr5e6', 4, 0x90001798),
        Register('csr5e7', 4, 0x9000179c),
        Register('csr5e8', 4, 0x900017a0),
        Register('csr5e9', 4, 0x900017a4),
        Register('csr5ea', 4, 0x900017a8),
        Register('csr5eb', 4, 0x900017ac),
        Register('csr5ec', 4, 0x900017b0),
        Register('csr5ed', 4, 0x900017b4),
        Register('csr5ee', 4, 0x900017b8),
        Register('csr5ef', 4, 0x900017bc),
        Register('csr5f0', 4, 0x900017c0),
        Register('csr5f1', 4, 0x900017c4),
        Register('csr5f2', 4, 0x900017c8),
        Register('csr5f3', 4, 0x900017cc),
        Register('csr5f4', 4, 0x900017d0),
        Register('csr5f5', 4, 0x900017d4),
        Register('csr5f6', 4, 0x900017d8),
        Register('csr5f7', 4, 0x900017dc),
        Register('csr5f8', 4, 0x900017e0),
        Register('csr5f9', 4, 0x900017e4),
        Register('csr5fa', 4, 0x900017e8),
        Register('csr5fb', 4, 0x900017ec),
        Register('csr5fc', 4, 0x900017f0),
        Register('csr5fd', 4, 0x900017f4),
        Register('csr5fe', 4, 0x900017f8),
        Register('csr5ff', 4, 0x900017fc),
        Register('hstatus', 4, 0x90001800),
        Register('csr601', 4, 0x90001804),
        Register('hedeleg', 4, 0x90001808),
        Register('hideleg', 4, 0x9000180c),
        Register('hie', 4, 0x90001810),
        Register('htimedelta', 4, 0x90001814),
        Register('hcounteren', 4, 0x90001818),
        Register('hgeie', 4, 0x9000181c),
        Register('csr608', 4, 0x90001820),
        Register('csr609', 4, 0x90001824),
        Register('csr60a', 4, 0x90001828),
        Register('csr60b', 4, 0x9000182c),
        Register('csr60c', 4, 0x90001830),
        Register('csr60d', 4, 0x90001834),
        Register('csr60e', 4, 0x90001838),
        Register('csr60f', 4, 0x9000183c),
        Register('csr610', 4, 0x90001840),
        Register('csr611', 4, 0x90001844),
        Register('csr612', 4, 0x90001848),
        Register('csr613', 4, 0x9000184c),
        Register('csr614', 4, 0x90001850),
        Register('htimedeltah', 4, 0x90001854),
        Register('csr616', 4, 0x90001858),
        Register('csr617', 4, 0x9000185c),
        Register('csr618', 4, 0x90001860),
        Register('csr619', 4, 0x90001864),
        Register('csr61a', 4, 0x90001868),
        Register('csr61b', 4, 0x9000186c),
        Register('csr61c', 4, 0x90001870),
        Register('csr61d', 4, 0x90001874),
        Register('csr61e', 4, 0x90001878),
        Register('csr61f', 4, 0x9000187c),
        Register('csr620', 4, 0x90001880),
        Register('csr621', 4, 0x90001884),
        Register('csr622', 4, 0x90001888),
        Register('csr623', 4, 0x9000188c),
        Register('csr624', 4, 0x90001890),
        Register('csr625', 4, 0x90001894),
        Register('csr626', 4, 0x90001898),
        Register('csr627', 4, 0x9000189c),
        Register('csr628', 4, 0x900018a0),
        Register('csr629', 4, 0x900018a4),
        Register('csr62a', 4, 0x900018a8),
        Register('csr62b', 4, 0x900018ac),
        Register('csr62c', 4, 0x900018b0),
        Register('csr62d', 4, 0x900018b4),
        Register('csr62e', 4, 0x900018b8),
        Register('csr62f', 4, 0x900018bc),
        Register('csr630', 4, 0x900018c0),
        Register('csr631', 4, 0x900018c4),
        Register('csr632', 4, 0x900018c8),
        Register('csr633', 4, 0x900018cc),
        Register('csr634', 4, 0x900018d0),
        Register('csr635', 4, 0x900018d4),
        Register('csr636', 4, 0x900018d8),
        Register('csr637', 4, 0x900018dc),
        Register('csr638', 4, 0x900018e0),
        Register('csr639', 4, 0x900018e4),
        Register('csr63a', 4, 0x900018e8),
        Register('csr63b', 4, 0x900018ec),
        Register('csr63c', 4, 0x900018f0),
        Register('csr63d', 4, 0x900018f4),
        Register('csr63e', 4, 0x900018f8),
        Register('csr63f', 4, 0x900018fc),
        Register('csr640', 4, 0x90001900),
        Register('csr641', 4, 0x90001904),
        Register('csr642', 4, 0x90001908),
        Register('htval', 4, 0x9000190c),
        Register('hip', 4, 0x90001910),
        Register('hvip', 4, 0x90001914),
        Register('csr646', 4, 0x90001918),
        Register('csr647', 4, 0x9000191c),
        Register('csr648', 4, 0x90001920),
        Register('csr649', 4, 0x90001924),
        Register('htinst', 4, 0x90001928),
        Register('csr64b', 4, 0x9000192c),
        Register('csr64c', 4, 0x90001930),
        Register('csr64d', 4, 0x90001934),
        Register('csr64e', 4, 0x90001938),
        Register('csr64f', 4, 0x9000193c),
        Register('csr650', 4, 0x90001940),
        Register('csr651', 4, 0x90001944),
        Register('csr652', 4, 0x90001948),
        Register('csr653', 4, 0x9000194c),
        Register('csr654', 4, 0x90001950),
        Register('csr655', 4, 0x90001954),
        Register('csr656', 4, 0x90001958),
        Register('csr657', 4, 0x9000195c),
        Register('csr658', 4, 0x90001960),
        Register('csr659', 4, 0x90001964),
        Register('csr65a', 4, 0x90001968),
        Register('csr65b', 4, 0x9000196c),
        Register('csr65c', 4, 0x90001970),
        Register('csr65d', 4, 0x90001974),
        Register('csr65e', 4, 0x90001978),
        Register('csr65f', 4, 0x9000197c),
        Register('csr660', 4, 0x90001980),
        Register('csr661', 4, 0x90001984),
        Register('csr662', 4, 0x90001988),
        Register('csr663', 4, 0x9000198c),
        Register('csr664', 4, 0x90001990),
        Register('csr665', 4, 0x90001994),
        Register('csr666', 4, 0x90001998),
        Register('csr667', 4, 0x9000199c),
        Register('csr668', 4, 0x900019a0),
        Register('csr669', 4, 0x900019a4),
        Register('csr66a', 4, 0x900019a8),
        Register('csr66b', 4, 0x900019ac),
        Register('csr66c', 4, 0x900019b0),
        Register('csr66d', 4, 0x900019b4),
        Register('csr66e', 4, 0x900019b8),
        Register('csr66f', 4, 0x900019bc),
        Register('csr670', 4, 0x900019c0),
        Register('csr671', 4, 0x900019c4),
        Register('csr672', 4, 0x900019c8),
        Register('csr673', 4, 0x900019cc),
        Register('csr674', 4, 0x900019d0),
        Register('csr675', 4, 0x900019d4),
        Register('csr676', 4, 0x900019d8),
        Register('csr677', 4, 0x900019dc),
        Register('csr678', 4, 0x900019e0),
        Register('csr679', 4, 0x900019e4),
        Register('csr67a', 4, 0x900019e8),
        Register('csr67b', 4, 0x900019ec),
        Register('csr67c', 4, 0x900019f0),
        Register('csr67d', 4, 0x900019f4),
        Register('csr67e', 4, 0x900019f8),
        Register('csr67f', 4, 0x900019fc),
        Register('hgatp', 4, 0x90001a00),
        Register('csr681', 4, 0x90001a04),
        Register('csr682', 4, 0x90001a08),
        Register('csr683', 4, 0x90001a0c),
        Register('csr684', 4, 0x90001a10),
        Register('csr685', 4, 0x90001a14),
        Register('csr686', 4, 0x90001a18),
        Register('csr687', 4, 0x90001a1c),
        Register('csr688', 4, 0x90001a20),
        Register('csr689', 4, 0x90001a24),
        Register('csr68a', 4, 0x90001a28),
        Register('csr68b', 4, 0x90001a2c),
        Register('csr68c', 4, 0x90001a30),
        Register('csr68d', 4, 0x90001a34),
        Register('csr68e', 4, 0x90001a38),
        Register('csr68f', 4, 0x90001a3c),
        Register('csr690', 4, 0x90001a40),
        Register('csr691', 4, 0x90001a44),
        Register('csr692', 4, 0x90001a48),
        Register('csr693', 4, 0x90001a4c),
        Register('csr694', 4, 0x90001a50),
        Register('csr695', 4, 0x90001a54),
        Register('csr696', 4, 0x90001a58),
        Register('csr697', 4, 0x90001a5c),
        Register('csr698', 4, 0x90001a60),
        Register('csr699', 4, 0x90001a64),
        Register('csr69a', 4, 0x90001a68),
        Register('csr69b', 4, 0x90001a6c),
        Register('csr69c', 4, 0x90001a70),
        Register('csr69d', 4, 0x90001a74),
        Register('csr69e', 4, 0x90001a78),
        Register('csr69f', 4, 0x90001a7c),
        Register('csr6a0', 4, 0x90001a80),
        Register('csr6a1', 4, 0x90001a84),
        Register('csr6a2', 4, 0x90001a88),
        Register('csr6a3', 4, 0x90001a8c),
        Register('csr6a4', 4, 0x90001a90),
        Register('csr6a5', 4, 0x90001a94),
        Register('csr6a6', 4, 0x90001a98),
        Register('csr6a7', 4, 0x90001a9c),
        Register('hcontext', 4, 0x90001aa0),
        Register('csr6a9', 4, 0x90001aa4),
        Register('csr6aa', 4, 0x90001aa8),
        Register('csr6ab', 4, 0x90001aac),
        Register('csr6ac', 4, 0x90001ab0),
        Register('csr6ad', 4, 0x90001ab4),
        Register('csr6ae', 4, 0x90001ab8),
        Register('csr6af', 4, 0x90001abc),
        Register('csr6b0', 4, 0x90001ac0),
        Register('csr6b1', 4, 0x90001ac4),
        Register('csr6b2', 4, 0x90001ac8),
        Register('csr6b3', 4, 0x90001acc),
        Register('csr6b4', 4, 0x90001ad0),
        Register('csr6b5', 4, 0x90001ad4),
        Register('csr6b6', 4, 0x90001ad8),
        Register('csr6b7', 4, 0x90001adc),
        Register('csr6b8', 4, 0x90001ae0),
        Register('csr6b9', 4, 0x90001ae4),
        Register('csr6ba', 4, 0x90001ae8),
        Register('csr6bb', 4, 0x90001aec),
        Register('csr6bc', 4, 0x90001af0),
        Register('csr6bd', 4, 0x90001af4),
        Register('csr6be', 4, 0x90001af8),
        Register('csr6bf', 4, 0x90001afc),
        Register('csr6c0', 4, 0x90001b00),
        Register('csr6c1', 4, 0x90001b04),
        Register('csr6c2', 4, 0x90001b08),
        Register('csr6c3', 4, 0x90001b0c),
        Register('csr6c4', 4, 0x90001b10),
        Register('csr6c5', 4, 0x90001b14),
        Register('csr6c6', 4, 0x90001b18),
        Register('csr6c7', 4, 0x90001b1c),
        Register('csr6c8', 4, 0x90001b20),
        Register('csr6c9', 4, 0x90001b24),
        Register('csr6ca', 4, 0x90001b28),
        Register('csr6cb', 4, 0x90001b2c),
        Register('csr6cc', 4, 0x90001b30),
        Register('csr6cd', 4, 0x90001b34),
        Register('csr6ce', 4, 0x90001b38),
        Register('csr6cf', 4, 0x90001b3c),
        Register('csr6d0', 4, 0x90001b40),
        Register('csr6d1', 4, 0x90001b44),
        Register('csr6d2', 4, 0x90001b48),
        Register('csr6d3', 4, 0x90001b4c),
        Register('csr6d4', 4, 0x90001b50),
        Register('csr6d5', 4, 0x90001b54),
        Register('csr6d6', 4, 0x90001b58),
        Register('csr6d7', 4, 0x90001b5c),
        Register('csr6d8', 4, 0x90001b60),
        Register('csr6d9', 4, 0x90001b64),
        Register('csr6da', 4, 0x90001b68),
        Register('csr6db', 4, 0x90001b6c),
        Register('csr6dc', 4, 0x90001b70),
        Register('csr6dd', 4, 0x90001b74),
        Register('csr6de', 4, 0x90001b78),
        Register('csr6df', 4, 0x90001b7c),
        Register('csr6e0', 4, 0x90001b80),
        Register('csr6e1', 4, 0x90001b84),
        Register('csr6e2', 4, 0x90001b88),
        Register('csr6e3', 4, 0x90001b8c),
        Register('csr6e4', 4, 0x90001b90),
        Register('csr6e5', 4, 0x90001b94),
        Register('csr6e6', 4, 0x90001b98),
        Register('csr6e7', 4, 0x90001b9c),
        Register('csr6e8', 4, 0x90001ba0),
        Register('csr6e9', 4, 0x90001ba4),
        Register('csr6ea', 4, 0x90001ba8),
        Register('csr6eb', 4, 0x90001bac),
        Register('csr6ec', 4, 0x90001bb0),
        Register('csr6ed', 4, 0x90001bb4),
        Register('csr6ee', 4, 0x90001bb8),
        Register('csr6ef', 4, 0x90001bbc),
        Register('csr6f0', 4, 0x90001bc0),
        Register('csr6f1', 4, 0x90001bc4),
        Register('csr6f2', 4, 0x90001bc8),
        Register('csr6f3', 4, 0x90001bcc),
        Register('csr6f4', 4, 0x90001bd0),
        Register('csr6f5', 4, 0x90001bd4),
        Register('csr6f6', 4, 0x90001bd8),
        Register('csr6f7', 4, 0x90001bdc),
        Register('csr6f8', 4, 0x90001be0),
        Register('csr6f9', 4, 0x90001be4),
        Register('csr6fa', 4, 0x90001be8),
        Register('csr6fb', 4, 0x90001bec),
        Register('csr6fc', 4, 0x90001bf0),
        Register('csr6fd', 4, 0x90001bf4),
        Register('csr6fe', 4, 0x90001bf8),
        Register('csr6ff', 4, 0x90001bfc),
        Register('csr700', 4, 0x90001c00),
        Register('csr701', 4, 0x90001c04),
        Register('csr702', 4, 0x90001c08),
        Register('csr703', 4, 0x90001c0c),
        Register('csr704', 4, 0x90001c10),
        Register('csr705', 4, 0x90001c14),
        Register('csr706', 4, 0x90001c18),
        Register('csr707', 4, 0x90001c1c),
        Register('csr708', 4, 0x90001c20),
        Register('csr709', 4, 0x90001c24),
        Register('csr70a', 4, 0x90001c28),
        Register('csr70b', 4, 0x90001c2c),
        Register('csr70c', 4, 0x90001c30),
        Register('csr70d', 4, 0x90001c34),
        Register('csr70e', 4, 0x90001c38),
        Register('csr70f', 4, 0x90001c3c),
        Register('csr710', 4, 0x90001c40),
        Register('csr711', 4, 0x90001c44),
        Register('csr712', 4, 0x90001c48),
        Register('csr713', 4, 0x90001c4c),
        Register('csr714', 4, 0x90001c50),
        Register('csr715', 4, 0x90001c54),
        Register('csr716', 4, 0x90001c58),
        Register('csr717', 4, 0x90001c5c),
        Register('csr718', 4, 0x90001c60),
        Register('csr719', 4, 0x90001c64),
        Register('csr71a', 4, 0x90001c68),
        Register('csr71b', 4, 0x90001c6c),
        Register('csr71c', 4, 0x90001c70),
        Register('csr71d', 4, 0x90001c74),
        Register('csr71e', 4, 0x90001c78),
        Register('csr71f', 4, 0x90001c7c),
        Register('csr720', 4, 0x90001c80),
        Register('csr721', 4, 0x90001c84),
        Register('csr722', 4, 0x90001c88),
        Register('csr723', 4, 0x90001c8c),
        Register('csr724', 4, 0x90001c90),
        Register('csr725', 4, 0x90001c94),
        Register('csr726', 4, 0x90001c98),
        Register('csr727', 4, 0x90001c9c),
        Register('csr728', 4, 0x90001ca0),
        Register('csr729', 4, 0x90001ca4),
        Register('csr72a', 4, 0x90001ca8),
        Register('csr72b', 4, 0x90001cac),
        Register('csr72c', 4, 0x90001cb0),
        Register('csr72d', 4, 0x90001cb4),
        Register('csr72e', 4, 0x90001cb8),
        Register('csr72f', 4, 0x90001cbc),
        Register('csr730', 4, 0x90001cc0),
        Register('csr731', 4, 0x90001cc4),
        Register('csr732', 4, 0x90001cc8),
        Register('csr733', 4, 0x90001ccc),
        Register('csr734', 4, 0x90001cd0),
        Register('csr735', 4, 0x90001cd4),
        Register('csr736', 4, 0x90001cd8),
        Register('csr737', 4, 0x90001cdc),
        Register('csr738', 4, 0x90001ce0),
        Register('csr739', 4, 0x90001ce4),
        Register('csr73a', 4, 0x90001ce8),
        Register('csr73b', 4, 0x90001cec),
        Register('csr73c', 4, 0x90001cf0),
        Register('csr73d', 4, 0x90001cf4),
        Register('csr73e', 4, 0x90001cf8),
        Register('csr73f', 4, 0x90001cfc),
        Register('csr740', 4, 0x90001d00),
        Register('csr741', 4, 0x90001d04),
        Register('csr742', 4, 0x90001d08),
        Register('csr743', 4, 0x90001d0c),
        Register('csr744', 4, 0x90001d10),
        Register('csr745', 4, 0x90001d14),
        Register('csr746', 4, 0x90001d18),
        Register('csr747', 4, 0x90001d1c),
        Register('csr748', 4, 0x90001d20),
        Register('csr749', 4, 0x90001d24),
        Register('csr74a', 4, 0x90001d28),
        Register('csr74b', 4, 0x90001d2c),
        Register('csr74c', 4, 0x90001d30),
        Register('csr74d', 4, 0x90001d34),
        Register('csr74e', 4, 0x90001d38),
        Register('csr74f', 4, 0x90001d3c),
        Register('csr750', 4, 0x90001d40),
        Register('csr751', 4, 0x90001d44),
        Register('csr752', 4, 0x90001d48),
        Register('csr753', 4, 0x90001d4c),
        Register('csr754', 4, 0x90001d50),
        Register('csr755', 4, 0x90001d54),
        Register('csr756', 4, 0x90001d58),
        Register('csr757', 4, 0x90001d5c),
        Register('csr758', 4, 0x90001d60),
        Register('csr759', 4, 0x90001d64),
        Register('csr75a', 4, 0x90001d68),
        Register('csr75b', 4, 0x90001d6c),
        Register('csr75c', 4, 0x90001d70),
        Register('csr75d', 4, 0x90001d74),
        Register('csr75e', 4, 0x90001d78),
        Register('csr75f', 4, 0x90001d7c),
        Register('csr760', 4, 0x90001d80),
        Register('csr761', 4, 0x90001d84),
        Register('csr762', 4, 0x90001d88),
        Register('csr763', 4, 0x90001d8c),
        Register('csr764', 4, 0x90001d90),
        Register('csr765', 4, 0x90001d94),
        Register('csr766', 4, 0x90001d98),
        Register('csr767', 4, 0x90001d9c),
        Register('csr768', 4, 0x90001da0),
        Register('csr769', 4, 0x90001da4),
        Register('csr76a', 4, 0x90001da8),
        Register('csr76b', 4, 0x90001dac),
        Register('csr76c', 4, 0x90001db0),
        Register('csr76d', 4, 0x90001db4),
        Register('csr76e', 4, 0x90001db8),
        Register('csr76f', 4, 0x90001dbc),
        Register('csr770', 4, 0x90001dc0),
        Register('csr771', 4, 0x90001dc4),
        Register('csr772', 4, 0x90001dc8),
        Register('csr773', 4, 0x90001dcc),
        Register('csr774', 4, 0x90001dd0),
        Register('csr775', 4, 0x90001dd4),
        Register('csr776', 4, 0x90001dd8),
        Register('csr777', 4, 0x90001ddc),
        Register('csr778', 4, 0x90001de0),
        Register('csr779', 4, 0x90001de4),
        Register('csr77a', 4, 0x90001de8),
        Register('csr77b', 4, 0x90001dec),
        Register('csr77c', 4, 0x90001df0),
        Register('csr77d', 4, 0x90001df4),
        Register('csr77e', 4, 0x90001df8),
        Register('csr77f', 4, 0x90001dfc),
        Register('csr780', 4, 0x90001e00),
        Register('csr781', 4, 0x90001e04),
        Register('csr782', 4, 0x90001e08),
        Register('csr783', 4, 0x90001e0c),
        Register('csr784', 4, 0x90001e10),
        Register('csr785', 4, 0x90001e14),
        Register('csr786', 4, 0x90001e18),
        Register('csr787', 4, 0x90001e1c),
        Register('csr788', 4, 0x90001e20),
        Register('csr789', 4, 0x90001e24),
        Register('csr78a', 4, 0x90001e28),
        Register('csr78b', 4, 0x90001e2c),
        Register('csr78c', 4, 0x90001e30),
        Register('csr78d', 4, 0x90001e34),
        Register('csr78e', 4, 0x90001e38),
        Register('csr78f', 4, 0x90001e3c),
        Register('csr790', 4, 0x90001e40),
        Register('csr791', 4, 0x90001e44),
        Register('csr792', 4, 0x90001e48),
        Register('csr793', 4, 0x90001e4c),
        Register('csr794', 4, 0x90001e50),
        Register('csr795', 4, 0x90001e54),
        Register('csr796', 4, 0x90001e58),
        Register('csr797', 4, 0x90001e5c),
        Register('csr798', 4, 0x90001e60),
        Register('csr799', 4, 0x90001e64),
        Register('csr79a', 4, 0x90001e68),
        Register('csr79b', 4, 0x90001e6c),
        Register('csr79c', 4, 0x90001e70),
        Register('csr79d', 4, 0x90001e74),
        Register('csr79e', 4, 0x90001e78),
        Register('csr79f', 4, 0x90001e7c),
        Register('tselect', 4, 0x90001e80),
        Register('tdata1', 4, 0x90001e84),
        Register('tdata2', 4, 0x90001e88),
        Register('tdata3', 4, 0x90001e8c),
        Register('csr7a4', 4, 0x90001e90),
        Register('csr7a5', 4, 0x90001e94),
        Register('csr7a6', 4, 0x90001e98),
        Register('csr7a7', 4, 0x90001e9c),
        Register('mcontext', 4, 0x90001ea0),
        Register('csr7a9', 4, 0x90001ea4),
        Register('csr7aa', 4, 0x90001ea8),
        Register('csr7ab', 4, 0x90001eac),
        Register('csr7ac', 4, 0x90001eb0),
        Register('csr7ad', 4, 0x90001eb4),
        Register('csr7ae', 4, 0x90001eb8),
        Register('csr7af', 4, 0x90001ebc),
        Register('dcsr', 4, 0x90001ec0),
        Register('dpc', 4, 0x90001ec4),
        Register('dscratch0', 4, 0x90001ec8),
        Register('dscratch1', 4, 0x90001ecc),
        Register('csr7b4', 4, 0x90001ed0),
        Register('csr7b5', 4, 0x90001ed4),
        Register('csr7b6', 4, 0x90001ed8),
        Register('csr7b7', 4, 0x90001edc),
        Register('csr7b8', 4, 0x90001ee0),
        Register('csr7b9', 4, 0x90001ee4),
        Register('csr7ba', 4, 0x90001ee8),
        Register('csr7bb', 4, 0x90001eec),
        Register('csr7bc', 4, 0x90001ef0),
        Register('csr7bd', 4, 0x90001ef4),
        Register('csr7be', 4, 0x90001ef8),
        Register('csr7bf', 4, 0x90001efc),
        Register('csr7c0', 4, 0x90001f00),
        Register('csr7c1', 4, 0x90001f04),
        Register('csr7c2', 4, 0x90001f08),
        Register('csr7c3', 4, 0x90001f0c),
        Register('csr7c4', 4, 0x90001f10),
        Register('csr7c5', 4, 0x90001f14),
        Register('csr7c6', 4, 0x90001f18),
        Register('csr7c7', 4, 0x90001f1c),
        Register('csr7c8', 4, 0x90001f20),
        Register('csr7c9', 4, 0x90001f24),
        Register('csr7ca', 4, 0x90001f28),
        Register('csr7cb', 4, 0x90001f2c),
        Register('csr7cc', 4, 0x90001f30),
        Register('csr7cd', 4, 0x90001f34),
        Register('csr7ce', 4, 0x90001f38),
        Register('csr7cf', 4, 0x90001f3c),
        Register('csr7d0', 4, 0x90001f40),
        Register('csr7d1', 4, 0x90001f44),
        Register('csr7d2', 4, 0x90001f48),
        Register('csr7d3', 4, 0x90001f4c),
        Register('csr7d4', 4, 0x90001f50),
        Register('csr7d5', 4, 0x90001f54),
        Register('csr7d6', 4, 0x90001f58),
        Register('csr7d7', 4, 0x90001f5c),
        Register('csr7d8', 4, 0x90001f60),
        Register('csr7d9', 4, 0x90001f64),
        Register('csr7da', 4, 0x90001f68),
        Register('csr7db', 4, 0x90001f6c),
        Register('csr7dc', 4, 0x90001f70),
        Register('csr7dd', 4, 0x90001f74),
        Register('csr7de', 4, 0x90001f78),
        Register('csr7df', 4, 0x90001f7c),
        Register('csr7e0', 4, 0x90001f80),
        Register('csr7e1', 4, 0x90001f84),
        Register('csr7e2', 4, 0x90001f88),
        Register('csr7e3', 4, 0x90001f8c),
        Register('csr7e4', 4, 0x90001f90),
        Register('csr7e5', 4, 0x90001f94),
        Register('csr7e6', 4, 0x90001f98),
        Register('csr7e7', 4, 0x90001f9c),
        Register('csr7e8', 4, 0x90001fa0),
        Register('csr7e9', 4, 0x90001fa4),
        Register('csr7ea', 4, 0x90001fa8),
        Register('csr7eb', 4, 0x90001fac),
        Register('csr7ec', 4, 0x90001fb0),
        Register('csr7ed', 4, 0x90001fb4),
        Register('csr7ee', 4, 0x90001fb8),
        Register('csr7ef', 4, 0x90001fbc),
        Register('csr7f0', 4, 0x90001fc0),
        Register('csr7f1', 4, 0x90001fc4),
        Register('csr7f2', 4, 0x90001fc8),
        Register('csr7f3', 4, 0x90001fcc),
        Register('csr7f4', 4, 0x90001fd0),
        Register('csr7f5', 4, 0x90001fd4),
        Register('csr7f6', 4, 0x90001fd8),
        Register('csr7f7', 4, 0x90001fdc),
        Register('csr7f8', 4, 0x90001fe0),
        Register('csr7f9', 4, 0x90001fe4),
        Register('csr7fa', 4, 0x90001fe8),
        Register('csr7fb', 4, 0x90001fec),
        Register('csr7fc', 4, 0x90001ff0),
        Register('csr7fd', 4, 0x90001ff4),
        Register('csr7fe', 4, 0x90001ff8),
        Register('csr7ff', 4, 0x90001ffc),
        Register('csr800', 4, 0x90002000),
        Register('csr801', 4, 0x90002004),
        Register('csr802', 4, 0x90002008),
        Register('csr803', 4, 0x9000200c),
        Register('csr804', 4, 0x90002010),
        Register('csr805', 4, 0x90002014),
        Register('csr806', 4, 0x90002018),
        Register('csr807', 4, 0x9000201c),
        Register('csr808', 4, 0x90002020),
        Register('csr809', 4, 0x90002024),
        Register('csr80a', 4, 0x90002028),
        Register('csr80b', 4, 0x9000202c),
        Register('csr80c', 4, 0x90002030),
        Register('csr80d', 4, 0x90002034),
        Register('csr80e', 4, 0x90002038),
        Register('csr80f', 4, 0x9000203c),
        Register('csr810', 4, 0x90002040),
        Register('csr811', 4, 0x90002044),
        Register('csr812', 4, 0x90002048),
        Register('csr813', 4, 0x9000204c),
        Register('csr814', 4, 0x90002050),
        Register('csr815', 4, 0x90002054),
        Register('csr816', 4, 0x90002058),
        Register('csr817', 4, 0x9000205c),
        Register('csr818', 4, 0x90002060),
        Register('csr819', 4, 0x90002064),
        Register('csr81a', 4, 0x90002068),
        Register('csr81b', 4, 0x9000206c),
        Register('csr81c', 4, 0x90002070),
        Register('csr81d', 4, 0x90002074),
        Register('csr81e', 4, 0x90002078),
        Register('csr81f', 4, 0x9000207c),
        Register('csr820', 4, 0x90002080),
        Register('csr821', 4, 0x90002084),
        Register('csr822', 4, 0x90002088),
        Register('csr823', 4, 0x9000208c),
        Register('csr824', 4, 0x90002090),
        Register('csr825', 4, 0x90002094),
        Register('csr826', 4, 0x90002098),
        Register('csr827', 4, 0x9000209c),
        Register('csr828', 4, 0x900020a0),
        Register('csr829', 4, 0x900020a4),
        Register('csr82a', 4, 0x900020a8),
        Register('csr82b', 4, 0x900020ac),
        Register('csr82c', 4, 0x900020b0),
        Register('csr82d', 4, 0x900020b4),
        Register('csr82e', 4, 0x900020b8),
        Register('csr82f', 4, 0x900020bc),
        Register('csr830', 4, 0x900020c0),
        Register('csr831', 4, 0x900020c4),
        Register('csr832', 4, 0x900020c8),
        Register('csr833', 4, 0x900020cc),
        Register('csr834', 4, 0x900020d0),
        Register('csr835', 4, 0x900020d4),
        Register('csr836', 4, 0x900020d8),
        Register('csr837', 4, 0x900020dc),
        Register('csr838', 4, 0x900020e0),
        Register('csr839', 4, 0x900020e4),
        Register('csr83a', 4, 0x900020e8),
        Register('csr83b', 4, 0x900020ec),
        Register('csr83c', 4, 0x900020f0),
        Register('csr83d', 4, 0x900020f4),
        Register('csr83e', 4, 0x900020f8),
        Register('csr83f', 4, 0x900020fc),
        Register('csr840', 4, 0x90002100),
        Register('csr841', 4, 0x90002104),
        Register('csr842', 4, 0x90002108),
        Register('csr843', 4, 0x9000210c),
        Register('csr844', 4, 0x90002110),
        Register('csr845', 4, 0x90002114),
        Register('csr846', 4, 0x90002118),
        Register('csr847', 4, 0x9000211c),
        Register('csr848', 4, 0x90002120),
        Register('csr849', 4, 0x90002124),
        Register('csr84a', 4, 0x90002128),
        Register('csr84b', 4, 0x9000212c),
        Register('csr84c', 4, 0x90002130),
        Register('csr84d', 4, 0x90002134),
        Register('csr84e', 4, 0x90002138),
        Register('csr84f', 4, 0x9000213c),
        Register('csr850', 4, 0x90002140),
        Register('csr851', 4, 0x90002144),
        Register('csr852', 4, 0x90002148),
        Register('csr853', 4, 0x9000214c),
        Register('csr854', 4, 0x90002150),
        Register('csr855', 4, 0x90002154),
        Register('csr856', 4, 0x90002158),
        Register('csr857', 4, 0x9000215c),
        Register('csr858', 4, 0x90002160),
        Register('csr859', 4, 0x90002164),
        Register('csr85a', 4, 0x90002168),
        Register('csr85b', 4, 0x9000216c),
        Register('csr85c', 4, 0x90002170),
        Register('csr85d', 4, 0x90002174),
        Register('csr85e', 4, 0x90002178),
        Register('csr85f', 4, 0x9000217c),
        Register('csr860', 4, 0x90002180),
        Register('csr861', 4, 0x90002184),
        Register('csr862', 4, 0x90002188),
        Register('csr863', 4, 0x9000218c),
        Register('csr864', 4, 0x90002190),
        Register('csr865', 4, 0x90002194),
        Register('csr866', 4, 0x90002198),
        Register('csr867', 4, 0x9000219c),
        Register('csr868', 4, 0x900021a0),
        Register('csr869', 4, 0x900021a4),
        Register('csr86a', 4, 0x900021a8),
        Register('csr86b', 4, 0x900021ac),
        Register('csr86c', 4, 0x900021b0),
        Register('csr86d', 4, 0x900021b4),
        Register('csr86e', 4, 0x900021b8),
        Register('csr86f', 4, 0x900021bc),
        Register('csr870', 4, 0x900021c0),
        Register('csr871', 4, 0x900021c4),
        Register('csr872', 4, 0x900021c8),
        Register('csr873', 4, 0x900021cc),
        Register('csr874', 4, 0x900021d0),
        Register('csr875', 4, 0x900021d4),
        Register('csr876', 4, 0x900021d8),
        Register('csr877', 4, 0x900021dc),
        Register('csr878', 4, 0x900021e0),
        Register('csr879', 4, 0x900021e4),
        Register('csr87a', 4, 0x900021e8),
        Register('csr87b', 4, 0x900021ec),
        Register('csr87c', 4, 0x900021f0),
        Register('csr87d', 4, 0x900021f4),
        Register('csr87e', 4, 0x900021f8),
        Register('csr87f', 4, 0x900021fc),
        Register('csr880', 4, 0x90002200),
        Register('csr881', 4, 0x90002204),
        Register('csr882', 4, 0x90002208),
        Register('csr883', 4, 0x9000220c),
        Register('csr884', 4, 0x90002210),
        Register('csr885', 4, 0x90002214),
        Register('csr886', 4, 0x90002218),
        Register('csr887', 4, 0x9000221c),
        Register('csr888', 4, 0x90002220),
        Register('csr889', 4, 0x90002224),
        Register('csr88a', 4, 0x90002228),
        Register('csr88b', 4, 0x9000222c),
        Register('csr88c', 4, 0x90002230),
        Register('csr88d', 4, 0x90002234),
        Register('csr88e', 4, 0x90002238),
        Register('csr88f', 4, 0x9000223c),
        Register('csr890', 4, 0x90002240),
        Register('csr891', 4, 0x90002244),
        Register('csr892', 4, 0x90002248),
        Register('csr893', 4, 0x9000224c),
        Register('csr894', 4, 0x90002250),
        Register('csr895', 4, 0x90002254),
        Register('csr896', 4, 0x90002258),
        Register('csr897', 4, 0x9000225c),
        Register('csr898', 4, 0x90002260),
        Register('csr899', 4, 0x90002264),
        Register('csr89a', 4, 0x90002268),
        Register('csr89b', 4, 0x9000226c),
        Register('csr89c', 4, 0x90002270),
        Register('csr89d', 4, 0x90002274),
        Register('csr89e', 4, 0x90002278),
        Register('csr89f', 4, 0x9000227c),
        Register('csr8a0', 4, 0x90002280),
        Register('csr8a1', 4, 0x90002284),
        Register('csr8a2', 4, 0x90002288),
        Register('csr8a3', 4, 0x9000228c),
        Register('csr8a4', 4, 0x90002290),
        Register('csr8a5', 4, 0x90002294),
        Register('csr8a6', 4, 0x90002298),
        Register('csr8a7', 4, 0x9000229c),
        Register('csr8a8', 4, 0x900022a0),
        Register('csr8a9', 4, 0x900022a4),
        Register('csr8aa', 4, 0x900022a8),
        Register('csr8ab', 4, 0x900022ac),
        Register('csr8ac', 4, 0x900022b0),
        Register('csr8ad', 4, 0x900022b4),
        Register('csr8ae', 4, 0x900022b8),
        Register('csr8af', 4, 0x900022bc),
        Register('csr8b0', 4, 0x900022c0),
        Register('csr8b1', 4, 0x900022c4),
        Register('csr8b2', 4, 0x900022c8),
        Register('csr8b3', 4, 0x900022cc),
        Register('csr8b4', 4, 0x900022d0),
        Register('csr8b5', 4, 0x900022d4),
        Register('csr8b6', 4, 0x900022d8),
        Register('csr8b7', 4, 0x900022dc),
        Register('csr8b8', 4, 0x900022e0),
        Register('csr8b9', 4, 0x900022e4),
        Register('csr8ba', 4, 0x900022e8),
        Register('csr8bb', 4, 0x900022ec),
        Register('csr8bc', 4, 0x900022f0),
        Register('csr8bd', 4, 0x900022f4),
        Register('csr8be', 4, 0x900022f8),
        Register('csr8bf', 4, 0x900022fc),
        Register('csr8c0', 4, 0x90002300),
        Register('csr8c1', 4, 0x90002304),
        Register('csr8c2', 4, 0x90002308),
        Register('csr8c3', 4, 0x9000230c),
        Register('csr8c4', 4, 0x90002310),
        Register('csr8c5', 4, 0x90002314),
        Register('csr8c6', 4, 0x90002318),
        Register('csr8c7', 4, 0x9000231c),
        Register('csr8c8', 4, 0x90002320),
        Register('csr8c9', 4, 0x90002324),
        Register('csr8ca', 4, 0x90002328),
        Register('csr8cb', 4, 0x9000232c),
        Register('csr8cc', 4, 0x90002330),
        Register('csr8cd', 4, 0x90002334),
        Register('csr8ce', 4, 0x90002338),
        Register('csr8cf', 4, 0x9000233c),
        Register('csr8d0', 4, 0x90002340),
        Register('csr8d1', 4, 0x90002344),
        Register('csr8d2', 4, 0x90002348),
        Register('csr8d3', 4, 0x9000234c),
        Register('csr8d4', 4, 0x90002350),
        Register('csr8d5', 4, 0x90002354),
        Register('csr8d6', 4, 0x90002358),
        Register('csr8d7', 4, 0x9000235c),
        Register('csr8d8', 4, 0x90002360),
        Register('csr8d9', 4, 0x90002364),
        Register('csr8da', 4, 0x90002368),
        Register('csr8db', 4, 0x9000236c),
        Register('csr8dc', 4, 0x90002370),
        Register('csr8dd', 4, 0x90002374),
        Register('csr8de', 4, 0x90002378),
        Register('csr8df', 4, 0x9000237c),
        Register('csr8e0', 4, 0x90002380),
        Register('csr8e1', 4, 0x90002384),
        Register('csr8e2', 4, 0x90002388),
        Register('csr8e3', 4, 0x9000238c),
        Register('csr8e4', 4, 0x90002390),
        Register('csr8e5', 4, 0x90002394),
        Register('csr8e6', 4, 0x90002398),
        Register('csr8e7', 4, 0x9000239c),
        Register('csr8e8', 4, 0x900023a0),
        Register('csr8e9', 4, 0x900023a4),
        Register('csr8ea', 4, 0x900023a8),
        Register('csr8eb', 4, 0x900023ac),
        Register('csr8ec', 4, 0x900023b0),
        Register('csr8ed', 4, 0x900023b4),
        Register('csr8ee', 4, 0x900023b8),
        Register('csr8ef', 4, 0x900023bc),
        Register('csr8f0', 4, 0x900023c0),
        Register('csr8f1', 4, 0x900023c4),
        Register('csr8f2', 4, 0x900023c8),
        Register('csr8f3', 4, 0x900023cc),
        Register('csr8f4', 4, 0x900023d0),
        Register('csr8f5', 4, 0x900023d4),
        Register('csr8f6', 4, 0x900023d8),
        Register('csr8f7', 4, 0x900023dc),
        Register('csr8f8', 4, 0x900023e0),
        Register('csr8f9', 4, 0x900023e4),
        Register('csr8fa', 4, 0x900023e8),
        Register('csr8fb', 4, 0x900023ec),
        Register('csr8fc', 4, 0x900023f0),
        Register('csr8fd', 4, 0x900023f4),
        Register('csr8fe', 4, 0x900023f8),
        Register('csr8ff', 4, 0x900023fc),
        Register('csr900', 4, 0x90002400),
        Register('csr901', 4, 0x90002404),
        Register('csr902', 4, 0x90002408),
        Register('csr903', 4, 0x9000240c),
        Register('csr904', 4, 0x90002410),
        Register('csr905', 4, 0x90002414),
        Register('csr906', 4, 0x90002418),
        Register('csr907', 4, 0x9000241c),
        Register('csr908', 4, 0x90002420),
        Register('csr909', 4, 0x90002424),
        Register('csr90a', 4, 0x90002428),
        Register('csr90b', 4, 0x9000242c),
        Register('csr90c', 4, 0x90002430),
        Register('csr90d', 4, 0x90002434),
        Register('csr90e', 4, 0x90002438),
        Register('csr90f', 4, 0x9000243c),
        Register('csr910', 4, 0x90002440),
        Register('csr911', 4, 0x90002444),
        Register('csr912', 4, 0x90002448),
        Register('csr913', 4, 0x9000244c),
        Register('csr914', 4, 0x90002450),
        Register('csr915', 4, 0x90002454),
        Register('csr916', 4, 0x90002458),
        Register('csr917', 4, 0x9000245c),
        Register('csr918', 4, 0x90002460),
        Register('csr919', 4, 0x90002464),
        Register('csr91a', 4, 0x90002468),
        Register('csr91b', 4, 0x9000246c),
        Register('csr91c', 4, 0x90002470),
        Register('csr91d', 4, 0x90002474),
        Register('csr91e', 4, 0x90002478),
        Register('csr91f', 4, 0x9000247c),
        Register('csr920', 4, 0x90002480),
        Register('csr921', 4, 0x90002484),
        Register('csr922', 4, 0x90002488),
        Register('csr923', 4, 0x9000248c),
        Register('csr924', 4, 0x90002490),
        Register('csr925', 4, 0x90002494),
        Register('csr926', 4, 0x90002498),
        Register('csr927', 4, 0x9000249c),
        Register('csr928', 4, 0x900024a0),
        Register('csr929', 4, 0x900024a4),
        Register('csr92a', 4, 0x900024a8),
        Register('csr92b', 4, 0x900024ac),
        Register('csr92c', 4, 0x900024b0),
        Register('csr92d', 4, 0x900024b4),
        Register('csr92e', 4, 0x900024b8),
        Register('csr92f', 4, 0x900024bc),
        Register('csr930', 4, 0x900024c0),
        Register('csr931', 4, 0x900024c4),
        Register('csr932', 4, 0x900024c8),
        Register('csr933', 4, 0x900024cc),
        Register('csr934', 4, 0x900024d0),
        Register('csr935', 4, 0x900024d4),
        Register('csr936', 4, 0x900024d8),
        Register('csr937', 4, 0x900024dc),
        Register('csr938', 4, 0x900024e0),
        Register('csr939', 4, 0x900024e4),
        Register('csr93a', 4, 0x900024e8),
        Register('csr93b', 4, 0x900024ec),
        Register('csr93c', 4, 0x900024f0),
        Register('csr93d', 4, 0x900024f4),
        Register('csr93e', 4, 0x900024f8),
        Register('csr93f', 4, 0x900024fc),
        Register('csr940', 4, 0x90002500),
        Register('csr941', 4, 0x90002504),
        Register('csr942', 4, 0x90002508),
        Register('csr943', 4, 0x9000250c),
        Register('csr944', 4, 0x90002510),
        Register('csr945', 4, 0x90002514),
        Register('csr946', 4, 0x90002518),
        Register('csr947', 4, 0x9000251c),
        Register('csr948', 4, 0x90002520),
        Register('csr949', 4, 0x90002524),
        Register('csr94a', 4, 0x90002528),
        Register('csr94b', 4, 0x9000252c),
        Register('csr94c', 4, 0x90002530),
        Register('csr94d', 4, 0x90002534),
        Register('csr94e', 4, 0x90002538),
        Register('csr94f', 4, 0x9000253c),
        Register('csr950', 4, 0x90002540),
        Register('csr951', 4, 0x90002544),
        Register('csr952', 4, 0x90002548),
        Register('csr953', 4, 0x9000254c),
        Register('csr954', 4, 0x90002550),
        Register('csr955', 4, 0x90002554),
        Register('csr956', 4, 0x90002558),
        Register('csr957', 4, 0x9000255c),
        Register('csr958', 4, 0x90002560),
        Register('csr959', 4, 0x90002564),
        Register('csr95a', 4, 0x90002568),
        Register('csr95b', 4, 0x9000256c),
        Register('csr95c', 4, 0x90002570),
        Register('csr95d', 4, 0x90002574),
        Register('csr95e', 4, 0x90002578),
        Register('csr95f', 4, 0x9000257c),
        Register('csr960', 4, 0x90002580),
        Register('csr961', 4, 0x90002584),
        Register('csr962', 4, 0x90002588),
        Register('csr963', 4, 0x9000258c),
        Register('csr964', 4, 0x90002590),
        Register('csr965', 4, 0x90002594),
        Register('csr966', 4, 0x90002598),
        Register('csr967', 4, 0x9000259c),
        Register('csr968', 4, 0x900025a0),
        Register('csr969', 4, 0x900025a4),
        Register('csr96a', 4, 0x900025a8),
        Register('csr96b', 4, 0x900025ac),
        Register('csr96c', 4, 0x900025b0),
        Register('csr96d', 4, 0x900025b4),
        Register('csr96e', 4, 0x900025b8),
        Register('csr96f', 4, 0x900025bc),
        Register('csr970', 4, 0x900025c0),
        Register('csr971', 4, 0x900025c4),
        Register('csr972', 4, 0x900025c8),
        Register('csr973', 4, 0x900025cc),
        Register('csr974', 4, 0x900025d0),
        Register('csr975', 4, 0x900025d4),
        Register('csr976', 4, 0x900025d8),
        Register('csr977', 4, 0x900025dc),
        Register('csr978', 4, 0x900025e0),
        Register('csr979', 4, 0x900025e4),
        Register('csr97a', 4, 0x900025e8),
        Register('csr97b', 4, 0x900025ec),
        Register('csr97c', 4, 0x900025f0),
        Register('csr97d', 4, 0x900025f4),
        Register('csr97e', 4, 0x900025f8),
        Register('csr97f', 4, 0x900025fc),
        Register('csr980', 4, 0x90002600),
        Register('csr981', 4, 0x90002604),
        Register('csr982', 4, 0x90002608),
        Register('csr983', 4, 0x9000260c),
        Register('csr984', 4, 0x90002610),
        Register('csr985', 4, 0x90002614),
        Register('csr986', 4, 0x90002618),
        Register('csr987', 4, 0x9000261c),
        Register('csr988', 4, 0x90002620),
        Register('csr989', 4, 0x90002624),
        Register('csr98a', 4, 0x90002628),
        Register('csr98b', 4, 0x9000262c),
        Register('csr98c', 4, 0x90002630),
        Register('csr98d', 4, 0x90002634),
        Register('csr98e', 4, 0x90002638),
        Register('csr98f', 4, 0x9000263c),
        Register('csr990', 4, 0x90002640),
        Register('csr991', 4, 0x90002644),
        Register('csr992', 4, 0x90002648),
        Register('csr993', 4, 0x9000264c),
        Register('csr994', 4, 0x90002650),
        Register('csr995', 4, 0x90002654),
        Register('csr996', 4, 0x90002658),
        Register('csr997', 4, 0x9000265c),
        Register('csr998', 4, 0x90002660),
        Register('csr999', 4, 0x90002664),
        Register('csr99a', 4, 0x90002668),
        Register('csr99b', 4, 0x9000266c),
        Register('csr99c', 4, 0x90002670),
        Register('csr99d', 4, 0x90002674),
        Register('csr99e', 4, 0x90002678),
        Register('csr99f', 4, 0x9000267c),
        Register('csr9a0', 4, 0x90002680),
        Register('csr9a1', 4, 0x90002684),
        Register('csr9a2', 4, 0x90002688),
        Register('csr9a3', 4, 0x9000268c),
        Register('csr9a4', 4, 0x90002690),
        Register('csr9a5', 4, 0x90002694),
        Register('csr9a6', 4, 0x90002698),
        Register('csr9a7', 4, 0x9000269c),
        Register('csr9a8', 4, 0x900026a0),
        Register('csr9a9', 4, 0x900026a4),
        Register('csr9aa', 4, 0x900026a8),
        Register('csr9ab', 4, 0x900026ac),
        Register('csr9ac', 4, 0x900026b0),
        Register('csr9ad', 4, 0x900026b4),
        Register('csr9ae', 4, 0x900026b8),
        Register('csr9af', 4, 0x900026bc),
        Register('csr9b0', 4, 0x900026c0),
        Register('csr9b1', 4, 0x900026c4),
        Register('csr9b2', 4, 0x900026c8),
        Register('csr9b3', 4, 0x900026cc),
        Register('csr9b4', 4, 0x900026d0),
        Register('csr9b5', 4, 0x900026d4),
        Register('csr9b6', 4, 0x900026d8),
        Register('csr9b7', 4, 0x900026dc),
        Register('csr9b8', 4, 0x900026e0),
        Register('csr9b9', 4, 0x900026e4),
        Register('csr9ba', 4, 0x900026e8),
        Register('csr9bb', 4, 0x900026ec),
        Register('csr9bc', 4, 0x900026f0),
        Register('csr9bd', 4, 0x900026f4),
        Register('csr9be', 4, 0x900026f8),
        Register('csr9bf', 4, 0x900026fc),
        Register('csr9c0', 4, 0x90002700),
        Register('csr9c1', 4, 0x90002704),
        Register('csr9c2', 4, 0x90002708),
        Register('csr9c3', 4, 0x9000270c),
        Register('csr9c4', 4, 0x90002710),
        Register('csr9c5', 4, 0x90002714),
        Register('csr9c6', 4, 0x90002718),
        Register('csr9c7', 4, 0x9000271c),
        Register('csr9c8', 4, 0x90002720),
        Register('csr9c9', 4, 0x90002724),
        Register('csr9ca', 4, 0x90002728),
        Register('csr9cb', 4, 0x9000272c),
        Register('csr9cc', 4, 0x90002730),
        Register('csr9cd', 4, 0x90002734),
        Register('csr9ce', 4, 0x90002738),
        Register('csr9cf', 4, 0x9000273c),
        Register('csr9d0', 4, 0x90002740),
        Register('csr9d1', 4, 0x90002744),
        Register('csr9d2', 4, 0x90002748),
        Register('csr9d3', 4, 0x9000274c),
        Register('csr9d4', 4, 0x90002750),
        Register('csr9d5', 4, 0x90002754),
        Register('csr9d6', 4, 0x90002758),
        Register('csr9d7', 4, 0x9000275c),
        Register('csr9d8', 4, 0x90002760),
        Register('csr9d9', 4, 0x90002764),
        Register('csr9da', 4, 0x90002768),
        Register('csr9db', 4, 0x9000276c),
        Register('csr9dc', 4, 0x90002770),
        Register('csr9dd', 4, 0x90002774),
        Register('csr9de', 4, 0x90002778),
        Register('csr9df', 4, 0x9000277c),
        Register('csr9e0', 4, 0x90002780),
        Register('csr9e1', 4, 0x90002784),
        Register('csr9e2', 4, 0x90002788),
        Register('csr9e3', 4, 0x9000278c),
        Register('csr9e4', 4, 0x90002790),
        Register('csr9e5', 4, 0x90002794),
        Register('csr9e6', 4, 0x90002798),
        Register('csr9e7', 4, 0x9000279c),
        Register('csr9e8', 4, 0x900027a0),
        Register('csr9e9', 4, 0x900027a4),
        Register('csr9ea', 4, 0x900027a8),
        Register('csr9eb', 4, 0x900027ac),
        Register('csr9ec', 4, 0x900027b0),
        Register('csr9ed', 4, 0x900027b4),
        Register('csr9ee', 4, 0x900027b8),
        Register('csr9ef', 4, 0x900027bc),
        Register('csr9f0', 4, 0x900027c0),
        Register('csr9f1', 4, 0x900027c4),
        Register('csr9f2', 4, 0x900027c8),
        Register('csr9f3', 4, 0x900027cc),
        Register('csr9f4', 4, 0x900027d0),
        Register('csr9f5', 4, 0x900027d4),
        Register('csr9f6', 4, 0x900027d8),
        Register('csr9f7', 4, 0x900027dc),
        Register('csr9f8', 4, 0x900027e0),
        Register('csr9f9', 4, 0x900027e4),
        Register('csr9fa', 4, 0x900027e8),
        Register('csr9fb', 4, 0x900027ec),
        Register('csr9fc', 4, 0x900027f0),
        Register('csr9fd', 4, 0x900027f4),
        Register('csr9fe', 4, 0x900027f8),
        Register('csr9ff', 4, 0x900027fc),
        Register('csra00', 4, 0x90002800),
        Register('csra01', 4, 0x90002804),
        Register('csra02', 4, 0x90002808),
        Register('csra03', 4, 0x9000280c),
        Register('csra04', 4, 0x90002810),
        Register('csra05', 4, 0x90002814),
        Register('csra06', 4, 0x90002818),
        Register('csra07', 4, 0x9000281c),
        Register('csra08', 4, 0x90002820),
        Register('csra09', 4, 0x90002824),
        Register('csra0a', 4, 0x90002828),
        Register('csra0b', 4, 0x9000282c),
        Register('csra0c', 4, 0x90002830),
        Register('csra0d', 4, 0x90002834),
        Register('csra0e', 4, 0x90002838),
        Register('csra0f', 4, 0x9000283c),
        Register('csra10', 4, 0x90002840),
        Register('csra11', 4, 0x90002844),
        Register('csra12', 4, 0x90002848),
        Register('csra13', 4, 0x9000284c),
        Register('csra14', 4, 0x90002850),
        Register('csra15', 4, 0x90002854),
        Register('csra16', 4, 0x90002858),
        Register('csra17', 4, 0x9000285c),
        Register('csra18', 4, 0x90002860),
        Register('csra19', 4, 0x90002864),
        Register('csra1a', 4, 0x90002868),
        Register('csra1b', 4, 0x9000286c),
        Register('csra1c', 4, 0x90002870),
        Register('csra1d', 4, 0x90002874),
        Register('csra1e', 4, 0x90002878),
        Register('csra1f', 4, 0x9000287c),
        Register('csra20', 4, 0x90002880),
        Register('csra21', 4, 0x90002884),
        Register('csra22', 4, 0x90002888),
        Register('csra23', 4, 0x9000288c),
        Register('csra24', 4, 0x90002890),
        Register('csra25', 4, 0x90002894),
        Register('csra26', 4, 0x90002898),
        Register('csra27', 4, 0x9000289c),
        Register('csra28', 4, 0x900028a0),
        Register('csra29', 4, 0x900028a4),
        Register('csra2a', 4, 0x900028a8),
        Register('csra2b', 4, 0x900028ac),
        Register('csra2c', 4, 0x900028b0),
        Register('csra2d', 4, 0x900028b4),
        Register('csra2e', 4, 0x900028b8),
        Register('csra2f', 4, 0x900028bc),
        Register('csra30', 4, 0x900028c0),
        Register('csra31', 4, 0x900028c4),
        Register('csra32', 4, 0x900028c8),
        Register('csra33', 4, 0x900028cc),
        Register('csra34', 4, 0x900028d0),
        Register('csra35', 4, 0x900028d4),
        Register('csra36', 4, 0x900028d8),
        Register('csra37', 4, 0x900028dc),
        Register('csra38', 4, 0x900028e0),
        Register('csra39', 4, 0x900028e4),
        Register('csra3a', 4, 0x900028e8),
        Register('csra3b', 4, 0x900028ec),
        Register('csra3c', 4, 0x900028f0),
        Register('csra3d', 4, 0x900028f4),
        Register('csra3e', 4, 0x900028f8),
        Register('csra3f', 4, 0x900028fc),
        Register('csra40', 4, 0x90002900),
        Register('csra41', 4, 0x90002904),
        Register('csra42', 4, 0x90002908),
        Register('csra43', 4, 0x9000290c),
        Register('csra44', 4, 0x90002910),
        Register('csra45', 4, 0x90002914),
        Register('csra46', 4, 0x90002918),
        Register('csra47', 4, 0x9000291c),
        Register('csra48', 4, 0x90002920),
        Register('csra49', 4, 0x90002924),
        Register('csra4a', 4, 0x90002928),
        Register('csra4b', 4, 0x9000292c),
        Register('csra4c', 4, 0x90002930),
        Register('csra4d', 4, 0x90002934),
        Register('csra4e', 4, 0x90002938),
        Register('csra4f', 4, 0x9000293c),
        Register('csra50', 4, 0x90002940),
        Register('csra51', 4, 0x90002944),
        Register('csra52', 4, 0x90002948),
        Register('csra53', 4, 0x9000294c),
        Register('csra54', 4, 0x90002950),
        Register('csra55', 4, 0x90002954),
        Register('csra56', 4, 0x90002958),
        Register('csra57', 4, 0x9000295c),
        Register('csra58', 4, 0x90002960),
        Register('csra59', 4, 0x90002964),
        Register('csra5a', 4, 0x90002968),
        Register('csra5b', 4, 0x9000296c),
        Register('csra5c', 4, 0x90002970),
        Register('csra5d', 4, 0x90002974),
        Register('csra5e', 4, 0x90002978),
        Register('csra5f', 4, 0x9000297c),
        Register('csra60', 4, 0x90002980),
        Register('csra61', 4, 0x90002984),
        Register('csra62', 4, 0x90002988),
        Register('csra63', 4, 0x9000298c),
        Register('csra64', 4, 0x90002990),
        Register('csra65', 4, 0x90002994),
        Register('csra66', 4, 0x90002998),
        Register('csra67', 4, 0x9000299c),
        Register('csra68', 4, 0x900029a0),
        Register('csra69', 4, 0x900029a4),
        Register('csra6a', 4, 0x900029a8),
        Register('csra6b', 4, 0x900029ac),
        Register('csra6c', 4, 0x900029b0),
        Register('csra6d', 4, 0x900029b4),
        Register('csra6e', 4, 0x900029b8),
        Register('csra6f', 4, 0x900029bc),
        Register('csra70', 4, 0x900029c0),
        Register('csra71', 4, 0x900029c4),
        Register('csra72', 4, 0x900029c8),
        Register('csra73', 4, 0x900029cc),
        Register('csra74', 4, 0x900029d0),
        Register('csra75', 4, 0x900029d4),
        Register('csra76', 4, 0x900029d8),
        Register('csra77', 4, 0x900029dc),
        Register('csra78', 4, 0x900029e0),
        Register('csra79', 4, 0x900029e4),
        Register('csra7a', 4, 0x900029e8),
        Register('csra7b', 4, 0x900029ec),
        Register('csra7c', 4, 0x900029f0),
        Register('csra7d', 4, 0x900029f4),
        Register('csra7e', 4, 0x900029f8),
        Register('csra7f', 4, 0x900029fc),
        Register('csra80', 4, 0x90002a00),
        Register('csra81', 4, 0x90002a04),
        Register('csra82', 4, 0x90002a08),
        Register('csra83', 4, 0x90002a0c),
        Register('csra84', 4, 0x90002a10),
        Register('csra85', 4, 0x90002a14),
        Register('csra86', 4, 0x90002a18),
        Register('csra87', 4, 0x90002a1c),
        Register('csra88', 4, 0x90002a20),
        Register('csra89', 4, 0x90002a24),
        Register('csra8a', 4, 0x90002a28),
        Register('csra8b', 4, 0x90002a2c),
        Register('csra8c', 4, 0x90002a30),
        Register('csra8d', 4, 0x90002a34),
        Register('csra8e', 4, 0x90002a38),
        Register('csra8f', 4, 0x90002a3c),
        Register('csra90', 4, 0x90002a40),
        Register('csra91', 4, 0x90002a44),
        Register('csra92', 4, 0x90002a48),
        Register('csra93', 4, 0x90002a4c),
        Register('csra94', 4, 0x90002a50),
        Register('csra95', 4, 0x90002a54),
        Register('csra96', 4, 0x90002a58),
        Register('csra97', 4, 0x90002a5c),
        Register('csra98', 4, 0x90002a60),
        Register('csra99', 4, 0x90002a64),
        Register('csra9a', 4, 0x90002a68),
        Register('csra9b', 4, 0x90002a6c),
        Register('csra9c', 4, 0x90002a70),
        Register('csra9d', 4, 0x90002a74),
        Register('csra9e', 4, 0x90002a78),
        Register('csra9f', 4, 0x90002a7c),
        Register('csraa0', 4, 0x90002a80),
        Register('csraa1', 4, 0x90002a84),
        Register('csraa2', 4, 0x90002a88),
        Register('csraa3', 4, 0x90002a8c),
        Register('csraa4', 4, 0x90002a90),
        Register('csraa5', 4, 0x90002a94),
        Register('csraa6', 4, 0x90002a98),
        Register('csraa7', 4, 0x90002a9c),
        Register('csraa8', 4, 0x90002aa0),
        Register('csraa9', 4, 0x90002aa4),
        Register('csraaa', 4, 0x90002aa8),
        Register('csraab', 4, 0x90002aac),
        Register('csraac', 4, 0x90002ab0),
        Register('csraad', 4, 0x90002ab4),
        Register('csraae', 4, 0x90002ab8),
        Register('csraaf', 4, 0x90002abc),
        Register('csrab0', 4, 0x90002ac0),
        Register('csrab1', 4, 0x90002ac4),
        Register('csrab2', 4, 0x90002ac8),
        Register('csrab3', 4, 0x90002acc),
        Register('csrab4', 4, 0x90002ad0),
        Register('csrab5', 4, 0x90002ad4),
        Register('csrab6', 4, 0x90002ad8),
        Register('csrab7', 4, 0x90002adc),
        Register('csrab8', 4, 0x90002ae0),
        Register('csrab9', 4, 0x90002ae4),
        Register('csraba', 4, 0x90002ae8),
        Register('csrabb', 4, 0x90002aec),
        Register('csrabc', 4, 0x90002af0),
        Register('csrabd', 4, 0x90002af4),
        Register('csrabe', 4, 0x90002af8),
        Register('csrabf', 4, 0x90002afc),
        Register('csrac0', 4, 0x90002b00),
        Register('csrac1', 4, 0x90002b04),
        Register('csrac2', 4, 0x90002b08),
        Register('csrac3', 4, 0x90002b0c),
        Register('csrac4', 4, 0x90002b10),
        Register('csrac5', 4, 0x90002b14),
        Register('csrac6', 4, 0x90002b18),
        Register('csrac7', 4, 0x90002b1c),
        Register('csrac8', 4, 0x90002b20),
        Register('csrac9', 4, 0x90002b24),
        Register('csraca', 4, 0x90002b28),
        Register('csracb', 4, 0x90002b2c),
        Register('csracc', 4, 0x90002b30),
        Register('csracd', 4, 0x90002b34),
        Register('csrace', 4, 0x90002b38),
        Register('csracf', 4, 0x90002b3c),
        Register('csrad0', 4, 0x90002b40),
        Register('csrad1', 4, 0x90002b44),
        Register('csrad2', 4, 0x90002b48),
        Register('csrad3', 4, 0x90002b4c),
        Register('csrad4', 4, 0x90002b50),
        Register('csrad5', 4, 0x90002b54),
        Register('csrad6', 4, 0x90002b58),
        Register('csrad7', 4, 0x90002b5c),
        Register('csrad8', 4, 0x90002b60),
        Register('csrad9', 4, 0x90002b64),
        Register('csrada', 4, 0x90002b68),
        Register('csradb', 4, 0x90002b6c),
        Register('csradc', 4, 0x90002b70),
        Register('csradd', 4, 0x90002b74),
        Register('csrade', 4, 0x90002b78),
        Register('csradf', 4, 0x90002b7c),
        Register('csrae0', 4, 0x90002b80),
        Register('csrae1', 4, 0x90002b84),
        Register('csrae2', 4, 0x90002b88),
        Register('csrae3', 4, 0x90002b8c),
        Register('csrae4', 4, 0x90002b90),
        Register('csrae5', 4, 0x90002b94),
        Register('csrae6', 4, 0x90002b98),
        Register('csrae7', 4, 0x90002b9c),
        Register('csrae8', 4, 0x90002ba0),
        Register('csrae9', 4, 0x90002ba4),
        Register('csraea', 4, 0x90002ba8),
        Register('csraeb', 4, 0x90002bac),
        Register('csraec', 4, 0x90002bb0),
        Register('csraed', 4, 0x90002bb4),
        Register('csraee', 4, 0x90002bb8),
        Register('csraef', 4, 0x90002bbc),
        Register('csraf0', 4, 0x90002bc0),
        Register('csraf1', 4, 0x90002bc4),
        Register('csraf2', 4, 0x90002bc8),
        Register('csraf3', 4, 0x90002bcc),
        Register('csraf4', 4, 0x90002bd0),
        Register('csraf5', 4, 0x90002bd4),
        Register('csraf6', 4, 0x90002bd8),
        Register('csraf7', 4, 0x90002bdc),
        Register('csraf8', 4, 0x90002be0),
        Register('csraf9', 4, 0x90002be4),
        Register('csrafa', 4, 0x90002be8),
        Register('csrafb', 4, 0x90002bec),
        Register('csrafc', 4, 0x90002bf0),
        Register('csrafd', 4, 0x90002bf4),
        Register('csrafe', 4, 0x90002bf8),
        Register('csraff', 4, 0x90002bfc),
        Register('mcycle', 4, 0x90002c00),
        Register('csrb01', 4, 0x90002c04),
        Register('minstret', 4, 0x90002c08),
        Register('mhpmcounter3', 4, 0x90002c0c),
        Register('mhpmcounter4', 4, 0x90002c10),
        Register('mhpmcounter5', 4, 0x90002c14),
        Register('mhpmcounter6', 4, 0x90002c18),
        Register('mhpmcounter7', 4, 0x90002c1c),
        Register('mhpmcounter8', 4, 0x90002c20),
        Register('mhpmcounter9', 4, 0x90002c24),
        Register('mhpmcounter10', 4, 0x90002c28),
        Register('mhpmcounter11', 4, 0x90002c2c),
        Register('mhpmcounter12', 4, 0x90002c30),
        Register('mhpmcounter13', 4, 0x90002c34),
        Register('mhpmcounter14', 4, 0x90002c38),
        Register('mhpmcounter15', 4, 0x90002c3c),
        Register('mhpmcounter16', 4, 0x90002c40),
        Register('mhpmcounter17', 4, 0x90002c44),
        Register('mhpmcounter18', 4, 0x90002c48),
        Register('mhpmcounter19', 4, 0x90002c4c),
        Register('mhpmcounter20', 4, 0x90002c50),
        Register('mhpmcounter21', 4, 0x90002c54),
        Register('mhpmcounter22', 4, 0x90002c58),
        Register('mhpmcounter23', 4, 0x90002c5c),
        Register('mhpmcounter24', 4, 0x90002c60),
        Register('mhpmcounter25', 4, 0x90002c64),
        Register('mhpmcounter26', 4, 0x90002c68),
        Register('mhpmcounter27', 4, 0x90002c6c),
        Register('mhpmcounter28', 4, 0x90002c70),
        Register('mhpmcounter29', 4, 0x90002c74),
        Register('mhpmcounter30', 4, 0x90002c78),
        Register('mhpmcounter31', 4, 0x90002c7c),
        Register('csrb20', 4, 0x90002c80),
        Register('csrb21', 4, 0x90002c84),
        Register('csrb22', 4, 0x90002c88),
        Register('csrb23', 4, 0x90002c8c),
        Register('csrb24', 4, 0x90002c90),
        Register('csrb25', 4, 0x90002c94),
        Register('csrb26', 4, 0x90002c98),
        Register('csrb27', 4, 0x90002c9c),
        Register('csrb28', 4, 0x90002ca0),
        Register('csrb29', 4, 0x90002ca4),
        Register('csrb2a', 4, 0x90002ca8),
        Register('csrb2b', 4, 0x90002cac),
        Register('csrb2c', 4, 0x90002cb0),
        Register('csrb2d', 4, 0x90002cb4),
        Register('csrb2e', 4, 0x90002cb8),
        Register('csrb2f', 4, 0x90002cbc),
        Register('csrb30', 4, 0x90002cc0),
        Register('csrb31', 4, 0x90002cc4),
        Register('csrb32', 4, 0x90002cc8),
        Register('csrb33', 4, 0x90002ccc),
        Register('csrb34', 4, 0x90002cd0),
        Register('csrb35', 4, 0x90002cd4),
        Register('csrb36', 4, 0x90002cd8),
        Register('csrb37', 4, 0x90002cdc),
        Register('csrb38', 4, 0x90002ce0),
        Register('csrb39', 4, 0x90002ce4),
        Register('csrb3a', 4, 0x90002ce8),
        Register('csrb3b', 4, 0x90002cec),
        Register('csrb3c', 4, 0x90002cf0),
        Register('csrb3d', 4, 0x90002cf4),
        Register('csrb3e', 4, 0x90002cf8),
        Register('csrb3f', 4, 0x90002cfc),
        Register('csrb40', 4, 0x90002d00),
        Register('csrb41', 4, 0x90002d04),
        Register('csrb42', 4, 0x90002d08),
        Register('csrb43', 4, 0x90002d0c),
        Register('csrb44', 4, 0x90002d10),
        Register('csrb45', 4, 0x90002d14),
        Register('csrb46', 4, 0x90002d18),
        Register('csrb47', 4, 0x90002d1c),
        Register('csrb48', 4, 0x90002d20),
        Register('csrb49', 4, 0x90002d24),
        Register('csrb4a', 4, 0x90002d28),
        Register('csrb4b', 4, 0x90002d2c),
        Register('csrb4c', 4, 0x90002d30),
        Register('csrb4d', 4, 0x90002d34),
        Register('csrb4e', 4, 0x90002d38),
        Register('csrb4f', 4, 0x90002d3c),
        Register('csrb50', 4, 0x90002d40),
        Register('csrb51', 4, 0x90002d44),
        Register('csrb52', 4, 0x90002d48),
        Register('csrb53', 4, 0x90002d4c),
        Register('csrb54', 4, 0x90002d50),
        Register('csrb55', 4, 0x90002d54),
        Register('csrb56', 4, 0x90002d58),
        Register('csrb57', 4, 0x90002d5c),
        Register('csrb58', 4, 0x90002d60),
        Register('csrb59', 4, 0x90002d64),
        Register('csrb5a', 4, 0x90002d68),
        Register('csrb5b', 4, 0x90002d6c),
        Register('csrb5c', 4, 0x90002d70),
        Register('csrb5d', 4, 0x90002d74),
        Register('csrb5e', 4, 0x90002d78),
        Register('csrb5f', 4, 0x90002d7c),
        Register('csrb60', 4, 0x90002d80),
        Register('csrb61', 4, 0x90002d84),
        Register('csrb62', 4, 0x90002d88),
        Register('csrb63', 4, 0x90002d8c),
        Register('csrb64', 4, 0x90002d90),
        Register('csrb65', 4, 0x90002d94),
        Register('csrb66', 4, 0x90002d98),
        Register('csrb67', 4, 0x90002d9c),
        Register('csrb68', 4, 0x90002da0),
        Register('csrb69', 4, 0x90002da4),
        Register('csrb6a', 4, 0x90002da8),
        Register('csrb6b', 4, 0x90002dac),
        Register('csrb6c', 4, 0x90002db0),
        Register('csrb6d', 4, 0x90002db4),
        Register('csrb6e', 4, 0x90002db8),
        Register('csrb6f', 4, 0x90002dbc),
        Register('csrb70', 4, 0x90002dc0),
        Register('csrb71', 4, 0x90002dc4),
        Register('csrb72', 4, 0x90002dc8),
        Register('csrb73', 4, 0x90002dcc),
        Register('csrb74', 4, 0x90002dd0),
        Register('csrb75', 4, 0x90002dd4),
        Register('csrb76', 4, 0x90002dd8),
        Register('csrb77', 4, 0x90002ddc),
        Register('csrb78', 4, 0x90002de0),
        Register('csrb79', 4, 0x90002de4),
        Register('csrb7a', 4, 0x90002de8),
        Register('csrb7b', 4, 0x90002dec),
        Register('csrb7c', 4, 0x90002df0),
        Register('csrb7d', 4, 0x90002df4),
        Register('csrb7e', 4, 0x90002df8),
        Register('csrb7f', 4, 0x90002dfc),
        Register('mcycleh', 4, 0x90002e00),
        Register('csrb81', 4, 0x90002e04),
        Register('minstreth', 4, 0x90002e08),
        Register('mhpmcounter3h', 4, 0x90002e0c),
        Register('mhpmcounter4h', 4, 0x90002e10),
        Register('mhpmcounter5h', 4, 0x90002e14),
        Register('mhpmcounter6h', 4, 0x90002e18),
        Register('mhpmcounter7h', 4, 0x90002e1c),
        Register('mhpmcounter8h', 4, 0x90002e20),
        Register('mhpmcounter9h', 4, 0x90002e24),
        Register('mhpmcounter10h', 4, 0x90002e28),
        Register('mhpmcounter11h', 4, 0x90002e2c),
        Register('mhpmcounter12h', 4, 0x90002e30),
        Register('mhpmcounter13h', 4, 0x90002e34),
        Register('mhpmcounter14h', 4, 0x90002e38),
        Register('mhpmcounter15h', 4, 0x90002e3c),
        Register('mhpmcounter16h', 4, 0x90002e40),
        Register('mhpmcounter17h', 4, 0x90002e44),
        Register('mhpmcounter18h', 4, 0x90002e48),
        Register('mhpmcounter19h', 4, 0x90002e4c),
        Register('mhpmcounter20h', 4, 0x90002e50),
        Register('mhpmcounter21h', 4, 0x90002e54),
        Register('mhpmcounter22h', 4, 0x90002e58),
        Register('mhpmcounter23h', 4, 0x90002e5c),
        Register('mhpmcounter24h', 4, 0x90002e60),
        Register('mhpmcounter25h', 4, 0x90002e64),
        Register('mhpmcounter26h', 4, 0x90002e68),
        Register('mhpmcounter27h', 4, 0x90002e6c),
        Register('mhpmcounter28h', 4, 0x90002e70),
        Register('mhpmcounter29h', 4, 0x90002e74),
        Register('mhpmcounter30h', 4, 0x90002e78),
        Register('mhpmcounter31h', 4, 0x90002e7c),
        Register('csrba0', 4, 0x90002e80),
        Register('csrba1', 4, 0x90002e84),
        Register('csrba2', 4, 0x90002e88),
        Register('csrba3', 4, 0x90002e8c),
        Register('csrba4', 4, 0x90002e90),
        Register('csrba5', 4, 0x90002e94),
        Register('csrba6', 4, 0x90002e98),
        Register('csrba7', 4, 0x90002e9c),
        Register('csrba8', 4, 0x90002ea0),
        Register('csrba9', 4, 0x90002ea4),
        Register('csrbaa', 4, 0x90002ea8),
        Register('csrbab', 4, 0x90002eac),
        Register('csrbac', 4, 0x90002eb0),
        Register('csrbad', 4, 0x90002eb4),
        Register('csrbae', 4, 0x90002eb8),
        Register('csrbaf', 4, 0x90002ebc),
        Register('csrbb0', 4, 0x90002ec0),
        Register('csrbb1', 4, 0x90002ec4),
        Register('csrbb2', 4, 0x90002ec8),
        Register('csrbb3', 4, 0x90002ecc),
        Register('csrbb4', 4, 0x90002ed0),
        Register('csrbb5', 4, 0x90002ed4),
        Register('csrbb6', 4, 0x90002ed8),
        Register('csrbb7', 4, 0x90002edc),
        Register('csrbb8', 4, 0x90002ee0),
        Register('csrbb9', 4, 0x90002ee4),
        Register('csrbba', 4, 0x90002ee8),
        Register('csrbbb', 4, 0x90002eec),
        Register('csrbbc', 4, 0x90002ef0),
        Register('csrbbd', 4, 0x90002ef4),
        Register('csrbbe', 4, 0x90002ef8),
        Register('csrbbf', 4, 0x90002efc),
        Register('csrbc0', 4, 0x90002f00),
        Register('csrbc1', 4, 0x90002f04),
        Register('csrbc2', 4, 0x90002f08),
        Register('csrbc3', 4, 0x90002f0c),
        Register('csrbc4', 4, 0x90002f10),
        Register('csrbc5', 4, 0x90002f14),
        Register('csrbc6', 4, 0x90002f18),
        Register('csrbc7', 4, 0x90002f1c),
        Register('csrbc8', 4, 0x90002f20),
        Register('csrbc9', 4, 0x90002f24),
        Register('csrbca', 4, 0x90002f28),
        Register('csrbcb', 4, 0x90002f2c),
        Register('csrbcc', 4, 0x90002f30),
        Register('csrbcd', 4, 0x90002f34),
        Register('csrbce', 4, 0x90002f38),
        Register('csrbcf', 4, 0x90002f3c),
        Register('csrbd0', 4, 0x90002f40),
        Register('csrbd1', 4, 0x90002f44),
        Register('csrbd2', 4, 0x90002f48),
        Register('csrbd3', 4, 0x90002f4c),
        Register('csrbd4', 4, 0x90002f50),
        Register('csrbd5', 4, 0x90002f54),
        Register('csrbd6', 4, 0x90002f58),
        Register('csrbd7', 4, 0x90002f5c),
        Register('csrbd8', 4, 0x90002f60),
        Register('csrbd9', 4, 0x90002f64),
        Register('csrbda', 4, 0x90002f68),
        Register('csrbdb', 4, 0x90002f6c),
        Register('csrbdc', 4, 0x90002f70),
        Register('csrbdd', 4, 0x90002f74),
        Register('csrbde', 4, 0x90002f78),
        Register('csrbdf', 4, 0x90002f7c),
        Register('csrbe0', 4, 0x90002f80),
        Register('csrbe1', 4, 0x90002f84),
        Register('csrbe2', 4, 0x90002f88),
        Register('csrbe3', 4, 0x90002f8c),
        Register('csrbe4', 4, 0x90002f90),
        Register('csrbe5', 4, 0x90002f94),
        Register('csrbe6', 4, 0x90002f98),
        Register('csrbe7', 4, 0x90002f9c),
        Register('csrbe8', 4, 0x90002fa0),
        Register('csrbe9', 4, 0x90002fa4),
        Register('csrbea', 4, 0x90002fa8),
        Register('csrbeb', 4, 0x90002fac),
        Register('csrbec', 4, 0x90002fb0),
        Register('csrbed', 4, 0x90002fb4),
        Register('csrbee', 4, 0x90002fb8),
        Register('csrbef', 4, 0x90002fbc),
        Register('csrbf0', 4, 0x90002fc0),
        Register('csrbf1', 4, 0x90002fc4),
        Register('csrbf2', 4, 0x90002fc8),
        Register('csrbf3', 4, 0x90002fcc),
        Register('csrbf4', 4, 0x90002fd0),
        Register('csrbf5', 4, 0x90002fd4),
        Register('csrbf6', 4, 0x90002fd8),
        Register('csrbf7', 4, 0x90002fdc),
        Register('csrbf8', 4, 0x90002fe0),
        Register('csrbf9', 4, 0x90002fe4),
        Register('csrbfa', 4, 0x90002fe8),
        Register('csrbfb', 4, 0x90002fec),
        Register('csrbfc', 4, 0x90002ff0),
        Register('csrbfd', 4, 0x90002ff4),
        Register('csrbfe', 4, 0x90002ff8),
        Register('csrbff', 4, 0x90002ffc),
        Register('cycle', 4, 0x90003000),
        Register('time', 4, 0x90003004),
        Register('instret', 4, 0x90003008),
        Register('hpmcounter3', 4, 0x9000300c),
        Register('hpmcounter4', 4, 0x90003010),
        Register('hpmcounter5', 4, 0x90003014),
        Register('hpmcounter6', 4, 0x90003018),
        Register('hpmcounter7', 4, 0x9000301c),
        Register('hpmcounter8', 4, 0x90003020),
        Register('hpmcounter9', 4, 0x90003024),
        Register('hpmcounter10', 4, 0x90003028),
        Register('hpmcounter11', 4, 0x9000302c),
        Register('hpmcounter12', 4, 0x90003030),
        Register('hpmcounter13', 4, 0x90003034),
        Register('hpmcounter14', 4, 0x90003038),
        Register('hpmcounter15', 4, 0x9000303c),
        Register('hpmcounter16', 4, 0x90003040),
        Register('hpmcounter17', 4, 0x90003044),
        Register('hpmcounter18', 4, 0x90003048),
        Register('hpmcounter19', 4, 0x9000304c),
        Register('hpmcounter20', 4, 0x90003050),
        Register('hpmcounter21', 4, 0x90003054),
        Register('hpmcounter22', 4, 0x90003058),
        Register('hpmcounter23', 4, 0x9000305c),
        Register('hpmcounter24', 4, 0x90003060),
        Register('hpmcounter25', 4, 0x90003064),
        Register('hpmcounter26', 4, 0x90003068),
        Register('hpmcounter27', 4, 0x9000306c),
        Register('hpmcounter28', 4, 0x90003070),
        Register('hpmcounter29', 4, 0x90003074),
        Register('hpmcounter30', 4, 0x90003078),
        Register('hpmcounter31', 4, 0x9000307c),
        Register('vl', 4, 0x90003080),
        Register('vtype', 4, 0x90003084),
        Register('vlenb', 4, 0x90003088),
        Register('csrc23', 4, 0x9000308c),
        Register('csrc24', 4, 0x90003090),
        Register('csrc25', 4, 0x90003094),
        Register('csrc26', 4, 0x90003098),
        Register('csrc27', 4, 0x9000309c),
        Register('csrc28', 4, 0x900030a0),
        Register('csrc29', 4, 0x900030a4),
        Register('csrc2a', 4, 0x900030a8),
        Register('csrc2b', 4, 0x900030ac),
        Register('csrc2c', 4, 0x900030b0),
        Register('csrc2d', 4, 0x900030b4),
        Register('csrc2e', 4, 0x900030b8),
        Register('csrc2f', 4, 0x900030bc),
        Register('csrc30', 4, 0x900030c0),
        Register('csrc31', 4, 0x900030c4),
        Register('csrc32', 4, 0x900030c8),
        Register('csrc33', 4, 0x900030cc),
        Register('csrc34', 4, 0x900030d0),
        Register('csrc35', 4, 0x900030d4),
        Register('csrc36', 4, 0x900030d8),
        Register('csrc37', 4, 0x900030dc),
        Register('csrc38', 4, 0x900030e0),
        Register('csrc39', 4, 0x900030e4),
        Register('csrc3a', 4, 0x900030e8),
        Register('csrc3b', 4, 0x900030ec),
        Register('csrc3c', 4, 0x900030f0),
        Register('csrc3d', 4, 0x900030f4),
        Register('csrc3e', 4, 0x900030f8),
        Register('csrc3f', 4, 0x900030fc),
        Register('csrc40', 4, 0x90003100),
        Register('csrc41', 4, 0x90003104),
        Register('csrc42', 4, 0x90003108),
        Register('csrc43', 4, 0x9000310c),
        Register('csrc44', 4, 0x90003110),
        Register('csrc45', 4, 0x90003114),
        Register('csrc46', 4, 0x90003118),
        Register('csrc47', 4, 0x9000311c),
        Register('csrc48', 4, 0x90003120),
        Register('csrc49', 4, 0x90003124),
        Register('csrc4a', 4, 0x90003128),
        Register('csrc4b', 4, 0x9000312c),
        Register('csrc4c', 4, 0x90003130),
        Register('csrc4d', 4, 0x90003134),
        Register('csrc4e', 4, 0x90003138),
        Register('csrc4f', 4, 0x9000313c),
        Register('csrc50', 4, 0x90003140),
        Register('csrc51', 4, 0x90003144),
        Register('csrc52', 4, 0x90003148),
        Register('csrc53', 4, 0x9000314c),
        Register('csrc54', 4, 0x90003150),
        Register('csrc55', 4, 0x90003154),
        Register('csrc56', 4, 0x90003158),
        Register('csrc57', 4, 0x9000315c),
        Register('csrc58', 4, 0x90003160),
        Register('csrc59', 4, 0x90003164),
        Register('csrc5a', 4, 0x90003168),
        Register('csrc5b', 4, 0x9000316c),
        Register('csrc5c', 4, 0x90003170),
        Register('csrc5d', 4, 0x90003174),
        Register('csrc5e', 4, 0x90003178),
        Register('csrc5f', 4, 0x9000317c),
        Register('csrc60', 4, 0x90003180),
        Register('csrc61', 4, 0x90003184),
        Register('csrc62', 4, 0x90003188),
        Register('csrc63', 4, 0x9000318c),
        Register('csrc64', 4, 0x90003190),
        Register('csrc65', 4, 0x90003194),
        Register('csrc66', 4, 0x90003198),
        Register('csrc67', 4, 0x9000319c),
        Register('csrc68', 4, 0x900031a0),
        Register('csrc69', 4, 0x900031a4),
        Register('csrc6a', 4, 0x900031a8),
        Register('csrc6b', 4, 0x900031ac),
        Register('csrc6c', 4, 0x900031b0),
        Register('csrc6d', 4, 0x900031b4),
        Register('csrc6e', 4, 0x900031b8),
        Register('csrc6f', 4, 0x900031bc),
        Register('csrc70', 4, 0x900031c0),
        Register('csrc71', 4, 0x900031c4),
        Register('csrc72', 4, 0x900031c8),
        Register('csrc73', 4, 0x900031cc),
        Register('csrc74', 4, 0x900031d0),
        Register('csrc75', 4, 0x900031d4),
        Register('csrc76', 4, 0x900031d8),
        Register('csrc77', 4, 0x900031dc),
        Register('csrc78', 4, 0x900031e0),
        Register('csrc79', 4, 0x900031e4),
        Register('csrc7a', 4, 0x900031e8),
        Register('csrc7b', 4, 0x900031ec),
        Register('csrc7c', 4, 0x900031f0),
        Register('csrc7d', 4, 0x900031f4),
        Register('csrc7e', 4, 0x900031f8),
        Register('csrc7f', 4, 0x900031fc),
        Register('cycleh', 4, 0x90003200),
        Register('timeh', 4, 0x90003204),
        Register('instreth', 4, 0x90003208),
        Register('hpmcounter3h', 4, 0x9000320c),
        Register('hpmcounter4h', 4, 0x90003210),
        Register('hpmcounter5h', 4, 0x90003214),
        Register('hpmcounter6h', 4, 0x90003218),
        Register('hpmcounter7h', 4, 0x9000321c),
        Register('hpmcounter8h', 4, 0x90003220),
        Register('hpmcounter9h', 4, 0x90003224),
        Register('hpmcounter10h', 4, 0x90003228),
        Register('hpmcounter11h', 4, 0x9000322c),
        Register('hpmcounter12h', 4, 0x90003230),
        Register('hpmcounter13h', 4, 0x90003234),
        Register('hpmcounter14h', 4, 0x90003238),
        Register('hpmcounter15h', 4, 0x9000323c),
        Register('hpmcounter16h', 4, 0x90003240),
        Register('hpmcounter17h', 4, 0x90003244),
        Register('hpmcounter18h', 4, 0x90003248),
        Register('hpmcounter19h', 4, 0x9000324c),
        Register('hpmcounter20h', 4, 0x90003250),
        Register('hpmcounter21h', 4, 0x90003254),
        Register('hpmcounter22h', 4, 0x90003258),
        Register('hpmcounter23h', 4, 0x9000325c),
        Register('hpmcounter24h', 4, 0x90003260),
        Register('hpmcounter25h', 4, 0x90003264),
        Register('hpmcounter26h', 4, 0x90003268),
        Register('hpmcounter27h', 4, 0x9000326c),
        Register('hpmcounter28h', 4, 0x90003270),
        Register('hpmcounter29h', 4, 0x90003274),
        Register('hpmcounter30h', 4, 0x90003278),
        Register('hpmcounter31h', 4, 0x9000327c),
        Register('csrca0', 4, 0x90003280),
        Register('csrca1', 4, 0x90003284),
        Register('csrca2', 4, 0x90003288),
        Register('csrca3', 4, 0x9000328c),
        Register('csrca4', 4, 0x90003290),
        Register('csrca5', 4, 0x90003294),
        Register('csrca6', 4, 0x90003298),
        Register('csrca7', 4, 0x9000329c),
        Register('csrca8', 4, 0x900032a0),
        Register('csrca9', 4, 0x900032a4),
        Register('csrcaa', 4, 0x900032a8),
        Register('csrcab', 4, 0x900032ac),
        Register('csrcac', 4, 0x900032b0),
        Register('csrcad', 4, 0x900032b4),
        Register('csrcae', 4, 0x900032b8),
        Register('csrcaf', 4, 0x900032bc),
        Register('csrcb0', 4, 0x900032c0),
        Register('csrcb1', 4, 0x900032c4),
        Register('csrcb2', 4, 0x900032c8),
        Register('csrcb3', 4, 0x900032cc),
        Register('csrcb4', 4, 0x900032d0),
        Register('csrcb5', 4, 0x900032d4),
        Register('csrcb6', 4, 0x900032d8),
        Register('csrcb7', 4, 0x900032dc),
        Register('csrcb8', 4, 0x900032e0),
        Register('csrcb9', 4, 0x900032e4),
        Register('csrcba', 4, 0x900032e8),
        Register('csrcbb', 4, 0x900032ec),
        Register('csrcbc', 4, 0x900032f0),
        Register('csrcbd', 4, 0x900032f4),
        Register('csrcbe', 4, 0x900032f8),
        Register('csrcbf', 4, 0x900032fc),
        Register('csrcc0', 4, 0x90003300),
        Register('csrcc1', 4, 0x90003304),
        Register('csrcc2', 4, 0x90003308),
        Register('csrcc3', 4, 0x9000330c),
        Register('csrcc4', 4, 0x90003310),
        Register('csrcc5', 4, 0x90003314),
        Register('csrcc6', 4, 0x90003318),
        Register('csrcc7', 4, 0x9000331c),
        Register('csrcc8', 4, 0x90003320),
        Register('csrcc9', 4, 0x90003324),
        Register('csrcca', 4, 0x90003328),
        Register('csrccb', 4, 0x9000332c),
        Register('csrccc', 4, 0x90003330),
        Register('csrccd', 4, 0x90003334),
        Register('csrcce', 4, 0x90003338),
        Register('csrccf', 4, 0x9000333c),
        Register('csrcd0', 4, 0x90003340),
        Register('csrcd1', 4, 0x90003344),
        Register('csrcd2', 4, 0x90003348),
        Register('csrcd3', 4, 0x9000334c),
        Register('csrcd4', 4, 0x90003350),
        Register('csrcd5', 4, 0x90003354),
        Register('csrcd6', 4, 0x90003358),
        Register('csrcd7', 4, 0x9000335c),
        Register('csrcd8', 4, 0x90003360),
        Register('csrcd9', 4, 0x90003364),
        Register('csrcda', 4, 0x90003368),
        Register('csrcdb', 4, 0x9000336c),
        Register('csrcdc', 4, 0x90003370),
        Register('csrcdd', 4, 0x90003374),
        Register('csrcde', 4, 0x90003378),
        Register('csrcdf', 4, 0x9000337c),
        Register('csrce0', 4, 0x90003380),
        Register('csrce1', 4, 0x90003384),
        Register('csrce2', 4, 0x90003388),
        Register('csrce3', 4, 0x9000338c),
        Register('csrce4', 4, 0x90003390),
        Register('csrce5', 4, 0x90003394),
        Register('csrce6', 4, 0x90003398),
        Register('csrce7', 4, 0x9000339c),
        Register('csrce8', 4, 0x900033a0),
        Register('csrce9', 4, 0x900033a4),
        Register('csrcea', 4, 0x900033a8),
        Register('csrceb', 4, 0x900033ac),
        Register('csrcec', 4, 0x900033b0),
        Register('csrced', 4, 0x900033b4),
        Register('csrcee', 4, 0x900033b8),
        Register('csrcef', 4, 0x900033bc),
        Register('csrcf0', 4, 0x900033c0),
        Register('csrcf1', 4, 0x900033c4),
        Register('csrcf2', 4, 0x900033c8),
        Register('csrcf3', 4, 0x900033cc),
        Register('csrcf4', 4, 0x900033d0),
        Register('csrcf5', 4, 0x900033d4),
        Register('csrcf6', 4, 0x900033d8),
        Register('csrcf7', 4, 0x900033dc),
        Register('csrcf8', 4, 0x900033e0),
        Register('csrcf9', 4, 0x900033e4),
        Register('csrcfa', 4, 0x900033e8),
        Register('csrcfb', 4, 0x900033ec),
        Register('csrcfc', 4, 0x900033f0),
        Register('csrcfd', 4, 0x900033f4),
        Register('csrcfe', 4, 0x900033f8),
        Register('csrcff', 4, 0x900033fc),
        Register('csrd00', 4, 0x90003400),
        Register('csrd01', 4, 0x90003404),
        Register('csrd02', 4, 0x90003408),
        Register('csrd03', 4, 0x9000340c),
        Register('csrd04', 4, 0x90003410),
        Register('csrd05', 4, 0x90003414),
        Register('csrd06', 4, 0x90003418),
        Register('csrd07', 4, 0x9000341c),
        Register('csrd08', 4, 0x90003420),
        Register('csrd09', 4, 0x90003424),
        Register('csrd0a', 4, 0x90003428),
        Register('csrd0b', 4, 0x9000342c),
        Register('csrd0c', 4, 0x90003430),
        Register('csrd0d', 4, 0x90003434),
        Register('csrd0e', 4, 0x90003438),
        Register('csrd0f', 4, 0x9000343c),
        Register('csrd10', 4, 0x90003440),
        Register('csrd11', 4, 0x90003444),
        Register('csrd12', 4, 0x90003448),
        Register('csrd13', 4, 0x9000344c),
        Register('csrd14', 4, 0x90003450),
        Register('csrd15', 4, 0x90003454),
        Register('csrd16', 4, 0x90003458),
        Register('csrd17', 4, 0x9000345c),
        Register('csrd18', 4, 0x90003460),
        Register('csrd19', 4, 0x90003464),
        Register('csrd1a', 4, 0x90003468),
        Register('csrd1b', 4, 0x9000346c),
        Register('csrd1c', 4, 0x90003470),
        Register('csrd1d', 4, 0x90003474),
        Register('csrd1e', 4, 0x90003478),
        Register('csrd1f', 4, 0x9000347c),
        Register('csrd20', 4, 0x90003480),
        Register('csrd21', 4, 0x90003484),
        Register('csrd22', 4, 0x90003488),
        Register('csrd23', 4, 0x9000348c),
        Register('csrd24', 4, 0x90003490),
        Register('csrd25', 4, 0x90003494),
        Register('csrd26', 4, 0x90003498),
        Register('csrd27', 4, 0x9000349c),
        Register('csrd28', 4, 0x900034a0),
        Register('csrd29', 4, 0x900034a4),
        Register('csrd2a', 4, 0x900034a8),
        Register('csrd2b', 4, 0x900034ac),
        Register('csrd2c', 4, 0x900034b0),
        Register('csrd2d', 4, 0x900034b4),
        Register('csrd2e', 4, 0x900034b8),
        Register('csrd2f', 4, 0x900034bc),
        Register('csrd30', 4, 0x900034c0),
        Register('csrd31', 4, 0x900034c4),
        Register('csrd32', 4, 0x900034c8),
        Register('csrd33', 4, 0x900034cc),
        Register('csrd34', 4, 0x900034d0),
        Register('csrd35', 4, 0x900034d4),
        Register('csrd36', 4, 0x900034d8),
        Register('csrd37', 4, 0x900034dc),
        Register('csrd38', 4, 0x900034e0),
        Register('csrd39', 4, 0x900034e4),
        Register('csrd3a', 4, 0x900034e8),
        Register('csrd3b', 4, 0x900034ec),
        Register('csrd3c', 4, 0x900034f0),
        Register('csrd3d', 4, 0x900034f4),
        Register('csrd3e', 4, 0x900034f8),
        Register('csrd3f', 4, 0x900034fc),
        Register('csrd40', 4, 0x90003500),
        Register('csrd41', 4, 0x90003504),
        Register('csrd42', 4, 0x90003508),
        Register('csrd43', 4, 0x9000350c),
        Register('csrd44', 4, 0x90003510),
        Register('csrd45', 4, 0x90003514),
        Register('csrd46', 4, 0x90003518),
        Register('csrd47', 4, 0x9000351c),
        Register('csrd48', 4, 0x90003520),
        Register('csrd49', 4, 0x90003524),
        Register('csrd4a', 4, 0x90003528),
        Register('csrd4b', 4, 0x9000352c),
        Register('csrd4c', 4, 0x90003530),
        Register('csrd4d', 4, 0x90003534),
        Register('csrd4e', 4, 0x90003538),
        Register('csrd4f', 4, 0x9000353c),
        Register('csrd50', 4, 0x90003540),
        Register('csrd51', 4, 0x90003544),
        Register('csrd52', 4, 0x90003548),
        Register('csrd53', 4, 0x9000354c),
        Register('csrd54', 4, 0x90003550),
        Register('csrd55', 4, 0x90003554),
        Register('csrd56', 4, 0x90003558),
        Register('csrd57', 4, 0x9000355c),
        Register('csrd58', 4, 0x90003560),
        Register('csrd59', 4, 0x90003564),
        Register('csrd5a', 4, 0x90003568),
        Register('csrd5b', 4, 0x9000356c),
        Register('csrd5c', 4, 0x90003570),
        Register('csrd5d', 4, 0x90003574),
        Register('csrd5e', 4, 0x90003578),
        Register('csrd5f', 4, 0x9000357c),
        Register('csrd60', 4, 0x90003580),
        Register('csrd61', 4, 0x90003584),
        Register('csrd62', 4, 0x90003588),
        Register('csrd63', 4, 0x9000358c),
        Register('csrd64', 4, 0x90003590),
        Register('csrd65', 4, 0x90003594),
        Register('csrd66', 4, 0x90003598),
        Register('csrd67', 4, 0x9000359c),
        Register('csrd68', 4, 0x900035a0),
        Register('csrd69', 4, 0x900035a4),
        Register('csrd6a', 4, 0x900035a8),
        Register('csrd6b', 4, 0x900035ac),
        Register('csrd6c', 4, 0x900035b0),
        Register('csrd6d', 4, 0x900035b4),
        Register('csrd6e', 4, 0x900035b8),
        Register('csrd6f', 4, 0x900035bc),
        Register('csrd70', 4, 0x900035c0),
        Register('csrd71', 4, 0x900035c4),
        Register('csrd72', 4, 0x900035c8),
        Register('csrd73', 4, 0x900035cc),
        Register('csrd74', 4, 0x900035d0),
        Register('csrd75', 4, 0x900035d4),
        Register('csrd76', 4, 0x900035d8),
        Register('csrd77', 4, 0x900035dc),
        Register('csrd78', 4, 0x900035e0),
        Register('csrd79', 4, 0x900035e4),
        Register('csrd7a', 4, 0x900035e8),
        Register('csrd7b', 4, 0x900035ec),
        Register('csrd7c', 4, 0x900035f0),
        Register('csrd7d', 4, 0x900035f4),
        Register('csrd7e', 4, 0x900035f8),
        Register('csrd7f', 4, 0x900035fc),
        Register('csrd80', 4, 0x90003600),
        Register('csrd81', 4, 0x90003604),
        Register('csrd82', 4, 0x90003608),
        Register('csrd83', 4, 0x9000360c),
        Register('csrd84', 4, 0x90003610),
        Register('csrd85', 4, 0x90003614),
        Register('csrd86', 4, 0x90003618),
        Register('csrd87', 4, 0x9000361c),
        Register('csrd88', 4, 0x90003620),
        Register('csrd89', 4, 0x90003624),
        Register('csrd8a', 4, 0x90003628),
        Register('csrd8b', 4, 0x9000362c),
        Register('csrd8c', 4, 0x90003630),
        Register('csrd8d', 4, 0x90003634),
        Register('csrd8e', 4, 0x90003638),
        Register('csrd8f', 4, 0x9000363c),
        Register('csrd90', 4, 0x90003640),
        Register('csrd91', 4, 0x90003644),
        Register('csrd92', 4, 0x90003648),
        Register('csrd93', 4, 0x9000364c),
        Register('csrd94', 4, 0x90003650),
        Register('csrd95', 4, 0x90003654),
        Register('csrd96', 4, 0x90003658),
        Register('csrd97', 4, 0x9000365c),
        Register('csrd98', 4, 0x90003660),
        Register('csrd99', 4, 0x90003664),
        Register('csrd9a', 4, 0x90003668),
        Register('csrd9b', 4, 0x9000366c),
        Register('csrd9c', 4, 0x90003670),
        Register('csrd9d', 4, 0x90003674),
        Register('csrd9e', 4, 0x90003678),
        Register('csrd9f', 4, 0x9000367c),
        Register('csrda0', 4, 0x90003680),
        Register('csrda1', 4, 0x90003684),
        Register('csrda2', 4, 0x90003688),
        Register('csrda3', 4, 0x9000368c),
        Register('csrda4', 4, 0x90003690),
        Register('csrda5', 4, 0x90003694),
        Register('csrda6', 4, 0x90003698),
        Register('csrda7', 4, 0x9000369c),
        Register('csrda8', 4, 0x900036a0),
        Register('csrda9', 4, 0x900036a4),
        Register('csrdaa', 4, 0x900036a8),
        Register('csrdab', 4, 0x900036ac),
        Register('csrdac', 4, 0x900036b0),
        Register('csrdad', 4, 0x900036b4),
        Register('csrdae', 4, 0x900036b8),
        Register('csrdaf', 4, 0x900036bc),
        Register('csrdb0', 4, 0x900036c0),
        Register('csrdb1', 4, 0x900036c4),
        Register('csrdb2', 4, 0x900036c8),
        Register('csrdb3', 4, 0x900036cc),
        Register('csrdb4', 4, 0x900036d0),
        Register('csrdb5', 4, 0x900036d4),
        Register('csrdb6', 4, 0x900036d8),
        Register('csrdb7', 4, 0x900036dc),
        Register('csrdb8', 4, 0x900036e0),
        Register('csrdb9', 4, 0x900036e4),
        Register('csrdba', 4, 0x900036e8),
        Register('csrdbb', 4, 0x900036ec),
        Register('csrdbc', 4, 0x900036f0),
        Register('csrdbd', 4, 0x900036f4),
        Register('csrdbe', 4, 0x900036f8),
        Register('csrdbf', 4, 0x900036fc),
        Register('csrdc0', 4, 0x90003700),
        Register('csrdc1', 4, 0x90003704),
        Register('csrdc2', 4, 0x90003708),
        Register('csrdc3', 4, 0x9000370c),
        Register('csrdc4', 4, 0x90003710),
        Register('csrdc5', 4, 0x90003714),
        Register('csrdc6', 4, 0x90003718),
        Register('csrdc7', 4, 0x9000371c),
        Register('csrdc8', 4, 0x90003720),
        Register('csrdc9', 4, 0x90003724),
        Register('csrdca', 4, 0x90003728),
        Register('csrdcb', 4, 0x9000372c),
        Register('csrdcc', 4, 0x90003730),
        Register('csrdcd', 4, 0x90003734),
        Register('csrdce', 4, 0x90003738),
        Register('csrdcf', 4, 0x9000373c),
        Register('csrdd0', 4, 0x90003740),
        Register('csrdd1', 4, 0x90003744),
        Register('csrdd2', 4, 0x90003748),
        Register('csrdd3', 4, 0x9000374c),
        Register('csrdd4', 4, 0x90003750),
        Register('csrdd5', 4, 0x90003754),
        Register('csrdd6', 4, 0x90003758),
        Register('csrdd7', 4, 0x9000375c),
        Register('csrdd8', 4, 0x90003760),
        Register('csrdd9', 4, 0x90003764),
        Register('csrdda', 4, 0x90003768),
        Register('csrddb', 4, 0x9000376c),
        Register('csrddc', 4, 0x90003770),
        Register('csrddd', 4, 0x90003774),
        Register('csrdde', 4, 0x90003778),
        Register('csrddf', 4, 0x9000377c),
        Register('csrde0', 4, 0x90003780),
        Register('csrde1', 4, 0x90003784),
        Register('csrde2', 4, 0x90003788),
        Register('csrde3', 4, 0x9000378c),
        Register('csrde4', 4, 0x90003790),
        Register('csrde5', 4, 0x90003794),
        Register('csrde6', 4, 0x90003798),
        Register('csrde7', 4, 0x9000379c),
        Register('csrde8', 4, 0x900037a0),
        Register('csrde9', 4, 0x900037a4),
        Register('csrdea', 4, 0x900037a8),
        Register('csrdeb', 4, 0x900037ac),
        Register('csrdec', 4, 0x900037b0),
        Register('csrded', 4, 0x900037b4),
        Register('csrdee', 4, 0x900037b8),
        Register('csrdef', 4, 0x900037bc),
        Register('csrdf0', 4, 0x900037c0),
        Register('csrdf1', 4, 0x900037c4),
        Register('csrdf2', 4, 0x900037c8),
        Register('csrdf3', 4, 0x900037cc),
        Register('csrdf4', 4, 0x900037d0),
        Register('csrdf5', 4, 0x900037d4),
        Register('csrdf6', 4, 0x900037d8),
        Register('csrdf7', 4, 0x900037dc),
        Register('csrdf8', 4, 0x900037e0),
        Register('csrdf9', 4, 0x900037e4),
        Register('csrdfa', 4, 0x900037e8),
        Register('csrdfb', 4, 0x900037ec),
        Register('csrdfc', 4, 0x900037f0),
        Register('csrdfd', 4, 0x900037f4),
        Register('csrdfe', 4, 0x900037f8),
        Register('csrdff', 4, 0x900037fc),
        Register('csre00', 4, 0x90003800),
        Register('csre01', 4, 0x90003804),
        Register('csre02', 4, 0x90003808),
        Register('csre03', 4, 0x9000380c),
        Register('csre04', 4, 0x90003810),
        Register('csre05', 4, 0x90003814),
        Register('csre06', 4, 0x90003818),
        Register('csre07', 4, 0x9000381c),
        Register('csre08', 4, 0x90003820),
        Register('csre09', 4, 0x90003824),
        Register('csre0a', 4, 0x90003828),
        Register('csre0b', 4, 0x9000382c),
        Register('csre0c', 4, 0x90003830),
        Register('csre0d', 4, 0x90003834),
        Register('csre0e', 4, 0x90003838),
        Register('csre0f', 4, 0x9000383c),
        Register('csre10', 4, 0x90003840),
        Register('csre11', 4, 0x90003844),
        Register('hgeip', 4, 0x90003848),
        Register('csre13', 4, 0x9000384c),
        Register('csre14', 4, 0x90003850),
        Register('csre15', 4, 0x90003854),
        Register('csre16', 4, 0x90003858),
        Register('csre17', 4, 0x9000385c),
        Register('csre18', 4, 0x90003860),
        Register('csre19', 4, 0x90003864),
        Register('csre1a', 4, 0x90003868),
        Register('csre1b', 4, 0x9000386c),
        Register('csre1c', 4, 0x90003870),
        Register('csre1d', 4, 0x90003874),
        Register('csre1e', 4, 0x90003878),
        Register('csre1f', 4, 0x9000387c),
        Register('csre20', 4, 0x90003880),
        Register('csre21', 4, 0x90003884),
        Register('csre22', 4, 0x90003888),
        Register('csre23', 4, 0x9000388c),
        Register('csre24', 4, 0x90003890),
        Register('csre25', 4, 0x90003894),
        Register('csre26', 4, 0x90003898),
        Register('csre27', 4, 0x9000389c),
        Register('csre28', 4, 0x900038a0),
        Register('csre29', 4, 0x900038a4),
        Register('csre2a', 4, 0x900038a8),
        Register('csre2b', 4, 0x900038ac),
        Register('csre2c', 4, 0x900038b0),
        Register('csre2d', 4, 0x900038b4),
        Register('csre2e', 4, 0x900038b8),
        Register('csre2f', 4, 0x900038bc),
        Register('csre30', 4, 0x900038c0),
        Register('csre31', 4, 0x900038c4),
        Register('csre32', 4, 0x900038c8),
        Register('csre33', 4, 0x900038cc),
        Register('csre34', 4, 0x900038d0),
        Register('csre35', 4, 0x900038d4),
        Register('csre36', 4, 0x900038d8),
        Register('csre37', 4, 0x900038dc),
        Register('csre38', 4, 0x900038e0),
        Register('csre39', 4, 0x900038e4),
        Register('csre3a', 4, 0x900038e8),
        Register('csre3b', 4, 0x900038ec),
        Register('csre3c', 4, 0x900038f0),
        Register('csre3d', 4, 0x900038f4),
        Register('csre3e', 4, 0x900038f8),
        Register('csre3f', 4, 0x900038fc),
        Register('csre40', 4, 0x90003900),
        Register('csre41', 4, 0x90003904),
        Register('csre42', 4, 0x90003908),
        Register('csre43', 4, 0x9000390c),
        Register('csre44', 4, 0x90003910),
        Register('csre45', 4, 0x90003914),
        Register('csre46', 4, 0x90003918),
        Register('csre47', 4, 0x9000391c),
        Register('csre48', 4, 0x90003920),
        Register('csre49', 4, 0x90003924),
        Register('csre4a', 4, 0x90003928),
        Register('csre4b', 4, 0x9000392c),
        Register('csre4c', 4, 0x90003930),
        Register('csre4d', 4, 0x90003934),
        Register('csre4e', 4, 0x90003938),
        Register('csre4f', 4, 0x9000393c),
        Register('csre50', 4, 0x90003940),
        Register('csre51', 4, 0x90003944),
        Register('csre52', 4, 0x90003948),
        Register('csre53', 4, 0x9000394c),
        Register('csre54', 4, 0x90003950),
        Register('csre55', 4, 0x90003954),
        Register('csre56', 4, 0x90003958),
        Register('csre57', 4, 0x9000395c),
        Register('csre58', 4, 0x90003960),
        Register('csre59', 4, 0x90003964),
        Register('csre5a', 4, 0x90003968),
        Register('csre5b', 4, 0x9000396c),
        Register('csre5c', 4, 0x90003970),
        Register('csre5d', 4, 0x90003974),
        Register('csre5e', 4, 0x90003978),
        Register('csre5f', 4, 0x9000397c),
        Register('csre60', 4, 0x90003980),
        Register('csre61', 4, 0x90003984),
        Register('csre62', 4, 0x90003988),
        Register('csre63', 4, 0x9000398c),
        Register('csre64', 4, 0x90003990),
        Register('csre65', 4, 0x90003994),
        Register('csre66', 4, 0x90003998),
        Register('csre67', 4, 0x9000399c),
        Register('csre68', 4, 0x900039a0),
        Register('csre69', 4, 0x900039a4),
        Register('csre6a', 4, 0x900039a8),
        Register('csre6b', 4, 0x900039ac),
        Register('csre6c', 4, 0x900039b0),
        Register('csre6d', 4, 0x900039b4),
        Register('csre6e', 4, 0x900039b8),
        Register('csre6f', 4, 0x900039bc),
        Register('csre70', 4, 0x900039c0),
        Register('csre71', 4, 0x900039c4),
        Register('csre72', 4, 0x900039c8),
        Register('csre73', 4, 0x900039cc),
        Register('csre74', 4, 0x900039d0),
        Register('csre75', 4, 0x900039d4),
        Register('csre76', 4, 0x900039d8),
        Register('csre77', 4, 0x900039dc),
        Register('csre78', 4, 0x900039e0),
        Register('csre79', 4, 0x900039e4),
        Register('csre7a', 4, 0x900039e8),
        Register('csre7b', 4, 0x900039ec),
        Register('csre7c', 4, 0x900039f0),
        Register('csre7d', 4, 0x900039f4),
        Register('csre7e', 4, 0x900039f8),
        Register('csre7f', 4, 0x900039fc),
        Register('csre80', 4, 0x90003a00),
        Register('csre81', 4, 0x90003a04),
        Register('csre82', 4, 0x90003a08),
        Register('csre83', 4, 0x90003a0c),
        Register('csre84', 4, 0x90003a10),
        Register('csre85', 4, 0x90003a14),
        Register('csre86', 4, 0x90003a18),
        Register('csre87', 4, 0x90003a1c),
        Register('csre88', 4, 0x90003a20),
        Register('csre89', 4, 0x90003a24),
        Register('csre8a', 4, 0x90003a28),
        Register('csre8b', 4, 0x90003a2c),
        Register('csre8c', 4, 0x90003a30),
        Register('csre8d', 4, 0x90003a34),
        Register('csre8e', 4, 0x90003a38),
        Register('csre8f', 4, 0x90003a3c),
        Register('csre90', 4, 0x90003a40),
        Register('csre91', 4, 0x90003a44),
        Register('csre92', 4, 0x90003a48),
        Register('csre93', 4, 0x90003a4c),
        Register('csre94', 4, 0x90003a50),
        Register('csre95', 4, 0x90003a54),
        Register('csre96', 4, 0x90003a58),
        Register('csre97', 4, 0x90003a5c),
        Register('csre98', 4, 0x90003a60),
        Register('csre99', 4, 0x90003a64),
        Register('csre9a', 4, 0x90003a68),
        Register('csre9b', 4, 0x90003a6c),
        Register('csre9c', 4, 0x90003a70),
        Register('csre9d', 4, 0x90003a74),
        Register('csre9e', 4, 0x90003a78),
        Register('csre9f', 4, 0x90003a7c),
        Register('csrea0', 4, 0x90003a80),
        Register('csrea1', 4, 0x90003a84),
        Register('csrea2', 4, 0x90003a88),
        Register('csrea3', 4, 0x90003a8c),
        Register('csrea4', 4, 0x90003a90),
        Register('csrea5', 4, 0x90003a94),
        Register('csrea6', 4, 0x90003a98),
        Register('csrea7', 4, 0x90003a9c),
        Register('csrea8', 4, 0x90003aa0),
        Register('csrea9', 4, 0x90003aa4),
        Register('csreaa', 4, 0x90003aa8),
        Register('csreab', 4, 0x90003aac),
        Register('csreac', 4, 0x90003ab0),
        Register('csread', 4, 0x90003ab4),
        Register('csreae', 4, 0x90003ab8),
        Register('csreaf', 4, 0x90003abc),
        Register('csreb0', 4, 0x90003ac0),
        Register('csreb1', 4, 0x90003ac4),
        Register('csreb2', 4, 0x90003ac8),
        Register('csreb3', 4, 0x90003acc),
        Register('csreb4', 4, 0x90003ad0),
        Register('csreb5', 4, 0x90003ad4),
        Register('csreb6', 4, 0x90003ad8),
        Register('csreb7', 4, 0x90003adc),
        Register('csreb8', 4, 0x90003ae0),
        Register('csreb9', 4, 0x90003ae4),
        Register('csreba', 4, 0x90003ae8),
        Register('csrebb', 4, 0x90003aec),
        Register('csrebc', 4, 0x90003af0),
        Register('csrebd', 4, 0x90003af4),
        Register('csrebe', 4, 0x90003af8),
        Register('csrebf', 4, 0x90003afc),
        Register('csrec0', 4, 0x90003b00),
        Register('csrec1', 4, 0x90003b04),
        Register('csrec2', 4, 0x90003b08),
        Register('csrec3', 4, 0x90003b0c),
        Register('csrec4', 4, 0x90003b10),
        Register('csrec5', 4, 0x90003b14),
        Register('csrec6', 4, 0x90003b18),
        Register('csrec7', 4, 0x90003b1c),
        Register('csrec8', 4, 0x90003b20),
        Register('csrec9', 4, 0x90003b24),
        Register('csreca', 4, 0x90003b28),
        Register('csrecb', 4, 0x90003b2c),
        Register('csrecc', 4, 0x90003b30),
        Register('csrecd', 4, 0x90003b34),
        Register('csrece', 4, 0x90003b38),
        Register('csrecf', 4, 0x90003b3c),
        Register('csred0', 4, 0x90003b40),
        Register('csred1', 4, 0x90003b44),
        Register('csred2', 4, 0x90003b48),
        Register('csred3', 4, 0x90003b4c),
        Register('csred4', 4, 0x90003b50),
        Register('csred5', 4, 0x90003b54),
        Register('csred6', 4, 0x90003b58),
        Register('csred7', 4, 0x90003b5c),
        Register('csred8', 4, 0x90003b60),
        Register('csred9', 4, 0x90003b64),
        Register('csreda', 4, 0x90003b68),
        Register('csredb', 4, 0x90003b6c),
        Register('csredc', 4, 0x90003b70),
        Register('csredd', 4, 0x90003b74),
        Register('csrede', 4, 0x90003b78),
        Register('csredf', 4, 0x90003b7c),
        Register('csree0', 4, 0x90003b80),
        Register('csree1', 4, 0x90003b84),
        Register('csree2', 4, 0x90003b88),
        Register('csree3', 4, 0x90003b8c),
        Register('csree4', 4, 0x90003b90),
        Register('csree5', 4, 0x90003b94),
        Register('csree6', 4, 0x90003b98),
        Register('csree7', 4, 0x90003b9c),
        Register('csree8', 4, 0x90003ba0),
        Register('csree9', 4, 0x90003ba4),
        Register('csreea', 4, 0x90003ba8),
        Register('csreeb', 4, 0x90003bac),
        Register('csreec', 4, 0x90003bb0),
        Register('csreed', 4, 0x90003bb4),
        Register('csreee', 4, 0x90003bb8),
        Register('csreef', 4, 0x90003bbc),
        Register('csref0', 4, 0x90003bc0),
        Register('csref1', 4, 0x90003bc4),
        Register('csref2', 4, 0x90003bc8),
        Register('csref3', 4, 0x90003bcc),
        Register('csref4', 4, 0x90003bd0),
        Register('csref5', 4, 0x90003bd4),
        Register('csref6', 4, 0x90003bd8),
        Register('csref7', 4, 0x90003bdc),
        Register('csref8', 4, 0x90003be0),
        Register('csref9', 4, 0x90003be4),
        Register('csrefa', 4, 0x90003be8),
        Register('csrefb', 4, 0x90003bec),
        Register('csrefc', 4, 0x90003bf0),
        Register('csrefd', 4, 0x90003bf4),
        Register('csrefe', 4, 0x90003bf8),
        Register('csreff', 4, 0x90003bfc),
        Register('csrf00', 4, 0x90003c00),
        Register('csrf01', 4, 0x90003c04),
        Register('csrf02', 4, 0x90003c08),
        Register('csrf03', 4, 0x90003c0c),
        Register('csrf04', 4, 0x90003c10),
        Register('csrf05', 4, 0x90003c14),
        Register('csrf06', 4, 0x90003c18),
        Register('csrf07', 4, 0x90003c1c),
        Register('csrf08', 4, 0x90003c20),
        Register('csrf09', 4, 0x90003c24),
        Register('csrf0a', 4, 0x90003c28),
        Register('csrf0b', 4, 0x90003c2c),
        Register('csrf0c', 4, 0x90003c30),
        Register('csrf0d', 4, 0x90003c34),
        Register('csrf0e', 4, 0x90003c38),
        Register('csrf0f', 4, 0x90003c3c),
        Register('csrf10', 4, 0x90003c40),
        Register('mvendorid', 4, 0x90003c44),
        Register('marchid', 4, 0x90003c48),
        Register('mimpid', 4, 0x90003c4c),
        Register('mhartid', 4, 0x90003c50),
        Register('csrf15', 4, 0x90003c54),
        Register('csrf16', 4, 0x90003c58),
        Register('csrf17', 4, 0x90003c5c),
        Register('csrf18', 4, 0x90003c60),
        Register('csrf19', 4, 0x90003c64),
        Register('csrf1a', 4, 0x90003c68),
        Register('csrf1b', 4, 0x90003c6c),
        Register('csrf1c', 4, 0x90003c70),
        Register('csrf1d', 4, 0x90003c74),
        Register('csrf1e', 4, 0x90003c78),
        Register('csrf1f', 4, 0x90003c7c),
        Register('csrf20', 4, 0x90003c80),
        Register('csrf21', 4, 0x90003c84),
        Register('csrf22', 4, 0x90003c88),
        Register('csrf23', 4, 0x90003c8c),
        Register('csrf24', 4, 0x90003c90),
        Register('csrf25', 4, 0x90003c94),
        Register('csrf26', 4, 0x90003c98),
        Register('csrf27', 4, 0x90003c9c),
        Register('csrf28', 4, 0x90003ca0),
        Register('csrf29', 4, 0x90003ca4),
        Register('csrf2a', 4, 0x90003ca8),
        Register('csrf2b', 4, 0x90003cac),
        Register('csrf2c', 4, 0x90003cb0),
        Register('csrf2d', 4, 0x90003cb4),
        Register('csrf2e', 4, 0x90003cb8),
        Register('csrf2f', 4, 0x90003cbc),
        Register('csrf30', 4, 0x90003cc0),
        Register('csrf31', 4, 0x90003cc4),
        Register('csrf32', 4, 0x90003cc8),
        Register('csrf33', 4, 0x90003ccc),
        Register('csrf34', 4, 0x90003cd0),
        Register('csrf35', 4, 0x90003cd4),
        Register('csrf36', 4, 0x90003cd8),
        Register('csrf37', 4, 0x90003cdc),
        Register('csrf38', 4, 0x90003ce0),
        Register('csrf39', 4, 0x90003ce4),
        Register('csrf3a', 4, 0x90003ce8),
        Register('csrf3b', 4, 0x90003cec),
        Register('csrf3c', 4, 0x90003cf0),
        Register('csrf3d', 4, 0x90003cf4),
        Register('csrf3e', 4, 0x90003cf8),
        Register('csrf3f', 4, 0x90003cfc),
        Register('csrf40', 4, 0x90003d00),
        Register('csrf41', 4, 0x90003d04),
        Register('csrf42', 4, 0x90003d08),
        Register('csrf43', 4, 0x90003d0c),
        Register('csrf44', 4, 0x90003d10),
        Register('csrf45', 4, 0x90003d14),
        Register('csrf46', 4, 0x90003d18),
        Register('csrf47', 4, 0x90003d1c),
        Register('csrf48', 4, 0x90003d20),
        Register('csrf49', 4, 0x90003d24),
        Register('csrf4a', 4, 0x90003d28),
        Register('csrf4b', 4, 0x90003d2c),
        Register('csrf4c', 4, 0x90003d30),
        Register('csrf4d', 4, 0x90003d34),
        Register('csrf4e', 4, 0x90003d38),
        Register('csrf4f', 4, 0x90003d3c),
        Register('csrf50', 4, 0x90003d40),
        Register('csrf51', 4, 0x90003d44),
        Register('csrf52', 4, 0x90003d48),
        Register('csrf53', 4, 0x90003d4c),
        Register('csrf54', 4, 0x90003d50),
        Register('csrf55', 4, 0x90003d54),
        Register('csrf56', 4, 0x90003d58),
        Register('csrf57', 4, 0x90003d5c),
        Register('csrf58', 4, 0x90003d60),
        Register('csrf59', 4, 0x90003d64),
        Register('csrf5a', 4, 0x90003d68),
        Register('csrf5b', 4, 0x90003d6c),
        Register('csrf5c', 4, 0x90003d70),
        Register('csrf5d', 4, 0x90003d74),
        Register('csrf5e', 4, 0x90003d78),
        Register('csrf5f', 4, 0x90003d7c),
        Register('csrf60', 4, 0x90003d80),
        Register('csrf61', 4, 0x90003d84),
        Register('csrf62', 4, 0x90003d88),
        Register('csrf63', 4, 0x90003d8c),
        Register('csrf64', 4, 0x90003d90),
        Register('csrf65', 4, 0x90003d94),
        Register('csrf66', 4, 0x90003d98),
        Register('csrf67', 4, 0x90003d9c),
        Register('csrf68', 4, 0x90003da0),
        Register('csrf69', 4, 0x90003da4),
        Register('csrf6a', 4, 0x90003da8),
        Register('csrf6b', 4, 0x90003dac),
        Register('csrf6c', 4, 0x90003db0),
        Register('csrf6d', 4, 0x90003db4),
        Register('csrf6e', 4, 0x90003db8),
        Register('csrf6f', 4, 0x90003dbc),
        Register('csrf70', 4, 0x90003dc0),
        Register('csrf71', 4, 0x90003dc4),
        Register('csrf72', 4, 0x90003dc8),
        Register('csrf73', 4, 0x90003dcc),
        Register('csrf74', 4, 0x90003dd0),
        Register('csrf75', 4, 0x90003dd4),
        Register('csrf76', 4, 0x90003dd8),
        Register('csrf77', 4, 0x90003ddc),
        Register('csrf78', 4, 0x90003de0),
        Register('csrf79', 4, 0x90003de4),
        Register('csrf7a', 4, 0x90003de8),
        Register('csrf7b', 4, 0x90003dec),
        Register('csrf7c', 4, 0x90003df0),
        Register('csrf7d', 4, 0x90003df4),
        Register('csrf7e', 4, 0x90003df8),
        Register('csrf7f', 4, 0x90003dfc),
        Register('csrf80', 4, 0x90003e00),
        Register('csrf81', 4, 0x90003e04),
        Register('csrf82', 4, 0x90003e08),
        Register('csrf83', 4, 0x90003e0c),
        Register('csrf84', 4, 0x90003e10),
        Register('csrf85', 4, 0x90003e14),
        Register('csrf86', 4, 0x90003e18),
        Register('csrf87', 4, 0x90003e1c),
        Register('csrf88', 4, 0x90003e20),
        Register('csrf89', 4, 0x90003e24),
        Register('csrf8a', 4, 0x90003e28),
        Register('csrf8b', 4, 0x90003e2c),
        Register('csrf8c', 4, 0x90003e30),
        Register('csrf8d', 4, 0x90003e34),
        Register('csrf8e', 4, 0x90003e38),
        Register('csrf8f', 4, 0x90003e3c),
        Register('csrf90', 4, 0x90003e40),
        Register('csrf91', 4, 0x90003e44),
        Register('csrf92', 4, 0x90003e48),
        Register('csrf93', 4, 0x90003e4c),
        Register('csrf94', 4, 0x90003e50),
        Register('csrf95', 4, 0x90003e54),
        Register('csrf96', 4, 0x90003e58),
        Register('csrf97', 4, 0x90003e5c),
        Register('csrf98', 4, 0x90003e60),
        Register('csrf99', 4, 0x90003e64),
        Register('csrf9a', 4, 0x90003e68),
        Register('csrf9b', 4, 0x90003e6c),
        Register('csrf9c', 4, 0x90003e70),
        Register('csrf9d', 4, 0x90003e74),
        Register('csrf9e', 4, 0x90003e78),
        Register('csrf9f', 4, 0x90003e7c),
        Register('csrfa0', 4, 0x90003e80),
        Register('csrfa1', 4, 0x90003e84),
        Register('csrfa2', 4, 0x90003e88),
        Register('csrfa3', 4, 0x90003e8c),
        Register('csrfa4', 4, 0x90003e90),
        Register('csrfa5', 4, 0x90003e94),
        Register('csrfa6', 4, 0x90003e98),
        Register('csrfa7', 4, 0x90003e9c),
        Register('csrfa8', 4, 0x90003ea0),
        Register('csrfa9', 4, 0x90003ea4),
        Register('csrfaa', 4, 0x90003ea8),
        Register('csrfab', 4, 0x90003eac),
        Register('csrfac', 4, 0x90003eb0),
        Register('csrfad', 4, 0x90003eb4),
        Register('csrfae', 4, 0x90003eb8),
        Register('csrfaf', 4, 0x90003ebc),
        Register('csrfb0', 4, 0x90003ec0),
        Register('csrfb1', 4, 0x90003ec4),
        Register('csrfb2', 4, 0x90003ec8),
        Register('csrfb3', 4, 0x90003ecc),
        Register('csrfb4', 4, 0x90003ed0),
        Register('csrfb5', 4, 0x90003ed4),
        Register('csrfb6', 4, 0x90003ed8),
        Register('csrfb7', 4, 0x90003edc),
        Register('csrfb8', 4, 0x90003ee0),
        Register('csrfb9', 4, 0x90003ee4),
        Register('csrfba', 4, 0x90003ee8),
        Register('csrfbb', 4, 0x90003eec),
        Register('csrfbc', 4, 0x90003ef0),
        Register('csrfbd', 4, 0x90003ef4),
        Register('csrfbe', 4, 0x90003ef8),
        Register('csrfbf', 4, 0x90003efc),
        Register('csrfc0', 4, 0x90003f00),
        Register('csrfc1', 4, 0x90003f04),
        Register('csrfc2', 4, 0x90003f08),
        Register('csrfc3', 4, 0x90003f0c),
        Register('csrfc4', 4, 0x90003f10),
        Register('csrfc5', 4, 0x90003f14),
        Register('csrfc6', 4, 0x90003f18),
        Register('csrfc7', 4, 0x90003f1c),
        Register('csrfc8', 4, 0x90003f20),
        Register('csrfc9', 4, 0x90003f24),
        Register('csrfca', 4, 0x90003f28),
        Register('csrfcb', 4, 0x90003f2c),
        Register('csrfcc', 4, 0x90003f30),
        Register('csrfcd', 4, 0x90003f34),
        Register('csrfce', 4, 0x90003f38),
        Register('csrfcf', 4, 0x90003f3c),
        Register('csrfd0', 4, 0x90003f40),
        Register('csrfd1', 4, 0x90003f44),
        Register('csrfd2', 4, 0x90003f48),
        Register('csrfd3', 4, 0x90003f4c),
        Register('csrfd4', 4, 0x90003f50),
        Register('csrfd5', 4, 0x90003f54),
        Register('csrfd6', 4, 0x90003f58),
        Register('csrfd7', 4, 0x90003f5c),
        Register('csrfd8', 4, 0x90003f60),
        Register('csrfd9', 4, 0x90003f64),
        Register('csrfda', 4, 0x90003f68),
        Register('csrfdb', 4, 0x90003f6c),
        Register('csrfdc', 4, 0x90003f70),
        Register('csrfdd', 4, 0x90003f74),
        Register('csrfde', 4, 0x90003f78),
        Register('csrfdf', 4, 0x90003f7c),
        Register('csrfe0', 4, 0x90003f80),
        Register('csrfe1', 4, 0x90003f84),
        Register('csrfe2', 4, 0x90003f88),
        Register('csrfe3', 4, 0x90003f8c),
        Register('csrfe4', 4, 0x90003f90),
        Register('csrfe5', 4, 0x90003f94),
        Register('csrfe6', 4, 0x90003f98),
        Register('csrfe7', 4, 0x90003f9c),
        Register('csrfe8', 4, 0x90003fa0),
        Register('csrfe9', 4, 0x90003fa4),
        Register('csrfea', 4, 0x90003fa8),
        Register('csrfeb', 4, 0x90003fac),
        Register('csrfec', 4, 0x90003fb0),
        Register('csrfed', 4, 0x90003fb4),
        Register('csrfee', 4, 0x90003fb8),
        Register('csrfef', 4, 0x90003fbc),
        Register('csrff0', 4, 0x90003fc0),
        Register('csrff1', 4, 0x90003fc4),
        Register('csrff2', 4, 0x90003fc8),
        Register('csrff3', 4, 0x90003fcc),
        Register('csrff4', 4, 0x90003fd0),
        Register('csrff5', 4, 0x90003fd4),
        Register('csrff6', 4, 0x90003fd8),
        Register('csrff7', 4, 0x90003fdc),
        Register('csrff8', 4, 0x90003fe0),
        Register('csrff9', 4, 0x90003fe4),
        Register('csrffa', 4, 0x90003fe8),
        Register('csrffb', 4, 0x90003fec),
        Register('csrffc', 4, 0x90003ff0),
        Register('csrffd', 4, 0x90003ff4),
        Register('csrffe', 4, 0x90003ff8),
        Register('csrfff', 4, 0x90003ffc)
    ]

register_arch(['riscv:le:32:rv32ic'], 32, Endness.LE, ArchPcode_RISCV_LE_32_RV32IC)
