from typing import Dict, Union
from pydantic import BaseModel

from artefacts.mixins import ContextReader, Artifact
from artefacts.nodes import BaseNodeReference, BaseNode
from artefacts.context import Context
from artefacts.shared import Metadata


class CatalogNode(BaseNode, BaseModel):
    pass


class CatalogNodeReference(BaseNodeReference):
    pass


class Catalog(Artifact, ContextReader, BaseModel):
    """
    Catalogs artifacts generated by `dbt docs generate`, and contain information about
    the actual state of all the tables tracked by dbt models.

    Examples:

        >>> from artefacts import Project
        >>> project = Project(target='./dbt_projects/jaffle_shop/target')
        >>> print(project.catalog)
        <Catalog v1>

    """

    class Config:
        arbitrary_types_allowed = True

    metadata: Metadata
    nodes: Dict[CatalogNodeReference, CatalogNode]
