from artefacts import config
from artefacts.context import Context


context = Context(config=config)


class ContextReader():

    @property
    def context(self):
        return context

    @property
    def manifest(self):
        return self.context.manifest

    @property
    def catalog(self):
        return self.context.catalog

    @property
    def run_results(self):
        return self.context.run_results

    @property
    def sources(self):
        return self.context.sources


class Artifact():

    @property
    def schema_version(self):
        return self.metadata.schema_version

    def __str__(self):
        return f"<{self.__class__.__name__} {self.schema_version}>"
