from typing import Dict
import pydantic

from artefacts.mixins import Artifact
from artefacts.mixins import ContextReader
from artefacts.shared import Metadata


class RunResults(Artifact, ContextReader, pydantic.BaseModel):
    """
    Run results are artifacts generated by `dbt build`, `dbt run`, `dbt test`, etc.

    Examples:

        >>> from artefacts import Project
        >>> project = Project(target='./dbt_projects/jaffle_shop/target')
        >>> print(project.run_results)
        <RunResults v3>

    """

    class Config:
        arbitrary_types_allowed = True

    metadata: Metadata
