from typing import Dict
import pydantic

from artefacts.mixins import ContextReader, Artifact
from artefacts.shared import Metadata



class Sources(Artifact, ContextReader, pydantic.BaseModel):
    """
    Sources are generated by the `dbt sources snapshot-freshness` command.

    Examples:

        >>> from artefacts import Project
        >>> project = Project(target='./dbt_projects/jaffle_shop/target')
        >>> print(project.sources)
        <Sources v2>

    """

    class Config:
        arbitrary_types_allowed = True

    metadata: Metadata
