import xfox
from Amisynth.utils import embeds  # Asumo que embeds es una lista global que estás usando

@xfox.addfunc(xfox.funcs)
async def authorIcon(url: str, indice: int = 1, *args, **kwargs):
    """
    Guarda un autor con ícono en la lista de embeds, con la URL del ícono y un índice opcional.
    Si se especifica el índice, se inserta o actualiza en esa posición. Si no, se agrega en la posición 1.
    
    :param url: La URL del ícono que se quiere mostrar en el autor del embed.
    :param indice: El índice opcional del embed (posición en la lista).
    """
    # Crear el embed con el autor y el ícono
    embed = {
        "author_icon": url,  # URL del ícono en el autor
        "index": indice      # Añadir el índice para identificar la posición
    }

    # Buscar si ya existe un embed con ese índice y actualizar solo el author_icon
    for i, item in enumerate(embeds):
        if item.get("index") == indice:
            # Mantener los otros atributos del embed y solo actualizar el author_icon
            embeds[i]["author_icon"] = url
            break
    else:
        # Si no se encontró, agregar uno nuevo
        embeds.append(embed)

    return ""
