import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

import cdk8s
import constructs


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Affinity",
    jsii_struct_bases=[],
    name_mapping={
        "node_affinity": "nodeAffinity",
        "pod_affinity": "podAffinity",
        "pod_anti_affinity": "podAntiAffinity",
    },
)
class Affinity:
    def __init__(
        self,
        *,
        node_affinity: typing.Optional["NodeAffinity"] = None,
        pod_affinity: typing.Optional["PodAffinity"] = None,
        pod_anti_affinity: typing.Optional["PodAntiAffinity"] = None,
    ) -> None:
        '''(experimental) Affinity is a group of affinity scheduling rules.

        :param node_affinity: (experimental) Describes node affinity scheduling rules for the pod.
        :param pod_affinity: (experimental) Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param pod_anti_affinity: (experimental) Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :stability: experimental
        :schema: io.k8s.api.core.v1.Affinity
        '''
        if isinstance(node_affinity, dict):
            node_affinity = NodeAffinity(**node_affinity)
        if isinstance(pod_affinity, dict):
            pod_affinity = PodAffinity(**pod_affinity)
        if isinstance(pod_anti_affinity, dict):
            pod_anti_affinity = PodAntiAffinity(**pod_anti_affinity)
        self._values: typing.Dict[str, typing.Any] = {}
        if node_affinity is not None:
            self._values["node_affinity"] = node_affinity
        if pod_affinity is not None:
            self._values["pod_affinity"] = pod_affinity
        if pod_anti_affinity is not None:
            self._values["pod_anti_affinity"] = pod_anti_affinity

    @builtins.property
    def node_affinity(self) -> typing.Optional["NodeAffinity"]:
        '''(experimental) Describes node affinity scheduling rules for the pod.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Affinity#nodeAffinity
        '''
        result = self._values.get("node_affinity")
        return typing.cast(typing.Optional["NodeAffinity"], result)

    @builtins.property
    def pod_affinity(self) -> typing.Optional["PodAffinity"]:
        '''(experimental) Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).

        :stability: experimental
        :schema: io.k8s.api.core.v1.Affinity#podAffinity
        '''
        result = self._values.get("pod_affinity")
        return typing.cast(typing.Optional["PodAffinity"], result)

    @builtins.property
    def pod_anti_affinity(self) -> typing.Optional["PodAntiAffinity"]:
        '''(experimental) Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).

        :stability: experimental
        :schema: io.k8s.api.core.v1.Affinity#podAntiAffinity
        '''
        result = self._values.get("pod_anti_affinity")
        return typing.cast(typing.Optional["PodAntiAffinity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Affinity(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AggregationRule",
    jsii_struct_bases=[],
    name_mapping={"cluster_role_selectors": "clusterRoleSelectors"},
)
class AggregationRule:
    def __init__(
        self,
        *,
        cluster_role_selectors: typing.Optional[typing.Sequence["LabelSelector"]] = None,
    ) -> None:
        '''(experimental) AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole.

        :param cluster_role_selectors: (experimental) ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules. If any of the selectors match, then the ClusterRole's permissions will be added

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.AggregationRule
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cluster_role_selectors is not None:
            self._values["cluster_role_selectors"] = cluster_role_selectors

    @builtins.property
    def cluster_role_selectors(self) -> typing.Optional[typing.List["LabelSelector"]]:
        '''(experimental) ClusterRoleSelectors holds a list of selectors which will be used to find ClusterRoles and create the rules.

        If any of the selectors match, then the ClusterRole's permissions will be added

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.AggregationRule#clusterRoleSelectors
        '''
        result = self._values.get("cluster_role_selectors")
        return typing.cast(typing.Optional[typing.List["LabelSelector"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AggregationRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AllowedCsiDriver",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class AllowedCsiDriver:
    def __init__(self, *, name: builtins.str) -> None:
        '''(experimental) AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.

        :param name: (experimental) Name is the registered name of the CSI driver.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedCSIDriver
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name is the registered name of the CSI driver.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedCSIDriver#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedCsiDriver(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AllowedFlexVolume",
    jsii_struct_bases=[],
    name_mapping={"driver": "driver"},
)
class AllowedFlexVolume:
    def __init__(self, *, driver: builtins.str) -> None:
        '''(experimental) AllowedFlexVolume represents a single Flexvolume that is allowed to be used.

        :param driver: (experimental) driver is the name of the Flexvolume driver.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedFlexVolume
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
        }

    @builtins.property
    def driver(self) -> builtins.str:
        '''(experimental) driver is the name of the Flexvolume driver.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedFlexVolume#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedFlexVolume(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AllowedHostPath",
    jsii_struct_bases=[],
    name_mapping={"path_prefix": "pathPrefix", "read_only": "readOnly"},
)
class AllowedHostPath:
    def __init__(
        self,
        *,
        path_prefix: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use.

        It requires the path prefix to be defined.

        :param path_prefix: (experimental) pathPrefix is the path prefix that the host volume must match. It does not support ``*``. Trailing slashes are trimmed when validating the path prefix with a host path. Examples: ``/foo`` would allow ``/foo``, ``/foo/`` and ``/foo/bar`` ``/foo`` would not allow ``/food`` or ``/etc/foo``
        :param read_only: (experimental) when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if path_prefix is not None:
            self._values["path_prefix"] = path_prefix
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def path_prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) pathPrefix is the path prefix that the host volume must match.

        It does not support ``*``. Trailing slashes are trimmed when validating the path prefix with a host path.

        Examples: ``/foo`` would allow ``/foo``, ``/foo/`` and ``/foo/bar`` ``/foo`` would not allow ``/food`` or ``/etc/foo``

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath#pathPrefix
        '''
        result = self._values.get("path_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.AllowedHostPath#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AllowedHostPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ApiServiceSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group_priority_minimum": "groupPriorityMinimum",
        "service": "service",
        "version_priority": "versionPriority",
        "ca_bundle": "caBundle",
        "group": "group",
        "insecure_skip_tls_verify": "insecureSkipTLSVerify",
        "version": "version",
    },
)
class ApiServiceSpec:
    def __init__(
        self,
        *,
        group_priority_minimum: jsii.Number,
        service: "ServiceReference",
        version_priority: jsii.Number,
        ca_bundle: typing.Optional[builtins.str] = None,
        group: typing.Optional[builtins.str] = None,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) APIServiceSpec contains information for locating and communicating with a server.

        Only https is supported, though you are able to disable certificate verification.

        :param group_priority_minimum: (experimental) GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object. (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s
        :param service: (experimental) Service is a reference to the service for this API server. It must communicate on port 443 If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.
        :param version_priority: (experimental) VersionPriority controls the ordering of this API version inside of its group. Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param ca_bundle: (experimental) CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.
        :param group: (experimental) Group is the API group name this server hosts.
        :param insecure_skip_tls_verify: (experimental) InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged. You should use the CABundle instead.
        :param version: (experimental) Version is the API version this server hosts. For example, "v1"

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec
        '''
        if isinstance(service, dict):
            service = ServiceReference(**service)
        self._values: typing.Dict[str, typing.Any] = {
            "group_priority_minimum": group_priority_minimum,
            "service": service,
            "version_priority": version_priority,
        }
        if ca_bundle is not None:
            self._values["ca_bundle"] = ca_bundle
        if group is not None:
            self._values["group"] = group
        if insecure_skip_tls_verify is not None:
            self._values["insecure_skip_tls_verify"] = insecure_skip_tls_verify
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def group_priority_minimum(self) -> jsii.Number:
        '''(experimental) GroupPriorityMininum is the priority this group should have at least.

        Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#groupPriorityMinimum
        '''
        result = self._values.get("group_priority_minimum")
        assert result is not None, "Required property 'group_priority_minimum' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def service(self) -> "ServiceReference":
        '''(experimental) Service is a reference to the service for this API server.

        It must communicate on port 443 If the Service is nil, that means the handling for the API groupversion is handled locally on this server. The call will simply delegate to the normal handler chain to be fulfilled.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#service
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast("ServiceReference", result)

    @builtins.property
    def version_priority(self) -> jsii.Number:
        '''(experimental) VersionPriority controls the ordering of this API version inside of its group.

        Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#versionPriority
        '''
        result = self._values.get("version_priority")
        assert result is not None, "Required property 'version_priority' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def ca_bundle(self) -> typing.Optional[builtins.str]:
        '''(experimental) CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.

        If unspecified, system trust roots on the apiserver are used.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#caBundle
        '''
        result = self._values.get("ca_bundle")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def group(self) -> typing.Optional[builtins.str]:
        '''(experimental) Group is the API group name this server hosts.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#group
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def insecure_skip_tls_verify(self) -> typing.Optional[builtins.bool]:
        '''(experimental) InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server.

        This is strongly discouraged.  You should use the CABundle instead.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#insecureSkipTLSVerify
        '''
        result = self._values.get("insecure_skip_tls_verify")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''(experimental) Version is the API version this server hosts.

        For example, "v1"

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceSpec#version
        '''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiServiceSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AuditSinkSpec",
    jsii_struct_bases=[],
    name_mapping={"policy": "policy", "webhook": "webhook"},
)
class AuditSinkSpec:
    def __init__(self, *, policy: "Policy", webhook: "Webhook") -> None:
        '''(experimental) AuditSinkSpec holds the spec for the audit sink.

        :param policy: (experimental) Policy defines the policy for selecting which events should be sent to the webhook required.
        :param webhook: (experimental) Webhook to send events required.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkSpec
        '''
        if isinstance(policy, dict):
            policy = Policy(**policy)
        if isinstance(webhook, dict):
            webhook = Webhook(**webhook)
        self._values: typing.Dict[str, typing.Any] = {
            "policy": policy,
            "webhook": webhook,
        }

    @builtins.property
    def policy(self) -> "Policy":
        '''(experimental) Policy defines the policy for selecting which events should be sent to the webhook required.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkSpec#policy
        '''
        result = self._values.get("policy")
        assert result is not None, "Required property 'policy' is missing"
        return typing.cast("Policy", result)

    @builtins.property
    def webhook(self) -> "Webhook":
        '''(experimental) Webhook to send events required.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkSpec#webhook
        '''
        result = self._values.get("webhook")
        assert result is not None, "Required property 'webhook' is missing"
        return typing.cast("Webhook", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AuditSinkSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AwsElasticBlockStoreVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeID",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.

        :param volume_id: (experimental) Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: (experimental) Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param partition: (experimental) The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param read_only: (experimental) Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :stability: experimental
        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''(experimental) Unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :stability: experimental
        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :stability: experimental
        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :stability: experimental
        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :stability: experimental
        :schema: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AzureDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "disk_name": "diskName",
        "disk_uri": "diskURI",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeSource:
    def __init__(
        self,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[builtins.str] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.

        :param disk_name: (experimental) The Name of the data disk in the blob storage.
        :param disk_uri: (experimental) The URI the data disk in the blob storage.
        :param caching_mode: (experimental) Host Caching mode: None, Read Only, Read Write.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param kind: (experimental) Expected values Shared: multiple blob disks per storage account Dedicated: single blob disk per storage account Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param read_only: (experimental) Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''(experimental) The Name of the data disk in the blob storage.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskName
        '''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''(experimental) The URI the data disk in the blob storage.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#diskURI
        '''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[builtins.str]:
        '''(experimental) Host Caching mode: None, Read Only, Read Write.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#cachingMode
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[builtins.str]:
        '''(experimental) Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set).

        defaults to shared

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AzureFilePersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
        "secret_namespace": "secretNamespace",
    },
)
class AzureFilePersistentVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
        secret_namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: (experimental) the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: (experimental) Share Name.
        :param read_only: (experimental) Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_namespace: (experimental) the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_namespace is not None:
            self._values["secret_namespace"] = secret_namespace

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''(experimental) the name of secret that contains Azure Storage Account Name and Key.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''(experimental) Share Name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_namespace(self) -> typing.Optional[builtins.str]:
        '''(experimental) the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFilePersistentVolumeSource#secretNamespace
        '''
        result = self._values.get("secret_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFilePersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.AzureFileVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "secret_name": "secretName",
        "share_name": "shareName",
        "read_only": "readOnly",
    },
)
class AzureFileVolumeSource:
    def __init__(
        self,
        *,
        secret_name: builtins.str,
        share_name: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) AzureFile represents an Azure File Service mount on the host and bind mount to the pod.

        :param secret_name: (experimental) the name of secret that contains Azure Storage Account Name and Key.
        :param share_name: (experimental) Share Name.
        :param read_only: (experimental) Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFileVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "secret_name": secret_name,
            "share_name": share_name,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def secret_name(self) -> builtins.str:
        '''(experimental) the name of secret that contains Azure Storage Account Name and Key.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#secretName
        '''
        result = self._values.get("secret_name")
        assert result is not None, "Required property 'secret_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def share_name(self) -> builtins.str:
        '''(experimental) Share Name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#shareName
        '''
        result = self._values.get("share_name")
        assert result is not None, "Required property 'share_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.AzureFileVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureFileVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Capabilities",
    jsii_struct_bases=[],
    name_mapping={"add": "add", "drop": "drop"},
)
class Capabilities:
    def __init__(
        self,
        *,
        add: typing.Optional[typing.Sequence[builtins.str]] = None,
        drop: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) Adds and removes POSIX capabilities from running containers.

        :param add: (experimental) Added capabilities.
        :param drop: (experimental) Removed capabilities.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Capabilities
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add is not None:
            self._values["add"] = add
        if drop is not None:
            self._values["drop"] = drop

    @builtins.property
    def add(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Added capabilities.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Capabilities#add
        '''
        result = self._values.get("add")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def drop(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Removed capabilities.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Capabilities#drop
        '''
        result = self._values.get("drop")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Capabilities(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CephFsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsPersistentVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional["SecretReference"] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: (experimental) Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
        :param path: (experimental) Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: (experimental) Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: (experimental) Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
        :param user: (experimental) Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''(experimental) Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSPersistentVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CephFsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "monitors": "monitors",
        "path": "path",
        "read_only": "readOnly",
        "secret_file": "secretFile",
        "secret_ref": "secretRef",
        "user": "user",
    },
)
class CephFsVolumeSource:
    def __init__(
        self,
        *,
        monitors: typing.Sequence[builtins.str],
        path: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_file: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional["LocalObjectReference"] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.

        :param monitors: (experimental) Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
        :param path: (experimental) Optional: Used as the mounted root, rather than the full Ceph tree, default is /.
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
        :param secret_file: (experimental) Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.
        :param secret_ref: (experimental) Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
        :param user: (experimental) Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "monitors": monitors,
        }
        if path is not None:
            self._values["path"] = path
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_file is not None:
            self._values["secret_file"] = secret_file
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def monitors(self) -> typing.List[builtins.str]:
        '''(experimental) Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#monitors
        '''
        result = self._values.get("monitors")
        assert result is not None, "Required property 'monitors' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: Used as the mounted root, rather than the full Ceph tree, default is /.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretFile
        '''
        result = self._values.get("secret_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''(experimental) Optional: SecretRef is reference to the authentication secret for User, default is empty.

        More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CephFSVolumeSource#user
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CephFsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CertificateSigningRequestSpec",
    jsii_struct_bases=[],
    name_mapping={
        "request": "request",
        "extra": "extra",
        "groups": "groups",
        "uid": "uid",
        "usages": "usages",
        "username": "username",
    },
)
class CertificateSigningRequestSpec:
    def __init__(
        self,
        *,
        request: builtins.str,
        extra: typing.Optional[typing.Mapping[builtins.str, typing.Sequence[builtins.str]]] = None,
        groups: typing.Optional[typing.Sequence[builtins.str]] = None,
        uid: typing.Optional[builtins.str] = None,
        usages: typing.Optional[typing.Sequence[builtins.str]] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) This information is immutable after the request is created.

        Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.

        :param request: (experimental) Base64-encoded PKCS#10 CSR data.
        :param extra: (experimental) Extra information about the requesting user. See user.Info interface for details.
        :param groups: (experimental) Group information about the requesting user. See user.Info interface for details.
        :param uid: (experimental) UID information about the requesting user. See user.Info interface for details.
        :param usages: (experimental) allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3 https://tools.ietf.org/html/rfc5280#section-4.2.1.12
        :param username: (experimental) Information about the requesting user. See user.Info interface for details.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "request": request,
        }
        if extra is not None:
            self._values["extra"] = extra
        if groups is not None:
            self._values["groups"] = groups
        if uid is not None:
            self._values["uid"] = uid
        if usages is not None:
            self._values["usages"] = usages
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def request(self) -> builtins.str:
        '''(experimental) Base64-encoded PKCS#10 CSR data.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#request
        '''
        result = self._values.get("request")
        assert result is not None, "Required property 'request' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def extra(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]]:
        '''(experimental) Extra information about the requesting user.

        See user.Info interface for details.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#extra
        '''
        result = self._values.get("extra")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.List[builtins.str]]], result)

    @builtins.property
    def groups(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Group information about the requesting user.

        See user.Info interface for details.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#groups
        '''
        result = self._values.get("groups")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''(experimental) UID information about the requesting user.

        See user.Info interface for details.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def usages(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) allowedUsages specifies a set of usage contexts the key will be valid for.

        See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3
        https://tools.ietf.org/html/rfc5280#section-4.2.1.12

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#usages
        '''
        result = self._values.get("usages")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(experimental) Information about the requesting user.

        See user.Info interface for details.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestSpec#username
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CertificateSigningRequestSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CinderPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeID",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderPersistentVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["SecretReference"] = None,
    ) -> None:
        '''(experimental) Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: (experimental) volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
        :param secret_ref: (experimental) Optional: points to a secret object containing parameters used to connect to OpenStack.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''(experimental) volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) Optional: points to a secret object containing parameters used to connect to OpenStack.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CinderVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "volume_id": "volumeID",
        "fs_type": "fsType",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class CinderVolumeSource:
    def __init__(
        self,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["LocalObjectReference"] = None,
    ) -> None:
        '''(experimental) Represents a cinder volume resource in Openstack.

        A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.

        :param volume_id: (experimental) volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
        :param secret_ref: (experimental) Optional: points to a secret object containing parameters used to connect to OpenStack.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "volume_id": volume_id,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''(experimental) volume id used to identify the volume in cinder More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderVolumeSource#volumeID
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''(experimental) Optional: points to a secret object containing parameters used to connect to OpenStack.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CinderVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CinderVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ClientIpConfig",
    jsii_struct_bases=[],
    name_mapping={"timeout_seconds": "timeoutSeconds"},
)
class ClientIpConfig:
    def __init__(self, *, timeout_seconds: typing.Optional[jsii.Number] = None) -> None:
        '''(experimental) ClientIPConfig represents the configurations of Client IP based session affinity.

        :param timeout_seconds: (experimental) timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ClientIPConfig
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) timeoutSeconds specifies the seconds of ClientIP type session sticky time.

        The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ClientIPConfig#timeoutSeconds
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClientIpConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ComponentCondition",
    jsii_struct_bases=[],
    name_mapping={
        "status": "status",
        "type": "type",
        "error": "error",
        "message": "message",
    },
)
class ComponentCondition:
    def __init__(
        self,
        *,
        status: builtins.str,
        type: builtins.str,
        error: typing.Optional[builtins.str] = None,
        message: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Information about the condition of a component.

        :param status: (experimental) Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
        :param type: (experimental) Type of condition for a component. Valid value: "Healthy"
        :param error: (experimental) Condition error code for a component. For example, a health check error code.
        :param message: (experimental) Message about the condition for a component. For example, information about a health check.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentCondition
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "status": status,
            "type": type,
        }
        if error is not None:
            self._values["error"] = error
        if message is not None:
            self._values["message"] = message

    @builtins.property
    def status(self) -> builtins.str:
        '''(experimental) Status of the condition for a component.

        Valid values for "Healthy": "True", "False", or "Unknown".

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentCondition#status
        '''
        result = self._values.get("status")
        assert result is not None, "Required property 'status' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''(experimental) Type of condition for a component.

        Valid value: "Healthy"

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentCondition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def error(self) -> typing.Optional[builtins.str]:
        '''(experimental) Condition error code for a component.

        For example, a health check error code.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentCondition#error
        '''
        result = self._values.get("error")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''(experimental) Message about the condition for a component.

        For example, information about a health check.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentCondition#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ComponentCondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ConfigMapEnvSource",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "optional": "optional"},
)
class ConfigMapEnvSource:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.

        :param name: (experimental) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: (experimental) Specify whether the ConfigMap must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapEnvSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specify whether the ConfigMap must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapEnvSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapEnvSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ConfigMapKeySelector",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "name": "name", "optional": "optional"},
)
class ConfigMapKeySelector:
    def __init__(
        self,
        *,
        key: builtins.str,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Selects a key from a ConfigMap.

        :param key: (experimental) The key to select.
        :param name: (experimental) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: (experimental) Specify whether the ConfigMap or its key must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapKeySelector
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
        }
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) The key to select.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specify whether the ConfigMap or its key must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapKeySelector#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapKeySelector(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ConfigMapNodeConfigSource",
    jsii_struct_bases=[],
    name_mapping={
        "kubelet_config_key": "kubeletConfigKey",
        "name": "name",
        "namespace": "namespace",
        "resource_version": "resourceVersion",
        "uid": "uid",
    },
)
class ConfigMapNodeConfigSource:
    def __init__(
        self,
        *,
        kubelet_config_key: builtins.str,
        name: builtins.str,
        namespace: builtins.str,
        resource_version: typing.Optional[builtins.str] = None,
        uid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.

        :param kubelet_config_key: (experimental) KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param name: (experimental) Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param namespace: (experimental) Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param resource_version: (experimental) ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param uid: (experimental) UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "kubelet_config_key": kubelet_config_key,
            "name": name,
            "namespace": namespace,
        }
        if resource_version is not None:
            self._values["resource_version"] = resource_version
        if uid is not None:
            self._values["uid"] = uid

    @builtins.property
    def kubelet_config_key(self) -> builtins.str:
        '''(experimental) KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#kubeletConfigKey
        '''
        result = self._values.get("kubelet_config_key")
        assert result is not None, "Required property 'kubelet_config_key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def namespace(self) -> builtins.str:
        '''(experimental) Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#namespace
        '''
        result = self._values.get("namespace")
        assert result is not None, "Required property 'namespace' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_version(self) -> typing.Optional[builtins.str]:
        '''(experimental) ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#resourceVersion
        '''
        result = self._values.get("resource_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def uid(self) -> typing.Optional[builtins.str]:
        '''(experimental) UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapNodeConfigSource#uid
        '''
        result = self._values.get("uid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapNodeConfigSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ConfigMapProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "name": "name", "optional": "optional"},
)
class ConfigMapProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence["KeyToPath"]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.

        :param items: (experimental) If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: (experimental) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: (experimental) Specify whether the ConfigMap or its keys must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapProjection
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''(experimental) If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapProjection#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specify whether the ConfigMap or its keys must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapProjection#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ConfigMapVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence["KeyToPath"]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.

        :param default_mode: (experimental) Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: (experimental) If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param name: (experimental) Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param optional: (experimental) Specify whether the ConfigMap or its keys must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional: mode bits to use on created files by default.

        Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List["KeyToPath"]]:
        '''(experimental) If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["KeyToPath"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the referent.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specify whether the ConfigMap or its keys must be defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapVolumeSource#optional
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Container",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "args": "args",
        "command": "command",
        "env": "env",
        "env_from": "envFrom",
        "image": "image",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness_probe": "livenessProbe",
        "ports": "ports",
        "readiness_probe": "readinessProbe",
        "resources": "resources",
        "security_context": "securityContext",
        "stdin": "stdin",
        "stdin_once": "stdinOnce",
        "termination_message_path": "terminationMessagePath",
        "termination_message_policy": "terminationMessagePolicy",
        "tty": "tty",
        "volume_devices": "volumeDevices",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class Container:
    def __init__(
        self,
        *,
        name: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env: typing.Optional[typing.Sequence["EnvVar"]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFromSource"]] = None,
        image: typing.Optional[builtins.str] = None,
        image_pull_policy: typing.Optional[builtins.str] = None,
        lifecycle: typing.Optional["Lifecycle"] = None,
        liveness_probe: typing.Optional["Probe"] = None,
        ports: typing.Optional[typing.Sequence["ContainerPort"]] = None,
        readiness_probe: typing.Optional["Probe"] = None,
        resources: typing.Optional["ResourceRequirements"] = None,
        security_context: typing.Optional["SecurityContext"] = None,
        stdin: typing.Optional[builtins.bool] = None,
        stdin_once: typing.Optional[builtins.bool] = None,
        termination_message_path: typing.Optional[builtins.str] = None,
        termination_message_policy: typing.Optional[builtins.str] = None,
        tty: typing.Optional[builtins.bool] = None,
        volume_devices: typing.Optional[typing.Sequence["VolumeDevice"]] = None,
        volume_mounts: typing.Optional[typing.Sequence["VolumeMount"]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) A single application container that you want to run within a pod.

        :param name: (experimental) Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param args: (experimental) Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: (experimental) Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: (experimental) List of environment variables to set in the container. Cannot be updated.
        :param env_from: (experimental) List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param image: (experimental) Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param image_pull_policy: (experimental) Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images Default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param lifecycle: (experimental) Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param liveness_probe: (experimental) Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param ports: (experimental) List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.
        :param readiness_probe: (experimental) Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param resources: (experimental) Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param security_context: (experimental) Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param stdin: (experimental) Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. Default: false.
        :param stdin_once: (experimental) Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false Default: false
        :param termination_message_path: (experimental) Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. Default: dev/termination-log. Cannot be updated.
        :param termination_message_policy: (experimental) Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. Default: File. Cannot be updated.
        :param tty: (experimental) Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. Default: false.
        :param volume_devices: (experimental) volumeDevices is the list of block devices to be used by the container. This is a beta feature.
        :param volume_mounts: (experimental) Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: (experimental) Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container
        '''
        if isinstance(lifecycle, dict):
            lifecycle = Lifecycle(**lifecycle)
        if isinstance(liveness_probe, dict):
            liveness_probe = Probe(**liveness_probe)
        if isinstance(readiness_probe, dict):
            readiness_probe = Probe(**readiness_probe)
        if isinstance(resources, dict):
            resources = ResourceRequirements(**resources)
        if isinstance(security_context, dict):
            security_context = SecurityContext(**security_context)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env is not None:
            self._values["env"] = env
        if env_from is not None:
            self._values["env_from"] = env_from
        if image is not None:
            self._values["image"] = image
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness_probe is not None:
            self._values["liveness_probe"] = liveness_probe
        if ports is not None:
            self._values["ports"] = ports
        if readiness_probe is not None:
            self._values["readiness_probe"] = readiness_probe
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if stdin is not None:
            self._values["stdin"] = stdin
        if stdin_once is not None:
            self._values["stdin_once"] = stdin_once
        if termination_message_path is not None:
            self._values["termination_message_path"] = termination_message_path
        if termination_message_policy is not None:
            self._values["termination_message_policy"] = termination_message_policy
        if tty is not None:
            self._values["tty"] = tty
        if volume_devices is not None:
            self._values["volume_devices"] = volume_devices
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Arguments to the entrypoint.

        The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#args
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env(self) -> typing.Optional[typing.List["EnvVar"]]:
        '''(experimental) List of environment variables to set in the container.

        Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#env
        '''
        result = self._values.get("env")
        return typing.cast(typing.Optional[typing.List["EnvVar"]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFromSource"]]:
        '''(experimental) List of sources to populate environment variables in the container.

        The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#envFrom
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFromSource"]], result)

    @builtins.property
    def image(self) -> typing.Optional[builtins.str]:
        '''(experimental) Docker image name.

        More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#image
        '''
        result = self._values.get("image")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) Image pull policy.

        One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :default: Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#imagePullPolicy
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["Lifecycle"]:
        '''(experimental) Actions that the management system should take in response to container lifecycle events.

        Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#lifecycle
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["Lifecycle"], result)

    @builtins.property
    def liveness_probe(self) -> typing.Optional["Probe"]:
        '''(experimental) Periodic probe of container liveness.

        Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#livenessProbe
        '''
        result = self._values.get("liveness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ContainerPort"]]:
        '''(experimental) List of ports to expose from the container.

        Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ContainerPort"]], result)

    @builtins.property
    def readiness_probe(self) -> typing.Optional["Probe"]:
        '''(experimental) Periodic probe of container service readiness.

        Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#readinessProbe
        '''
        result = self._values.get("readiness_probe")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ResourceRequirements"]:
        '''(experimental) Compute Resources required by this container.

        Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#resources
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ResourceRequirements"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["SecurityContext"]:
        '''(experimental) Security options the pod should run with.

        More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#securityContext
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["SecurityContext"], result)

    @builtins.property
    def stdin(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether this container should allocate a buffer for stdin in the container runtime.

        If this is not set, reads from stdin in the container will always result in EOF. Default is false.

        :default: false.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#stdin
        '''
        result = self._values.get("stdin")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stdin_once(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether the container runtime should close the stdin channel after it has been opened by a single attach.

        When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false

        :default: false

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#stdinOnce
        '''
        result = self._values.get("stdin_once")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def termination_message_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem.

        Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.

        :default: dev/termination-log. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#terminationMessagePath
        '''
        result = self._values.get("termination_message_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def termination_message_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) Indicate how the termination message should be populated.

        File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.

        :default: File. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#terminationMessagePolicy
        '''
        result = self._values.get("termination_message_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tty(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.

        Default is false.

        :default: false.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#tty
        '''
        result = self._values.get("tty")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_devices(self) -> typing.Optional[typing.List["VolumeDevice"]]:
        '''(experimental) volumeDevices is the list of block devices to be used by the container.

        This is a beta feature.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#volumeDevices
        '''
        result = self._values.get("volume_devices")
        return typing.cast(typing.Optional[typing.List["VolumeDevice"]], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''(experimental) Pod volumes to mount into the container's filesystem.

        Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#volumeMounts
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''(experimental) Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Container#workingDir
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Container(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "container_port": "containerPort",
        "host_ip": "hostIP",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        container_port: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) ContainerPort represents a network port in a single container.

        :param container_port: (experimental) Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: (experimental) What host IP to bind the external port to.
        :param host_port: (experimental) Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param name: (experimental) If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param protocol: (experimental) Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: TCP".

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "container_port": container_port,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def container_port(self) -> jsii.Number:
        '''(experimental) Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort#containerPort
        '''
        result = self._values.get("container_port")
        assert result is not None, "Required property 'container_port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''(experimental) What host IP to bind the external port to.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort#hostIP
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort#hostPort
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name. Name for the port that can be referred to by services.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''(experimental) Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: TCP".

        :stability: experimental
        :schema: io.k8s.api.core.v1.ContainerPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CronJobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "job_template": "jobTemplate",
        "schedule": "schedule",
        "concurrency_policy": "concurrencyPolicy",
        "failed_jobs_history_limit": "failedJobsHistoryLimit",
        "starting_deadline_seconds": "startingDeadlineSeconds",
        "successful_jobs_history_limit": "successfulJobsHistoryLimit",
        "suspend": "suspend",
    },
)
class CronJobSpec:
    def __init__(
        self,
        *,
        job_template: "JobTemplateSpec",
        schedule: builtins.str,
        concurrency_policy: typing.Optional[builtins.str] = None,
        failed_jobs_history_limit: typing.Optional[jsii.Number] = None,
        starting_deadline_seconds: typing.Optional[jsii.Number] = None,
        successful_jobs_history_limit: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) CronJobSpec describes how the job execution will look like and when it will actually run.

        :param job_template: (experimental) Specifies the job that will be created when executing a CronJob.
        :param schedule: (experimental) The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
        :param concurrency_policy: (experimental) Specifies how to treat concurrent executions of a Job. Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one
        :param failed_jobs_history_limit: (experimental) The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
        :param starting_deadline_seconds: (experimental) Optional deadline in seconds for starting the job if it misses scheduled time for any reason. Missed jobs executions will be counted as failed ones.
        :param successful_jobs_history_limit: (experimental) The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.
        :param suspend: (experimental) This flag tells the controller to suspend subsequent executions, it does not apply to already started executions. Defaults to false. Default: false.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec
        '''
        if isinstance(job_template, dict):
            job_template = JobTemplateSpec(**job_template)
        self._values: typing.Dict[str, typing.Any] = {
            "job_template": job_template,
            "schedule": schedule,
        }
        if concurrency_policy is not None:
            self._values["concurrency_policy"] = concurrency_policy
        if failed_jobs_history_limit is not None:
            self._values["failed_jobs_history_limit"] = failed_jobs_history_limit
        if starting_deadline_seconds is not None:
            self._values["starting_deadline_seconds"] = starting_deadline_seconds
        if successful_jobs_history_limit is not None:
            self._values["successful_jobs_history_limit"] = successful_jobs_history_limit
        if suspend is not None:
            self._values["suspend"] = suspend

    @builtins.property
    def job_template(self) -> "JobTemplateSpec":
        '''(experimental) Specifies the job that will be created when executing a CronJob.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#jobTemplate
        '''
        result = self._values.get("job_template")
        assert result is not None, "Required property 'job_template' is missing"
        return typing.cast("JobTemplateSpec", result)

    @builtins.property
    def schedule(self) -> builtins.str:
        '''(experimental) The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#schedule
        '''
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def concurrency_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) Specifies how to treat concurrent executions of a Job.

        Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#concurrencyPolicy
        '''
        result = self._values.get("concurrency_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def failed_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The number of failed finished jobs to retain.

        This is a pointer to distinguish between explicit zero and not specified.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#failedJobsHistoryLimit
        '''
        result = self._values.get("failed_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def starting_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional deadline in seconds for starting the job if it misses scheduled time for any reason.

        Missed jobs executions will be counted as failed ones.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#startingDeadlineSeconds
        '''
        result = self._values.get("starting_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def successful_jobs_history_limit(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The number of successful finished jobs to retain.

        This is a pointer to distinguish between explicit zero and not specified.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#successfulJobsHistoryLimit
        '''
        result = self._values.get("successful_jobs_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''(experimental) This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.

        Defaults to false.

        :default: false.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobSpec#suspend
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CronJobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CrossVersionObjectReference",
    jsii_struct_bases=[],
    name_mapping={"kind": "kind", "name": "name", "api_version": "apiVersion"},
)
class CrossVersionObjectReference:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) CrossVersionObjectReference contains enough information to let you identify the referred resource.

        :param kind: (experimental) Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds"
        :param name: (experimental) Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param api_version: (experimental) API version of the referent.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_version is not None:
            self._values["api_version"] = api_version

    @builtins.property
    def kind(self) -> builtins.str:
        '''(experimental) Kind of the referent;

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds"

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name of the referent;

        More info: http://kubernetes.io/docs/user-guide/identifiers#names

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''(experimental) API version of the referent.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CrossVersionObjectReference(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CsiDriverSpec",
    jsii_struct_bases=[],
    name_mapping={
        "attach_required": "attachRequired",
        "pod_info_on_mount": "podInfoOnMount",
    },
)
class CsiDriverSpec:
    def __init__(
        self,
        *,
        attach_required: typing.Optional[builtins.bool] = None,
        pod_info_on_mount: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) CSIDriverSpec is the specification of a CSIDriver.

        :param attach_required: (experimental) attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.
        :param pod_info_on_mount: (experimental) If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID). Default: false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID)

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverSpec
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if attach_required is not None:
            self._values["attach_required"] = attach_required
        if pod_info_on_mount is not None:
            self._values["pod_info_on_mount"] = pod_info_on_mount

    @builtins.property
    def attach_required(self) -> typing.Optional[builtins.bool]:
        '''(experimental) attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting.

        The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverSpec#attachRequired
        '''
        result = self._values.get("attach_required")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def pod_info_on_mount(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID).

        :default: false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace": pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID)

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverSpec#podInfoOnMount
        '''
        result = self._values.get("pod_info_on_mount")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiDriverSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CsiNodeDriver",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_id": "nodeID",
        "topology_keys": "topologyKeys",
    },
)
class CsiNodeDriver:
    def __init__(
        self,
        *,
        name: builtins.str,
        node_id: builtins.str,
        topology_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) CSINodeDriver holds information about the specification of one CSI driver installed on a node.

        :param name: (experimental) This is the name of the CSI driver that this object refers to. This MUST be the same name returned by the CSI GetPluginName() call for that driver.
        :param node_id: (experimental) nodeID of the node from the driver point of view. This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.
        :param topology_keys: (experimental) topologyKeys is the list of keys supported by the driver. When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeDriver
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "node_id": node_id,
        }
        if topology_keys is not None:
            self._values["topology_keys"] = topology_keys

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) This is the name of the CSI driver that this object refers to.

        This MUST be the same name returned by the CSI GetPluginName() call for that driver.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeDriver#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def node_id(self) -> builtins.str:
        '''(experimental) nodeID of the node from the driver point of view.

        This field enables Kubernetes to communicate with storage systems that do not share the same nomenclature for nodes. For example, Kubernetes may refer to a given node as "node1", but the storage system may refer to the same node as "nodeA". When Kubernetes issues a command to the storage system to attach a volume to a specific node, it can use this field to refer to the node name using the ID that the storage system will understand, e.g. "nodeA" instead of "node1". This field is required.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeDriver#nodeID
        '''
        result = self._values.get("node_id")
        assert result is not None, "Required property 'node_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def topology_keys(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) topologyKeys is the list of keys supported by the driver.

        When a driver is initialized on a cluster, it provides a set of topology keys that it understands (e.g. "company.com/zone", "company.com/region"). When a driver is initialized on a node, it provides the same topology keys along with values. Kubelet will expose these topology keys as labels on its own node object. When Kubernetes does topology aware provisioning, it can use this list to determine which labels it should retrieve from the node object and pass back to the driver. It is possible for different nodes to use different topology keys. This can be empty if driver does not support topology.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeDriver#topologyKeys
        '''
        result = self._values.get("topology_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeDriver(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CsiNodeSpec",
    jsii_struct_bases=[],
    name_mapping={"drivers": "drivers"},
)
class CsiNodeSpec:
    def __init__(self, *, drivers: typing.Sequence[CsiNodeDriver]) -> None:
        '''(experimental) CSINodeSpec holds information about the specification of all CSI drivers installed on a node.

        :param drivers: (experimental) drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are uninstalled, this can become empty.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeSpec
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "drivers": drivers,
        }

    @builtins.property
    def drivers(self) -> typing.List[CsiNodeDriver]:
        '''(experimental) drivers is a list of information of all CSI Drivers existing on a node.

        If all drivers in the list are uninstalled, this can become empty.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeSpec#drivers
        '''
        result = self._values.get("drivers")
        assert result is not None, "Required property 'drivers' is missing"
        return typing.cast(typing.List[CsiNodeDriver], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiNodeSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "volume_handle": "volumeHandle",
        "controller_expand_secret_ref": "controllerExpandSecretRef",
        "controller_publish_secret_ref": "controllerPublishSecretRef",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "node_stage_secret_ref": "nodeStageSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        volume_handle: builtins.str,
        controller_expand_secret_ref: typing.Optional["SecretReference"] = None,
        controller_publish_secret_ref: typing.Optional["SecretReference"] = None,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional["SecretReference"] = None,
        node_stage_secret_ref: typing.Optional["SecretReference"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''(experimental) Represents storage that is managed by an external CSI volume driver (Beta feature).

        :param driver: (experimental) Driver is the name of the driver to use for this volume. Required.
        :param volume_handle: (experimental) VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        :param controller_expand_secret_ref: (experimental) ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param controller_publish_secret_ref: (experimental) ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param node_publish_secret_ref: (experimental) NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param node_stage_secret_ref: (experimental) NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param read_only: (experimental) Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: (experimental) Attributes of the volume to publish.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource
        '''
        if isinstance(controller_expand_secret_ref, dict):
            controller_expand_secret_ref = SecretReference(**controller_expand_secret_ref)
        if isinstance(controller_publish_secret_ref, dict):
            controller_publish_secret_ref = SecretReference(**controller_publish_secret_ref)
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = SecretReference(**node_publish_secret_ref)
        if isinstance(node_stage_secret_ref, dict):
            node_stage_secret_ref = SecretReference(**node_stage_secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
            "volume_handle": volume_handle,
        }
        if controller_expand_secret_ref is not None:
            self._values["controller_expand_secret_ref"] = controller_expand_secret_ref
        if controller_publish_secret_ref is not None:
            self._values["controller_publish_secret_ref"] = controller_publish_secret_ref
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if node_stage_secret_ref is not None:
            self._values["node_stage_secret_ref"] = node_stage_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''(experimental) Driver is the name of the driver to use for this volume.

        Required.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume_handle(self) -> builtins.str:
        '''(experimental) VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls.

        Required.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeHandle
        '''
        result = self._values.get("volume_handle")
        assert result is not None, "Required property 'volume_handle' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def controller_expand_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call.

        This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerExpandSecretRef
        '''
        result = self._values.get("controller_expand_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def controller_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#controllerPublishSecretRef
        '''
        result = self._values.get("controller_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def node_stage_secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls.

        This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#nodeStageSecretRef
        '''
        result = self._values.get("node_stage_secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: The value to pass to ControllerPublishVolumeRequest.

        Defaults to false (read/write).

        :default: false (read/write).

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) Attributes of the volume to publish.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIPersistentVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "node_publish_secret_ref": "nodePublishSecretRef",
        "read_only": "readOnly",
        "volume_attributes": "volumeAttributes",
    },
)
class CsiVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        node_publish_secret_ref: typing.Optional["LocalObjectReference"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        volume_attributes: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''(experimental) Represents a source location of a volume to mount, managed by an external CSI driver.

        :param driver: (experimental) Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param fs_type: (experimental) Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param node_publish_secret_ref: (experimental) NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param read_only: (experimental) Specifies a read-only configuration for the volume. Defaults to false (read/write). Default: false (read/write).
        :param volume_attributes: (experimental) VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource
        '''
        if isinstance(node_publish_secret_ref, dict):
            node_publish_secret_ref = LocalObjectReference(**node_publish_secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if node_publish_secret_ref is not None:
            self._values["node_publish_secret_ref"] = node_publish_secret_ref
        if read_only is not None:
            self._values["read_only"] = read_only
        if volume_attributes is not None:
            self._values["volume_attributes"] = volume_attributes

    @builtins.property
    def driver(self) -> builtins.str:
        '''(experimental) Driver is the name of the CSI driver that handles this volume.

        Consult with your admin for the correct name as registered in the cluster.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_publish_secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''(experimental) NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls.

        This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource#nodePublishSecretRef
        '''
        result = self._values.get("node_publish_secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Specifies a read-only configuration for the volume.

        Defaults to false (read/write).

        :default: false (read/write).

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def volume_attributes(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) VolumeAttributes stores driver-specific properties that are passed to the CSI driver.

        Consult your driver's documentation for supported values.

        :stability: experimental
        :schema: io.k8s.api.core.v1.CSIVolumeSource#volumeAttributes
        '''
        result = self._values.get("volume_attributes")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceColumnDefinition",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "type": "type",
        "description": "description",
        "format": "format",
        "json_path": "jsonPath",
        "priority": "priority",
    },
)
class CustomResourceColumnDefinition:
    def __init__(
        self,
        *,
        name: builtins.str,
        type: builtins.str,
        description: typing.Optional[builtins.str] = None,
        format: typing.Optional[builtins.str] = None,
        json_path: typing.Optional[builtins.str] = None,
        priority: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''(experimental) CustomResourceColumnDefinition specifies a column for server side printing.

        :param name: (experimental) name is a human readable name for the column.
        :param type: (experimental) type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.
        :param description: (experimental) description is a human readable description of this column.
        :param format: (experimental) format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.
        :param json_path: (experimental) JSONPath is a simple JSON path, i.e. with array notation.
        :param priority: (experimental) priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "type": type,
        }
        if description is not None:
            self._values["description"] = description
        if format is not None:
            self._values["format"] = format
        if json_path is not None:
            self._values["json_path"] = json_path
        if priority is not None:
            self._values["priority"] = priority

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) name is a human readable name for the column.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''(experimental) type is an OpenAPI type definition for this column.

        See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#type
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''(experimental) description is a human readable description of this column.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''(experimental) format is an optional OpenAPI type definition for this column.

        The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for more.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def json_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) JSONPath is a simple JSON path, i.e. with array notation.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#JSONPath
        '''
        result = self._values.get("json_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        '''(experimental) priority is an integer defining the relative importance of this column compared to others.

        Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a higher priority.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceColumnDefinition#priority
        '''
        result = self._values.get("priority")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceColumnDefinition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceConversion",
    jsii_struct_bases=[],
    name_mapping={
        "strategy": "strategy",
        "conversion_review_versions": "conversionReviewVersions",
        "webhook_client_config": "webhookClientConfig",
    },
)
class CustomResourceConversion:
    def __init__(
        self,
        *,
        strategy: builtins.str,
        conversion_review_versions: typing.Optional[typing.Sequence[builtins.str]] = None,
        webhook_client_config: typing.Optional["WebhookClientConfig"] = None,
    ) -> None:
        '''(experimental) CustomResourceConversion describes how to convert different versions of a CR.

        :param strategy: (experimental) ``strategy`` specifies the conversion strategy. Allowed values are: - ``None``: The converter only change the apiVersion and would not touch any other field in the CR. - ``Webhook``: API Server will call to an external webhook to do the conversion. Additional information is needed for this option. This requires spec.preserveUnknownFields to be false.
        :param conversion_review_versions: (experimental) ConversionReviewVersions is an ordered list of preferred ``ConversionReview`` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, conversion will fail for this object. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Default to ``['v1beta1']``. Default: v1beta1']`.
        :param webhook_client_config: (experimental) ``webhookClientConfig`` is the instructions for how to call the webhook if strategy is ``Webhook``. This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion
        '''
        if isinstance(webhook_client_config, dict):
            webhook_client_config = WebhookClientConfig(**webhook_client_config)
        self._values: typing.Dict[str, typing.Any] = {
            "strategy": strategy,
        }
        if conversion_review_versions is not None:
            self._values["conversion_review_versions"] = conversion_review_versions
        if webhook_client_config is not None:
            self._values["webhook_client_config"] = webhook_client_config

    @builtins.property
    def strategy(self) -> builtins.str:
        '''(experimental) ``strategy`` specifies the conversion strategy.

        Allowed values are: - ``None``: The converter only change the apiVersion and would not touch any other field in the CR. - ``Webhook``: API Server will call to an external webhook to do the conversion. Additional information
        is needed for this option. This requires spec.preserveUnknownFields to be false.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#strategy
        '''
        result = self._values.get("strategy")
        assert result is not None, "Required property 'strategy' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def conversion_review_versions(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) ConversionReviewVersions is an ordered list of preferred ``ConversionReview`` versions the Webhook expects.

        API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, conversion will fail for this object. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Default to ``['v1beta1']``.

        :default: v1beta1']`.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#conversionReviewVersions
        '''
        result = self._values.get("conversion_review_versions")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def webhook_client_config(self) -> typing.Optional["WebhookClientConfig"]:
        '''(experimental) ``webhookClientConfig`` is the instructions for how to call the webhook if strategy is ``Webhook``.

        This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceConversion#webhookClientConfig
        '''
        result = self._values.get("webhook_client_config")
        return typing.cast(typing.Optional["WebhookClientConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceConversion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceDefinitionNames",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "plural": "plural",
        "categories": "categories",
        "list_kind": "listKind",
        "short_names": "shortNames",
        "singular": "singular",
    },
)
class CustomResourceDefinitionNames:
    def __init__(
        self,
        *,
        kind: builtins.str,
        plural: builtins.str,
        categories: typing.Optional[typing.Sequence[builtins.str]] = None,
        list_kind: typing.Optional[builtins.str] = None,
        short_names: typing.Optional[typing.Sequence[builtins.str]] = None,
        singular: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition.

        :param kind: (experimental) Kind is the serialized kind of the resource. It is normally CamelCase and singular.
        :param plural: (experimental) Plural is the plural name of the resource to serve. It must match the name of the CustomResourceDefinition-registration too: plural.group and it must be all lowercase.
        :param categories: (experimental) Categories is a list of grouped resources custom resources belong to (e.g. 'all').
        :param list_kind: (experimental) ListKind is the serialized kind of the list for this resource. Defaults to List. Default: kind>List.
        :param short_names: (experimental) ShortNames are short names for the resource. It must be all lowercase.
        :param singular: (experimental) Singular is the singular name of the resource. It must be all lowercase Defaults to lowercased Default: lowercased

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "kind": kind,
            "plural": plural,
        }
        if categories is not None:
            self._values["categories"] = categories
        if list_kind is not None:
            self._values["list_kind"] = list_kind
        if short_names is not None:
            self._values["short_names"] = short_names
        if singular is not None:
            self._values["singular"] = singular

    @builtins.property
    def kind(self) -> builtins.str:
        '''(experimental) Kind is the serialized kind of the resource.

        It is normally CamelCase and singular.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#kind
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def plural(self) -> builtins.str:
        '''(experimental) Plural is the plural name of the resource to serve.

        It must match the name of the CustomResourceDefinition-registration too: plural.group and it must be all lowercase.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#plural
        '''
        result = self._values.get("plural")
        assert result is not None, "Required property 'plural' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def categories(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Categories is a list of grouped resources custom resources belong to (e.g. 'all').

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#categories
        '''
        result = self._values.get("categories")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def list_kind(self) -> typing.Optional[builtins.str]:
        '''(experimental) ListKind is the serialized kind of the list for this resource.

        Defaults to List.

        :default: kind>List.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#listKind
        '''
        result = self._values.get("list_kind")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def short_names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) ShortNames are short names for the resource.

        It must be all lowercase.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#shortNames
        '''
        result = self._values.get("short_names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def singular(self) -> typing.Optional[builtins.str]:
        '''(experimental) Singular is the singular name of the resource.

        It must be all lowercase  Defaults to lowercased

        :default: lowercased

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionNames#singular
        '''
        result = self._values.get("singular")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionNames(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceDefinitionSpec",
    jsii_struct_bases=[],
    name_mapping={
        "group": "group",
        "names": "names",
        "scope": "scope",
        "additional_printer_columns": "additionalPrinterColumns",
        "conversion": "conversion",
        "preserve_unknown_fields": "preserveUnknownFields",
        "subresources": "subresources",
        "validation": "validation",
        "version": "version",
        "versions": "versions",
    },
)
class CustomResourceDefinitionSpec:
    def __init__(
        self,
        *,
        group: builtins.str,
        names: CustomResourceDefinitionNames,
        scope: builtins.str,
        additional_printer_columns: typing.Optional[typing.Sequence[CustomResourceColumnDefinition]] = None,
        conversion: typing.Optional[CustomResourceConversion] = None,
        preserve_unknown_fields: typing.Optional[builtins.bool] = None,
        subresources: typing.Optional["CustomResourceSubresources"] = None,
        validation: typing.Optional["CustomResourceValidation"] = None,
        version: typing.Optional[builtins.str] = None,
        versions: typing.Optional[typing.Sequence["CustomResourceDefinitionVersion"]] = None,
    ) -> None:
        '''(experimental) CustomResourceDefinitionSpec describes how a user wants their resource to appear.

        :param group: (experimental) Group is the group this resource belongs in.
        :param names: (experimental) Names are the names used to describe this custom resource.
        :param scope: (experimental) Scope indicates whether this resource is cluster or namespace scoped. Default is namespaced Default: namespaced
        :param additional_printer_columns: (experimental) AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive. Default: a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive.
        :param conversion: (experimental) ``conversion`` defines conversion settings for the CRD.
        :param preserve_unknown_fields: (experimental) preserveUnknownFields disables pruning of object fields which are not specified in the OpenAPI schema. apiVersion, kind, metadata and known fields inside metadata are always preserved. Defaults to true in v1beta and will default to false in v1. Default: true in v1beta and will default to false in v1.
        :param subresources: (experimental) Subresources describes the subresources for CustomResource Optional, the global subresources for all versions. Top-level and per-version subresources are mutually exclusive.
        :param validation: (experimental) Validation describes the validation methods for CustomResources Optional, the global validation schema for all versions. Top-level and per-version schemas are mutually exclusive.
        :param version: (experimental) Version is the version this resource belongs in Should be always first item in Versions field if provided. Optional, but at least one of Version or Versions must be set. Deprecated: Please use ``Versions``.
        :param versions: (experimental) Versions is the list of all supported versions for this resource. If Version field is provided, this field is optional. Validation: All versions must use the same validation schema for now. i.e., top level Validation field is applied to all of these versions. Order: The version name will be used to compute the order. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec
        '''
        if isinstance(names, dict):
            names = CustomResourceDefinitionNames(**names)
        if isinstance(conversion, dict):
            conversion = CustomResourceConversion(**conversion)
        if isinstance(subresources, dict):
            subresources = CustomResourceSubresources(**subresources)
        if isinstance(validation, dict):
            validation = CustomResourceValidation(**validation)
        self._values: typing.Dict[str, typing.Any] = {
            "group": group,
            "names": names,
            "scope": scope,
        }
        if additional_printer_columns is not None:
            self._values["additional_printer_columns"] = additional_printer_columns
        if conversion is not None:
            self._values["conversion"] = conversion
        if preserve_unknown_fields is not None:
            self._values["preserve_unknown_fields"] = preserve_unknown_fields
        if subresources is not None:
            self._values["subresources"] = subresources
        if validation is not None:
            self._values["validation"] = validation
        if version is not None:
            self._values["version"] = version
        if versions is not None:
            self._values["versions"] = versions

    @builtins.property
    def group(self) -> builtins.str:
        '''(experimental) Group is the group this resource belongs in.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#group
        '''
        result = self._values.get("group")
        assert result is not None, "Required property 'group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def names(self) -> CustomResourceDefinitionNames:
        '''(experimental) Names are the names used to describe this custom resource.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#names
        '''
        result = self._values.get("names")
        assert result is not None, "Required property 'names' is missing"
        return typing.cast(CustomResourceDefinitionNames, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''(experimental) Scope indicates whether this resource is cluster or namespace scoped.

        Default is namespaced

        :default: namespaced

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def additional_printer_columns(
        self,
    ) -> typing.Optional[typing.List[CustomResourceColumnDefinition]]:
        '''(experimental) AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive.

        :default: a created-at column. Optional, the global columns for all versions. Top-level and per-version columns are mutually exclusive.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#additionalPrinterColumns
        '''
        result = self._values.get("additional_printer_columns")
        return typing.cast(typing.Optional[typing.List[CustomResourceColumnDefinition]], result)

    @builtins.property
    def conversion(self) -> typing.Optional[CustomResourceConversion]:
        '''(experimental) ``conversion`` defines conversion settings for the CRD.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#conversion
        '''
        result = self._values.get("conversion")
        return typing.cast(typing.Optional[CustomResourceConversion], result)

    @builtins.property
    def preserve_unknown_fields(self) -> typing.Optional[builtins.bool]:
        '''(experimental) preserveUnknownFields disables pruning of object fields which are not specified in the OpenAPI schema.

        apiVersion, kind, metadata and known fields inside metadata are always preserved. Defaults to true in v1beta and will default to false in v1.

        :default: true in v1beta and will default to false in v1.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#preserveUnknownFields
        '''
        result = self._values.get("preserve_unknown_fields")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def subresources(self) -> typing.Optional["CustomResourceSubresources"]:
        '''(experimental) Subresources describes the subresources for CustomResource Optional, the global subresources for all versions.

        Top-level and per-version subresources are mutually exclusive.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#subresources
        '''
        result = self._values.get("subresources")
        return typing.cast(typing.Optional["CustomResourceSubresources"], result)

    @builtins.property
    def validation(self) -> typing.Optional["CustomResourceValidation"]:
        '''(experimental) Validation describes the validation methods for CustomResources Optional, the global validation schema for all versions.

        Top-level and per-version schemas are mutually exclusive.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#validation
        '''
        result = self._values.get("validation")
        return typing.cast(typing.Optional["CustomResourceValidation"], result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''(experimental) Version is the version this resource belongs in Should be always first item in Versions field if provided.

        Optional, but at least one of Version or Versions must be set. Deprecated: Please use ``Versions``.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#version
        '''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def versions(
        self,
    ) -> typing.Optional[typing.List["CustomResourceDefinitionVersion"]]:
        '''(experimental) Versions is the list of all supported versions for this resource.

        If Version field is provided, this field is optional. Validation: All versions must use the same validation schema for now. i.e., top level Validation field is applied to all of these versions. Order: The version name will be used to compute the order. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionSpec#versions
        '''
        result = self._values.get("versions")
        return typing.cast(typing.Optional[typing.List["CustomResourceDefinitionVersion"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceDefinitionVersion",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "served": "served",
        "storage": "storage",
        "additional_printer_columns": "additionalPrinterColumns",
        "schema": "schema",
        "subresources": "subresources",
    },
)
class CustomResourceDefinitionVersion:
    def __init__(
        self,
        *,
        name: builtins.str,
        served: builtins.bool,
        storage: builtins.bool,
        additional_printer_columns: typing.Optional[typing.Sequence[CustomResourceColumnDefinition]] = None,
        schema: typing.Optional["CustomResourceValidation"] = None,
        subresources: typing.Optional["CustomResourceSubresources"] = None,
    ) -> None:
        '''(experimental) CustomResourceDefinitionVersion describes a version for CRD.

        :param name: (experimental) Name is the version name, e.g. “v1”, “v2beta1”, etc.
        :param served: (experimental) Served is a flag enabling/disabling this version from being served via REST APIs.
        :param storage: (experimental) Storage flags the version as storage version. There must be exactly one flagged as storage version.
        :param additional_printer_columns: (experimental) AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null. Default: a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null
        :param schema: (experimental) Schema describes the schema for CustomResource used in validation, pruning, and defaulting. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.
        :param subresources: (experimental) Subresources describes the subresources for CustomResource Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion
        '''
        if isinstance(schema, dict):
            schema = CustomResourceValidation(**schema)
        if isinstance(subresources, dict):
            subresources = CustomResourceSubresources(**subresources)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "served": served,
            "storage": storage,
        }
        if additional_printer_columns is not None:
            self._values["additional_printer_columns"] = additional_printer_columns
        if schema is not None:
            self._values["schema"] = schema
        if subresources is not None:
            self._values["subresources"] = subresources

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name is the version name, e.g. “v1”, “v2beta1”, etc.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def served(self) -> builtins.bool:
        '''(experimental) Served is a flag enabling/disabling this version from being served via REST APIs.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#served
        '''
        result = self._values.get("served")
        assert result is not None, "Required property 'served' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def storage(self) -> builtins.bool:
        '''(experimental) Storage flags the version as storage version.

        There must be exactly one flagged as storage version.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#storage
        '''
        result = self._values.get("storage")
        assert result is not None, "Required property 'storage' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def additional_printer_columns(
        self,
    ) -> typing.Optional[typing.List[CustomResourceColumnDefinition]]:
        '''(experimental) AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null.

        :default: a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#additionalPrinterColumns
        '''
        result = self._values.get("additional_printer_columns")
        return typing.cast(typing.Optional[typing.List[CustomResourceColumnDefinition]], result)

    @builtins.property
    def schema(self) -> typing.Optional["CustomResourceValidation"]:
        '''(experimental) Schema describes the schema for CustomResource used in validation, pruning, and defaulting.

        Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional["CustomResourceValidation"], result)

    @builtins.property
    def subresources(self) -> typing.Optional["CustomResourceSubresources"]:
        '''(experimental) Subresources describes the subresources for CustomResource Top-level and per-version subresources are mutually exclusive.

        Per-version subresources must not all be set to identical values (top-level subresources should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionVersion#subresources
        '''
        result = self._values.get("subresources")
        return typing.cast(typing.Optional["CustomResourceSubresources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceDefinitionVersion(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceSubresourceScale",
    jsii_struct_bases=[],
    name_mapping={
        "spec_replicas_path": "specReplicasPath",
        "status_replicas_path": "statusReplicasPath",
        "label_selector_path": "labelSelectorPath",
    },
)
class CustomResourceSubresourceScale:
    def __init__(
        self,
        *,
        spec_replicas_path: builtins.str,
        status_replicas_path: builtins.str,
        label_selector_path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.

        :param spec_replicas_path: (experimental) SpecReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Spec.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .spec. If there is no value under the given path in the CustomResource, the /scale subresource will return an error on GET.
        :param status_replicas_path: (experimental) StatusReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. If there is no value under the given path in the CustomResource, the status replica value in the /scale subresource will default to 0.
        :param label_selector_path: (experimental) LabelSelectorPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Selector. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status or .spec. Must be set to work with HPA. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the CustomResource, the status label selector value in the /scale subresource will default to the empty string.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresourceScale
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "spec_replicas_path": spec_replicas_path,
            "status_replicas_path": status_replicas_path,
        }
        if label_selector_path is not None:
            self._values["label_selector_path"] = label_selector_path

    @builtins.property
    def spec_replicas_path(self) -> builtins.str:
        '''(experimental) SpecReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Spec.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .spec. If there is no value under the given path in the CustomResource, the /scale subresource will return an error on GET.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresourceScale#specReplicasPath
        '''
        result = self._values.get("spec_replicas_path")
        assert result is not None, "Required property 'spec_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def status_replicas_path(self) -> builtins.str:
        '''(experimental) StatusReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. If there is no value under the given path in the CustomResource, the status replica value in the /scale subresource will default to 0.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresourceScale#statusReplicasPath
        '''
        result = self._values.get("status_replicas_path")
        assert result is not None, "Required property 'status_replicas_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def label_selector_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) LabelSelectorPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Selector. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status or .spec. Must be set to work with HPA. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the CustomResource, the status label selector value in the /scale subresource will default to the empty string.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresourceScale#labelSelectorPath
        '''
        result = self._values.get("label_selector_path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresourceScale(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceSubresources",
    jsii_struct_bases=[],
    name_mapping={"scale": "scale", "status": "status"},
)
class CustomResourceSubresources:
    def __init__(
        self,
        *,
        scale: typing.Optional[CustomResourceSubresourceScale] = None,
        status: typing.Any = None,
    ) -> None:
        '''(experimental) CustomResourceSubresources defines the status and scale subresources for CustomResources.

        :param scale: (experimental) Scale denotes the scale subresource for CustomResources.
        :param status: (experimental) Status denotes the status subresource for CustomResources.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources
        '''
        if isinstance(scale, dict):
            scale = CustomResourceSubresourceScale(**scale)
        self._values: typing.Dict[str, typing.Any] = {}
        if scale is not None:
            self._values["scale"] = scale
        if status is not None:
            self._values["status"] = status

    @builtins.property
    def scale(self) -> typing.Optional[CustomResourceSubresourceScale]:
        '''(experimental) Scale denotes the scale subresource for CustomResources.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources#scale
        '''
        result = self._values.get("scale")
        return typing.cast(typing.Optional[CustomResourceSubresourceScale], result)

    @builtins.property
    def status(self) -> typing.Any:
        '''(experimental) Status denotes the status subresource for CustomResources.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceSubresources#status
        '''
        result = self._values.get("status")
        return typing.cast(typing.Any, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceSubresources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.CustomResourceValidation",
    jsii_struct_bases=[],
    name_mapping={"open_apiv3_schema": "openAPIV3Schema"},
)
class CustomResourceValidation:
    def __init__(
        self,
        *,
        open_apiv3_schema: typing.Optional["JsonSchemaProps"] = None,
    ) -> None:
        '''(experimental) CustomResourceValidation is a list of validation methods for CustomResources.

        :param open_apiv3_schema: (experimental) OpenAPIV3Schema is the OpenAPI v3 schema to be validated against.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceValidation
        '''
        if isinstance(open_apiv3_schema, dict):
            open_apiv3_schema = JsonSchemaProps(**open_apiv3_schema)
        self._values: typing.Dict[str, typing.Any] = {}
        if open_apiv3_schema is not None:
            self._values["open_apiv3_schema"] = open_apiv3_schema

    @builtins.property
    def open_apiv3_schema(self) -> typing.Optional["JsonSchemaProps"]:
        '''(experimental) OpenAPIV3Schema is the OpenAPI v3 schema to be validated against.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceValidation#openAPIV3Schema
        '''
        result = self._values.get("open_apiv3_schema")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomResourceValidation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DaemonSetSpec",
    jsii_struct_bases=[],
    name_mapping={
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "revision_history_limit": "revisionHistoryLimit",
        "selector": "selector",
        "template_generation": "templateGeneration",
        "update_strategy": "updateStrategy",
    },
)
class DaemonSetSpec:
    def __init__(
        self,
        *,
        template: "PodTemplateSpec",
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        selector: typing.Optional["LabelSelector"] = None,
        template_generation: typing.Optional[jsii.Number] = None,
        update_strategy: typing.Optional["DaemonSetUpdateStrategy"] = None,
    ) -> None:
        '''(experimental) DaemonSetSpec is the specification of a daemon set.

        :param template: (experimental) An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param min_ready_seconds: (experimental) The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready). Default: 0 (pod will be considered available as soon as it is ready).
        :param revision_history_limit: (experimental) The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param selector: (experimental) A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param template_generation: (experimental) DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.
        :param update_strategy: (experimental) An update strategy to replace existing DaemonSet pods with new pods.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec
        '''
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(update_strategy, dict):
            update_strategy = DaemonSetUpdateStrategy(**update_strategy)
        self._values: typing.Dict[str, typing.Any] = {
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if selector is not None:
            self._values["selector"] = selector
        if template_generation is not None:
            self._values["template_generation"] = template_generation
        if update_strategy is not None:
            self._values["update_strategy"] = update_strategy

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''(experimental) An object that describes the pod that will be created.

        The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready).

        :default: 0 (pod will be considered available as soon as it is ready).

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The number of old history to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def selector(self) -> typing.Optional["LabelSelector"]:
        '''(experimental) A label query over pods that are managed by the daemon set.

        Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["LabelSelector"], result)

    @builtins.property
    def template_generation(self) -> typing.Optional[jsii.Number]:
        '''(experimental) DEPRECATED.

        A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#templateGeneration
        '''
        result = self._values.get("template_generation")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def update_strategy(self) -> typing.Optional["DaemonSetUpdateStrategy"]:
        '''(experimental) An update strategy to replace existing DaemonSet pods with new pods.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetSpec#updateStrategy
        '''
        result = self._values.get("update_strategy")
        return typing.cast(typing.Optional["DaemonSetUpdateStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DaemonSetUpdateStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DaemonSetUpdateStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional["RollingUpdateDaemonSet"] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param rolling_update: (experimental) Rolling update config params. Present only if type = "RollingUpdate".
        :param type: (experimental) Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is OnDelete. Default: OnDelete.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetUpdateStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDaemonSet(**rolling_update)
        self._values: typing.Dict[str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDaemonSet"]:
        '''(experimental) Rolling update config params.

        Present only if type = "RollingUpdate".

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetUpdateStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDaemonSet"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Type of daemon set update.

        Can be "RollingUpdate" or "OnDelete". Default is OnDelete.

        :default: OnDelete.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetUpdateStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetUpdateStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DeleteOptions",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "dry_run": "dryRun",
        "grace_period_seconds": "gracePeriodSeconds",
        "kind": "kind",
        "orphan_dependents": "orphanDependents",
        "preconditions": "preconditions",
        "propagation_policy": "propagationPolicy",
    },
)
class DeleteOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        dry_run: typing.Optional[typing.Sequence[builtins.str]] = None,
        grace_period_seconds: typing.Optional[jsii.Number] = None,
        kind: typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"] = None,
        orphan_dependents: typing.Optional[builtins.bool] = None,
        preconditions: typing.Optional["Preconditions"] = None,
        propagation_policy: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) DeleteOptions may be provided when deleting an API object.

        :param api_version: (experimental) APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources
        :param dry_run: (experimental) When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
        :param grace_period_seconds: (experimental) The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately. Default: a per object value if not specified. zero means delete immediately.
        :param kind: (experimental) Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds
        :param orphan_dependents: (experimental) Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param preconditions: (experimental) Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.
        :param propagation_policy: (experimental) Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions
        '''
        if isinstance(preconditions, dict):
            preconditions = Preconditions(**preconditions)
        self._values: typing.Dict[str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if dry_run is not None:
            self._values["dry_run"] = dry_run
        if grace_period_seconds is not None:
            self._values["grace_period_seconds"] = grace_period_seconds
        if kind is not None:
            self._values["kind"] = kind
        if orphan_dependents is not None:
            self._values["orphan_dependents"] = orphan_dependents
        if preconditions is not None:
            self._values["preconditions"] = preconditions
        if propagation_policy is not None:
            self._values["propagation_policy"] = propagation_policy

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''(experimental) APIVersion defines the versioned schema of this representation of an object.

        Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#apiVersion
        '''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dry_run(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) When present, indicates that modifications should not be persisted.

        An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#dryRun
        '''
        result = self._values.get("dry_run")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def grace_period_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The duration in seconds before the object should be deleted.

        Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.

        :default: a per object value if not specified. zero means delete immediately.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#gracePeriodSeconds
        '''
        result = self._values.get("grace_period_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def kind(
        self,
    ) -> typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"]:
        '''(experimental) Kind is a string value representing the REST resource this object represents.

        Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#kind
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional["IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"], result)

    @builtins.property
    def orphan_dependents(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the "orphan" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#orphanDependents
        '''
        result = self._values.get("orphan_dependents")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def preconditions(self) -> typing.Optional["Preconditions"]:
        '''(experimental) Must be fulfilled before a deletion is carried out.

        If not possible, a 409 Conflict status will be returned.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#preconditions
        '''
        result = self._values.get("preconditions")
        return typing.cast(typing.Optional["Preconditions"], result)

    @builtins.property
    def propagation_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) Whether and how garbage collection will be performed.

        Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: 'Orphan' - orphan the dependents; 'Background' - allow the garbage collector to delete the dependents in the background; 'Foreground' - a cascading policy that deletes all dependents in the foreground.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions#propagationPolicy
        '''
        result = self._values.get("propagation_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeleteOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DeploymentSpec",
    jsii_struct_bases=[],
    name_mapping={
        "selector": "selector",
        "template": "template",
        "min_ready_seconds": "minReadySeconds",
        "paused": "paused",
        "progress_deadline_seconds": "progressDeadlineSeconds",
        "replicas": "replicas",
        "revision_history_limit": "revisionHistoryLimit",
        "strategy": "strategy",
    },
)
class DeploymentSpec:
    def __init__(
        self,
        *,
        selector: "LabelSelector",
        template: "PodTemplateSpec",
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        paused: typing.Optional[builtins.bool] = None,
        progress_deadline_seconds: typing.Optional[jsii.Number] = None,
        replicas: typing.Optional[jsii.Number] = None,
        revision_history_limit: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional["DeploymentStrategy"] = None,
    ) -> None:
        '''(experimental) DeploymentSpec is the specification of the desired behavior of the Deployment.

        :param selector: (experimental) Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param template: (experimental) Template describes the pods that will be created.
        :param min_ready_seconds: (experimental) Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready) Default: 0 (pod will be considered available as soon as it is ready)
        :param paused: (experimental) Indicates that the deployment is paused.
        :param progress_deadline_seconds: (experimental) The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s. Default: 600s.
        :param replicas: (experimental) Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1. Default: 1.
        :param revision_history_limit: (experimental) The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10. Default: 10.
        :param strategy: (experimental) The deployment strategy to use to replace existing pods with new ones.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec
        '''
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(strategy, dict):
            strategy = DeploymentStrategy(**strategy)
        self._values: typing.Dict[str, typing.Any] = {
            "selector": selector,
            "template": template,
        }
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds
        if paused is not None:
            self._values["paused"] = paused
        if progress_deadline_seconds is not None:
            self._values["progress_deadline_seconds"] = progress_deadline_seconds
        if replicas is not None:
            self._values["replicas"] = replicas
        if revision_history_limit is not None:
            self._values["revision_history_limit"] = revision_history_limit
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def selector(self) -> "LabelSelector":
        '''(experimental) Label selector for pods.

        Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#selector
        '''
        result = self._values.get("selector")
        assert result is not None, "Required property 'selector' is missing"
        return typing.cast("LabelSelector", result)

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''(experimental) Template describes the pods that will be created.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Defaults to 0 (pod will be considered available as soon as it is ready)

        :default: 0 (pod will be considered available as soon as it is ready)

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#minReadySeconds
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def paused(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates that the deployment is paused.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#paused
        '''
        result = self._values.get("paused")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def progress_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The maximum time in seconds for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.

        :default: 600s.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#progressDeadlineSeconds
        '''
        result = self._values.get("progress_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of desired pods.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.

        :default: 1.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#replicas
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def revision_history_limit(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The number of old ReplicaSets to retain to allow rollback.

        This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.

        :default: 10.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#revisionHistoryLimit
        '''
        result = self._values.get("revision_history_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional["DeploymentStrategy"]:
        '''(experimental) The deployment strategy to use to replace existing pods with new ones.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentSpec#strategy
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["DeploymentStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DeploymentStrategy",
    jsii_struct_bases=[],
    name_mapping={"rolling_update": "rollingUpdate", "type": "type"},
)
class DeploymentStrategy:
    def __init__(
        self,
        *,
        rolling_update: typing.Optional["RollingUpdateDeployment"] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) DeploymentStrategy describes how to replace existing pods with new ones.

        :param rolling_update: (experimental) Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param type: (experimental) Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate. Default: RollingUpdate.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentStrategy
        '''
        if isinstance(rolling_update, dict):
            rolling_update = RollingUpdateDeployment(**rolling_update)
        self._values: typing.Dict[str, typing.Any] = {}
        if rolling_update is not None:
            self._values["rolling_update"] = rolling_update
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def rolling_update(self) -> typing.Optional["RollingUpdateDeployment"]:
        '''(experimental) Rolling update config params.

        Present only if DeploymentStrategyType = RollingUpdate.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentStrategy#rollingUpdate
        '''
        result = self._values.get("rolling_update")
        return typing.cast(typing.Optional["RollingUpdateDeployment"], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Type of deployment.

        Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.

        :default: RollingUpdate.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentStrategy#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DownwardApiProjection",
    jsii_struct_bases=[],
    name_mapping={"items": "items"},
)
class DownwardApiProjection:
    def __init__(
        self,
        *,
        items: typing.Optional[typing.Sequence["DownwardApiVolumeFile"]] = None,
    ) -> None:
        '''(experimental) Represents downward API info for projecting into a projected volume.

        Note that this is identical to a downwardAPI volume source without the default mode.

        :param items: (experimental) Items is a list of DownwardAPIVolume file.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIProjection
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def items(self) -> typing.Optional[typing.List["DownwardApiVolumeFile"]]:
        '''(experimental) Items is a list of DownwardAPIVolume file.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIProjection#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List["DownwardApiVolumeFile"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiProjection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DownwardApiVolumeFile",
    jsii_struct_bases=[],
    name_mapping={
        "path": "path",
        "field_ref": "fieldRef",
        "mode": "mode",
        "resource_field_ref": "resourceFieldRef",
    },
)
class DownwardApiVolumeFile:
    def __init__(
        self,
        *,
        path: builtins.str,
        field_ref: typing.Optional["ObjectFieldSelector"] = None,
        mode: typing.Optional[jsii.Number] = None,
        resource_field_ref: typing.Optional["ResourceFieldSelector"] = None,
    ) -> None:
        '''(experimental) DownwardAPIVolumeFile represents information to create the file containing the pod field.

        :param path: (experimental) Required: Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param field_ref: (experimental) Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
        :param mode: (experimental) Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param resource_field_ref: (experimental) Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile
        '''
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "path": path,
        }
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if mode is not None:
            self._values["mode"] = mode
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) Required: Path is  the relative path name of the file to be created.

        Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''(experimental) Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional: mode bits to use on this file, must be a value between 0 and 0777.

        If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''(experimental) Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeFile#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeFile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.DownwardApiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"default_mode": "defaultMode", "items": "items"},
)
class DownwardApiVolumeSource:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Sequence[DownwardApiVolumeFile]] = None,
    ) -> None:
        '''(experimental) DownwardAPIVolumeSource represents a volume containing downward API info.

        Downward API volumes support ownership management and SELinux relabeling.

        :param default_mode: (experimental) Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: (experimental) Items is a list of downward API volume file.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional: mode bits to use on created files by default.

        Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#defaultMode
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.List[DownwardApiVolumeFile]]:
        '''(experimental) Items is a list of downward API volume file.

        :stability: experimental
        :schema: io.k8s.api.core.v1.DownwardAPIVolumeSource#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.List[DownwardApiVolumeFile]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DownwardApiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EmptyDirVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeSource:
    def __init__(
        self,
        *,
        medium: typing.Optional[builtins.str] = None,
        size_limit: typing.Optional["Quantity"] = None,
    ) -> None:
        '''(experimental) Represents an empty directory for a pod.

        Empty directory volumes support ownership management and SELinux relabeling.

        :param medium: (experimental) What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param size_limit: (experimental) Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir

        :stability: experimental
        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[builtins.str]:
        '''(experimental) What type of storage medium should back this directory.

        The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir

        :stability: experimental
        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#medium
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def size_limit(self) -> typing.Optional["Quantity"]:
        '''(experimental) Total amount of local storage required for this EmptyDir volume.

        The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir

        :stability: experimental
        :schema: io.k8s.api.core.v1.EmptyDirVolumeSource#sizeLimit
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional["Quantity"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EndpointAddress",
    jsii_struct_bases=[],
    name_mapping={
        "ip": "ip",
        "hostname": "hostname",
        "node_name": "nodeName",
        "target_ref": "targetRef",
    },
)
class EndpointAddress:
    def __init__(
        self,
        *,
        ip: builtins.str,
        hostname: typing.Optional[builtins.str] = None,
        node_name: typing.Optional[builtins.str] = None,
        target_ref: typing.Optional["ObjectReference"] = None,
    ) -> None:
        '''(experimental) EndpointAddress is a tuple that describes single IP address.

        :param ip: (experimental) The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.
        :param hostname: (experimental) The Hostname of this endpoint.
        :param node_name: (experimental) Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param target_ref: (experimental) Reference to object providing the endpoint.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointAddress
        '''
        if isinstance(target_ref, dict):
            target_ref = ObjectReference(**target_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "ip": ip,
        }
        if hostname is not None:
            self._values["hostname"] = hostname
        if node_name is not None:
            self._values["node_name"] = node_name
        if target_ref is not None:
            self._values["target_ref"] = target_ref

    @builtins.property
    def ip(self) -> builtins.str:
        '''(experimental) The IP of this endpoint.

        May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointAddress#ip
        '''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''(experimental) The Hostname of this endpoint.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointAddress#hostname
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional: Node hosting this endpoint.

        This can be used to determine endpoints local to a node.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointAddress#nodeName
        '''
        result = self._values.get("node_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_ref(self) -> typing.Optional["ObjectReference"]:
        '''(experimental) Reference to object providing the endpoint.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointAddress#targetRef
        '''
        result = self._values.get("target_ref")
        return typing.cast(typing.Optional["ObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointAddress(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EndpointPort",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "name": "name", "protocol": "protocol"},
)
class EndpointPort:
    def __init__(
        self,
        *,
        port: jsii.Number,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) EndpointPort is a tuple that describes a single port.

        :param port: (experimental) The port number of the endpoint.
        :param name: (experimental) The name of this port (corresponds to ServicePort.Name). Must be a DNS_LABEL. Optional only if one port is defined.
        :param protocol: (experimental) The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP. Default: TCP.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointPort
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def port(self) -> jsii.Number:
        '''(experimental) The port number of the endpoint.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointPort#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''(experimental) The name of this port (corresponds to ServicePort.Name). Must be a DNS_LABEL. Optional only if one port is defined.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointPort#name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional[builtins.str]:
        '''(experimental) The IP protocol for this port.

        Must be UDP, TCP, or SCTP. Default is TCP.

        :default: TCP.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointPort#protocol
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EndpointSubset",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "not_ready_addresses": "notReadyAddresses",
        "ports": "ports",
    },
)
class EndpointSubset:
    def __init__(
        self,
        *,
        addresses: typing.Optional[typing.Sequence[EndpointAddress]] = None,
        not_ready_addresses: typing.Optional[typing.Sequence[EndpointAddress]] = None,
        ports: typing.Optional[typing.Sequence[EndpointPort]] = None,
    ) -> None:
        '''(experimental) EndpointSubset is a group of addresses with a common set of ports.

        The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:
        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        }
        The resulting set of endpoints can be viewed as:
        a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
        b: [ 10.10.1.1:309, 10.10.2.2:309 ]

        :param addresses: (experimental) IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param not_ready_addresses: (experimental) IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param ports: (experimental) Port numbers available on the related IP addresses.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointSubset
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if addresses is not None:
            self._values["addresses"] = addresses
        if not_ready_addresses is not None:
            self._values["not_ready_addresses"] = not_ready_addresses
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''(experimental) IP addresses which offer the related ports that are marked as ready.

        These endpoints should be considered safe for load balancers and clients to utilize.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointSubset#addresses
        '''
        result = self._values.get("addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def not_ready_addresses(self) -> typing.Optional[typing.List[EndpointAddress]]:
        '''(experimental) IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointSubset#notReadyAddresses
        '''
        result = self._values.get("not_ready_addresses")
        return typing.cast(typing.Optional[typing.List[EndpointAddress]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[EndpointPort]]:
        '''(experimental) Port numbers available on the related IP addresses.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointSubset#ports
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[EndpointPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EndpointSubset(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EnvFromSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_ref": "configMapRef",
        "prefix": "prefix",
        "secret_ref": "secretRef",
    },
)
class EnvFromSource:
    def __init__(
        self,
        *,
        config_map_ref: typing.Optional[ConfigMapEnvSource] = None,
        prefix: typing.Optional[builtins.str] = None,
        secret_ref: typing.Optional["SecretEnvSource"] = None,
    ) -> None:
        '''(experimental) EnvFromSource represents the source of a set of ConfigMaps.

        :param config_map_ref: (experimental) The ConfigMap to select from.
        :param prefix: (experimental) An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param secret_ref: (experimental) The Secret to select from.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvFromSource
        '''
        if isinstance(config_map_ref, dict):
            config_map_ref = ConfigMapEnvSource(**config_map_ref)
        if isinstance(secret_ref, dict):
            secret_ref = SecretEnvSource(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {}
        if config_map_ref is not None:
            self._values["config_map_ref"] = config_map_ref
        if prefix is not None:
            self._values["prefix"] = prefix
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def config_map_ref(self) -> typing.Optional[ConfigMapEnvSource]:
        '''(experimental) The ConfigMap to select from.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvFromSource#configMapRef
        '''
        result = self._values.get("config_map_ref")
        return typing.cast(typing.Optional[ConfigMapEnvSource], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional identifier to prepend to each key in the ConfigMap.

        Must be a C_IDENTIFIER.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvFromSource#prefix
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretEnvSource"]:
        '''(experimental) The Secret to select from.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvFromSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretEnvSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvFromSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EnvVar",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value", "value_from": "valueFrom"},
)
class EnvVar:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
        value_from: typing.Optional["EnvVarSource"] = None,
    ) -> None:
        '''(experimental) EnvVar represents an environment variable present in a Container.

        :param name: (experimental) Name of the environment variable. Must be a C_IDENTIFIER.
        :param value: (experimental) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". Default: .
        :param value_from: (experimental) Source for the environment variable's value. Cannot be used if value is not empty.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVar
        '''
        if isinstance(value_from, dict):
            value_from = EnvVarSource(**value_from)
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value
        if value_from is not None:
            self._values["value_from"] = value_from

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) Name of the environment variable.

        Must be a C_IDENTIFIER.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVar#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''(experimental) Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables.

        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".

        :default: .

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVar#value
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def value_from(self) -> typing.Optional["EnvVarSource"]:
        '''(experimental) Source for the environment variable's value.

        Cannot be used if value is not empty.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVar#valueFrom
        '''
        result = self._values.get("value_from")
        return typing.cast(typing.Optional["EnvVarSource"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVar(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EnvVarSource",
    jsii_struct_bases=[],
    name_mapping={
        "config_map_key_ref": "configMapKeyRef",
        "field_ref": "fieldRef",
        "resource_field_ref": "resourceFieldRef",
        "secret_key_ref": "secretKeyRef",
    },
)
class EnvVarSource:
    def __init__(
        self,
        *,
        config_map_key_ref: typing.Optional[ConfigMapKeySelector] = None,
        field_ref: typing.Optional["ObjectFieldSelector"] = None,
        resource_field_ref: typing.Optional["ResourceFieldSelector"] = None,
        secret_key_ref: typing.Optional["SecretKeySelector"] = None,
    ) -> None:
        '''(experimental) EnvVarSource represents a source for the value of an EnvVar.

        :param config_map_key_ref: (experimental) Selects a key of a ConfigMap.
        :param field_ref: (experimental) Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.
        :param resource_field_ref: (experimental) Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param secret_key_ref: (experimental) Selects a key of a secret in the pod's namespace.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVarSource
        '''
        if isinstance(config_map_key_ref, dict):
            config_map_key_ref = ConfigMapKeySelector(**config_map_key_ref)
        if isinstance(field_ref, dict):
            field_ref = ObjectFieldSelector(**field_ref)
        if isinstance(resource_field_ref, dict):
            resource_field_ref = ResourceFieldSelector(**resource_field_ref)
        if isinstance(secret_key_ref, dict):
            secret_key_ref = SecretKeySelector(**secret_key_ref)
        self._values: typing.Dict[str, typing.Any] = {}
        if config_map_key_ref is not None:
            self._values["config_map_key_ref"] = config_map_key_ref
        if field_ref is not None:
            self._values["field_ref"] = field_ref
        if resource_field_ref is not None:
            self._values["resource_field_ref"] = resource_field_ref
        if secret_key_ref is not None:
            self._values["secret_key_ref"] = secret_key_ref

    @builtins.property
    def config_map_key_ref(self) -> typing.Optional[ConfigMapKeySelector]:
        '''(experimental) Selects a key of a ConfigMap.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVarSource#configMapKeyRef
        '''
        result = self._values.get("config_map_key_ref")
        return typing.cast(typing.Optional[ConfigMapKeySelector], result)

    @builtins.property
    def field_ref(self) -> typing.Optional["ObjectFieldSelector"]:
        '''(experimental) Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVarSource#fieldRef
        '''
        result = self._values.get("field_ref")
        return typing.cast(typing.Optional["ObjectFieldSelector"], result)

    @builtins.property
    def resource_field_ref(self) -> typing.Optional["ResourceFieldSelector"]:
        '''(experimental) Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVarSource#resourceFieldRef
        '''
        result = self._values.get("resource_field_ref")
        return typing.cast(typing.Optional["ResourceFieldSelector"], result)

    @builtins.property
    def secret_key_ref(self) -> typing.Optional["SecretKeySelector"]:
        '''(experimental) Selects a key of a secret in the pod's namespace.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EnvVarSource#secretKeyRef
        '''
        result = self._values.get("secret_key_ref")
        return typing.cast(typing.Optional["SecretKeySelector"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvVarSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EventSeries",
    jsii_struct_bases=[],
    name_mapping={
        "count": "count",
        "last_observed_time": "lastObservedTime",
        "state": "state",
    },
)
class EventSeries:
    def __init__(
        self,
        *,
        count: jsii.Number,
        last_observed_time: datetime.datetime,
        state: builtins.str,
    ) -> None:
        '''(experimental) EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.

        :param count: (experimental) Number of occurrences in this series up to the last heartbeat time.
        :param last_observed_time: (experimental) Time when last Event from the series was seen before last heartbeat.
        :param state: (experimental) Information whether this series is ongoing or finished. Deprecated. Planned removal for 1.18

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventSeries
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "count": count,
            "last_observed_time": last_observed_time,
            "state": state,
        }

    @builtins.property
    def count(self) -> jsii.Number:
        '''(experimental) Number of occurrences in this series up to the last heartbeat time.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventSeries#count
        '''
        result = self._values.get("count")
        assert result is not None, "Required property 'count' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def last_observed_time(self) -> datetime.datetime:
        '''(experimental) Time when last Event from the series was seen before last heartbeat.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventSeries#lastObservedTime
        '''
        result = self._values.get("last_observed_time")
        assert result is not None, "Required property 'last_observed_time' is missing"
        return typing.cast(datetime.datetime, result)

    @builtins.property
    def state(self) -> builtins.str:
        '''(experimental) Information whether this series is ongoing or finished.

        Deprecated. Planned removal for 1.18

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventSeries#state
        '''
        result = self._values.get("state")
        assert result is not None, "Required property 'state' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSeries(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.EventSource",
    jsii_struct_bases=[],
    name_mapping={"component": "component", "host": "host"},
)
class EventSource:
    def __init__(
        self,
        *,
        component: typing.Optional[builtins.str] = None,
        host: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) EventSource contains information for an event.

        :param component: (experimental) Component from which the event is generated.
        :param host: (experimental) Node name on which the event is generated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if component is not None:
            self._values["component"] = component
        if host is not None:
            self._values["host"] = host

    @builtins.property
    def component(self) -> typing.Optional[builtins.str]:
        '''(experimental) Component from which the event is generated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventSource#component
        '''
        result = self._values.get("component")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''(experimental) Node name on which the event is generated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventSource#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EventSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ExecAction",
    jsii_struct_bases=[],
    name_mapping={"command": "command"},
)
class ExecAction:
    def __init__(
        self,
        *,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) ExecAction describes a "run in container" action.

        :param command: (experimental) Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ExecAction
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if command is not None:
            self._values["command"] = command

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem.

        The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ExecAction#command
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExecAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ExternalDocumentation",
    jsii_struct_bases=[],
    name_mapping={"description": "description", "url": "url"},
)
class ExternalDocumentation:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) ExternalDocumentation allows referencing an external resource for extended documentation.

        :param description: 
        :param url: 

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.ExternalDocumentation
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if url is not None:
            self._values["url"] = url

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.ExternalDocumentation#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.ExternalDocumentation#url
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalDocumentation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.ExternalMetricSource",
    jsii_struct_bases=[],
    name_mapping={"metric": "metric", "target": "target"},
)
class ExternalMetricSource:
    def __init__(self, *, metric: "MetricIdentifier", target: "MetricTarget") -> None:
        '''(experimental) ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).

        :param metric: (experimental) metric identifies the target metric by name and selector.
        :param target: (experimental) target specifies the target value for the given metric.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource
        '''
        if isinstance(metric, dict):
            metric = MetricIdentifier(**metric)
        if isinstance(target, dict):
            target = MetricTarget(**target)
        self._values: typing.Dict[str, typing.Any] = {
            "metric": metric,
            "target": target,
        }

    @builtins.property
    def metric(self) -> "MetricIdentifier":
        '''(experimental) metric identifies the target metric by name and selector.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource#metric
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast("MetricIdentifier", result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''(experimental) target specifies the target value for the given metric.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.ExternalMetricSource#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExternalMetricSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.FcVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "lun": "lun",
        "read_only": "readOnly",
        "target_ww_ns": "targetWWNs",
        "wwids": "wwids",
    },
)
class FcVolumeSource:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        lun: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        target_ww_ns: typing.Optional[typing.Sequence[builtins.str]] = None,
        wwids: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) Represents a Fibre Channel volume.

        Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.

        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param lun: (experimental) Optional: FC target lun number.
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param target_ww_ns: (experimental) Optional: FC target worldwide names (WWNs).
        :param wwids: (experimental) Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if lun is not None:
            self._values["lun"] = lun
        if read_only is not None:
            self._values["read_only"] = read_only
        if target_ww_ns is not None:
            self._values["target_ww_ns"] = target_ww_ns
        if wwids is not None:
            self._values["wwids"] = wwids

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lun(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional: FC target lun number.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource#lun
        '''
        result = self._values.get("lun")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def target_ww_ns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Optional: FC target worldwide names (WWNs).

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource#targetWWNs
        '''
        result = self._values.get("target_ww_ns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def wwids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FCVolumeSource#wwids
        '''
        result = self._values.get("wwids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FcVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.FlexPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexPersistentVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["SecretReference"] = None,
    ) -> None:
        '''(experimental) FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.

        :param driver: (experimental) Driver is the name of the driver to use for this volume.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: (experimental) Optional: Extra command options if any.
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: (experimental) Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''(experimental) Driver is the name of the driver to use for this volume.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) Optional: Extra command options if any.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.FlexVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "driver": "driver",
        "fs_type": "fsType",
        "options": "options",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class FlexVolumeSource:
    def __init__(
        self,
        *,
        driver: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        options: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["LocalObjectReference"] = None,
    ) -> None:
        '''(experimental) FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.

        :param driver: (experimental) Driver is the name of the driver to use for this volume.
        :param fs_type: (experimental) Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param options: (experimental) Optional: Extra command options if any.
        :param read_only: (experimental) Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. Default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param secret_ref: (experimental) Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "driver": driver,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if options is not None:
            self._values["options"] = options
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def driver(self) -> builtins.str:
        '''(experimental) Driver is the name of the driver to use for this volume.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource#driver
        '''
        result = self._values.get("driver")
        assert result is not None, "Required property 'driver' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type to mount.

        Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) Optional: Extra command options if any.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource#options
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Optional: Defaults to false (read/write).

        ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :default: false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''(experimental) Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts.

        This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlexVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlexVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.FlockerVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"dataset_name": "datasetName", "dataset_uuid": "datasetUUID"},
)
class FlockerVolumeSource:
    def __init__(
        self,
        *,
        dataset_name: typing.Optional[builtins.str] = None,
        dataset_uuid: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Represents a Flocker volume mounted by the Flocker agent.

        One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.

        :param dataset_name: (experimental) Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.
        :param dataset_uuid: (experimental) UUID of the dataset. This is unique identifier of a Flocker dataset

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlockerVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if dataset_name is not None:
            self._values["dataset_name"] = dataset_name
        if dataset_uuid is not None:
            self._values["dataset_uuid"] = dataset_uuid

    @builtins.property
    def dataset_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated.

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetName
        '''
        result = self._values.get("dataset_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dataset_uuid(self) -> typing.Optional[builtins.str]:
        '''(experimental) UUID of the dataset.

        This is unique identifier of a Flocker dataset

        :stability: experimental
        :schema: io.k8s.api.core.v1.FlockerVolumeSource#datasetUUID
        '''
        result = self._values.get("dataset_uuid")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FlockerVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.FsGroupStrategyOptions",
    jsii_struct_bases=[],
    name_mapping={"ranges": "ranges", "rule": "rule"},
)
class FsGroupStrategyOptions:
    def __init__(
        self,
        *,
        ranges: typing.Optional[typing.Sequence["IdRange"]] = None,
        rule: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) FSGroupStrategyOptions defines the strategy type and options used to create the strategy.

        :param ranges: (experimental) ranges are the allowed ranges of fs groups. If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        :param rule: (experimental) rule is the strategy that will dictate what FSGroup is used in the SecurityContext.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if ranges is not None:
            self._values["ranges"] = ranges
        if rule is not None:
            self._values["rule"] = rule

    @builtins.property
    def ranges(self) -> typing.Optional[typing.List["IdRange"]]:
        '''(experimental) ranges are the allowed ranges of fs groups.

        If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#ranges
        '''
        result = self._values.get("ranges")
        return typing.cast(typing.Optional[typing.List["IdRange"]], result)

    @builtins.property
    def rule(self) -> typing.Optional[builtins.str]:
        '''(experimental) rule is the strategy that will dictate what FSGroup is used in the SecurityContext.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions#rule
        '''
        result = self._values.get("rule")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FsGroupStrategyOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.GcePersistentDiskVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GcePersistentDiskVolumeSource:
    def __init__(
        self,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.

        :param pd_name: (experimental) Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param fs_type: (experimental) Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param partition: (experimental) The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param read_only: (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk Default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :stability: experimental
        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "pd_name": pd_name,
        }
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''(experimental) Unique name of the PD resource in GCE.

        Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :stability: experimental
        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#pdName
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :stability: experimental
        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :stability: experimental
        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#partition
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :default: false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk

        :stability: experimental
        :schema: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GcePersistentDiskVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.GitRepoVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "repository": "repository",
        "directory": "directory",
        "revision": "revision",
    },
)
class GitRepoVolumeSource:
    def __init__(
        self,
        *,
        repository: builtins.str,
        directory: typing.Optional[builtins.str] = None,
        revision: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Represents a volume that is populated with the contents of a git repository.

        Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.

        :param repository: (experimental) Repository URL.
        :param directory: (experimental) Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param revision: (experimental) Commit hash for the specified revision.

        :stability: experimental
        :schema: io.k8s.api.core.v1.GitRepoVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "repository": repository,
        }
        if directory is not None:
            self._values["directory"] = directory
        if revision is not None:
            self._values["revision"] = revision

    @builtins.property
    def repository(self) -> builtins.str:
        '''(experimental) Repository URL.

        :stability: experimental
        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#repository
        '''
        result = self._values.get("repository")
        assert result is not None, "Required property 'repository' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def directory(self) -> typing.Optional[builtins.str]:
        '''(experimental) Target directory name.

        Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#directory
        '''
        result = self._values.get("directory")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def revision(self) -> typing.Optional[builtins.str]:
        '''(experimental) Commit hash for the specified revision.

        :stability: experimental
        :schema: io.k8s.api.core.v1.GitRepoVolumeSource#revision
        '''
        result = self._values.get("revision")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GitRepoVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.GlusterfsPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "endpoints": "endpoints",
        "path": "path",
        "endpoints_namespace": "endpointsNamespace",
        "read_only": "readOnly",
    },
)
class GlusterfsPersistentVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        endpoints_namespace: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: (experimental) EndpointsName is the endpoint name that details Glusterfs topology. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
        :param path: (experimental) Path is the Glusterfs volume path. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
        :param endpoints_namespace: (experimental) EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
        :param read_only: (experimental) ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if endpoints_namespace is not None:
            self._values["endpoints_namespace"] = endpoints_namespace
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''(experimental) EndpointsName is the endpoint name that details Glusterfs topology.

        More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) Path is the Glusterfs volume path.

        More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoints_namespace(self) -> typing.Optional[builtins.str]:
        '''(experimental) EndpointsNamespace is the namespace that contains Glusterfs endpoint.

        If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#endpointsNamespace
        '''
        result = self._values.get("endpoints_namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.GlusterfsVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "path": "path", "read_only": "readOnly"},
)
class GlusterfsVolumeSource:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Represents a Glusterfs mount that lasts the lifetime of a pod.

        Glusterfs volumes do not support ownership management or SELinux relabeling.

        :param endpoints: (experimental) EndpointsName is the endpoint name that details Glusterfs topology. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
        :param path: (experimental) Path is the Glusterfs volume path. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
        :param read_only: (experimental) ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod Default: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''(experimental) EndpointsName is the endpoint name that details Glusterfs topology.

        More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#endpoints
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) Path is the Glusterfs volume path.

        More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions.

        Defaults to false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :default: false. More info: https://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod

        :stability: experimental
        :schema: io.k8s.api.core.v1.GlusterfsVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlusterfsVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Handler",
    jsii_struct_bases=[],
    name_mapping={"exec": "exec", "http_get": "httpGet", "tcp_socket": "tcpSocket"},
)
class Handler:
    def __init__(
        self,
        *,
        exec: typing.Optional[ExecAction] = None,
        http_get: typing.Optional["HttpGetAction"] = None,
        tcp_socket: typing.Optional["TcpSocketAction"] = None,
    ) -> None:
        '''(experimental) Handler defines a specific action that should be taken.

        :param exec: (experimental) One and only one of the following should be specified. Exec specifies the action to take.
        :param http_get: (experimental) HTTPGet specifies the http request to perform.
        :param tcp_socket: (experimental) TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported

        :stability: experimental
        :schema: io.k8s.api.core.v1.Handler
        '''
        if isinstance(exec, dict):
            exec = ExecAction(**exec)
        if isinstance(http_get, dict):
            http_get = HttpGetAction(**http_get)
        if isinstance(tcp_socket, dict):
            tcp_socket = TcpSocketAction(**tcp_socket)
        self._values: typing.Dict[str, typing.Any] = {}
        if exec is not None:
            self._values["exec"] = exec
        if http_get is not None:
            self._values["http_get"] = http_get
        if tcp_socket is not None:
            self._values["tcp_socket"] = tcp_socket

    @builtins.property
    def exec(self) -> typing.Optional[ExecAction]:
        '''(experimental) One and only one of the following should be specified.

        Exec specifies the action to take.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Handler#exec
        '''
        result = self._values.get("exec")
        return typing.cast(typing.Optional[ExecAction], result)

    @builtins.property
    def http_get(self) -> typing.Optional["HttpGetAction"]:
        '''(experimental) HTTPGet specifies the http request to perform.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Handler#httpGet
        '''
        result = self._values.get("http_get")
        return typing.cast(typing.Optional["HttpGetAction"], result)

    @builtins.property
    def tcp_socket(self) -> typing.Optional["TcpSocketAction"]:
        '''(experimental) TCPSocket specifies an action involving a TCP port.

        TCP hooks not yet supported

        :stability: experimental
        :schema: io.k8s.api.core.v1.Handler#tcpSocket
        '''
        result = self._values.get("tcp_socket")
        return typing.cast(typing.Optional["TcpSocketAction"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Handler(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HorizontalPodAutoscalerSpec",
    jsii_struct_bases=[],
    name_mapping={
        "max_replicas": "maxReplicas",
        "scale_target_ref": "scaleTargetRef",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
    },
)
class HorizontalPodAutoscalerSpec:
    def __init__(
        self,
        *,
        max_replicas: jsii.Number,
        scale_target_ref: CrossVersionObjectReference,
        metrics: typing.Optional[typing.Sequence["MetricSpec"]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''(experimental) HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.

        :param max_replicas: (experimental) maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param scale_target_ref: (experimental) scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param metrics: (experimental) metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used). The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods. Ergo, metrics used must decrease as the pod count is increased, and vice-versa. See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param min_replicas: (experimental) minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec
        '''
        if isinstance(scale_target_ref, dict):
            scale_target_ref = CrossVersionObjectReference(**scale_target_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "max_replicas": max_replicas,
            "scale_target_ref": scale_target_ref,
        }
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''(experimental) maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up.

        It cannot be less that minReplicas.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#maxReplicas
        '''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scale_target_ref(self) -> CrossVersionObjectReference:
        '''(experimental) scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#scaleTargetRef
        '''
        result = self._values.get("scale_target_ref")
        assert result is not None, "Required property 'scale_target_ref' is missing"
        return typing.cast(CrossVersionObjectReference, result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List["MetricSpec"]]:
        '''(experimental) metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).

        The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#metrics
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List["MetricSpec"]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''(experimental) minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.

        It defaults to 1 pod.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec#minReplicas
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Optional[typing.Sequence[builtins.str]] = None,
        ip: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :param hostnames: (experimental) Hostnames for the above IP address.
        :param ip: (experimental) IP address of the host file entry.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostAlias
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if hostnames is not None:
            self._values["hostnames"] = hostnames
        if ip is not None:
            self._values["ip"] = ip

    @builtins.property
    def hostnames(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Hostnames for the above IP address.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostAlias#hostnames
        '''
        result = self._values.get("hostnames")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ip(self) -> typing.Optional[builtins.str]:
        '''(experimental) IP address of the host file entry.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostAlias#ip
        '''
        result = self._values.get("ip")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HostPathVolumeSource",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeSource:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Represents a host path mapped into a pod.

        Host path volumes do not support ownership management or SELinux relabeling.

        :param path: (experimental) Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param type: (experimental) Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath. Default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostPathVolumeSource
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) Path of the directory on the host.

        If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostPathVolumeSource#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath.

        :default: More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath

        :stability: experimental
        :schema: io.k8s.api.core.v1.HostPathVolumeSource#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HostPortRange",
    jsii_struct_bases=[],
    name_mapping={"max": "max", "min": "min"},
)
class HostPortRange:
    def __init__(self, *, max: jsii.Number, min: jsii.Number) -> None:
        '''(experimental) HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.

        It requires both the start and end to be defined.

        :param max: (experimental) max is the end of the range, inclusive.
        :param min: (experimental) min is the start of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.HostPortRange
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max": max,
            "min": min,
        }

    @builtins.property
    def max(self) -> jsii.Number:
        '''(experimental) max is the end of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.HostPortRange#max
        '''
        result = self._values.get("max")
        assert result is not None, "Required property 'max' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def min(self) -> jsii.Number:
        '''(experimental) min is the start of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.HostPortRange#min
        '''
        result = self._values.get("min")
        assert result is not None, "Required property 'min' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPortRange(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HttpGetAction",
    jsii_struct_bases=[],
    name_mapping={
        "port": "port",
        "host": "host",
        "http_headers": "httpHeaders",
        "path": "path",
        "scheme": "scheme",
    },
)
class HttpGetAction:
    def __init__(
        self,
        *,
        port: "IntOrString",
        host: typing.Optional[builtins.str] = None,
        http_headers: typing.Optional[typing.Sequence["HttpHeader"]] = None,
        path: typing.Optional[builtins.str] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) HTTPGetAction describes an action based on HTTP Get requests.

        :param port: (experimental) Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param host: (experimental) Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param http_headers: (experimental) Custom headers to set in the request. HTTP allows repeated headers.
        :param path: (experimental) Path to access on the HTTP server.
        :param scheme: (experimental) Scheme to use for connecting to the host. Defaults to HTTP. Default: HTTP.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "port": port,
        }
        if host is not None:
            self._values["host"] = host
        if http_headers is not None:
            self._values["http_headers"] = http_headers
        if path is not None:
            self._values["path"] = path
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def port(self) -> "IntOrString":
        '''(experimental) Name or number of the port to access on the container.

        Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction#port
        '''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast("IntOrString", result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''(experimental) Host name to connect to, defaults to the pod IP.

        You probably want to set "Host" in httpHeaders instead.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http_headers(self) -> typing.Optional[typing.List["HttpHeader"]]:
        '''(experimental) Custom headers to set in the request.

        HTTP allows repeated headers.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction#httpHeaders
        '''
        result = self._values.get("http_headers")
        return typing.cast(typing.Optional[typing.List["HttpHeader"]], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Path to access on the HTTP server.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''(experimental) Scheme to use for connecting to the host.

        Defaults to HTTP.

        :default: HTTP.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPGetAction#scheme
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HttpHeader",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class HttpHeader:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''(experimental) HTTPHeader describes a custom header to be used in HTTP probes.

        :param name: (experimental) The header field name.
        :param value: (experimental) The header field value.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPHeader
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) The header field name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPHeader#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''(experimental) The header field value.

        :stability: experimental
        :schema: io.k8s.api.core.v1.HTTPHeader#value
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HttpIngressPath",
    jsii_struct_bases=[],
    name_mapping={"backend": "backend", "path": "path"},
)
class HttpIngressPath:
    def __init__(
        self,
        *,
        backend: "IngressBackend",
        path: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) HTTPIngressPath associates a path regex with a backend.

        Incoming urls matching the path are forwarded to the backend.

        :param backend: (experimental) Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param path: (experimental) Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.HTTPIngressPath
        '''
        if isinstance(backend, dict):
            backend = IngressBackend(**backend)
        self._values: typing.Dict[str, typing.Any] = {
            "backend": backend,
        }
        if path is not None:
            self._values["path"] = path

    @builtins.property
    def backend(self) -> "IngressBackend":
        '''(experimental) Backend defines the referenced service endpoint to which the traffic will be forwarded to.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.HTTPIngressPath#backend
        '''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast("IngressBackend", result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.HTTPIngressPath#path
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.HttpIngressRuleValue",
    jsii_struct_bases=[],
    name_mapping={"paths": "paths"},
)
class HttpIngressRuleValue:
    def __init__(self, *, paths: typing.Sequence[HttpIngressPath]) -> None:
        '''(experimental) HTTPIngressRuleValue is a list of http selectors pointing to backends.

        In the example: http:///? -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.

        :param paths: (experimental) A collection of paths that map requests to backends.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.HTTPIngressRuleValue
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "paths": paths,
        }

    @builtins.property
    def paths(self) -> typing.List[HttpIngressPath]:
        '''(experimental) A collection of paths that map requests to backends.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.HTTPIngressRuleValue#paths
        '''
        result = self._values.get("paths")
        assert result is not None, "Required property 'paths' is missing"
        return typing.cast(typing.List[HttpIngressPath], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpIngressRuleValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IdRange",
    jsii_struct_bases=[],
    name_mapping={"max": "max", "min": "min"},
)
class IdRange:
    def __init__(self, *, max: jsii.Number, min: jsii.Number) -> None:
        '''(experimental) IDRange provides a min/max of an allowed range of IDs.

        :param max: (experimental) max is the end of the range, inclusive.
        :param min: (experimental) min is the start of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.IDRange
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max": max,
            "min": min,
        }

    @builtins.property
    def max(self) -> jsii.Number:
        '''(experimental) max is the end of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.IDRange#max
        '''
        result = self._values.get("max")
        assert result is not None, "Required property 'max' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def min(self) -> jsii.Number:
        '''(experimental) min is the start of the range, inclusive.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.IDRange#min
        '''
        result = self._values.get("min")
        assert result is not None, "Required property 'min' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IdRange(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IngressBackend",
    jsii_struct_bases=[],
    name_mapping={"service_name": "serviceName", "service_port": "servicePort"},
)
class IngressBackend:
    def __init__(
        self,
        *,
        service_name: builtins.str,
        service_port: "IntOrString",
    ) -> None:
        '''(experimental) IngressBackend describes all endpoints for a given service and port.

        :param service_name: (experimental) Specifies the name of the referenced service.
        :param service_port: (experimental) Specifies the port of the referenced service.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressBackend
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "service_name": service_name,
            "service_port": service_port,
        }

    @builtins.property
    def service_name(self) -> builtins.str:
        '''(experimental) Specifies the name of the referenced service.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressBackend#serviceName
        '''
        result = self._values.get("service_name")
        assert result is not None, "Required property 'service_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def service_port(self) -> "IntOrString":
        '''(experimental) Specifies the port of the referenced service.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressBackend#servicePort
        '''
        result = self._values.get("service_port")
        assert result is not None, "Required property 'service_port' is missing"
        return typing.cast("IntOrString", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IngressRule",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "http": "http"},
)
class IngressRule:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        http: typing.Optional[HttpIngressRuleValue] = None,
    ) -> None:
        '''(experimental) IngressRule represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.

        :param host: (experimental) Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        :param http: 

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressRule
        '''
        if isinstance(http, dict):
            http = HttpIngressRuleValue(**http)
        self._values: typing.Dict[str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if http is not None:
            self._values["http"] = http

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''(experimental) Host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the
        IP in the Spec of the parent Ingress.
        2. The ``:`` delimiter is not respected because ports are not allowed.
        Currently the port of an Ingress is implicitly :80 for http and
        :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressRule#host
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def http(self) -> typing.Optional[HttpIngressRuleValue]:
        '''
        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressRule#http
        '''
        result = self._values.get("http")
        return typing.cast(typing.Optional[HttpIngressRuleValue], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IngressSpec",
    jsii_struct_bases=[],
    name_mapping={"backend": "backend", "rules": "rules", "tls": "tls"},
)
class IngressSpec:
    def __init__(
        self,
        *,
        backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[IngressRule]] = None,
        tls: typing.Optional[typing.Sequence["IngressTls"]] = None,
    ) -> None:
        '''(experimental) IngressSpec describes the Ingress the user wishes to exist.

        :param backend: (experimental) A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
        :param rules: (experimental) A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param tls: (experimental) TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressSpec
        '''
        if isinstance(backend, dict):
            backend = IngressBackend(**backend)
        self._values: typing.Dict[str, typing.Any] = {}
        if backend is not None:
            self._values["backend"] = backend
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def backend(self) -> typing.Optional[IngressBackend]:
        '''(experimental) A default backend capable of servicing requests that don't match any rule.

        At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressSpec#backend
        '''
        result = self._values.get("backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''(experimental) A list of host rules used to configure the Ingress.

        If unspecified, or no rule matches, all traffic is sent to the default backend.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressSpec#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List["IngressTls"]]:
        '''(experimental) TLS configuration.

        Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressSpec#tls
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List["IngressTls"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret_name": "secretName"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) IngressTLS describes the transport layer security associated with an Ingress.

        :param hosts: (experimental) Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified. Default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param secret_name: (experimental) SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressTLS
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret_name is not None:
            self._values["secret_name"] = secret_name

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Hosts are a list of hosts included in the TLS certificate.

        The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :default: the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressTLS#hosts
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) SecretName is the name of the secret used to terminate SSL traffic on 443.

        Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressTLS#secretName
        '''
        result = self._values.get("secret_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Initializer",
    jsii_struct_bases=[],
    name_mapping={"name": "name"},
)
class Initializer:
    def __init__(self, *, name: builtins.str) -> None:
        '''(experimental) Initializer is information about an initializer that has not yet completed.

        :param name: (experimental) name of the process that is responsible for initializing this object.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.Initializer
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''(experimental) name of the process that is responsible for initializing this object.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.Initializer#name
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Initializer(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.Initializers",
    jsii_struct_bases=[],
    name_mapping={"pending": "pending", "result": "result"},
)
class Initializers:
    def __init__(
        self,
        *,
        pending: typing.Sequence[Initializer],
        result: typing.Optional["KubeStatusProps"] = None,
    ) -> None:
        '''(experimental) Initializers tracks the progress of initialization.

        :param pending: (experimental) Pending is a list of initializers that must execute in order before this object is visible. When the last pending initializer is removed, and no failing result is set, the initializers struct will be set to nil and the object is considered as initialized and visible to all clients.
        :param result: (experimental) If result is set with the Failure field, the object will be persisted to storage and then deleted, ensuring that other clients can observe the deletion.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.Initializers
        '''
        if isinstance(result, dict):
            result = KubeStatusProps(**result)
        self._values: typing.Dict[str, typing.Any] = {
            "pending": pending,
        }
        if result is not None:
            self._values["result"] = result

    @builtins.property
    def pending(self) -> typing.List[Initializer]:
        '''(experimental) Pending is a list of initializers that must execute in order before this object is visible.

        When the last pending initializer is removed, and no failing result is set, the initializers struct will be set to nil and the object is considered as initialized and visible to all clients.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.Initializers#pending
        '''
        result = self._values.get("pending")
        assert result is not None, "Required property 'pending' is missing"
        return typing.cast(typing.List[Initializer], result)

    @builtins.property
    def result(self) -> typing.Optional["KubeStatusProps"]:
        '''(experimental) If result is set with the Failure field, the object will be persisted to storage and then deleted, ensuring that other clients can observe the deletion.

        :stability: experimental
        :schema: io.k8s.apimachinery.pkg.apis.meta.v1.Initializers#result
        '''
        result = self._values.get("result")
        return typing.cast(typing.Optional["KubeStatusProps"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Initializers(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class IntOrString(
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IntOrString",
):
    '''
    :stability: experimental
    :schema: io.k8s.apimachinery.pkg.util.intstr.IntOrString
    '''

    @jsii.member(jsii_name="fromNumber") # type: ignore[misc]
    @builtins.classmethod
    def from_number(cls, value: jsii.Number) -> "IntOrString":
        '''
        :param value: -

        :stability: experimental
        '''
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromNumber", [value]))

    @jsii.member(jsii_name="fromString") # type: ignore[misc]
    @builtins.classmethod
    def from_string(cls, value: builtins.str) -> "IntOrString":
        '''
        :param value: -

        :stability: experimental
        '''
        return typing.cast("IntOrString", jsii.sinvoke(cls, "fromString", [value]))


@jsii.enum(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind"
)
class IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind(enum.Enum):
    '''(experimental) Kind is a string value representing the REST resource this object represents.

    Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

    :stability: experimental
    :schema: IoK8SApimachineryPkgApisMetaV1DeleteOptionsKind
    '''

    DELETE_OPTIONS = "DELETE_OPTIONS"
    '''(experimental) DeleteOptions.

    :stability: experimental
    '''


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IpBlock",
    jsii_struct_bases=[],
    name_mapping={"cidr": "cidr", "except_": "except"},
)
class IpBlock:
    def __init__(
        self,
        *,
        cidr: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) IPBlock describes a particular CIDR (Ex.

        "192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.

        :param cidr: (experimental) CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24".
        :param except_: (experimental) Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range.

        :stability: experimental
        :schema: io.k8s.api.networking.v1.IPBlock
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "cidr": cidr,
        }
        if except_ is not None:
            self._values["except_"] = except_

    @builtins.property
    def cidr(self) -> builtins.str:
        '''(experimental) CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24".

        :stability: experimental
        :schema: io.k8s.api.networking.v1.IPBlock#cidr
        '''
        result = self._values.get("cidr")
        assert result is not None, "Required property 'cidr' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range.

        :stability: experimental
        :schema: io.k8s.api.networking.v1.IPBlock#except
        '''
        result = self._values.get("except_")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IpBlock(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IscsiPersistentVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiPersistentVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["SecretReference"] = None,
    ) -> None:
        '''(experimental) ISCSIPersistentVolumeSource represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: (experimental) Target iSCSI Qualified Name.
        :param lun: (experimental) iSCSI Target Lun number.
        :param target_portal: (experimental) iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: (experimental) whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: (experimental) whether support iSCSI Session CHAP authentication.
        :param fs_type: (experimental) Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: (experimental) Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: (experimental) iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: (experimental) iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: (experimental) CHAP Secret for iSCSI target and initiator authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = SecretReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''(experimental) Target iSCSI Qualified Name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''(experimental) iSCSI Target Lun number.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''(experimental) iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''(experimental) whether support iSCSI Discovery CHAP authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''(experimental) whether support iSCSI Session CHAP authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''(experimental) iSCSI Interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) iSCSI Target Portal List.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["SecretReference"]:
        '''(experimental) CHAP Secret for iSCSI target and initiator authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIPersistentVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["SecretReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiPersistentVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.IscsiVolumeSource",
    jsii_struct_bases=[],
    name_mapping={
        "iqn": "iqn",
        "lun": "lun",
        "target_portal": "targetPortal",
        "chap_auth_discovery": "chapAuthDiscovery",
        "chap_auth_session": "chapAuthSession",
        "fs_type": "fsType",
        "initiator_name": "initiatorName",
        "iscsi_interface": "iscsiInterface",
        "portals": "portals",
        "read_only": "readOnly",
        "secret_ref": "secretRef",
    },
)
class IscsiVolumeSource:
    def __init__(
        self,
        *,
        iqn: builtins.str,
        lun: jsii.Number,
        target_portal: builtins.str,
        chap_auth_discovery: typing.Optional[builtins.bool] = None,
        chap_auth_session: typing.Optional[builtins.bool] = None,
        fs_type: typing.Optional[builtins.str] = None,
        initiator_name: typing.Optional[builtins.str] = None,
        iscsi_interface: typing.Optional[builtins.str] = None,
        portals: typing.Optional[typing.Sequence[builtins.str]] = None,
        read_only: typing.Optional[builtins.bool] = None,
        secret_ref: typing.Optional["LocalObjectReference"] = None,
    ) -> None:
        '''(experimental) Represents an ISCSI disk.

        ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.

        :param iqn: (experimental) Target iSCSI Qualified Name.
        :param lun: (experimental) iSCSI Target Lun number.
        :param target_portal: (experimental) iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param chap_auth_discovery: (experimental) whether support iSCSI Discovery CHAP authentication.
        :param chap_auth_session: (experimental) whether support iSCSI Session CHAP authentication.
        :param fs_type: (experimental) Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param initiator_name: (experimental) Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.
        :param iscsi_interface: (experimental) iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). Default: default' (tcp).
        :param portals: (experimental) iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param read_only: (experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. Default: false.
        :param secret_ref: (experimental) CHAP Secret for iSCSI target and initiator authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource
        '''
        if isinstance(secret_ref, dict):
            secret_ref = LocalObjectReference(**secret_ref)
        self._values: typing.Dict[str, typing.Any] = {
            "iqn": iqn,
            "lun": lun,
            "target_portal": target_portal,
        }
        if chap_auth_discovery is not None:
            self._values["chap_auth_discovery"] = chap_auth_discovery
        if chap_auth_session is not None:
            self._values["chap_auth_session"] = chap_auth_session
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if initiator_name is not None:
            self._values["initiator_name"] = initiator_name
        if iscsi_interface is not None:
            self._values["iscsi_interface"] = iscsi_interface
        if portals is not None:
            self._values["portals"] = portals
        if read_only is not None:
            self._values["read_only"] = read_only
        if secret_ref is not None:
            self._values["secret_ref"] = secret_ref

    @builtins.property
    def iqn(self) -> builtins.str:
        '''(experimental) Target iSCSI Qualified Name.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iqn
        '''
        result = self._values.get("iqn")
        assert result is not None, "Required property 'iqn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lun(self) -> jsii.Number:
        '''(experimental) iSCSI Target Lun number.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#lun
        '''
        result = self._values.get("lun")
        assert result is not None, "Required property 'lun' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target_portal(self) -> builtins.str:
        '''(experimental) iSCSI Target Portal.

        The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#targetPortal
        '''
        result = self._values.get("target_portal")
        assert result is not None, "Required property 'target_portal' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def chap_auth_discovery(self) -> typing.Optional[builtins.bool]:
        '''(experimental) whether support iSCSI Discovery CHAP authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthDiscovery
        '''
        result = self._values.get("chap_auth_discovery")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def chap_auth_session(self) -> typing.Optional[builtins.bool]:
        '''(experimental) whether support iSCSI Session CHAP authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#chapAuthSession
        '''
        result = self._values.get("chap_auth_session")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#fsType
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def initiator_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) Custom iSCSI Initiator Name.

        If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface : will be created for the connection.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#initiatorName
        '''
        result = self._values.get("initiator_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def iscsi_interface(self) -> typing.Optional[builtins.str]:
        '''(experimental) iSCSI Interface Name that uses an iSCSI transport.

        Defaults to 'default' (tcp).

        :default: default' (tcp).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#iscsiInterface
        '''
        result = self._values.get("iscsi_interface")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def portals(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) iSCSI Target Portal List.

        The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#portals
        '''
        result = self._values.get("portals")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''(experimental) ReadOnly here will force the ReadOnly setting in VolumeMounts.

        Defaults to false.

        :default: false.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#readOnly
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secret_ref(self) -> typing.Optional["LocalObjectReference"]:
        '''(experimental) CHAP Secret for iSCSI target and initiator authentication.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ISCSIVolumeSource#secretRef
        '''
        result = self._values.get("secret_ref")
        return typing.cast(typing.Optional["LocalObjectReference"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IscsiVolumeSource(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.JobSpec",
    jsii_struct_bases=[],
    name_mapping={
        "template": "template",
        "active_deadline_seconds": "activeDeadlineSeconds",
        "backoff_limit": "backoffLimit",
        "completions": "completions",
        "manual_selector": "manualSelector",
        "parallelism": "parallelism",
        "selector": "selector",
        "ttl_seconds_after_finished": "ttlSecondsAfterFinished",
    },
)
class JobSpec:
    def __init__(
        self,
        *,
        template: "PodTemplateSpec",
        active_deadline_seconds: typing.Optional[jsii.Number] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        completions: typing.Optional[jsii.Number] = None,
        manual_selector: typing.Optional[builtins.bool] = None,
        parallelism: typing.Optional[jsii.Number] = None,
        selector: typing.Optional["LabelSelector"] = None,
        ttl_seconds_after_finished: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''(experimental) JobSpec describes how the job execution will look like.

        :param template: (experimental) Describes the pod that will be created when executing a job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param active_deadline_seconds: (experimental) Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer
        :param backoff_limit: (experimental) Specifies the number of retries before marking this job failed. Defaults to 6 Default: 6
        :param completions: (experimental) Specifies the desired number of successfully finished pods the job should be run with. Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value. Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param manual_selector: (experimental) manualSelector controls generation of pod labels and pod selectors. Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template. When true, the user is responsible for picking unique labels and specifying the selector. Failure to pick a unique label may cause this and other jobs to not function correctly. However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
        :param parallelism: (experimental) Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param selector: (experimental) A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param ttl_seconds_after_finished: (experimental) ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec
        '''
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        if isinstance(selector, dict):
            selector = LabelSelector(**selector)
        self._values: typing.Dict[str, typing.Any] = {
            "template": template,
        }
        if active_deadline_seconds is not None:
            self._values["active_deadline_seconds"] = active_deadline_seconds
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if completions is not None:
            self._values["completions"] = completions
        if manual_selector is not None:
            self._values["manual_selector"] = manual_selector
        if parallelism is not None:
            self._values["parallelism"] = parallelism
        if selector is not None:
            self._values["selector"] = selector
        if ttl_seconds_after_finished is not None:
            self._values["ttl_seconds_after_finished"] = ttl_seconds_after_finished

    @builtins.property
    def template(self) -> "PodTemplateSpec":
        '''(experimental) Describes the pod that will be created when executing a job.

        More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#template
        '''
        result = self._values.get("template")
        assert result is not None, "Required property 'template' is missing"
        return typing.cast("PodTemplateSpec", result)

    @builtins.property
    def active_deadline_seconds(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it;

        value must be positive integer

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#activeDeadlineSeconds
        '''
        result = self._values.get("active_deadline_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Specifies the number of retries before marking this job failed.

        Defaults to 6

        :default: 6

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#backoffLimit
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def completions(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Specifies the desired number of successfully finished pods the job should be run with.

        Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#completions
        '''
        result = self._values.get("completions")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def manual_selector(self) -> typing.Optional[builtins.bool]:
        '''(experimental) manualSelector controls generation of pod labels and pod selectors.

        Leave ``manualSelector`` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see ``manualSelector=true`` in jobs that were created with the old ``extensions/v1beta1`` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#manualSelector
        '''
        result = self._values.get("manual_selector")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def parallelism(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Specifies the maximum desired number of pods the job should run at any given time.

        The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#parallelism
        '''
        result = self._values.get("parallelism")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def selector(self) -> typing.Optional["LabelSelector"]:
        '''(experimental) A label query over pods that should match the pod count.

        Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#selector
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional["LabelSelector"], result)

    @builtins.property
    def ttl_seconds_after_finished(self) -> typing.Optional[jsii.Number]:
        '''(experimental) ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobSpec#ttlSecondsAfterFinished
        '''
        result = self._values.get("ttl_seconds_after_finished")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.JobTemplateSpec",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class JobTemplateSpec:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[JobSpec] = None,
    ) -> None:
        '''(experimental) JobTemplateSpec describes the data a Job should have when created from a template.

        :param metadata: (experimental) Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.JobTemplateSpec
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = JobSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata of the jobs created from this template.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.JobTemplateSpec#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[JobSpec]:
        '''(experimental) Specification of the desired behavior of the job.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.JobTemplateSpec#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[JobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobTemplateSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.JsonSchemaProps",
    jsii_struct_bases=[],
    name_mapping={
        "additional_items": "additionalItems",
        "additional_properties": "additionalProperties",
        "all_of": "allOf",
        "any_of": "anyOf",
        "default": "default",
        "definitions": "definitions",
        "dependencies": "dependencies",
        "description": "description",
        "enum": "enum",
        "example": "example",
        "exclusive_maximum": "exclusiveMaximum",
        "exclusive_minimum": "exclusiveMinimum",
        "external_docs": "externalDocs",
        "format": "format",
        "id": "id",
        "items": "items",
        "maximum": "maximum",
        "max_items": "maxItems",
        "max_length": "maxLength",
        "max_properties": "maxProperties",
        "minimum": "minimum",
        "min_items": "minItems",
        "min_length": "minLength",
        "min_properties": "minProperties",
        "multiple_of": "multipleOf",
        "not_": "not",
        "nullable": "nullable",
        "one_of": "oneOf",
        "pattern": "pattern",
        "pattern_properties": "patternProperties",
        "properties": "properties",
        "ref": "ref",
        "required": "required",
        "schema": "schema",
        "title": "title",
        "type": "type",
        "unique_items": "uniqueItems",
    },
)
class JsonSchemaProps:
    def __init__(
        self,
        *,
        additional_items: typing.Any = None,
        additional_properties: typing.Any = None,
        all_of: typing.Optional[typing.Sequence["JsonSchemaProps"]] = None,
        any_of: typing.Optional[typing.Sequence["JsonSchemaProps"]] = None,
        default: typing.Any = None,
        definitions: typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]] = None,
        dependencies: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        description: typing.Optional[builtins.str] = None,
        enum: typing.Optional[typing.Sequence[typing.Any]] = None,
        example: typing.Any = None,
        exclusive_maximum: typing.Optional[builtins.bool] = None,
        exclusive_minimum: typing.Optional[builtins.bool] = None,
        external_docs: typing.Optional[ExternalDocumentation] = None,
        format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        items: typing.Any = None,
        maximum: typing.Optional[jsii.Number] = None,
        max_items: typing.Optional[jsii.Number] = None,
        max_length: typing.Optional[jsii.Number] = None,
        max_properties: typing.Optional[jsii.Number] = None,
        minimum: typing.Optional[jsii.Number] = None,
        min_items: typing.Optional[jsii.Number] = None,
        min_length: typing.Optional[jsii.Number] = None,
        min_properties: typing.Optional[jsii.Number] = None,
        multiple_of: typing.Optional[jsii.Number] = None,
        not_: typing.Optional["JsonSchemaProps"] = None,
        nullable: typing.Optional[builtins.bool] = None,
        one_of: typing.Optional[typing.Sequence["JsonSchemaProps"]] = None,
        pattern: typing.Optional[builtins.str] = None,
        pattern_properties: typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]] = None,
        properties: typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]] = None,
        ref: typing.Optional[builtins.str] = None,
        required: typing.Optional[typing.Sequence[builtins.str]] = None,
        schema: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        unique_items: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).

        :param additional_items: 
        :param additional_properties: 
        :param all_of: 
        :param any_of: 
        :param default: (experimental) default is a default value for undefined object fields. Defaulting is an alpha feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        :param definitions: 
        :param dependencies: 
        :param description: 
        :param enum: 
        :param example: 
        :param exclusive_maximum: 
        :param exclusive_minimum: 
        :param external_docs: 
        :param format: 
        :param id: 
        :param items: 
        :param maximum: 
        :param max_items: 
        :param max_length: 
        :param max_properties: 
        :param minimum: 
        :param min_items: 
        :param min_length: 
        :param min_properties: 
        :param multiple_of: 
        :param not_: 
        :param nullable: 
        :param one_of: 
        :param pattern: 
        :param pattern_properties: 
        :param properties: 
        :param ref: 
        :param required: 
        :param schema: 
        :param title: 
        :param type: 
        :param unique_items: 

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps
        '''
        if isinstance(external_docs, dict):
            external_docs = ExternalDocumentation(**external_docs)
        if isinstance(not_, dict):
            not_ = JsonSchemaProps(**not_)
        self._values: typing.Dict[str, typing.Any] = {}
        if additional_items is not None:
            self._values["additional_items"] = additional_items
        if additional_properties is not None:
            self._values["additional_properties"] = additional_properties
        if all_of is not None:
            self._values["all_of"] = all_of
        if any_of is not None:
            self._values["any_of"] = any_of
        if default is not None:
            self._values["default"] = default
        if definitions is not None:
            self._values["definitions"] = definitions
        if dependencies is not None:
            self._values["dependencies"] = dependencies
        if description is not None:
            self._values["description"] = description
        if enum is not None:
            self._values["enum"] = enum
        if example is not None:
            self._values["example"] = example
        if exclusive_maximum is not None:
            self._values["exclusive_maximum"] = exclusive_maximum
        if exclusive_minimum is not None:
            self._values["exclusive_minimum"] = exclusive_minimum
        if external_docs is not None:
            self._values["external_docs"] = external_docs
        if format is not None:
            self._values["format"] = format
        if id is not None:
            self._values["id"] = id
        if items is not None:
            self._values["items"] = items
        if maximum is not None:
            self._values["maximum"] = maximum
        if max_items is not None:
            self._values["max_items"] = max_items
        if max_length is not None:
            self._values["max_length"] = max_length
        if max_properties is not None:
            self._values["max_properties"] = max_properties
        if minimum is not None:
            self._values["minimum"] = minimum
        if min_items is not None:
            self._values["min_items"] = min_items
        if min_length is not None:
            self._values["min_length"] = min_length
        if min_properties is not None:
            self._values["min_properties"] = min_properties
        if multiple_of is not None:
            self._values["multiple_of"] = multiple_of
        if not_ is not None:
            self._values["not_"] = not_
        if nullable is not None:
            self._values["nullable"] = nullable
        if one_of is not None:
            self._values["one_of"] = one_of
        if pattern is not None:
            self._values["pattern"] = pattern
        if pattern_properties is not None:
            self._values["pattern_properties"] = pattern_properties
        if properties is not None:
            self._values["properties"] = properties
        if ref is not None:
            self._values["ref"] = ref
        if required is not None:
            self._values["required"] = required
        if schema is not None:
            self._values["schema"] = schema
        if title is not None:
            self._values["title"] = title
        if type is not None:
            self._values["type"] = type
        if unique_items is not None:
            self._values["unique_items"] = unique_items

    @builtins.property
    def additional_items(self) -> typing.Any:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#additionalItems
        '''
        result = self._values.get("additional_items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def additional_properties(self) -> typing.Any:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#additionalProperties
        '''
        result = self._values.get("additional_properties")
        return typing.cast(typing.Any, result)

    @builtins.property
    def all_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#allOf
        '''
        result = self._values.get("all_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def any_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#anyOf
        '''
        result = self._values.get("any_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def default(self) -> typing.Any:
        '''(experimental) default is a default value for undefined object fields.

        Defaulting is an alpha feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#default
        '''
        result = self._values.get("default")
        return typing.cast(typing.Any, result)

    @builtins.property
    def definitions(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#definitions
        '''
        result = self._values.get("definitions")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def dependencies(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#dependencies
        '''
        result = self._values.get("dependencies")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enum(self) -> typing.Optional[typing.List[typing.Any]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#enum
        '''
        result = self._values.get("enum")
        return typing.cast(typing.Optional[typing.List[typing.Any]], result)

    @builtins.property
    def example(self) -> typing.Any:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#example
        '''
        result = self._values.get("example")
        return typing.cast(typing.Any, result)

    @builtins.property
    def exclusive_maximum(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#exclusiveMaximum
        '''
        result = self._values.get("exclusive_maximum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def exclusive_minimum(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#exclusiveMinimum
        '''
        result = self._values.get("exclusive_minimum")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def external_docs(self) -> typing.Optional[ExternalDocumentation]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#externalDocs
        '''
        result = self._values.get("external_docs")
        return typing.cast(typing.Optional[ExternalDocumentation], result)

    @builtins.property
    def format(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#format
        '''
        result = self._values.get("format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#id
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def items(self) -> typing.Any:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#items
        '''
        result = self._values.get("items")
        return typing.cast(typing.Any, result)

    @builtins.property
    def maximum(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#maximum
        '''
        result = self._values.get("maximum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_items(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#maxItems
        '''
        result = self._values.get("max_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_length(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#maxLength
        '''
        result = self._values.get("max_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def max_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#maxProperties
        '''
        result = self._values.get("max_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def minimum(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#minimum
        '''
        result = self._values.get("minimum")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_items(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#minItems
        '''
        result = self._values.get("min_items")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_length(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#minLength
        '''
        result = self._values.get("min_length")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_properties(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#minProperties
        '''
        result = self._values.get("min_properties")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def multiple_of(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#multipleOf
        '''
        result = self._values.get("multiple_of")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def not_(self) -> typing.Optional["JsonSchemaProps"]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#not
        '''
        result = self._values.get("not_")
        return typing.cast(typing.Optional["JsonSchemaProps"], result)

    @builtins.property
    def nullable(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#nullable
        '''
        result = self._values.get("nullable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def one_of(self) -> typing.Optional[typing.List["JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#oneOf
        '''
        result = self._values.get("one_of")
        return typing.cast(typing.Optional[typing.List["JsonSchemaProps"]], result)

    @builtins.property
    def pattern(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#pattern
        '''
        result = self._values.get("pattern")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pattern_properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#patternProperties
        '''
        result = self._values.get("pattern_properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def properties(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#properties
        '''
        result = self._values.get("properties")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "JsonSchemaProps"]], result)

    @builtins.property
    def ref(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#$ref
        '''
        result = self._values.get("ref")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def required(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#required
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def schema(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#$schema
        '''
        result = self._values.get("schema")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#title
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unique_items(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSONSchemaProps#uniqueItems
        '''
        result = self._values.get("unique_items")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JsonSchemaProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KeyToPath",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "path": "path", "mode": "mode"},
)
class KeyToPath:
    def __init__(
        self,
        *,
        key: builtins.str,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''(experimental) Maps a string key to a path within a volume.

        :param key: (experimental) The key to project.
        :param path: (experimental) The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: (experimental) Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :stability: experimental
        :schema: io.k8s.api.core.v1.KeyToPath
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) The key to project.

        :stability: experimental
        :schema: io.k8s.api.core.v1.KeyToPath#key
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) The relative path of the file to map the key to.

        May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.

        :stability: experimental
        :schema: io.k8s.api.core.v1.KeyToPath#path
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Optional: mode bits to use on this file, must be a value between 0 and 0777.

        If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.

        :stability: experimental
        :schema: io.k8s.api.core.v1.KeyToPath#mode
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KeyToPath(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeApiService(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiService",
):
    '''(experimental) APIService represents a server for a particular GroupVersion.

    Name must be "version.group".

    :stability: experimental
    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        '''
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        '''
        props = KubeApiServiceProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeApiServiceList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceList",
):
    '''(experimental) APIServiceList is a list of APIService objects.

    :stability: experimental
    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeApiServiceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeApiServiceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeApiServiceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeApiServiceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeApiServiceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) APIServiceList is a list of APIService objects.

        :param items: 
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeApiServiceProps"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeApiServiceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeApiServiceListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceListV1Beta1",
):
    '''(experimental) APIServiceList is a list of APIService objects.

    :stability: experimental
    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeApiServiceV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeApiServiceListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeApiServiceV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeApiServiceListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeApiServiceListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeApiServiceV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) APIServiceList is a list of APIService objects.

        :param items: 
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeApiServiceV1Beta1Props"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeApiServiceV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIServiceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeApiServiceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> None:
        '''(experimental) APIService represents a server for a particular GroupVersion.

        Name must be "version.group".

        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = ApiServiceSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[ApiServiceSpec]:
        '''(experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[ApiServiceSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeApiServiceV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceV1Beta1",
):
    '''(experimental) APIService represents a server for a particular GroupVersion.

    Name must be "version.group".

    :stability: experimental
    :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        '''
        props = KubeApiServiceV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        '''
        props = KubeApiServiceV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeApiServiceV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeApiServiceV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[ApiServiceSpec] = None,
    ) -> None:
        '''(experimental) APIService represents a server for a particular GroupVersion.

        Name must be "version.group".

        :param metadata: 
        :param spec: (experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = ApiServiceSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[ApiServiceSpec]:
        '''(experimental) Spec contains information for locating and communicating with a server.

        :stability: experimental
        :schema: io.k8s.kube-aggregator.pkg.apis.apiregistration.v1beta1.APIService#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[ApiServiceSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeApiServiceV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeAuditSinkListV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeAuditSinkListV1Alpha1",
):
    '''(experimental) AuditSinkList is a list of AuditSink items.

    :stability: experimental
    :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeAuditSinkV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.auditregistration.v1alpha1.AuditSinkList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of audit configurations.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeAuditSinkListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeAuditSinkV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.auditregistration.v1alpha1.AuditSinkList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of audit configurations.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeAuditSinkListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.auditregistration.v1alpha1.AuditSinkList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeAuditSinkListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeAuditSinkListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeAuditSinkV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) AuditSinkList is a list of AuditSink items.

        :param items: (experimental) List of audit configurations.
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeAuditSinkV1Alpha1Props"]:
        '''(experimental) List of audit configurations.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeAuditSinkV1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSinkList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeAuditSinkListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeAuditSinkV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeAuditSinkV1Alpha1",
):
    '''(experimental) AuditSink represents a cluster level audit sink.

    :stability: experimental
    :schema: io.k8s.api.auditregistration.v1alpha1.AuditSink
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[AuditSinkSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.auditregistration.v1alpha1.AuditSink" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: (experimental) Spec defines the audit configuration spec.

        :stability: experimental
        '''
        props = KubeAuditSinkV1Alpha1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[AuditSinkSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.auditregistration.v1alpha1.AuditSink".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: (experimental) Spec defines the audit configuration spec.

        :stability: experimental
        '''
        props = KubeAuditSinkV1Alpha1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.auditregistration.v1alpha1.AuditSink".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeAuditSinkV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeAuditSinkV1Alpha1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[AuditSinkSpec] = None,
    ) -> None:
        '''(experimental) AuditSink represents a cluster level audit sink.

        :param metadata: 
        :param spec: (experimental) Spec defines the audit configuration spec.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSink
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = AuditSinkSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSink#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[AuditSinkSpec]:
        '''(experimental) Spec defines the audit configuration spec.

        :stability: experimental
        :schema: io.k8s.api.auditregistration.v1alpha1.AuditSink#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[AuditSinkSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeAuditSinkV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeBinding(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeBinding",
):
    '''(experimental) Binding ties one object to another;

    for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

    :stability: experimental
    :schema: io.k8s.api.core.v1.Binding
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        target: "ObjectReference",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Binding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param target: (experimental) The target object that you want to bind to the standard object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeBindingProps(target=target, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        target: "ObjectReference",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param target: (experimental) The target object that you want to bind to the standard object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeBindingProps(target=target, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeBindingProps",
    jsii_struct_bases=[],
    name_mapping={"target": "target", "metadata": "metadata"},
)
class KubeBindingProps:
    def __init__(
        self,
        *,
        target: "ObjectReference",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Binding ties one object to another;

        for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

        :param target: (experimental) The target object that you want to bind to the standard object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Binding
        '''
        if isinstance(target, dict):
            target = ObjectReference(**target)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def target(self) -> "ObjectReference":
        '''(experimental) The target object that you want to bind to the standard object.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Binding#target
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("ObjectReference", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Binding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCertificateSigningRequestListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCertificateSigningRequestListV1Beta1",
):
    '''
    :stability: experimental
    :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCertificateSigningRequestV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCertificateSigningRequestListV1Beta1Props(
            items=items, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCertificateSigningRequestV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCertificateSigningRequestListV1Beta1Props(
            items=items, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequestList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCertificateSigningRequestListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCertificateSigningRequestListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCertificateSigningRequestV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''
        :param items: 
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCertificateSigningRequestV1Beta1Props"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCertificateSigningRequestV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequestList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCertificateSigningRequestV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCertificateSigningRequestV1Beta1",
):
    '''(experimental) Describes a certificate signing request.

    :stability: experimental
    :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequest
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CertificateSigningRequestSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.certificates.v1beta1.CertificateSigningRequest" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: (experimental) The certificate request itself and any additional information.

        :stability: experimental
        '''
        props = KubeCertificateSigningRequestV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CertificateSigningRequestSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: (experimental) The certificate request itself and any additional information.

        :stability: experimental
        '''
        props = KubeCertificateSigningRequestV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.certificates.v1beta1.CertificateSigningRequest".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCertificateSigningRequestV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCertificateSigningRequestV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CertificateSigningRequestSpec] = None,
    ) -> None:
        '''(experimental) Describes a certificate signing request.

        :param metadata: 
        :param spec: (experimental) The certificate request itself and any additional information.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequest
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CertificateSigningRequestSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequest#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CertificateSigningRequestSpec]:
        '''(experimental) The certificate request itself and any additional information.

        :stability: experimental
        :schema: io.k8s.api.certificates.v1beta1.CertificateSigningRequest#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CertificateSigningRequestSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCertificateSigningRequestV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRole(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRole",
):
    '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1.ClusterRole
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1.ClusterRole" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleProps(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBinding(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBinding",
):
    '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

    It can reference a ClusterRole in the global namespace, and adds who information via Subject.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleBinding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingProps(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeClusterRoleBindingList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingList",
):
    '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleBindingProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleBindingList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleBindingProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleBindingListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleBindingProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleBindingProps"]:
        '''(experimental) Items is a list of ClusterRoleBindings.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleBindingProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBindingList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleBindingListV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingListV1Alpha1",
):
    '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleBindingListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleBindingV1Alpha1Props"]:
        '''(experimental) Items is a list of ClusterRoleBindings.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleBindingV1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleBindingListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingListV1Beta1",
):
    '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBindingList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBindingList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleBindingListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleBindingV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleBindingList is a collection of ClusterRoleBindings.

        :param items: (experimental) Items is a list of ClusterRoleBindings.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBindingList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleBindingV1Beta1Props"]:
        '''(experimental) Items is a list of ClusterRoleBindings.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBindingList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleBindingV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBindingList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingProps",
    jsii_struct_bases=[],
    name_mapping={
        "role_ref": "roleRef",
        "metadata": "metadata",
        "subjects": "subjects",
    },
)
class KubeClusterRoleBindingProps:
    def __init__(
        self,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

        It can reference a ClusterRole in the global namespace, and adds who information via Subject.

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding
        '''
        if isinstance(role_ref, dict):
            role_ref = RoleRef(**role_ref)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "role_ref": role_ref,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if subjects is not None:
            self._values["subjects"] = subjects

    @builtins.property
    def role_ref(self) -> "RoleRef":
        '''(experimental) RoleRef can only reference a ClusterRole in the global namespace.

        If the RoleRef cannot be resolved, the Authorizer must return an error.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#roleRef
        '''
        result = self._values.get("role_ref")
        assert result is not None, "Required property 'role_ref' is missing"
        return typing.cast("RoleRef", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subjects(self) -> typing.Optional[typing.List["Subject"]]:
        '''(experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleBinding#subjects
        '''
        result = self._values.get("subjects")
        return typing.cast(typing.Optional[typing.List["Subject"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleBindingV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingV1Alpha1",
):
    '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

    It can reference a ClusterRole in the global namespace, and adds who information via Subject.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBinding
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingV1Alpha1Props(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingV1Alpha1Props(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={
        "role_ref": "roleRef",
        "metadata": "metadata",
        "subjects": "subjects",
    },
)
class KubeClusterRoleBindingV1Alpha1Props:
    def __init__(
        self,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

        It can reference a ClusterRole in the global namespace, and adds who information via Subject.

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBinding
        '''
        if isinstance(role_ref, dict):
            role_ref = RoleRef(**role_ref)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "role_ref": role_ref,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if subjects is not None:
            self._values["subjects"] = subjects

    @builtins.property
    def role_ref(self) -> "RoleRef":
        '''(experimental) RoleRef can only reference a ClusterRole in the global namespace.

        If the RoleRef cannot be resolved, the Authorizer must return an error.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#roleRef
        '''
        result = self._values.get("role_ref")
        assert result is not None, "Required property 'role_ref' is missing"
        return typing.cast("RoleRef", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subjects(self) -> typing.Optional[typing.List["Subject"]]:
        '''(experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleBinding#subjects
        '''
        result = self._values.get("subjects")
        return typing.cast(typing.Optional[typing.List["Subject"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleBindingV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingV1Beta1",
):
    '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

    It can reference a ClusterRole in the global namespace, and adds who information via Subject.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBinding
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleBinding" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingV1Beta1Props(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        '''
        props = KubeClusterRoleBindingV1Beta1Props(
            role_ref=role_ref, metadata=metadata, subjects=subjects
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleBinding".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleBindingV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={
        "role_ref": "roleRef",
        "metadata": "metadata",
        "subjects": "subjects",
    },
)
class KubeClusterRoleBindingV1Beta1Props:
    def __init__(
        self,
        *,
        role_ref: "RoleRef",
        metadata: typing.Optional["ObjectMeta"] = None,
        subjects: typing.Optional[typing.Sequence["Subject"]] = None,
    ) -> None:
        '''(experimental) ClusterRoleBinding references a ClusterRole, but not contain it.

        It can reference a ClusterRole in the global namespace, and adds who information via Subject.

        :param role_ref: (experimental) RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved, the Authorizer must return an error.
        :param metadata: (experimental) Standard object's metadata.
        :param subjects: (experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBinding
        '''
        if isinstance(role_ref, dict):
            role_ref = RoleRef(**role_ref)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "role_ref": role_ref,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if subjects is not None:
            self._values["subjects"] = subjects

    @builtins.property
    def role_ref(self) -> "RoleRef":
        '''(experimental) RoleRef can only reference a ClusterRole in the global namespace.

        If the RoleRef cannot be resolved, the Authorizer must return an error.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBinding#roleRef
        '''
        result = self._values.get("role_ref")
        assert result is not None, "Required property 'role_ref' is missing"
        return typing.cast("RoleRef", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBinding#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subjects(self) -> typing.Optional[typing.List["Subject"]]:
        '''(experimental) Subjects holds references to the objects the role applies to.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleBinding#subjects
        '''
        result = self._values.get("subjects")
        return typing.cast(typing.Optional[typing.List["Subject"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleBindingV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleList",
):
    '''(experimental) ClusterRoleList is a collection of ClusterRoles.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1.ClusterRoleList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1.ClusterRoleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleList is a collection of ClusterRoles.

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleProps"]:
        '''(experimental) Items is a list of ClusterRoles.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRoleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleListV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleListV1Alpha1",
):
    '''(experimental) ClusterRoleList is a collection of ClusterRoles.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRoleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleList is a collection of ClusterRoles.

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleV1Alpha1Props"]:
        '''(experimental) Items is a list of ClusterRoles.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleV1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRoleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleListV1Beta1",
):
    '''(experimental) ClusterRoleList is a collection of ClusterRoles.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1beta1.ClusterRoleList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeClusterRoleV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRoleList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeClusterRoleV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRoleList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        '''
        props = KubeClusterRoleListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRoleList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeClusterRoleListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeClusterRoleV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ClusterRoleList is a collection of ClusterRoles.

        :param items: (experimental) Items is a list of ClusterRoles.
        :param metadata: (experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeClusterRoleV1Beta1Props"]:
        '''(experimental) Items is a list of ClusterRoles.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeClusterRoleV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRoleList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleProps",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation_rule": "aggregationRule",
        "metadata": "metadata",
        "rules": "rules",
    },
)
class KubeClusterRoleProps:
    def __init__(
        self,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRole
        '''
        if isinstance(aggregation_rule, dict):
            aggregation_rule = AggregationRule(**aggregation_rule)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if aggregation_rule is not None:
            self._values["aggregation_rule"] = aggregation_rule
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def aggregation_rule(self) -> typing.Optional[AggregationRule]:
        '''(experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.

        If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRole#aggregationRule
        '''
        result = self._values.get("aggregation_rule")
        return typing.cast(typing.Optional[AggregationRule], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRole#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRule"]]:
        '''(experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1.ClusterRole#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleV1Alpha1",
):
    '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1alpha1.ClusterRole
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1alpha1.ClusterRole" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleV1Alpha1Props(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRole".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleV1Alpha1Props(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRole".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation_rule": "aggregationRule",
        "metadata": "metadata",
        "rules": "rules",
    },
)
class KubeClusterRoleV1Alpha1Props:
    def __init__(
        self,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRole
        '''
        if isinstance(aggregation_rule, dict):
            aggregation_rule = AggregationRule(**aggregation_rule)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if aggregation_rule is not None:
            self._values["aggregation_rule"] = aggregation_rule
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def aggregation_rule(self) -> typing.Optional[AggregationRule]:
        '''(experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.

        If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRole#aggregationRule
        '''
        result = self._values.get("aggregation_rule")
        return typing.cast(typing.Optional[AggregationRule], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRole#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRule"]]:
        '''(experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1alpha1.ClusterRole#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeClusterRoleV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleV1Beta1",
):
    '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

    :stability: experimental
    :schema: io.k8s.api.rbac.v1beta1.ClusterRole
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.rbac.v1beta1.ClusterRole" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleV1Beta1Props(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.rbac.v1beta1.ClusterRole".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        '''
        props = KubeClusterRoleV1Beta1Props(
            aggregation_rule=aggregation_rule, metadata=metadata, rules=rules
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.rbac.v1beta1.ClusterRole".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeClusterRoleV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={
        "aggregation_rule": "aggregationRule",
        "metadata": "metadata",
        "rules": "rules",
    },
)
class KubeClusterRoleV1Beta1Props:
    def __init__(
        self,
        *,
        aggregation_rule: typing.Optional[AggregationRule] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        rules: typing.Optional[typing.Sequence["PolicyRule"]] = None,
    ) -> None:
        '''(experimental) ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

        :param aggregation_rule: (experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole. If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.
        :param metadata: (experimental) Standard object's metadata.
        :param rules: (experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRole
        '''
        if isinstance(aggregation_rule, dict):
            aggregation_rule = AggregationRule(**aggregation_rule)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if aggregation_rule is not None:
            self._values["aggregation_rule"] = aggregation_rule
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def aggregation_rule(self) -> typing.Optional[AggregationRule]:
        '''(experimental) AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.

        If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will be stomped by the controller.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRole#aggregationRule
        '''
        result = self._values.get("aggregation_rule")
        return typing.cast(typing.Optional[AggregationRule], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRole#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List["PolicyRule"]]:
        '''(experimental) Rules holds all the PolicyRules for this ClusterRole.

        :stability: experimental
        :schema: io.k8s.api.rbac.v1beta1.ClusterRole#rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List["PolicyRule"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeClusterRoleV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeComponentStatus(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeComponentStatus",
):
    '''(experimental) ComponentStatus (and ComponentStatusList) holds the cluster validation info.

    :stability: experimental
    :schema: io.k8s.api.core.v1.ComponentStatus
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        conditions: typing.Optional[typing.Sequence[ComponentCondition]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.ComponentStatus" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param conditions: (experimental) List of component conditions observed.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        conditions: typing.Optional[typing.Sequence[ComponentCondition]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param conditions: (experimental) List of component conditions observed.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeComponentStatusProps(conditions=conditions, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeComponentStatusList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeComponentStatusList",
):
    '''(experimental) Status of all the conditions for the component as a list of ComponentStatus objects.

    :stability: experimental
    :schema: io.k8s.api.core.v1.ComponentStatusList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeComponentStatusProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.ComponentStatusList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of ComponentStatus objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeComponentStatusProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of ComponentStatus objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeComponentStatusListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeComponentStatusListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeComponentStatusListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeComponentStatusProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Status of all the conditions for the component as a list of ComponentStatus objects.

        :param items: (experimental) List of ComponentStatus objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatusList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeComponentStatusProps"]:
        '''(experimental) List of ComponentStatus objects.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatusList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeComponentStatusProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatusList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeComponentStatusProps",
    jsii_struct_bases=[],
    name_mapping={"conditions": "conditions", "metadata": "metadata"},
)
class KubeComponentStatusProps:
    def __init__(
        self,
        *,
        conditions: typing.Optional[typing.Sequence[ComponentCondition]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) ComponentStatus (and ComponentStatusList) holds the cluster validation info.

        :param conditions: (experimental) List of component conditions observed.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatus
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if conditions is not None:
            self._values["conditions"] = conditions
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def conditions(self) -> typing.Optional[typing.List[ComponentCondition]]:
        '''(experimental) List of component conditions observed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatus#conditions
        '''
        result = self._values.get("conditions")
        return typing.cast(typing.Optional[typing.List[ComponentCondition]], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.ComponentStatus#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeComponentStatusProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeConfigMap(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeConfigMap",
):
    '''(experimental) ConfigMap holds configuration data for pods to consume.

    :stability: experimental
    :schema: io.k8s.api.core.v1.ConfigMap
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.ConfigMap" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param binary_data: (experimental) BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: (experimental) Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param binary_data: (experimental) BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: (experimental) Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeConfigMapProps(
            binary_data=binary_data, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeConfigMapList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeConfigMapList",
):
    '''(experimental) ConfigMapList is a resource containing a list of ConfigMap objects.

    :stability: experimental
    :schema: io.k8s.api.core.v1.ConfigMapList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeConfigMapProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.ConfigMapList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of ConfigMaps.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeConfigMapProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of ConfigMaps.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeConfigMapListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeConfigMapListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeConfigMapListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeConfigMapProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ConfigMapList is a resource containing a list of ConfigMap objects.

        :param items: (experimental) Items is the list of ConfigMaps.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeConfigMapProps"]:
        '''(experimental) Items is the list of ConfigMaps.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeConfigMapProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMapList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeConfigMapProps",
    jsii_struct_bases=[],
    name_mapping={"binary_data": "binaryData", "data": "data", "metadata": "metadata"},
)
class KubeConfigMapProps:
    def __init__(
        self,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) ConfigMap holds configuration data for pods to consume.

        :param binary_data: (experimental) BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param data: (experimental) Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMap
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMap#binaryData
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMap#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.ConfigMap#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevision(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevision",
):
    '''(experimental) ControllerRevision implements an immutable snapshot of state data.

    Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.ControllerRevision
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.ControllerRevision" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionProps(
            revision=revision, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeControllerRevisionList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionList",
):
    '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.ControllerRevisionList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeControllerRevisionProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.ControllerRevisionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeControllerRevisionProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeControllerRevisionListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeControllerRevisionProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevisionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeControllerRevisionProps"]:
        '''(experimental) Items is the list of ControllerRevisions.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevisionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeControllerRevisionProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevisionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevisionListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionListV1Beta1",
):
    '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta1.ControllerRevisionList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta1.ControllerRevisionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.ControllerRevisionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.ControllerRevisionList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeControllerRevisionListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevisionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeControllerRevisionV1Beta1Props"]:
        '''(experimental) Items is the list of ControllerRevisions.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevisionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeControllerRevisionV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevisionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevisionListV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionListV1Beta2",
):
    '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.ControllerRevisionList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.ControllerRevisionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListV1Beta2Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ControllerRevisionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeControllerRevisionListV1Beta2Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ControllerRevisionList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionListV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeControllerRevisionListV1Beta2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeControllerRevisionV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) ControllerRevisionList is a resource containing a list of ControllerRevision objects.

        :param items: (experimental) Items is the list of ControllerRevisions.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevisionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeControllerRevisionV1Beta2Props"]:
        '''(experimental) Items is the list of ControllerRevisions.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevisionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeControllerRevisionV1Beta2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevisionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionListV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionProps",
    jsii_struct_bases=[],
    name_mapping={"revision": "revision", "data": "data", "metadata": "metadata"},
)
class KubeControllerRevisionProps:
    def __init__(
        self,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) ControllerRevision implements an immutable snapshot of state data.

        Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevision
        '''
        if isinstance(data, dict):
            data = RawExtension(**data)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "revision": revision,
        }
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def revision(self) -> jsii.Number:
        '''(experimental) Revision indicates the revision of the state represented by Data.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevision#revision
        '''
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def data(self) -> typing.Optional["RawExtension"]:
        '''(experimental) Data is the serialized representation of the state.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevision#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional["RawExtension"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1.ControllerRevision#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevisionV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionV1Beta1",
):
    '''(experimental) DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.

    See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta1.ControllerRevision
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta1.ControllerRevision" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionV1Beta1Props(
            revision=revision, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta1.ControllerRevision".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionV1Beta1Props(
            revision=revision, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta1.ControllerRevision".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"revision": "revision", "data": "data", "metadata": "metadata"},
)
class KubeControllerRevisionV1Beta1Props:
    def __init__(
        self,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision.

        See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevision
        '''
        if isinstance(data, dict):
            data = RawExtension(**data)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "revision": revision,
        }
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def revision(self) -> jsii.Number:
        '''(experimental) Revision indicates the revision of the state represented by Data.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevision#revision
        '''
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def data(self) -> typing.Optional["RawExtension"]:
        '''(experimental) Data is the serialized representation of the state.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevision#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional["RawExtension"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta1.ControllerRevision#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeControllerRevisionV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionV1Beta2",
):
    '''(experimental) DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.

    See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.ControllerRevision
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.ControllerRevision" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionV1Beta2Props(
            revision=revision, data=data, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.ControllerRevision".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeControllerRevisionV1Beta2Props(
            revision=revision, data=data, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.ControllerRevision".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeControllerRevisionV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"revision": "revision", "data": "data", "metadata": "metadata"},
)
class KubeControllerRevisionV1Beta2Props:
    def __init__(
        self,
        *,
        revision: jsii.Number,
        data: typing.Optional["RawExtension"] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision.

        See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

        :param revision: (experimental) Revision indicates the revision of the state represented by Data.
        :param data: (experimental) Data is the serialized representation of the state.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevision
        '''
        if isinstance(data, dict):
            data = RawExtension(**data)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "revision": revision,
        }
        if data is not None:
            self._values["data"] = data
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def revision(self) -> jsii.Number:
        '''(experimental) Revision indicates the revision of the state represented by Data.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevision#revision
        '''
        result = self._values.get("revision")
        assert result is not None, "Required property 'revision' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def data(self) -> typing.Optional["RawExtension"]:
        '''(experimental) Data is the serialized representation of the state.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevision#data
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional["RawExtension"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.ControllerRevision#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeControllerRevisionV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobListV1Beta1",
):
    '''(experimental) CronJobList is a collection of cron jobs.

    :stability: experimental
    :schema: io.k8s.api.batch.v1beta1.CronJobList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCronJobV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v1beta1.CronJobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCronJobListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCronJobV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCronJobListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCronJobListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCronJobV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) CronJobList is a collection of cron jobs.

        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCronJobV1Beta1Props"]:
        '''(experimental) items is the list of CronJobs.

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCronJobV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobListV2Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobListV2Alpha1",
):
    '''(experimental) CronJobList is a collection of cron jobs.

    :stability: experimental
    :schema: io.k8s.api.batch.v2alpha1.CronJobList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCronJobV2Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v2alpha1.CronJobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCronJobListV2Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCronJobV2Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v2alpha1.CronJobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCronJobListV2Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v2alpha1.CronJobList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobListV2Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCronJobListV2Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCronJobV2Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) CronJobList is a collection of cron jobs.

        :param items: (experimental) items is the list of CronJobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCronJobV2Alpha1Props"]:
        '''(experimental) items is the list of CronJobs.

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCronJobV2Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobListV2Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobV1Beta1",
):
    '''(experimental) CronJob represents the configuration of a single cron job.

    :stability: experimental
    :schema: io.k8s.api.batch.v1beta1.CronJob
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v1beta1.CronJob" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeCronJobV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeCronJobV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCronJobV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> None:
        '''(experimental) CronJob represents the configuration of a single cron job.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJob
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CronJobSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJob#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CronJobSpec]:
        '''(experimental) Specification of the desired behavior of a cron job, including the schedule.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v1beta1.CronJob#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CronJobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCronJobV2Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobV2Alpha1",
):
    '''(experimental) CronJob represents the configuration of a single cron job.

    :stability: experimental
    :schema: io.k8s.api.batch.v2alpha1.CronJob
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v2alpha1.CronJob" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeCronJobV2Alpha1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v2alpha1.CronJob".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeCronJobV2Alpha1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v2alpha1.CronJob".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCronJobV2Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeCronJobV2Alpha1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[CronJobSpec] = None,
    ) -> None:
        '''(experimental) CronJob represents the configuration of a single cron job.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJob
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = CronJobSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJob#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[CronJobSpec]:
        '''(experimental) Specification of the desired behavior of a cron job, including the schedule.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v2alpha1.CronJob#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[CronJobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCronJobV2Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiDriverListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiDriverListV1Beta1",
):
    '''(experimental) CSIDriverList is a collection of CSIDriver objects.

    :stability: experimental
    :schema: io.k8s.api.storage.v1beta1.CSIDriverList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCsiDriverV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.storage.v1beta1.CSIDriverList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of CSIDriver.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeCsiDriverListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCsiDriverV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriverList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of CSIDriver.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeCsiDriverListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriverList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiDriverListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiDriverListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCsiDriverV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) CSIDriverList is a collection of CSIDriver objects.

        :param items: (experimental) items is the list of CSIDriver.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiDriverV1Beta1Props"]:
        '''(experimental) items is the list of CSIDriver.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiDriverV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriverList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiDriverV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiDriverV1Beta1",
):
    '''(experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

    CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

    :stability: experimental
    :schema: io.k8s.api.storage.v1beta1.CSIDriver
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: CsiDriverSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.storage.v1beta1.CSIDriver" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: (experimental) Specification of the CSI Driver.
        :param metadata: (experimental) Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCsiDriverV1Beta1Props(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: CsiDriverSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIDriver".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: (experimental) Specification of the CSI Driver.
        :param metadata: (experimental) Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeCsiDriverV1Beta1Props(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIDriver".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiDriverV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiDriverV1Beta1Props:
    def __init__(
        self,
        *,
        spec: CsiDriverSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

        CSI drivers do not need to create the CSIDriver object directly. Instead they may use the cluster-driver-registrar sidecar container. When deployed with a CSI driver it automatically creates a CSIDriver object representing the driver. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

        :param spec: (experimental) Specification of the CSI Driver.
        :param metadata: (experimental) Standard object metadata. metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriver
        '''
        if isinstance(spec, dict):
            spec = CsiDriverSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiDriverSpec:
        '''(experimental) Specification of the CSI Driver.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriver#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiDriverSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata.

        metadata.Name indicates the name of the CSI driver that this object refers to; it MUST be the same name returned by the CSI GetPluginName() call for that driver. The driver name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), dots (.), and alphanumerics between. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSIDriver#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiDriverV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiNodeListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiNodeListV1Beta1",
):
    '''(experimental) CSINodeList is a collection of CSINode objects.

    :stability: experimental
    :schema: io.k8s.api.storage.v1beta1.CSINodeList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCsiNodeV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.storage.v1beta1.CSINodeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of CSINode.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeCsiNodeListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCsiNodeV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINodeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of CSINode.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        '''
        props = KubeCsiNodeListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINodeList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiNodeListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCsiNodeListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCsiNodeV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) CSINodeList is a collection of CSINode objects.

        :param items: (experimental) items is the list of CSINode.
        :param metadata: (experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCsiNodeV1Beta1Props"]:
        '''(experimental) items is the list of CSINode.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCsiNodeV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINodeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCsiNodeV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiNodeV1Beta1",
):
    '''(experimental) CSINode holds information about all CSI drivers installed on a node.

    CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

    :stability: experimental
    :schema: io.k8s.api.storage.v1beta1.CSINode
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: CsiNodeSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.storage.v1beta1.CSINode" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: (experimental) spec is the specification of CSINode.
        :param metadata: (experimental) metadata.name must be the Kubernetes node name.

        :stability: experimental
        '''
        props = KubeCsiNodeV1Beta1Props(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: CsiNodeSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSINode".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: (experimental) spec is the specification of CSINode.
        :param metadata: (experimental) metadata.name must be the Kubernetes node name.

        :stability: experimental
        '''
        props = KubeCsiNodeV1Beta1Props(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSINode".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCsiNodeV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCsiNodeV1Beta1Props:
    def __init__(
        self,
        *,
        spec: CsiNodeSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) CSINode holds information about all CSI drivers installed on a node.

        CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

        :param spec: (experimental) spec is the specification of CSINode.
        :param metadata: (experimental) metadata.name must be the Kubernetes node name.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINode
        '''
        if isinstance(spec, dict):
            spec = CsiNodeSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CsiNodeSpec:
        '''(experimental) spec is the specification of CSINode.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINode#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CsiNodeSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) metadata.name must be the Kubernetes node name.

        :stability: experimental
        :schema: io.k8s.api.storage.v1beta1.CSINode#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCsiNodeV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCustomResourceDefinitionListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCustomResourceDefinitionListV1Beta1",
):
    '''(experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

    :stability: experimental
    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeCustomResourceDefinitionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items individual CustomResourceDefinitions.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCustomResourceDefinitionListV1Beta1Props(
            items=items, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeCustomResourceDefinitionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items individual CustomResourceDefinitions.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCustomResourceDefinitionListV1Beta1Props(
            items=items, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCustomResourceDefinitionListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeCustomResourceDefinitionV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

        :param items: (experimental) Items individual CustomResourceDefinitions.
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeCustomResourceDefinitionV1Beta1Props"]:
        '''(experimental) Items individual CustomResourceDefinitions.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeCustomResourceDefinitionV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinitionList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeCustomResourceDefinitionV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCustomResourceDefinitionV1Beta1",
):
    '''(experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.

    Its name MUST be in the format <.spec.name>.<.spec.group>.

    :stability: experimental
    :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: CustomResourceDefinitionSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: (experimental) Spec describes how the user wants the resources to appear.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCustomResourceDefinitionV1Beta1Props(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: CustomResourceDefinitionSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: (experimental) Spec describes how the user wants the resources to appear.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeCustomResourceDefinitionV1Beta1Props(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeCustomResourceDefinitionV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeCustomResourceDefinitionV1Beta1Props:
    def __init__(
        self,
        *,
        spec: CustomResourceDefinitionSpec,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) CustomResourceDefinition represents a resource that should be exposed on the API server.

        Its name MUST be in the format <.spec.name>.<.spec.group>.

        :param spec: (experimental) Spec describes how the user wants the resources to appear.
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition
        '''
        if isinstance(spec, dict):
            spec = CustomResourceDefinitionSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> CustomResourceDefinitionSpec:
        '''(experimental) Spec describes how the user wants the resources to appear.

        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast(CustomResourceDefinitionSpec, result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.CustomResourceDefinition#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeCustomResourceDefinitionV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSet(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSet",
):
    '''(experimental) DaemonSet represents the configuration of a daemon set.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.DaemonSet
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.DaemonSet" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDaemonSetList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetList",
):
    '''(experimental) DaemonSetList is a collection of daemon sets.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.DaemonSetList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDaemonSetProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.DaemonSetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDaemonSetProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDaemonSetListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDaemonSetProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DaemonSetList is a collection of daemon sets.

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDaemonSetProps"]:
        '''(experimental) A list of daemon sets.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDaemonSetProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSetListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetListV1Beta1",
):
    '''(experimental) DaemonSetList is a collection of daemon sets.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.DaemonSetList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.DaemonSetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DaemonSetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DaemonSetList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDaemonSetListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DaemonSetList is a collection of daemon sets.

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDaemonSetV1Beta1Props"]:
        '''(experimental) A list of daemon sets.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDaemonSetV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSetListV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetListV1Beta2",
):
    '''(experimental) DaemonSetList is a collection of daemon sets.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.DaemonSetList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.DaemonSetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListV1Beta2Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DaemonSetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeDaemonSetListV1Beta2Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DaemonSetList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetListV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDaemonSetListV1Beta2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDaemonSetV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DaemonSetList is a collection of daemon sets.

        :param items: (experimental) A list of daemon sets.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDaemonSetV1Beta2Props"]:
        '''(experimental) A list of daemon sets.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDaemonSetV1Beta2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetListV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDaemonSetProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) DaemonSet represents the configuration of a daemon set.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSet
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DaemonSetSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSet#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DaemonSetSpec]:
        '''(experimental) The desired behavior of this daemon set.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DaemonSet#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DaemonSetSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSetV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetV1Beta1",
):
    '''(experimental) DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.

    See the release notes for more information. DaemonSet represents the configuration of a daemon set.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.DaemonSet
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.DaemonSet" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DaemonSet".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DaemonSet".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDaemonSetV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet.

        See the release notes for more information. DaemonSet represents the configuration of a daemon set.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSet
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DaemonSetSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSet#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DaemonSetSpec]:
        '''(experimental) The desired behavior of this daemon set.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DaemonSet#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DaemonSetSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDaemonSetV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetV1Beta2",
):
    '''(experimental) DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.

    See the release notes for more information. DaemonSet represents the configuration of a daemon set.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.DaemonSet
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.DaemonSet" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetV1Beta2Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DaemonSet".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeDaemonSetV1Beta2Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DaemonSet".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDaemonSetV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDaemonSetV1Beta2Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DaemonSetSpec] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet.

        See the release notes for more information. DaemonSet represents the configuration of a daemon set.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSet
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DaemonSetSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSet#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DaemonSetSpec]:
        '''(experimental) The desired behavior of this daemon set.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DaemonSet#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DaemonSetSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDaemonSetV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeployment(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeployment",
):
    '''(experimental) Deployment enables declarative updates for Pods and ReplicaSets.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.Deployment
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.Deployment" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeDeploymentList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentList",
):
    '''(experimental) DeploymentList is a list of Deployments.

    :stability: experimental
    :schema: io.k8s.api.apps.v1.DeploymentList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDeploymentProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1.DeploymentList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDeploymentProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDeploymentListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDeploymentProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DeploymentList is a list of Deployments.

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DeploymentList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDeploymentProps"]:
        '''(experimental) Items is the list of Deployments.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DeploymentList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDeploymentProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.DeploymentList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeploymentListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentListV1Beta1",
):
    '''(experimental) DeploymentList is a list of Deployments.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.DeploymentList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.DeploymentList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.DeploymentList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.DeploymentList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDeploymentListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DeploymentList is a list of Deployments.

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DeploymentList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDeploymentV1Beta1Props"]:
        '''(experimental) Items is the list of Deployments.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DeploymentList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDeploymentV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.DeploymentList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeploymentListV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentListV1Beta2",
):
    '''(experimental) DeploymentList is a list of Deployments.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.DeploymentList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.DeploymentList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListV1Beta2Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.DeploymentList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeDeploymentListV1Beta2Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.DeploymentList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentListV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeDeploymentListV1Beta2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeDeploymentV1Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DeploymentList is a list of Deployments.

        :param items: (experimental) Items is the list of Deployments.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeDeploymentV1Beta2Props"]:
        '''(experimental) Items is the list of Deployments.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeDeploymentV1Beta2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.DeploymentList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentListV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDeploymentProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) Deployment enables declarative updates for Pods and ReplicaSets.

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.Deployment
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DeploymentSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.Deployment#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DeploymentSpec]:
        '''(experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.apps.v1.Deployment#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DeploymentSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeploymentV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentV1Beta1",
):
    '''(experimental) DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.

    See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.Deployment
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.Deployment" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.Deployment".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.Deployment".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDeploymentV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment.

        See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.Deployment
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DeploymentSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.Deployment#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DeploymentSpec]:
        '''(experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.Deployment#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DeploymentSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeDeploymentV1Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentV1Beta2",
):
    '''(experimental) DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.

    See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

    :stability: experimental
    :schema: io.k8s.api.apps.v1beta2.Deployment
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.apps.v1beta2.Deployment" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentV1Beta2Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.apps.v1beta2.Deployment".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        '''
        props = KubeDeploymentV1Beta2Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.apps.v1beta2.Deployment".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeDeploymentV1Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeDeploymentV1Beta2Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[DeploymentSpec] = None,
    ) -> None:
        '''(experimental) DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment.

        See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.

        :param metadata: (experimental) Standard object metadata.
        :param spec: (experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.Deployment
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = DeploymentSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.Deployment#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[DeploymentSpec]:
        '''(experimental) Specification of the desired behavior of the Deployment.

        :stability: experimental
        :schema: io.k8s.api.apps.v1beta2.Deployment#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[DeploymentSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeDeploymentV1Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEndpoints(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEndpoints",
):
    '''(experimental) Endpoints is a collection of endpoints that implement the actual service.

    Example:
    Name: "mysvc",
    Subsets: [
    {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    },
    {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
    },
    ]

    :stability: experimental
    :schema: io.k8s.api.core.v1.Endpoints
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        subsets: typing.Optional[typing.Sequence[EndpointSubset]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Endpoints" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param subsets: (experimental) The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :stability: experimental
        '''
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        subsets: typing.Optional[typing.Sequence[EndpointSubset]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param subsets: (experimental) The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :stability: experimental
        '''
        props = KubeEndpointsProps(metadata=metadata, subsets=subsets)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEndpointsList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEndpointsList",
):
    '''(experimental) EndpointsList is a list of endpoints.

    :stability: experimental
    :schema: io.k8s.api.core.v1.EndpointsList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeEndpointsProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.EndpointsList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of endpoints.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeEndpointsProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of endpoints.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeEndpointsListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEndpointsListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEndpointsListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeEndpointsProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) EndpointsList is a list of endpoints.

        :param items: (experimental) List of endpoints.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointsList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEndpointsProps"]:
        '''(experimental) List of endpoints.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointsList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEndpointsProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.EndpointsList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEndpointsProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "subsets": "subsets"},
)
class KubeEndpointsProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        subsets: typing.Optional[typing.Sequence[EndpointSubset]] = None,
    ) -> None:
        '''(experimental) Endpoints is a collection of endpoints that implement the actual service.

        Example:
        Name: "mysvc",
        Subsets: [
        {
        Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        },
        {
        Addresses: [{"ip": "10.10.3.3"}],
        Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
        },
        ]

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param subsets: (experimental) The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Endpoints
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if subsets is not None:
            self._values["subsets"] = subsets

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Endpoints#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def subsets(self) -> typing.Optional[typing.List[EndpointSubset]]:
        '''(experimental) The set of all endpoints is the union of all subsets.

        Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Endpoints#subsets
        '''
        result = self._values.get("subsets")
        return typing.cast(typing.Optional[typing.List[EndpointSubset]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEndpointsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEvent(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEvent",
):
    '''(experimental) Event is a report of an event somewhere in the cluster.

    :stability: experimental
    :schema: io.k8s.api.core.v1.Event
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        involved_object: "ObjectReference",
        metadata: "ObjectMeta",
        action: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        event_time: typing.Optional[datetime.datetime] = None,
        first_timestamp: typing.Optional[datetime.datetime] = None,
        last_timestamp: typing.Optional[datetime.datetime] = None,
        message: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_component: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        source: typing.Optional[EventSource] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Event" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param involved_object: (experimental) The object that this event is about.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param action: (experimental) What action was taken/failed regarding to the Regarding object.
        :param count: (experimental) The number of times this event has occurred.
        :param event_time: (experimental) Time when this Event was first observed.
        :param first_timestamp: (experimental) The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param last_timestamp: (experimental) The time at which the most recent occurrence of this event was recorded.
        :param message: (experimental) A human-readable description of the status of this operation.
        :param reason: (experimental) This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param related: (experimental) Optional secondary object for more complex actions.
        :param reporting_component: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param source: (experimental) The component reporting this event. Should be a short machine understandable string.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        '''
        props = KubeEventProps(
            involved_object=involved_object,
            metadata=metadata,
            action=action,
            count=count,
            event_time=event_time,
            first_timestamp=first_timestamp,
            last_timestamp=last_timestamp,
            message=message,
            reason=reason,
            related=related,
            reporting_component=reporting_component,
            reporting_instance=reporting_instance,
            series=series,
            source=source,
            type=type,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        involved_object: "ObjectReference",
        metadata: "ObjectMeta",
        action: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        event_time: typing.Optional[datetime.datetime] = None,
        first_timestamp: typing.Optional[datetime.datetime] = None,
        last_timestamp: typing.Optional[datetime.datetime] = None,
        message: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_component: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        source: typing.Optional[EventSource] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Event".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param involved_object: (experimental) The object that this event is about.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param action: (experimental) What action was taken/failed regarding to the Regarding object.
        :param count: (experimental) The number of times this event has occurred.
        :param event_time: (experimental) Time when this Event was first observed.
        :param first_timestamp: (experimental) The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param last_timestamp: (experimental) The time at which the most recent occurrence of this event was recorded.
        :param message: (experimental) A human-readable description of the status of this operation.
        :param reason: (experimental) This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param related: (experimental) Optional secondary object for more complex actions.
        :param reporting_component: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param source: (experimental) The component reporting this event. Should be a short machine understandable string.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        '''
        props = KubeEventProps(
            involved_object=involved_object,
            metadata=metadata,
            action=action,
            count=count,
            event_time=event_time,
            first_timestamp=first_timestamp,
            last_timestamp=last_timestamp,
            message=message,
            reason=reason,
            related=related,
            reporting_component=reporting_component,
            reporting_instance=reporting_instance,
            series=series,
            source=source,
            type=type,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Event".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeEventList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventList",
):
    '''(experimental) EventList is a list of events.

    :stability: experimental
    :schema: io.k8s.api.core.v1.EventList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeEventProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.EventList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of events.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeEventListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeEventProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.EventList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of events.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeEventListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.EventList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEventListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeEventProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) EventList is a list of events.

        :param items: (experimental) List of events.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEventProps"]:
        '''(experimental) List of events.

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEventProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.EventList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEventListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventListV1Beta1",
):
    '''(experimental) EventList is a list of Event objects.

    :stability: experimental
    :schema: io.k8s.api.events.v1beta1.EventList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeEventV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.events.v1beta1.EventList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeEventListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeEventV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.EventList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeEventListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.EventList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeEventListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeEventV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) EventList is a list of Event objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeEventV1Beta1Props"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeEventV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.EventList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventProps",
    jsii_struct_bases=[],
    name_mapping={
        "involved_object": "involvedObject",
        "metadata": "metadata",
        "action": "action",
        "count": "count",
        "event_time": "eventTime",
        "first_timestamp": "firstTimestamp",
        "last_timestamp": "lastTimestamp",
        "message": "message",
        "reason": "reason",
        "related": "related",
        "reporting_component": "reportingComponent",
        "reporting_instance": "reportingInstance",
        "series": "series",
        "source": "source",
        "type": "type",
    },
)
class KubeEventProps:
    def __init__(
        self,
        *,
        involved_object: "ObjectReference",
        metadata: "ObjectMeta",
        action: typing.Optional[builtins.str] = None,
        count: typing.Optional[jsii.Number] = None,
        event_time: typing.Optional[datetime.datetime] = None,
        first_timestamp: typing.Optional[datetime.datetime] = None,
        last_timestamp: typing.Optional[datetime.datetime] = None,
        message: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_component: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        source: typing.Optional[EventSource] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Event is a report of an event somewhere in the cluster.

        :param involved_object: (experimental) The object that this event is about.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param action: (experimental) What action was taken/failed regarding to the Regarding object.
        :param count: (experimental) The number of times this event has occurred.
        :param event_time: (experimental) Time when this Event was first observed.
        :param first_timestamp: (experimental) The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param last_timestamp: (experimental) The time at which the most recent occurrence of this event was recorded.
        :param message: (experimental) A human-readable description of the status of this operation.
        :param reason: (experimental) This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param related: (experimental) Optional secondary object for more complex actions.
        :param reporting_component: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param source: (experimental) The component reporting this event. Should be a short machine understandable string.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event
        '''
        if isinstance(involved_object, dict):
            involved_object = ObjectReference(**involved_object)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(related, dict):
            related = ObjectReference(**related)
        if isinstance(series, dict):
            series = EventSeries(**series)
        if isinstance(source, dict):
            source = EventSource(**source)
        self._values: typing.Dict[str, typing.Any] = {
            "involved_object": involved_object,
            "metadata": metadata,
        }
        if action is not None:
            self._values["action"] = action
        if count is not None:
            self._values["count"] = count
        if event_time is not None:
            self._values["event_time"] = event_time
        if first_timestamp is not None:
            self._values["first_timestamp"] = first_timestamp
        if last_timestamp is not None:
            self._values["last_timestamp"] = last_timestamp
        if message is not None:
            self._values["message"] = message
        if reason is not None:
            self._values["reason"] = reason
        if related is not None:
            self._values["related"] = related
        if reporting_component is not None:
            self._values["reporting_component"] = reporting_component
        if reporting_instance is not None:
            self._values["reporting_instance"] = reporting_instance
        if series is not None:
            self._values["series"] = series
        if source is not None:
            self._values["source"] = source
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def involved_object(self) -> "ObjectReference":
        '''(experimental) The object that this event is about.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#involvedObject
        '''
        result = self._values.get("involved_object")
        assert result is not None, "Required property 'involved_object' is missing"
        return typing.cast("ObjectReference", result)

    @builtins.property
    def metadata(self) -> "ObjectMeta":
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#metadata
        '''
        result = self._values.get("metadata")
        assert result is not None, "Required property 'metadata' is missing"
        return typing.cast("ObjectMeta", result)

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        '''(experimental) What action was taken/failed regarding to the Regarding object.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#action
        '''
        result = self._values.get("action")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The number of times this event has occurred.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#count
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def event_time(self) -> typing.Optional[datetime.datetime]:
        '''(experimental) Time when this Event was first observed.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#eventTime
        '''
        result = self._values.get("event_time")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def first_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''(experimental) The time at which the event was first recorded.

        (Time of server receipt is in TypeMeta.)

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#firstTimestamp
        '''
        result = self._values.get("first_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def last_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''(experimental) The time at which the most recent occurrence of this event was recorded.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#lastTimestamp
        '''
        result = self._values.get("last_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def message(self) -> typing.Optional[builtins.str]:
        '''(experimental) A human-readable description of the status of this operation.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#message
        '''
        result = self._values.get("message")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reason(self) -> typing.Optional[builtins.str]:
        '''(experimental) This should be a short, machine understandable string that gives the reason for the transition into the object's current status.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#reason
        '''
        result = self._values.get("reason")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def related(self) -> typing.Optional["ObjectReference"]:
        '''(experimental) Optional secondary object for more complex actions.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#related
        '''
        result = self._values.get("related")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def reporting_component(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#reportingComponent
        '''
        result = self._values.get("reporting_component")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reporting_instance(self) -> typing.Optional[builtins.str]:
        '''(experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#reportingInstance
        '''
        result = self._values.get("reporting_instance")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def series(self) -> typing.Optional[EventSeries]:
        '''(experimental) Data about the Event series this event represents or nil if it's a singleton Event.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#series
        '''
        result = self._values.get("series")
        return typing.cast(typing.Optional[EventSeries], result)

    @builtins.property
    def source(self) -> typing.Optional[EventSource]:
        '''(experimental) The component reporting this event.

        Should be a short machine understandable string.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#source
        '''
        result = self._values.get("source")
        return typing.cast(typing.Optional[EventSource], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        :schema: io.k8s.api.core.v1.Event#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEventV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventV1Beta1",
):
    '''(experimental) Event is a report of an event somewhere in the cluster.

    It generally denotes some state change in the system.

    :stability: experimental
    :schema: io.k8s.api.events.v1beta1.Event
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[EventSource] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional["ObjectReference"] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.events.v1beta1.Event" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param event_time: (experimental) Required. Time when this Event was first observed.
        :param action: (experimental) What action was taken/failed regarding to the regarding object.
        :param deprecated_count: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: 
        :param note: (experimental) Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: (experimental) Why the action was taken.
        :param regarding: (experimental) The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: (experimental) Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        '''
        props = KubeEventV1Beta1Props(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[EventSource] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional["ObjectReference"] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.Event".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param event_time: (experimental) Required. Time when this Event was first observed.
        :param action: (experimental) What action was taken/failed regarding to the regarding object.
        :param deprecated_count: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: 
        :param note: (experimental) Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: (experimental) Why the action was taken.
        :param regarding: (experimental) The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: (experimental) Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        '''
        props = KubeEventV1Beta1Props(
            event_time=event_time,
            action=action,
            deprecated_count=deprecated_count,
            deprecated_first_timestamp=deprecated_first_timestamp,
            deprecated_last_timestamp=deprecated_last_timestamp,
            deprecated_source=deprecated_source,
            metadata=metadata,
            note=note,
            reason=reason,
            regarding=regarding,
            related=related,
            reporting_controller=reporting_controller,
            reporting_instance=reporting_instance,
            series=series,
            type=type,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.Event".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEventV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={
        "event_time": "eventTime",
        "action": "action",
        "deprecated_count": "deprecatedCount",
        "deprecated_first_timestamp": "deprecatedFirstTimestamp",
        "deprecated_last_timestamp": "deprecatedLastTimestamp",
        "deprecated_source": "deprecatedSource",
        "metadata": "metadata",
        "note": "note",
        "reason": "reason",
        "regarding": "regarding",
        "related": "related",
        "reporting_controller": "reportingController",
        "reporting_instance": "reportingInstance",
        "series": "series",
        "type": "type",
    },
)
class KubeEventV1Beta1Props:
    def __init__(
        self,
        *,
        event_time: datetime.datetime,
        action: typing.Optional[builtins.str] = None,
        deprecated_count: typing.Optional[jsii.Number] = None,
        deprecated_first_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_last_timestamp: typing.Optional[datetime.datetime] = None,
        deprecated_source: typing.Optional[EventSource] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        note: typing.Optional[builtins.str] = None,
        reason: typing.Optional[builtins.str] = None,
        regarding: typing.Optional["ObjectReference"] = None,
        related: typing.Optional["ObjectReference"] = None,
        reporting_controller: typing.Optional[builtins.str] = None,
        reporting_instance: typing.Optional[builtins.str] = None,
        series: typing.Optional[EventSeries] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Event is a report of an event somewhere in the cluster.

        It generally denotes some state change in the system.

        :param event_time: (experimental) Required. Time when this Event was first observed.
        :param action: (experimental) What action was taken/failed regarding to the regarding object.
        :param deprecated_count: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_first_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_last_timestamp: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param deprecated_source: (experimental) Deprecated field assuring backward compatibility with core.v1 Event type.
        :param metadata: 
        :param note: (experimental) Optional. A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.
        :param reason: (experimental) Why the action was taken.
        :param regarding: (experimental) The object this Event is about. In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.
        :param related: (experimental) Optional secondary object for more complex actions. E.g. when regarding object triggers a creation or deletion of related object.
        :param reporting_controller: (experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.
        :param reporting_instance: (experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.
        :param series: (experimental) Data about the Event series this event represents or nil if it's a singleton Event.
        :param type: (experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event
        '''
        if isinstance(deprecated_source, dict):
            deprecated_source = EventSource(**deprecated_source)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(regarding, dict):
            regarding = ObjectReference(**regarding)
        if isinstance(related, dict):
            related = ObjectReference(**related)
        if isinstance(series, dict):
            series = EventSeries(**series)
        self._values: typing.Dict[str, typing.Any] = {
            "event_time": event_time,
        }
        if action is not None:
            self._values["action"] = action
        if deprecated_count is not None:
            self._values["deprecated_count"] = deprecated_count
        if deprecated_first_timestamp is not None:
            self._values["deprecated_first_timestamp"] = deprecated_first_timestamp
        if deprecated_last_timestamp is not None:
            self._values["deprecated_last_timestamp"] = deprecated_last_timestamp
        if deprecated_source is not None:
            self._values["deprecated_source"] = deprecated_source
        if metadata is not None:
            self._values["metadata"] = metadata
        if note is not None:
            self._values["note"] = note
        if reason is not None:
            self._values["reason"] = reason
        if regarding is not None:
            self._values["regarding"] = regarding
        if related is not None:
            self._values["related"] = related
        if reporting_controller is not None:
            self._values["reporting_controller"] = reporting_controller
        if reporting_instance is not None:
            self._values["reporting_instance"] = reporting_instance
        if series is not None:
            self._values["series"] = series
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def event_time(self) -> datetime.datetime:
        '''(experimental) Required.

        Time when this Event was first observed.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#eventTime
        '''
        result = self._values.get("event_time")
        assert result is not None, "Required property 'event_time' is missing"
        return typing.cast(datetime.datetime, result)

    @builtins.property
    def action(self) -> typing.Optional[builtins.str]:
        '''(experimental) What action was taken/failed regarding to the regarding object.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#action
        '''
        result = self._values.get("action")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def deprecated_count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Deprecated field assuring backward compatibility with core.v1 Event type.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#deprecatedCount
        '''
        result = self._values.get("deprecated_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def deprecated_first_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''(experimental) Deprecated field assuring backward compatibility with core.v1 Event type.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#deprecatedFirstTimestamp
        '''
        result = self._values.get("deprecated_first_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def deprecated_last_timestamp(self) -> typing.Optional[datetime.datetime]:
        '''(experimental) Deprecated field assuring backward compatibility with core.v1 Event type.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#deprecatedLastTimestamp
        '''
        result = self._values.get("deprecated_last_timestamp")
        return typing.cast(typing.Optional[datetime.datetime], result)

    @builtins.property
    def deprecated_source(self) -> typing.Optional[EventSource]:
        '''(experimental) Deprecated field assuring backward compatibility with core.v1 Event type.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#deprecatedSource
        '''
        result = self._values.get("deprecated_source")
        return typing.cast(typing.Optional[EventSource], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def note(self) -> typing.Optional[builtins.str]:
        '''(experimental) Optional.

        A human-readable description of the status of this operation. Maximal length of the note is 1kB, but libraries should be prepared to handle values up to 64kB.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#note
        '''
        result = self._values.get("note")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reason(self) -> typing.Optional[builtins.str]:
        '''(experimental) Why the action was taken.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#reason
        '''
        result = self._values.get("reason")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def regarding(self) -> typing.Optional["ObjectReference"]:
        '''(experimental) The object this Event is about.

        In most cases it's an Object reporting controller implements. E.g. ReplicaSetController implements ReplicaSets and this event is emitted because it acts on some changes in a ReplicaSet object.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#regarding
        '''
        result = self._values.get("regarding")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def related(self) -> typing.Optional["ObjectReference"]:
        '''(experimental) Optional secondary object for more complex actions.

        E.g. when regarding object triggers a creation or deletion of related object.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#related
        '''
        result = self._values.get("related")
        return typing.cast(typing.Optional["ObjectReference"], result)

    @builtins.property
    def reporting_controller(self) -> typing.Optional[builtins.str]:
        '''(experimental) Name of the controller that emitted this Event, e.g. ``kubernetes.io/kubelet``.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#reportingController
        '''
        result = self._values.get("reporting_controller")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def reporting_instance(self) -> typing.Optional[builtins.str]:
        '''(experimental) ID of the controller instance, e.g. ``kubelet-xyzf``.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#reportingInstance
        '''
        result = self._values.get("reporting_instance")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def series(self) -> typing.Optional[EventSeries]:
        '''(experimental) Data about the Event series this event represents or nil if it's a singleton Event.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#series
        '''
        result = self._values.get("series")
        return typing.cast(typing.Optional[EventSeries], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) Type of this event (Normal, Warning), new types could be added in the future.

        :stability: experimental
        :schema: io.k8s.api.events.v1beta1.Event#type
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEventV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeEvictionV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEvictionV1Beta1",
):
    '''(experimental) Eviction evicts a pod from its node subject to certain policies and safety constraints.

    This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods//evictions.

    :stability: experimental
    :schema: io.k8s.api.policy.v1beta1.Eviction
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        delete_options: typing.Optional[DeleteOptions] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.policy.v1beta1.Eviction" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param delete_options: (experimental) DeleteOptions may be provided.
        :param metadata: (experimental) ObjectMeta describes the pod that is being evicted.

        :stability: experimental
        '''
        props = KubeEvictionV1Beta1Props(
            delete_options=delete_options, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        delete_options: typing.Optional[DeleteOptions] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.Eviction".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param delete_options: (experimental) DeleteOptions may be provided.
        :param metadata: (experimental) ObjectMeta describes the pod that is being evicted.

        :stability: experimental
        '''
        props = KubeEvictionV1Beta1Props(
            delete_options=delete_options, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.Eviction".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeEvictionV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"delete_options": "deleteOptions", "metadata": "metadata"},
)
class KubeEvictionV1Beta1Props:
    def __init__(
        self,
        *,
        delete_options: typing.Optional[DeleteOptions] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Eviction evicts a pod from its node subject to certain policies and safety constraints.

        This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods//evictions.

        :param delete_options: (experimental) DeleteOptions may be provided.
        :param metadata: (experimental) ObjectMeta describes the pod that is being evicted.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.Eviction
        '''
        if isinstance(delete_options, dict):
            delete_options = DeleteOptions(**delete_options)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if delete_options is not None:
            self._values["delete_options"] = delete_options
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def delete_options(self) -> typing.Optional[DeleteOptions]:
        '''(experimental) DeleteOptions may be provided.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.Eviction#deleteOptions
        '''
        result = self._values.get("delete_options")
        return typing.cast(typing.Optional[DeleteOptions], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) ObjectMeta describes the pod that is being evicted.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.Eviction#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeEvictionV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscaler(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscaler",
):
    '''(experimental) configuration of a horizontal pod autoscaler.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeHorizontalPodAutoscalerList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerList",
):
    '''(experimental) list of horizontal pod autoscaler objects.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) list of horizontal pod autoscaler objects.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) list of horizontal pod autoscaler objects.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeHorizontalPodAutoscalerListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) list of horizontal pod autoscaler objects.

        :param items: (experimental) list of horizontal pod autoscaler objects.
        :param metadata: (experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeHorizontalPodAutoscalerProps"]:
        '''(experimental) list of horizontal pod autoscaler objects.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeHorizontalPodAutoscalerProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerListV2Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerListV2Beta1",
):
    '''(experimental) HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListV2Beta1Props(
            items=items, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListV2Beta1Props(
            items=items, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerListV2Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeHorizontalPodAutoscalerListV2Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.

        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeHorizontalPodAutoscalerV2Beta1Props"]:
        '''(experimental) items is the list of horizontal pod autoscaler objects.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeHorizontalPodAutoscalerV2Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) metadata is the standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerListV2Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerListV2Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerListV2Beta2",
):
    '''(experimental) HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListV2Beta2Props(
            items=items, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerListV2Beta2Props(
            items=items, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerListV2Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeHorizontalPodAutoscalerListV2Beta2Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeHorizontalPodAutoscalerV2Beta2Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

        :param items: (experimental) items is the list of horizontal pod autoscaler objects.
        :param metadata: (experimental) metadata is the standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeHorizontalPodAutoscalerV2Beta2Props"]:
        '''(experimental) items is the list of horizontal pod autoscaler objects.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeHorizontalPodAutoscalerV2Beta2Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) metadata is the standard list metadata.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerListV2Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeHorizontalPodAutoscalerProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) configuration of a horizontal pod autoscaler.

        :param metadata: (experimental) Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = HorizontalPodAutoscalerSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[HorizontalPodAutoscalerSpec]:
        '''(experimental) behaviour of autoscaler.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerV2Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerV2Beta1",
):
    '''(experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerV2Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerV2Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerV2Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeHorizontalPodAutoscalerV2Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = HorizontalPodAutoscalerSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) metadata is the standard object metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[HorizontalPodAutoscalerSpec]:
        '''(experimental) spec is the specification for the behaviour of the autoscaler.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerV2Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeHorizontalPodAutoscalerV2Beta2(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerV2Beta2",
):
    '''(experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

    :stability: experimental
    :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerV2Beta2Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        '''
        props = KubeHorizontalPodAutoscalerV2Beta2Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeHorizontalPodAutoscalerV2Beta2Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeHorizontalPodAutoscalerV2Beta2Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[HorizontalPodAutoscalerSpec] = None,
    ) -> None:
        '''(experimental) HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

        :param metadata: (experimental) metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = HorizontalPodAutoscalerSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) metadata is the standard object metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[HorizontalPodAutoscalerSpec]:
        '''(experimental) spec is the specification for the behaviour of the autoscaler.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status.

        :stability: experimental
        :schema: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[HorizontalPodAutoscalerSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeHorizontalPodAutoscalerV2Beta2Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeIngressListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeIngressListV1Beta1",
):
    '''(experimental) IngressList is a collection of Ingress.

    :stability: experimental
    :schema: io.k8s.api.networking.v1beta1.IngressList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeIngressV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.networking.v1beta1.IngressList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of Ingress.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeIngressListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeIngressV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.IngressList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of Ingress.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeIngressListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.IngressList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeIngressListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeIngressListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeIngressV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) IngressList is a collection of Ingress.

        :param items: (experimental) Items is the list of Ingress.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeIngressV1Beta1Props"]:
        '''(experimental) Items is the list of Ingress.

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeIngressV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.IngressList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeIngressListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeIngressV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeIngressV1Beta1",
):
    '''(experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

    An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

    :stability: experimental
    :schema: io.k8s.api.networking.v1beta1.Ingress
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[IngressSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.networking.v1beta1.Ingress" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeIngressV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[IngressSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1beta1.Ingress".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeIngressV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1beta1.Ingress".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeIngressV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeIngressV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[IngressSpec] = None,
    ) -> None:
        '''(experimental) Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

        An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.Ingress
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = IngressSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.Ingress#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[IngressSpec]:
        '''(experimental) Spec is the desired state of the Ingress.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.networking.v1beta1.Ingress#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[IngressSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeIngressV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeJob(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeJob",
):
    '''(experimental) Job represents the configuration of a single job.

    :stability: experimental
    :schema: io.k8s.api.batch.v1.Job
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[JobSpec] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v1.Job" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeJobProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[JobSpec] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.Job".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeJobProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.Job".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeJobList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeJobList",
):
    '''(experimental) JobList is a collection of jobs.

    :stability: experimental
    :schema: io.k8s.api.batch.v1.JobList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeJobProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.batch.v1.JobList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is the list of Jobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeJobListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeJobProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.batch.v1.JobList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is the list of Jobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeJobListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.batch.v1.JobList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeJobListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeJobListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeJobProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) JobList is a collection of jobs.

        :param items: (experimental) items is the list of Jobs.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeJobProps"]:
        '''(experimental) items is the list of Jobs.

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeJobProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1.JobList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeJobListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeJobProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeJobProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional[JobSpec] = None,
    ) -> None:
        '''(experimental) Job represents the configuration of a single job.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v1.Job
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = JobSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.batch.v1.Job#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional[JobSpec]:
        '''(experimental) Specification of the desired behavior of a job.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.batch.v1.Job#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional[JobSpec], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeJobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLease(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLease",
):
    '''(experimental) Lease defines a lease concept.

    :stability: experimental
    :schema: io.k8s.api.coordination.v1.Lease
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.coordination.v1.Lease" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLeaseProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.Lease".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLeaseProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1.Lease".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeLeaseList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseList",
):
    '''(experimental) LeaseList is a list of Lease objects.

    :stability: experimental
    :schema: io.k8s.api.coordination.v1.LeaseList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeLeaseProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.coordination.v1.LeaseList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeLeaseListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeLeaseProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.LeaseList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeLeaseListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1.LeaseList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeLeaseListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeLeaseProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) LeaseList is a list of Lease objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.LeaseList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeLeaseProps"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.LeaseList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeLeaseProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.LeaseList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLeaseListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLeaseListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseListV1Beta1",
):
    '''(experimental) LeaseList is a list of Lease objects.

    :stability: experimental
    :schema: io.k8s.api.coordination.v1beta1.LeaseList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeLeaseV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.coordination.v1beta1.LeaseList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeLeaseListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeLeaseV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.LeaseList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeLeaseListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.LeaseList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeLeaseListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeLeaseV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) LeaseList is a list of Lease objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.LeaseList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeLeaseV1Beta1Props"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.LeaseList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeLeaseV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.LeaseList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLeaseListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeLeaseProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> None:
        '''(experimental) Lease defines a lease concept.

        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.Lease
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = LeaseSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.Lease#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["LeaseSpec"]:
        '''(experimental) Specification of the Lease.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.coordination.v1.Lease#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["LeaseSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLeaseProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLeaseV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseV1Beta1",
):
    '''(experimental) Lease defines a lease concept.

    :stability: experimental
    :schema: io.k8s.api.coordination.v1beta1.Lease
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.coordination.v1beta1.Lease" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLeaseV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.coordination.v1beta1.Lease".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLeaseV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.coordination.v1beta1.Lease".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLeaseV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeLeaseV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LeaseSpec"] = None,
    ) -> None:
        '''(experimental) Lease defines a lease concept.

        :param metadata: (experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param spec: (experimental) Specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.Lease
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = LeaseSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.Lease#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["LeaseSpec"]:
        '''(experimental) Specification of the Lease.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.coordination.v1beta1.Lease#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["LeaseSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLeaseV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLimitRange(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLimitRange",
):
    '''(experimental) LimitRange sets resource usage limits for each kind of resource in a Namespace.

    :stability: experimental
    :schema: io.k8s.api.core.v1.LimitRange
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LimitRangeSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.LimitRange" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLimitRangeProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LimitRangeSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRange".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeLimitRangeProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRange".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeLimitRangeList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLimitRangeList",
):
    '''(experimental) LimitRangeList is a list of LimitRange items.

    :stability: experimental
    :schema: io.k8s.api.core.v1.LimitRangeList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeLimitRangeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.LimitRangeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of LimitRange objects. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeLimitRangeListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeLimitRangeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRangeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of LimitRange objects. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeLimitRangeListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRangeList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLimitRangeListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeLimitRangeListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeLimitRangeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) LimitRangeList is a list of LimitRange items.

        :param items: (experimental) Items is a list of LimitRange objects. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRangeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeLimitRangeProps"]:
        '''(experimental) Items is a list of LimitRange objects.

        More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRangeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeLimitRangeProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRangeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLimitRangeListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLimitRangeProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeLimitRangeProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["LimitRangeSpec"] = None,
    ) -> None:
        '''(experimental) LimitRange sets resource usage limits for each kind of resource in a Namespace.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRange
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = LimitRangeSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRange#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["LimitRangeSpec"]:
        '''(experimental) Spec defines the limits enforced.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.LimitRange#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["LimitRangeSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLimitRangeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLocalSubjectAccessReview(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLocalSubjectAccessReview",
):
    '''(experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

    Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

    :stability: experimental
    :schema: io.k8s.api.authorization.v1.LocalSubjectAccessReview
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.authorization.v1.LocalSubjectAccessReview" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeLocalSubjectAccessReviewProps(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeLocalSubjectAccessReviewProps(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLocalSubjectAccessReviewProps",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeLocalSubjectAccessReviewProps:
    def __init__(
        self,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

        Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.api.authorization.v1.LocalSubjectAccessReview
        '''
        if isinstance(spec, dict):
            spec = SubjectAccessReviewSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> "SubjectAccessReviewSpec":
        '''(experimental) Spec holds information about the request being evaluated.

        spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.

        :stability: experimental
        :schema: io.k8s.api.authorization.v1.LocalSubjectAccessReview#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast("SubjectAccessReviewSpec", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.authorization.v1.LocalSubjectAccessReview#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLocalSubjectAccessReviewProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeLocalSubjectAccessReviewV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLocalSubjectAccessReviewV1Beta1",
):
    '''(experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

    Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

    :stability: experimental
    :schema: io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeLocalSubjectAccessReviewV1Beta1Props(spec=spec, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        '''
        props = KubeLocalSubjectAccessReviewV1Beta1Props(spec=spec, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeLocalSubjectAccessReviewV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"spec": "spec", "metadata": "metadata"},
)
class KubeLocalSubjectAccessReviewV1Beta1Props:
    def __init__(
        self,
        *,
        spec: "SubjectAccessReviewSpec",
        metadata: typing.Optional["ObjectMeta"] = None,
    ) -> None:
        '''(experimental) LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

        Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

        :param spec: (experimental) Spec holds information about the request being evaluated. spec.namespace must be equal to the namespace you made the request against. If empty, it is defaulted.
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview
        '''
        if isinstance(spec, dict):
            spec = SubjectAccessReviewSpec(**spec)
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "spec": spec,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def spec(self) -> "SubjectAccessReviewSpec":
        '''(experimental) Spec holds information about the request being evaluated.

        spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.

        :stability: experimental
        :schema: io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview#spec
        '''
        result = self._values.get("spec")
        assert result is not None, "Required property 'spec' is missing"
        return typing.cast("SubjectAccessReviewSpec", result)

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.authorization.v1beta1.LocalSubjectAccessReview#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeLocalSubjectAccessReviewV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeMutatingWebhookConfigurationListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeMutatingWebhookConfigurationListV1Beta1",
):
    '''(experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.

    :stability: experimental
    :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeMutatingWebhookConfigurationV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of MutatingWebhookConfiguration.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeMutatingWebhookConfigurationListV1Beta1Props(
            items=items, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeMutatingWebhookConfigurationV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of MutatingWebhookConfiguration.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeMutatingWebhookConfigurationListV1Beta1Props(
            items=items, metadata=metadata
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeMutatingWebhookConfigurationListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeMutatingWebhookConfigurationListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeMutatingWebhookConfigurationV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.

        :param items: (experimental) List of MutatingWebhookConfiguration.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeMutatingWebhookConfigurationV1Beta1Props"]:
        '''(experimental) List of MutatingWebhookConfiguration.

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeMutatingWebhookConfigurationV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfigurationList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeMutatingWebhookConfigurationListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeMutatingWebhookConfigurationV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeMutatingWebhookConfigurationV1Beta1",
):
    '''(experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.

    :stability: experimental
    :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        webhooks: typing.Optional[typing.Sequence["MutatingWebhook"]] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param webhooks: (experimental) Webhooks is a list of webhooks and the affected resources and operations.

        :stability: experimental
        '''
        props = KubeMutatingWebhookConfigurationV1Beta1Props(
            metadata=metadata, webhooks=webhooks
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        webhooks: typing.Optional[typing.Sequence["MutatingWebhook"]] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param webhooks: (experimental) Webhooks is a list of webhooks and the affected resources and operations.

        :stability: experimental
        '''
        props = KubeMutatingWebhookConfigurationV1Beta1Props(
            metadata=metadata, webhooks=webhooks
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeMutatingWebhookConfigurationV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "webhooks": "webhooks"},
)
class KubeMutatingWebhookConfigurationV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        webhooks: typing.Optional[typing.Sequence["MutatingWebhook"]] = None,
    ) -> None:
        '''(experimental) MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.

        :param metadata: (experimental) Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.
        :param webhooks: (experimental) Webhooks is a list of webhooks and the affected resources and operations.

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if webhooks is not None:
            self._values["webhooks"] = webhooks

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object metadata;

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def webhooks(self) -> typing.Optional[typing.List["MutatingWebhook"]]:
        '''(experimental) Webhooks is a list of webhooks and the affected resources and operations.

        :stability: experimental
        :schema: io.k8s.api.admissionregistration.v1beta1.MutatingWebhookConfiguration#webhooks
        '''
        result = self._values.get("webhooks")
        return typing.cast(typing.Optional[typing.List["MutatingWebhook"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeMutatingWebhookConfigurationV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeNamespace(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNamespace",
):
    '''(experimental) Namespace provides a scope for Names.

    Use of multiple namespaces is optional.

    :stability: experimental
    :schema: io.k8s.api.core.v1.Namespace
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NamespaceSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Namespace" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeNamespaceProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NamespaceSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Namespace".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeNamespaceProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Namespace".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeNamespaceList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNamespaceList",
):
    '''(experimental) NamespaceList is a list of Namespaces.

    :stability: experimental
    :schema: io.k8s.api.core.v1.NamespaceList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeNamespaceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.NamespaceList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeNamespaceListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeNamespaceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.NamespaceList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeNamespaceListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.NamespaceList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNamespaceListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeNamespaceListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeNamespaceProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) NamespaceList is a list of Namespaces.

        :param items: (experimental) Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.NamespaceList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeNamespaceProps"]:
        '''(experimental) Items is the list of Namespace objects in the list.

        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/

        :stability: experimental
        :schema: io.k8s.api.core.v1.NamespaceList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeNamespaceProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.NamespaceList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNamespaceListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNamespaceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeNamespaceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NamespaceSpec"] = None,
    ) -> None:
        '''(experimental) Namespace provides a scope for Names.

        Use of multiple namespaces is optional.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Namespace
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = NamespaceSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Namespace#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["NamespaceSpec"]:
        '''(experimental) Spec defines the behavior of the Namespace.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Namespace#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["NamespaceSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNamespaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeNetworkPolicy(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicy",
):
    '''(experimental) NetworkPolicy describes what network traffic is allowed for a set of Pods.

    :stability: experimental
    :schema: io.k8s.api.networking.v1.NetworkPolicy
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.networking.v1.NetworkPolicy" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        '''
        props = KubeNetworkPolicyProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicy".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        '''
        props = KubeNetworkPolicyProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicy".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeNetworkPolicyList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyList",
):
    '''(experimental) NetworkPolicyList is a list of NetworkPolicy objects.

    :stability: experimental
    :schema: io.k8s.api.networking.v1.NetworkPolicyList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeNetworkPolicyProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.networking.v1.NetworkPolicyList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeNetworkPolicyListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeNetworkPolicyProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicyList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeNetworkPolicyListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicyList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeNetworkPolicyListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeNetworkPolicyProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) NetworkPolicyList is a list of NetworkPolicy objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicyList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeNetworkPolicyProps"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicyList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeNetworkPolicyProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicyList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNetworkPolicyListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeNetworkPolicyListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyListV1Beta1",
):
    '''(experimental) DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.NetworkPolicyList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeNetworkPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.NetworkPolicyList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeNetworkPolicyListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeNetworkPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.NetworkPolicyList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubeNetworkPolicyListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.NetworkPolicyList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeNetworkPolicyListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeNetworkPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicyList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeNetworkPolicyV1Beta1Props"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicyList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeNetworkPolicyV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicyList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNetworkPolicyListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeNetworkPolicyProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> None:
        '''(experimental) NetworkPolicy describes what network traffic is allowed for a set of Pods.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicy
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = NetworkPolicySpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicy#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["NetworkPolicySpec"]:
        '''(experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        :schema: io.k8s.api.networking.v1.NetworkPolicy#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["NetworkPolicySpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNetworkPolicyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeNetworkPolicyV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyV1Beta1",
):
    '''(experimental) DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.

    :stability: experimental
    :schema: io.k8s.api.extensions.v1beta1.NetworkPolicy
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.extensions.v1beta1.NetworkPolicy" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        '''
        props = KubeNetworkPolicyV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.extensions.v1beta1.NetworkPolicy".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        '''
        props = KubeNetworkPolicyV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.extensions.v1beta1.NetworkPolicy".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNetworkPolicyV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeNetworkPolicyV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NetworkPolicySpec"] = None,
    ) -> None:
        '''(experimental) DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicy
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = NetworkPolicySpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicy#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["NetworkPolicySpec"]:
        '''(experimental) Specification of the desired behavior for this NetworkPolicy.

        :stability: experimental
        :schema: io.k8s.api.extensions.v1beta1.NetworkPolicy#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["NetworkPolicySpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNetworkPolicyV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubeNode(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNode",
):
    '''(experimental) Node is a worker node in Kubernetes.

    Each node will have a unique identifier in the cache (i.e. in etcd).

    :stability: experimental
    :schema: io.k8s.api.core.v1.Node
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NodeSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Node" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeNodeProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NodeSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Node".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubeNodeProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Node".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubeNodeList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNodeList",
):
    '''(experimental) NodeList is the whole list of all Nodes which have been registered with master.

    :stability: experimental
    :schema: io.k8s.api.core.v1.NodeList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubeNodeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.NodeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of nodes.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeNodeListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubeNodeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.NodeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of nodes.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubeNodeListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.NodeList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNodeListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubeNodeListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubeNodeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) NodeList is the whole list of all Nodes which have been registered with master.

        :param items: (experimental) List of nodes.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.NodeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubeNodeProps"]:
        '''(experimental) List of nodes.

        :stability: experimental
        :schema: io.k8s.api.core.v1.NodeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubeNodeProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.NodeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNodeListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubeNodeProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubeNodeProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["NodeSpec"] = None,
    ) -> None:
        '''(experimental) Node is a worker node in Kubernetes.

        Each node will have a unique identifier in the cache (i.e. in etcd).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Node
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = NodeSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Node#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["NodeSpec"]:
        '''(experimental) Spec defines the behavior of a node.

        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Node#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["NodeSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubeNodeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePersistentVolume(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolume",
):
    '''(experimental) PersistentVolume (PV) is a storage resource provisioned by an administrator.

    It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes

    :stability: experimental
    :schema: io.k8s.api.core.v1.PersistentVolume
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PersistentVolume" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes

        :stability: experimental
        '''
        props = KubePersistentVolumeProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolume".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes

        :stability: experimental
        '''
        props = KubePersistentVolumeProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolume".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubePersistentVolumeClaim(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeClaim",
):
    '''(experimental) PersistentVolumeClaim is a user's request for and claim to a persistent volume.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PersistentVolumeClaim
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeClaimSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeClaim" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims

        :stability: experimental
        '''
        props = KubePersistentVolumeClaimProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeClaimSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaim".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims

        :stability: experimental
        '''
        props = KubePersistentVolumeClaimProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaim".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubePersistentVolumeClaimList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeClaimList",
):
    '''(experimental) PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PersistentVolumeClaimList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePersistentVolumeClaimProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeClaimList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) A list of persistent volume claims. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePersistentVolumeClaimListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePersistentVolumeClaimProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaimList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) A list of persistent volume claims. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePersistentVolumeClaimListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaimList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeClaimListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePersistentVolumeClaimListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePersistentVolumeClaimProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

        :param items: (experimental) A list of persistent volume claims. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaimList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePersistentVolumeClaimProps"]:
        '''(experimental) A list of persistent volume claims.

        More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaimList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePersistentVolumeClaimProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaimList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePersistentVolumeClaimListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeClaimProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePersistentVolumeClaimProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeClaimSpec"] = None,
    ) -> None:
        '''(experimental) PersistentVolumeClaim is a user's request for and claim to a persistent volume.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaim
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PersistentVolumeClaimSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaim#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PersistentVolumeClaimSpec"]:
        '''(experimental) Spec defines the desired characteristics of a volume requested by a pod author.

        More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeClaim#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PersistentVolumeClaimSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePersistentVolumeClaimProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePersistentVolumeList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeList",
):
    '''(experimental) PersistentVolumeList is a list of PersistentVolume items.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PersistentVolumeList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePersistentVolumeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PersistentVolumeList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePersistentVolumeListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePersistentVolumeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePersistentVolumeListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePersistentVolumeListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePersistentVolumeProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PersistentVolumeList is a list of PersistentVolume items.

        :param items: (experimental) List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePersistentVolumeProps"]:
        '''(experimental) List of persistent volumes.

        More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePersistentVolumeProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolumeList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePersistentVolumeListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePersistentVolumeProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePersistentVolumeProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PersistentVolumeSpec"] = None,
    ) -> None:
        '''(experimental) PersistentVolume (PV) is a storage resource provisioned by an administrator.

        It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolume
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PersistentVolumeSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolume#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PersistentVolumeSpec"]:
        '''(experimental) Spec defines a specification of a persistent volume owned by the cluster.

        Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes

        :stability: experimental
        :schema: io.k8s.api.core.v1.PersistentVolume#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PersistentVolumeSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePod(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePod",
):
    '''(experimental) Pod is a collection of containers that can run on a host.

    This resource is created by clients and scheduled onto hosts.

    :stability: experimental
    :schema: io.k8s.api.core.v1.Pod
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.Pod" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubePodProps(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.Pod".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubePodProps(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.Pod".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubePodDisruptionBudgetListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodDisruptionBudgetListV1Beta1",
):
    '''(experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

    :stability: experimental
    :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudgetList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePodDisruptionBudgetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubePodDisruptionBudgetListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePodDisruptionBudgetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: 
        :param metadata: 

        :stability: experimental
        '''
        props = KubePodDisruptionBudgetListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodDisruptionBudgetListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePodDisruptionBudgetListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePodDisruptionBudgetV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

        :param items: 
        :param metadata: 

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudgetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePodDisruptionBudgetV1Beta1Props"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudgetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePodDisruptionBudgetV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudgetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodDisruptionBudgetListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodDisruptionBudgetV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodDisruptionBudgetV1Beta1",
):
    '''(experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

    :stability: experimental
    :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudget
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodDisruptionBudgetSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.policy.v1beta1.PodDisruptionBudget" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: (experimental) Specification of the desired behavior of the PodDisruptionBudget.

        :stability: experimental
        '''
        props = KubePodDisruptionBudgetV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodDisruptionBudgetSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: (experimental) Specification of the desired behavior of the PodDisruptionBudget.

        :stability: experimental
        '''
        props = KubePodDisruptionBudgetV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodDisruptionBudgetV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePodDisruptionBudgetV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodDisruptionBudgetSpec"] = None,
    ) -> None:
        '''(experimental) PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

        :param metadata: 
        :param spec: (experimental) Specification of the desired behavior of the PodDisruptionBudget.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudget
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PodDisruptionBudgetSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudget#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PodDisruptionBudgetSpec"]:
        '''(experimental) Specification of the desired behavior of the PodDisruptionBudget.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodDisruptionBudget#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PodDisruptionBudgetSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodDisruptionBudgetV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodList",
):
    '''(experimental) PodList is a list of Pods.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PodList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePodProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PodList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of pods. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePodListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePodProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of pods. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePodListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePodListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePodProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PodList is a list of Pods.

        :param items: (experimental) List of pods. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePodProps"]:
        '''(experimental) List of pods.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePodProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodPresetListV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodPresetListV1Alpha1",
):
    '''(experimental) PodPresetList is a list of PodPreset objects.

    :stability: experimental
    :schema: io.k8s.api.settings.v1alpha1.PodPresetList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePodPresetV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.settings.v1alpha1.PodPresetList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubePodPresetListV1Alpha1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePodPresetV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.settings.v1alpha1.PodPresetList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubePodPresetListV1Alpha1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.settings.v1alpha1.PodPresetList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodPresetListV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePodPresetListV1Alpha1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePodPresetV1Alpha1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PodPresetList is a list of PodPreset objects.

        :param items: (experimental) Items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPresetList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePodPresetV1Alpha1Props"]:
        '''(experimental) Items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPresetList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePodPresetV1Alpha1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPresetList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodPresetListV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodPresetV1Alpha1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodPresetV1Alpha1",
):
    '''(experimental) PodPreset is a policy resource that defines additional runtime requirements for a Pod.

    :stability: experimental
    :schema: io.k8s.api.settings.v1alpha1.PodPreset
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodPresetSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.settings.v1alpha1.PodPreset" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: 
        :param spec: 

        :stability: experimental
        '''
        props = KubePodPresetV1Alpha1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodPresetSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.settings.v1alpha1.PodPreset".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: 
        :param spec: 

        :stability: experimental
        '''
        props = KubePodPresetV1Alpha1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.settings.v1alpha1.PodPreset".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodPresetV1Alpha1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePodPresetV1Alpha1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodPresetSpec"] = None,
    ) -> None:
        '''(experimental) PodPreset is a policy resource that defines additional runtime requirements for a Pod.

        :param metadata: 
        :param spec: 

        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPreset
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PodPresetSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPreset#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PodPresetSpec"]:
        '''
        :stability: experimental
        :schema: io.k8s.api.settings.v1alpha1.PodPreset#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PodPresetSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodPresetV1Alpha1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePodProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSpec"] = None,
    ) -> None:
        '''(experimental) Pod is a collection of containers that can run on a host.

        This resource is created by clients and scheduled onto hosts.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Pod
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PodSpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.Pod#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PodSpec"]:
        '''(experimental) Specification of the desired behavior of the pod.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.Pod#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PodSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodSecurityPolicyListV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodSecurityPolicyListV1Beta1",
):
    '''(experimental) PodSecurityPolicyList is a list of PodSecurityPolicy objects.

    :stability: experimental
    :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicyList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePodSecurityPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicyList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubePodSecurityPolicyListV1Beta1Props(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePodSecurityPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        '''
        props = KubePodSecurityPolicyListV1Beta1Props(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodSecurityPolicyListV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePodSecurityPolicyListV1Beta1Props:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePodSecurityPolicyV1Beta1Props"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PodSecurityPolicyList is a list of PodSecurityPolicy objects.

        :param items: (experimental) items is a list of schema objects.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicyList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePodSecurityPolicyV1Beta1Props"]:
        '''(experimental) items is a list of schema objects.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicyList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePodSecurityPolicyV1Beta1Props"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicyList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodSecurityPolicyListV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodSecurityPolicyV1Beta1(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodSecurityPolicyV1Beta1",
):
    '''(experimental) PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.

    :stability: experimental
    :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicy
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSecurityPolicySpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.policy.v1beta1.PodSecurityPolicy" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec defines the policy enforced.

        :stability: experimental
        '''
        props = KubePodSecurityPolicyV1Beta1Props(metadata=metadata, spec=spec)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSecurityPolicySpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec defines the policy enforced.

        :stability: experimental
        '''
        props = KubePodSecurityPolicyV1Beta1Props(metadata=metadata, spec=spec)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodSecurityPolicyV1Beta1Props",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "spec": "spec"},
)
class KubePodSecurityPolicyV1Beta1Props:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        spec: typing.Optional["PodSecurityPolicySpec"] = None,
    ) -> None:
        '''(experimental) PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param spec: (experimental) spec defines the policy enforced.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicy
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(spec, dict):
            spec = PodSecurityPolicySpec(**spec)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if spec is not None:
            self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicy#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def spec(self) -> typing.Optional["PodSecurityPolicySpec"]:
        '''(experimental) spec defines the policy enforced.

        :stability: experimental
        :schema: io.k8s.api.policy.v1beta1.PodSecurityPolicy#spec
        '''
        result = self._values.get("spec")
        return typing.cast(typing.Optional["PodSecurityPolicySpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodSecurityPolicyV1Beta1Props(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePodTemplate(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodTemplate",
):
    '''(experimental) PodTemplate describes a template for creating copies of a predefined pod.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PodTemplate
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        template: typing.Optional["PodTemplateSpec"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PodTemplate" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param template: (experimental) Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubePodTemplateProps(metadata=metadata, template=template)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        template: typing.Optional["PodTemplateSpec"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplate".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param template: (experimental) Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        '''
        props = KubePodTemplateProps(metadata=metadata, template=template)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplate".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubePodTemplateList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodTemplateList",
):
    '''(experimental) PodTemplateList is a list of PodTemplates.

    :stability: experimental
    :schema: io.k8s.api.core.v1.PodTemplateList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePodTemplateProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.core.v1.PodTemplateList" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param items: (experimental) List of pod templates.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePodTemplateListProps(items=items, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        items: typing.Sequence["KubePodTemplateProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplateList".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param items: (experimental) List of pod templates.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        '''
        props = KubePodTemplateListProps(items=items, metadata=metadata)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplateList".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodTemplateListProps",
    jsii_struct_bases=[],
    name_mapping={"items": "items", "metadata": "metadata"},
)
class KubePodTemplateListProps:
    def __init__(
        self,
        *,
        items: typing.Sequence["KubePodTemplateProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) PodTemplateList is a list of PodTemplates.

        :param items: (experimental) List of pod templates.
        :param metadata: (experimental) Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplateList
        '''
        if isinstance(metadata, dict):
            metadata = ListMeta(**metadata)
        self._values: typing.Dict[str, typing.Any] = {
            "items": items,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def items(self) -> typing.List["KubePodTemplateProps"]:
        '''(experimental) List of pod templates.

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplateList#items
        '''
        result = self._values.get("items")
        assert result is not None, "Required property 'items' is missing"
        return typing.cast(typing.List["KubePodTemplateProps"], result)

    @builtins.property
    def metadata(self) -> typing.Optional["ListMeta"]:
        '''(experimental) Standard list metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplateList#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ListMeta"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodTemplateListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePodTemplateProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata", "template": "template"},
)
class KubePodTemplateProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional["ObjectMeta"] = None,
        template: typing.Optional["PodTemplateSpec"] = None,
    ) -> None:
        '''(experimental) PodTemplate describes a template for creating copies of a predefined pod.

        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param template: (experimental) Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplate
        '''
        if isinstance(metadata, dict):
            metadata = ObjectMeta(**metadata)
        if isinstance(template, dict):
            template = PodTemplateSpec(**template)
        self._values: typing.Dict[str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if template is not None:
            self._values["template"] = template

    @builtins.property
    def metadata(self) -> typing.Optional["ObjectMeta"]:
        '''(experimental) Standard object's metadata.

        More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplate#metadata
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional["ObjectMeta"], result)

    @builtins.property
    def template(self) -> typing.Optional["PodTemplateSpec"]:
        '''(experimental) Template defines the pods that will be created from this pod template.

        https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status

        :stability: experimental
        :schema: io.k8s.api.core.v1.PodTemplate#template
        '''
        result = self._values.get("template")
        return typing.cast(typing.Optional["PodTemplateSpec"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KubePodTemplateProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KubePriorityClass(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePriorityClass",
):
    '''(experimental) PriorityClass defines mapping from a priority class name to the priority integer value.

    The value can be any valid integer.

    :stability: experimental
    :schema: io.k8s.api.scheduling.v1.PriorityClass
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        value: jsii.Number,
        description: typing.Optional[builtins.str] = None,
        global_default: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        preemption_policy: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.scheduling.v1.PriorityClass" API object.

        :param scope: the scope in which to define this object.
        :param id: a scope-local name for the object.
        :param value: (experimental) The value of this priority class. This is the actual priority that pods receive when they have the name of this class in their pod spec.
        :param description: (experimental) description is an arbitrary string that usually provides guidelines on when this priority class should be used.
        :param global_default: (experimental) globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. Only one PriorityClass can be marked as ``globalDefault``. However, if more than one PriorityClasses exists with their ``globalDefault`` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param preemption_policy: (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature. Default: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.

        :stability: experimental
        '''
        props = KubePriorityClassProps(
            value=value,
            description=description,
            global_default=global_default,
            metadata=metadata,
            preemption_policy=preemption_policy,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="manifest") # type: ignore[misc]
    @builtins.classmethod
    def manifest(
        cls,
        *,
        value: jsii.Number,
        description: typing.Optional[builtins.str] = None,
        global_default: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional["ObjectMeta"] = None,
        preemption_policy: typing.Optional[builtins.str] = None,
    ) -> typing.Any:
        '''(experimental) Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClass".

        This can be used to inline resource manifests inside other objects (e.g. as templates).

        :param value: (experimental) The value of this priority class. This is the actual priority that pods receive when they have the name of this class in their pod spec.
        :param description: (experimental) description is an arbitrary string that usually provides guidelines on when this priority class should be used.
        :param global_default: (experimental) globalDefault specifies whether this PriorityClass should be considered as the default priority for pods that do not have any priority class. Only one PriorityClass can be marked as ``globalDefault``. However, if more than one PriorityClasses exists with their ``globalDefault`` field set to true, the smallest value of such global default PriorityClasses will be used as the default priority.
        :param metadata: (experimental) Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param preemption_policy: (experimental) PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature. Default: PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.

        :stability: experimental
        '''
        props = KubePriorityClassProps(
            value=value,
            description=description,
            global_default=global_default,
            metadata=metadata,
            preemption_policy=preemption_policy,
        )

        return typing.cast(typing.Any, jsii.sinvoke(cls, "manifest", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="GVK")
    def GVK(cls) -> cdk8s.GroupVersionKind:
        '''(experimental) Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClass".

        :stability: experimental
        '''
        return typing.cast(cdk8s.GroupVersionKind, jsii.sget(cls, "GVK"))


class KubePriorityClassList(
    cdk8s.ApiObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@opencdk8s/cdk8s-argocd-resources.k8s.KubePriorityClassList",
):
    '''(experimental) PriorityClassList is a collection of priority classes.

    :stability: experimental
    :schema: io.k8s.api.scheduling.v1.PriorityClassList
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        items: typing.Sequence["KubePriorityClassProps"],
        metadata: typing.Optional["ListMeta"] = None,
    ) -> None:
        '''(experimental) Defines a "io.k8s.api.scheduling.v1.PriorityClassList" API