"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class ManagedInstanceRole extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        let domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        let ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (ssmManagementEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (domainJoinEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        this.instanceProfile = new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'instanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/cdk-library-managed-instance-role.ManagedInstanceRole", version: "2.1.3" };
//# sourceMappingURL=data:application/json;base64,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