"""
This file is part of DeepDRR.
Copyright (c) 2020 Benjamin D. Killeen.

DeepDRR is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

DEEPDRR is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DeepDRR.  If not, see <https://www.gnu.org/licenses/>.
"""

from .core import (
    HomogeneousObject,
    PointOrVector,
    get_data,
    Point,
    Vector,
    Point2D,
    Point3D,
    Vector2D,
    Vector3D,
    point,
    vector,
    F,
    p,
    v,
    f,
    Transform,
    FrameTransform,
    frame_transform,
    RAS_from_LPS,
    LPS_from_RAS,
    mm_from_m,
    m_from_mm,
    cm_from_m,
    m_from_cm,
    cm_from_mm,
    mm_from_cm,
    unity_from_slicer,
    slicer_from_unity,
    CameraProjection,
    CameraIntrinsicTransform,
)
from .hyperplane import HyperPlane, Line, Line2D, Line3D, Plane, line, l, pl, plane
from .ray import Ray, Ray2D, Ray3D, ray
from .segment import Segment, Segment2D, Segment3D, segment
from .exceptions import JoinError, MeetError
from scipy.spatial.transform import Rotation
from .random import spherical_uniform

__all__ = [
    "HomogeneousObject",
    "PointOrVector",
    "get_data",
    "Point",
    "Point2D",
    "Point3D",
    "Vector",
    "Vector2D",
    "Vector3D",
    "Line",
    "HyperPlane",
    "Line2D",
    "Line3D",
    "Segment",
    "Segment2D",
    "Segment3D",
    "Plane",
    "Ray",
    "Ray",
    "Ray3D",
    "point",
    "vector",
    "line",
    "plane",
    "ray",
    "segment",
    "F",
    "p",
    "v",
    "l",
    "pl",
    "f",
    "Transform",
    "FrameTransform",
    "frame_transform",
    "RAS_from_LPS",
    "LPS_from_RAS",
    "mm_from_m",
    "m_from_mm",
    "cm_from_m",
    "m_from_cm",
    "cm_from_mm",
    "mm_from_cm",
    "unity_from_slicer",
    "slicer_from_unity",
    "JoinError",
    "MeetError",
    "CameraIntrinsicTransform",
    "CameraProjection",
    "Rotation",
    "spherical_uniform",
]
