# pulp_rpm-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 3.5.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_rpm
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_rpm
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_rpm
from pulpcore.client.pulp_rpm.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_rpm.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: Basic
configuration = pulpcore.client.pulp_rpm.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)


# Enter a context with an instance of the API client
with pulpcore.client.pulp_rpm.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_rpm.ContentAdvisoriesApi(api_client)
    file = '/path/to/file' # file | An uploaded file that may be turned into the artifact of the content unit. (optional)
repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)

    try:
        # Create an update record
        api_response = api_instance.create(file=file, repository=repository)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentAdvisoriesApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentAdvisoriesApi* | [**create**](docs/ContentAdvisoriesApi.md#create) | **POST** /pulp/api/v3/content/rpm/advisories/ | Create an update record
*ContentAdvisoriesApi* | [**list**](docs/ContentAdvisoriesApi.md#list) | **GET** /pulp/api/v3/content/rpm/advisories/ | List update records
*ContentAdvisoriesApi* | [**read**](docs/ContentAdvisoriesApi.md#read) | **GET** {update_record_href} | Inspect an update record
*ContentDistributionTreesApi* | [**delete**](docs/ContentDistributionTreesApi.md#delete) | **DELETE** {distribution_tree_href} | Delete a distribution tree
*ContentDistributionTreesApi* | [**list**](docs/ContentDistributionTreesApi.md#list) | **GET** /pulp/api/v3/content/rpm/distribution_trees/ | List distribution trees
*ContentDistributionTreesApi* | [**read**](docs/ContentDistributionTreesApi.md#read) | **GET** {distribution_tree_href} | Inspect a distribution tree
*ContentModulemdDefaultsApi* | [**create**](docs/ContentModulemdDefaultsApi.md#create) | **POST** /pulp/api/v3/content/rpm/modulemd_defaults/ | Create a modulemd defaults
*ContentModulemdDefaultsApi* | [**list**](docs/ContentModulemdDefaultsApi.md#list) | **GET** /pulp/api/v3/content/rpm/modulemd_defaults/ | List modulemd defaultss
*ContentModulemdDefaultsApi* | [**read**](docs/ContentModulemdDefaultsApi.md#read) | **GET** {modulemd_defaults_href} | Inspect a modulemd defaults
*ContentModulemdsApi* | [**create**](docs/ContentModulemdsApi.md#create) | **POST** /pulp/api/v3/content/rpm/modulemds/ | Create a modulemd
*ContentModulemdsApi* | [**list**](docs/ContentModulemdsApi.md#list) | **GET** /pulp/api/v3/content/rpm/modulemds/ | List modulemds
*ContentModulemdsApi* | [**read**](docs/ContentModulemdsApi.md#read) | **GET** {modulemd_href} | Inspect a modulemd
*ContentPackagecategoriesApi* | [**delete**](docs/ContentPackagecategoriesApi.md#delete) | **DELETE** {package_category_href} | Delete a package category
*ContentPackagecategoriesApi* | [**list**](docs/ContentPackagecategoriesApi.md#list) | **GET** /pulp/api/v3/content/rpm/packagecategories/ | List package categorys
*ContentPackagecategoriesApi* | [**read**](docs/ContentPackagecategoriesApi.md#read) | **GET** {package_category_href} | Inspect a package category
*ContentPackageenvironmentsApi* | [**delete**](docs/ContentPackageenvironmentsApi.md#delete) | **DELETE** {package_environment_href} | Delete a package environment
*ContentPackageenvironmentsApi* | [**list**](docs/ContentPackageenvironmentsApi.md#list) | **GET** /pulp/api/v3/content/rpm/packageenvironments/ | List package environments
*ContentPackageenvironmentsApi* | [**read**](docs/ContentPackageenvironmentsApi.md#read) | **GET** {package_environment_href} | Inspect a package environment
*ContentPackagegroupsApi* | [**delete**](docs/ContentPackagegroupsApi.md#delete) | **DELETE** {package_group_href} | Delete a package group
*ContentPackagegroupsApi* | [**list**](docs/ContentPackagegroupsApi.md#list) | **GET** /pulp/api/v3/content/rpm/packagegroups/ | List package groups
*ContentPackagegroupsApi* | [**read**](docs/ContentPackagegroupsApi.md#read) | **GET** {package_group_href} | Inspect a package group
*ContentPackagelangpacksApi* | [**delete**](docs/ContentPackagelangpacksApi.md#delete) | **DELETE** {package_langpacks_href} | Delete a package langpacks
*ContentPackagelangpacksApi* | [**list**](docs/ContentPackagelangpacksApi.md#list) | **GET** /pulp/api/v3/content/rpm/packagelangpacks/ | List package langpackss
*ContentPackagelangpacksApi* | [**read**](docs/ContentPackagelangpacksApi.md#read) | **GET** {package_langpacks_href} | Inspect a package langpacks
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /pulp/api/v3/content/rpm/packages/ | Create a package
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /pulp/api/v3/content/rpm/packages/ | List packages
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {package_href} | Inspect a package
*ContentRepoMetadataFilesApi* | [**delete**](docs/ContentRepoMetadataFilesApi.md#delete) | **DELETE** {repo_metadata_file_href} | Delete a repo metadata file
*ContentRepoMetadataFilesApi* | [**list**](docs/ContentRepoMetadataFilesApi.md#list) | **GET** /pulp/api/v3/content/rpm/repo_metadata_files/ | List repo metadata files
*ContentRepoMetadataFilesApi* | [**read**](docs/ContentRepoMetadataFilesApi.md#read) | **GET** {repo_metadata_file_href} | Inspect a repo metadata file
*DistributionsRpmApi* | [**create**](docs/DistributionsRpmApi.md#create) | **POST** /pulp/api/v3/distributions/rpm/rpm/ | Create a rpm distribution
*DistributionsRpmApi* | [**delete**](docs/DistributionsRpmApi.md#delete) | **DELETE** {rpm_distribution_href} | Delete a rpm distribution
*DistributionsRpmApi* | [**list**](docs/DistributionsRpmApi.md#list) | **GET** /pulp/api/v3/distributions/rpm/rpm/ | List rpm distributions
*DistributionsRpmApi* | [**partial_update**](docs/DistributionsRpmApi.md#partial_update) | **PATCH** {rpm_distribution_href} | Partially update a rpm distribution
*DistributionsRpmApi* | [**read**](docs/DistributionsRpmApi.md#read) | **GET** {rpm_distribution_href} | Inspect a rpm distribution
*DistributionsRpmApi* | [**update**](docs/DistributionsRpmApi.md#update) | **PUT** {rpm_distribution_href} | Update a rpm distribution
*PublicationsRpmApi* | [**create**](docs/PublicationsRpmApi.md#create) | **POST** /pulp/api/v3/publications/rpm/rpm/ | Create a rpm publication
*PublicationsRpmApi* | [**delete**](docs/PublicationsRpmApi.md#delete) | **DELETE** {rpm_publication_href} | Delete a rpm publication
*PublicationsRpmApi* | [**list**](docs/PublicationsRpmApi.md#list) | **GET** /pulp/api/v3/publications/rpm/rpm/ | List rpm publications
*PublicationsRpmApi* | [**read**](docs/PublicationsRpmApi.md#read) | **GET** {rpm_publication_href} | Inspect a rpm publication
*RemotesRpmApi* | [**create**](docs/RemotesRpmApi.md#create) | **POST** /pulp/api/v3/remotes/rpm/rpm/ | Create a rpm remote
*RemotesRpmApi* | [**delete**](docs/RemotesRpmApi.md#delete) | **DELETE** {rpm_remote_href} | Delete a rpm remote
*RemotesRpmApi* | [**list**](docs/RemotesRpmApi.md#list) | **GET** /pulp/api/v3/remotes/rpm/rpm/ | List rpm remotes
*RemotesRpmApi* | [**partial_update**](docs/RemotesRpmApi.md#partial_update) | **PATCH** {rpm_remote_href} | Partially update a rpm remote
*RemotesRpmApi* | [**read**](docs/RemotesRpmApi.md#read) | **GET** {rpm_remote_href} | Inspect a rpm remote
*RemotesRpmApi* | [**update**](docs/RemotesRpmApi.md#update) | **PUT** {rpm_remote_href} | Update a rpm remote
*RepositoriesRpmApi* | [**create**](docs/RepositoriesRpmApi.md#create) | **POST** /pulp/api/v3/repositories/rpm/rpm/ | Create a rpm repository
*RepositoriesRpmApi* | [**delete**](docs/RepositoriesRpmApi.md#delete) | **DELETE** {rpm_repository_href} | Delete a rpm repository
*RepositoriesRpmApi* | [**list**](docs/RepositoriesRpmApi.md#list) | **GET** /pulp/api/v3/repositories/rpm/rpm/ | List rpm repositorys
*RepositoriesRpmApi* | [**modify**](docs/RepositoriesRpmApi.md#modify) | **POST** {rpm_repository_href}modify/ | Modify Repository Content
*RepositoriesRpmApi* | [**partial_update**](docs/RepositoriesRpmApi.md#partial_update) | **PATCH** {rpm_repository_href} | Partially update a rpm repository
*RepositoriesRpmApi* | [**read**](docs/RepositoriesRpmApi.md#read) | **GET** {rpm_repository_href} | Inspect a rpm repository
*RepositoriesRpmApi* | [**sync**](docs/RepositoriesRpmApi.md#sync) | **POST** {rpm_repository_href}sync/ | Sync from remote
*RepositoriesRpmApi* | [**update**](docs/RepositoriesRpmApi.md#update) | **PUT** {rpm_repository_href} | Update a rpm repository
*RepositoriesRpmVersionsApi* | [**delete**](docs/RepositoriesRpmVersionsApi.md#delete) | **DELETE** {rpm_repository_version_href} | Delete a repository version
*RepositoriesRpmVersionsApi* | [**list**](docs/RepositoriesRpmVersionsApi.md#list) | **GET** {rpm_repository_href}versions/ | List repository versions
*RepositoriesRpmVersionsApi* | [**read**](docs/RepositoriesRpmVersionsApi.md#read) | **GET** {rpm_repository_version_href} | Inspect a repository version
*RepositoriesRpmVersionsApi* | [**repair**](docs/RepositoriesRpmVersionsApi.md#repair) | **POST** {rpm_repository_version_href}repair/ | 
*RpmCopyApi* | [**copy_content**](docs/RpmCopyApi.md#copy_content) | **POST** /pulp/api/v3/rpm/copy/ | Copy content


## Documentation For Models

 - [Addon](docs/Addon.md)
 - [Artifact](docs/Artifact.md)
 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [Checksum](docs/Checksum.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [Copy](docs/Copy.md)
 - [Image](docs/Image.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RpmDistributionTree](docs/RpmDistributionTree.md)
 - [RpmModulemd](docs/RpmModulemd.md)
 - [RpmModulemdDefaults](docs/RpmModulemdDefaults.md)
 - [RpmPackage](docs/RpmPackage.md)
 - [RpmPackageCategory](docs/RpmPackageCategory.md)
 - [RpmPackageEnvironment](docs/RpmPackageEnvironment.md)
 - [RpmPackageGroup](docs/RpmPackageGroup.md)
 - [RpmPackageLangpacks](docs/RpmPackageLangpacks.md)
 - [RpmRepoMetadataFile](docs/RpmRepoMetadataFile.md)
 - [RpmRepositorySyncURL](docs/RpmRepositorySyncURL.md)
 - [RpmRpmDistribution](docs/RpmRpmDistribution.md)
 - [RpmRpmPublication](docs/RpmRpmPublication.md)
 - [RpmRpmRemote](docs/RpmRpmRemote.md)
 - [RpmRpmRepository](docs/RpmRpmRepository.md)
 - [RpmUpdateCollection](docs/RpmUpdateCollection.md)
 - [RpmUpdateRecord](docs/RpmUpdateRecord.md)
 - [Variant](docs/Variant.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Author




