# Copyright (c) 2019 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from . import command_service_pb2 as com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class CommandServiceStub(object):
  """Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
  information with each tracking result. This supports the implementation of stateless clients.
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.SubmitAndWait = channel.unary_unary(
        '/com.digitalasset.ledger.api.v1.CommandService/SubmitAndWait',
        request_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.SerializeToString,
        response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
    self.SubmitAndWaitForTransactionId = channel.unary_unary(
        '/com.digitalasset.ledger.api.v1.CommandService/SubmitAndWaitForTransactionId',
        request_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.SerializeToString,
        response_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionIdResponse.FromString,
        )
    self.SubmitAndWaitForTransaction = channel.unary_unary(
        '/com.digitalasset.ledger.api.v1.CommandService/SubmitAndWaitForTransaction',
        request_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.SerializeToString,
        response_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionResponse.FromString,
        )
    self.SubmitAndWaitForTransactionTree = channel.unary_unary(
        '/com.digitalasset.ledger.api.v1.CommandService/SubmitAndWaitForTransactionTree',
        request_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.SerializeToString,
        response_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionTreeResponse.FromString,
        )


class CommandServiceServicer(object):
  """Command Service is able to correlate submitted commands with completion data, identify timeouts, and return contextual
  information with each tracking result. This supports the implementation of stateless clients.
  """

  def SubmitAndWait(self, request, context):
    """Submits a single composite command and waits for its result.
    Returns ``RESOURCE_EXHAUSTED`` if the number of in-flight commands reached the maximum (if a limit is configured).
    Propagates the gRPC error of failed submissions including DAML interpretation errors.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SubmitAndWaitForTransactionId(self, request, context):
    """Submits a single composite command, waits for its result, and returns the transaction id.
    Returns ``RESOURCE_EXHAUSTED`` if the number of in-flight commands reached the maximum (if a limit is configured).
    Propagates the gRPC error of failed submissions including DAML interpretation errors.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SubmitAndWaitForTransaction(self, request, context):
    """Submits a single composite command, waits for its result, and returns the transaction.
    Returns ``RESOURCE_EXHAUSTED`` if the number of in-flight commands reached the maximum (if a limit is configured).
    Propagates the gRPC error of failed submissions including DAML interpretation errors.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SubmitAndWaitForTransactionTree(self, request, context):
    """Submits a single composite command, waits for its result, and returns the transaction tree.
    Returns ``RESOURCE_EXHAUSTED`` if the number of in-flight commands reached the maximum (if a limit is configured).
    Propagates the gRPC error of failed submissions including DAML interpretation errors.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_CommandServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'SubmitAndWait': grpc.unary_unary_rpc_method_handler(
          servicer.SubmitAndWait,
          request_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.FromString,
          response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
      ),
      'SubmitAndWaitForTransactionId': grpc.unary_unary_rpc_method_handler(
          servicer.SubmitAndWaitForTransactionId,
          request_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.FromString,
          response_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionIdResponse.SerializeToString,
      ),
      'SubmitAndWaitForTransaction': grpc.unary_unary_rpc_method_handler(
          servicer.SubmitAndWaitForTransaction,
          request_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.FromString,
          response_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionResponse.SerializeToString,
      ),
      'SubmitAndWaitForTransactionTree': grpc.unary_unary_rpc_method_handler(
          servicer.SubmitAndWaitForTransactionTree,
          request_deserializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitRequest.FromString,
          response_serializer=com_dot_digitalasset_dot_ledger_dot_api_dot_v1_dot_command__service__pb2.SubmitAndWaitForTransactionTreeResponse.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'com.digitalasset.ledger.api.v1.CommandService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
