# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/03b_utils.misc.ipynb.

# %% auto 0
__all__ = []

# %% ../../nbs/03b_utils.misc.ipynb 5
import re
import codecs
import numpy as np
import jax, jax.numpy as jnp

from fastcore.test import test_eq

# %% ../../nbs/03b_utils.misc.ipynb 6
def to_numpy(t):
    # if t.dtype == jnp.bfloat16:
    return np.array(t, dtype=np.float32)
    # return t

# %% ../../nbs/03b_utils.misc.ipynb 7
def is_cpu(t: jax.Array):
    return t.device() == jax.devices("cpu")[0]


# %% ../../nbs/03b_utils.misc.ipynb 8
def test_array_repr(input: str, template:str):
    # Depending on the jax version, the arrray type can be either "Array" or "DeviceArray".
    # Depending on platform, the default device can be "cpu:0" or "gpu:0" (or, I guess, "tpu:0"?)

    # Create templace to match the "Array" and "gpu:0" case, they will be replaced with
    # regexes that will match either case

    # Escape the template to make it a valid regex.
     
    template = re.escape(template)
    template = template.replace("Array", "(Array|DeviceArray)")
    template = template.replace("\\ gpu:0", "( cpu:0| gpu:0| tpu:0)?")
    
    # Does imput match the regex?
    if not re.search(template, input):
        template = template.replace("\\", "")
        raise Exception(f"Template does not match\nTemplate: '{template}'\ninput:    '{input}'")
        
