<h1 align="center">
  <br>
  <a href="https://vantage6.ai"><img src="https://github.com/IKNL/guidelines/blob/master/resources/logos/vantage6.png?raw=true" alt="vantage6" width="350"></a>
</h1>

<h3 align=center> A privacy preserving federated learning solution</h3>
<h3 align="center">

[![PyPI version](https://badge.fury.io/py/vantage6-common.svg)](https://badge.fury.io/py/vantage6-common)

</h3>

<p align="center">
  <a href="#books-documentation">Documentation</a> •
  <a href="#gift_heart-contributing">Contributing</a> •
  <a href="#black_nib-references">References</a>
</p>

* * *

This repository is part of **vantage6**, our **priVAcy preserviNg federaTed leArninG infrastructurE for Secure Insight eXchange**. Other repositories include:

-   [vantage6](https://github.com/iknl/vantage6)
-   vantage6-common (you are here)
-   [vantage6-server](https://github.com/iknl/vantage6-server)
-   [vantage6-node](https://github.com/iknl/vantage6-node)
-   [vantage6-client](https://github.com/iknl/vantage6-client)
-   [vantage6-UI](https://github.com/IKNL/Vantage6-UI)
-   [vantage6-master](https://github.com/iknl/vantage6-master)

## :books: Documentation

This repository contains the code for all common classes, methods, and constants that are shared between the aforementioned **vantage6** repositories. For a more detailed, comprehensive guide, please refer to our [website (`https://vantage6.ai`)](https://vantage6.ai) and the official [documentation (`https://docs.vantage6.ai/`)](https://docs.vantage6.ai/).

## :gift_heart: Contributing

We hope to continue developing, improving, and supporting **vantage6** with the help of the federated learning community. If you are interested in contributing, first of all, thank you! Second, please take a look at our [contributing guidelines](https://docs.vantage6.ai/how-to-contribute/how-to-contribute)

## :lock_with_ink_pen: Data Protection Impact Assessment
Deploying Federated Learning solutions in real life often requires careful analysis and approval of a variety of legal entities. As part of these processes, we at IKNL have written a [Data Protection Impact Assessment (DPIA), which you can find here](https://vantage6.ai/data-protection-impact-assessment-dpia/). Please note that this DPIA was executed by IKNL and is specific for our situation. It can be used as an example by other organizations, but it cannot be used verbatim.

## :black_nib: References
If you are using **vantage6**, please cite this repository as well as the accompanying paper as follows:

> - Frank Martin, Melle Sieswerda, Hasan Alradhi, et al. vantage6. Available at https://doi.org/10.5281/zenodo.3686944. Accessed on [MONTH, 20XX].
> - Arturo Moncada-Torres, Frank Martin, Melle Sieswerda, Johan van Soest, Gijs Gelijnse. VANTAGE6: an open source priVAcy preserviNg federaTed leArninG infrastructurE for Secure Insight eXchange. AMIA Annual Symposium Proceedings, 2020, p. 870-877. [[BibTeX](https://arturomoncadatorres.com/bibtex/moncada-torres2020vantage6.txt), [PDF](https://vantage6.ai/vantage6/)]

* * *

<p align="center">
  <a href="https://github.com/IKNL/vantage6">vantage6</a> •
  <a>Common</a> •
  <a href="https://github.com/IKNL/vantage6-server">Server</a> •
  <a href="https://github.com/IKNL/vantage6-node">Node</a> •
  <a href="https://github.com/IKNL/vantage6-client">Client</a> •
  <a href="https://github.com/IKNL/Vantage6-UI">UI</a> •
  <a href="https://github.com/IKNL/vantage6-master">Master</a>
</p>
