#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for vyos_lldp_global
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: vyos_lldp_global
short_description: LLDP global resource module
description: This module manages link layer discovery protocol (LLDP) attributes on
  VyOS devices.
version_added: 1.0.0
notes:
- Tested against VyOS 1.1.8 (helium).
- This module works with connection C(network_cli). See L(the VyOS OS Platform Options,../network/user_guide/platform_vyos.html).
author:
- Rohit Thakur (@rohitthakur2590)
options:
  config:
    description: The provided link layer discovery protocol (LLDP) configuration.
    type: dict
    suboptions:
      enable:
        description:
        - This argument is a boolean value to enable or disable LLDP.
        type: bool
      address:
        description:
        - This argument defines management-address.
        type: str
      snmp:
        description:
        - This argument enable the SNMP queries to LLDP database.
        type: str
      legacy_protocols:
        description:
        - List of the supported legacy protocols.
        type: list
        choices:
        - cdp
        - edp
        - fdp
        - sonmp
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the VyOS device
      by executing the command B(show configuration commands | grep lldp).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state of the configuration after module completion.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged

"""
EXAMPLES = """
# Using merged
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration commands|grep lldp
#
- name: Merge provided configuration with device configuration
  vyos.vyos.vyos_lldp_global:
    config:
      legacy_protocols:
      - fdp
      - cdp
      snmp: enable
      address: 192.0.2.11
    state: merged
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
# "before": []
#
# "commands": [
#        "set service lldp legacy-protocols fdp",
#        "set service lldp legacy-protocols cdp",
#        "set service lldp snmp enable",
#        "set service lldp management-address '192.0.2.11'"
#    ]
#
# "after": [
#        {
#            "snmp": "enable"
#        },
#        {
#            "address": "192.0.2.11"
#        },
#        {
#            "legacy_protocols": [
#                "cdp",
#                "fdp"
#            ]
#        }
#        {
#            "enable": true
#        }
#    ]
#
# After state:
# -------------
#
# set service lldp legacy-protocols cdp
# set service lldp legacy-protocols fdp
# set service lldp management-address '192.0.2.11'
# set service lldp snmp enable


# Using replaced
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration commands | grep lldp
# set service lldp legacy-protocols cdp
# set service lldp legacy-protocols fdp
# set service lldp management-address '192.0.2.11'
# set service lldp snmp enable
#
- name: Replace device configurations with provided configurations
  vyos.vyos.vyos_lldp_global:
    config:
      legacy_protocols:
      - edp
      - sonmp
      - cdp
      address: 192.0.2.14
    state: replaced
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#
# "before": [
#        {
#            "snmp": "enable"
#        },
#        {
#            "address": "192.0.2.11"
#        },
#        {
#            "legacy_protocols": [
#                "cdp",
#                "fdp"
#            ]
#        }
#        {
#            "enable": true
#        }
#    ]
# "commands": [
#        "delete service lldp snmp",
#        "delete service lldp legacy-protocols fdp",
#        "set service lldp management-address '192.0.2.14'",
#        "set service lldp legacy-protocols edp",
#        "set service lldp legacy-protocols sonmp"
#    ]
#
# "after": [
#        {
#            "address": "192.0.2.14"
#        },
#        {
#            "legacy_protocols": [
#                "cdp",
#                "edp",
#                "sonmp"
#            ]
#        }
#        {
#            "enable": true
#        }
#    ]
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration commands|grep lldp
# set service lldp legacy-protocols cdp
# set service lldp legacy-protocols edp
# set service lldp legacy-protocols sonmp
# set service lldp management-address '192.0.2.14'


# Using deleted
#
# Before state
# -------------
# vyos@vyos:~$ show configuration commands|grep lldp
# set service lldp legacy-protocols cdp
# set service lldp legacy-protocols edp
# set service lldp legacy-protocols sonmp
# set service lldp management-address '192.0.2.14'
#
- name: Delete attributes of given lldp service (This won't delete the LLDP service
    itself)
  vyos.vyos.vyos_lldp_global:
    config:
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
# "before": [
#        {
#            "address": "192.0.2.14"
#        },
#        {
#            "legacy_protocols": [
#                "cdp",
#                "edp",
#                "sonmp"
#            ]
#        }
#        {
#            "enable": true
#        }
#    ]
#
#  "commands": [
#       "delete service lldp management-address",
#        "delete service lldp legacy-protocols"
#    ]
#
# "after": [
#        {
#            "enable": true
#        }
#          ]
#
# After state
# ------------
# vyos@vyos:~$ show configuration commands | grep lldp
# set service lldp


# Using gathered
#
# Before state:
# -------------
#
# vyos@192# run show configuration commands | grep lldp
# set service lldp legacy-protocols 'cdp'
# set service lldp management-address '192.0.2.17'
#
- name: Gather lldp global config with provided configurations
  vyos.vyos.vyos_lldp_global:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": [
# {
#        "config_trap": true,
#        "group": {
#            "address_group": [
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.3.1"
#                        },
#                        {
#                            "address": "192.0.3.2"
#                        }
#                    ],
#                    "name": "ENG-HOSTS"
#                },
#                {
#                    "description": "Sales office hosts address list",
#                    "members": [
#                        {
#                            "address": "192.0.2.1"
#                        },
#                        {
#                            "address": "192.0.2.2"
#                        },
#                        {
#                            "address": "192.0.2.3"
#                        }
#                    ],
#                    "name": "SALES-HOSTS"
#                }
#            ],
#            "network_group": [
#                {
#                    "description": "This group has the Management network addresses",
#                    "members": [
#                        {
#                            "address": "192.0.1.0/24"
#                        }
#                    ],
#                    "name": "MGMT"
#                }
#            ]
#        },
#        "log_martians": true,
#        "ping": {
#            "all": true,
#            "broadcast": true
#        },
#        "route_redirects": [
#            {
#                "afi": "ipv4",
#                "icmp_redirects": {
#                    "receive": false,
#                    "send": true
#                },
#                "ip_src_route": true
#            }
#        ],
#        "state_policy": [
#            {
#                "action": "accept",
#                "connection_type": "established",
#                "log": true
#            },
#            {
#                "action": "reject",
#                "connection_type": "invalid"
#            }
#        ],
#        "syn_cookies": true,
#        "twa_hazards_protection": true,
#        "validation": "strict"
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep lldp
# set service lldp legacy-protocols 'cdp'
# set service lldp management-address '192.0.2.17'


# Using rendered
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_lldp_global:
    config:
      address: 192.0.2.17
      enable: true
      legacy_protocols:
      - cdp
    state: rendered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": [
#         "set service lldp legacy-protocols 'cdp'",
#         "set service lldp",
#         "set service lldp management-address '192.0.2.17'"
#     ]
#


# Using parsed
#
#
- name: Parse the provided commands to provide structured configuration
  vyos.vyos.vyos_lldp_global:
    running_config:
      "set service lldp legacy-protocols 'cdp'
       set service lldp legacy-protocols 'fdp'
       set service lldp management-address '192.0.2.11'"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed": {
#         "address": "192.0.2.11",
#         "enable": true,
#         "legacy_protocols": [
#             "cdp",
#             "fdp"
#         ]
#     }
#


"""
RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: list
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
    - set service lldp legacy-protocols sonmp
    - set service lldp management-address '192.0.2.14'
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.argspec.lldp_global.lldp_global import (
    Lldp_globalArgs,
)
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.config.lldp_global.lldp_global import (
    Lldp_global,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]
    module = AnsibleModule(
        argument_spec=Lldp_globalArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )
    result = Lldp_global(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
