# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ModelPackagingConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, enabled: bool=None, model_packager_image: str=None, namespace: str=None, node_selector: Dict[str, str]=None, output_connection_id: str=None, packager_integration_namespace: str=None, service_account: str=None, timeout: str=None, toleration: Dict[str, str]=None):  # noqa: E501
        """ModelPackagingConfig - a model defined in Swagger

        :param enabled: The enabled of this ModelPackagingConfig.  # noqa: E501
        :type enabled: bool
        :param model_packager_image: The model_packager_image of this ModelPackagingConfig.  # noqa: E501
        :type model_packager_image: str
        :param namespace: The namespace of this ModelPackagingConfig.  # noqa: E501
        :type namespace: str
        :param node_selector: The node_selector of this ModelPackagingConfig.  # noqa: E501
        :type node_selector: Dict[str, str]
        :param output_connection_id: The output_connection_id of this ModelPackagingConfig.  # noqa: E501
        :type output_connection_id: str
        :param packager_integration_namespace: The packager_integration_namespace of this ModelPackagingConfig.  # noqa: E501
        :type packager_integration_namespace: str
        :param service_account: The service_account of this ModelPackagingConfig.  # noqa: E501
        :type service_account: str
        :param timeout: The timeout of this ModelPackagingConfig.  # noqa: E501
        :type timeout: str
        :param toleration: The toleration of this ModelPackagingConfig.  # noqa: E501
        :type toleration: Dict[str, str]
        """
        self.swagger_types = {
            'enabled': bool,
            'model_packager_image': str,
            'namespace': str,
            'node_selector': Dict[str, str],
            'output_connection_id': str,
            'packager_integration_namespace': str,
            'service_account': str,
            'timeout': str,
            'toleration': Dict[str, str]
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'model_packager_image': 'modelPackagerImage',
            'namespace': 'namespace',
            'node_selector': 'nodeSelector',
            'output_connection_id': 'outputConnectionID',
            'packager_integration_namespace': 'packagerIntegrationNamespace',
            'service_account': 'serviceAccount',
            'timeout': 'timeout',
            'toleration': 'toleration'
        }

        self._enabled = enabled
        self._model_packager_image = model_packager_image
        self._namespace = namespace
        self._node_selector = node_selector
        self._output_connection_id = output_connection_id
        self._packager_integration_namespace = packager_integration_namespace
        self._service_account = service_account
        self._timeout = timeout
        self._toleration = toleration

    @classmethod
    def from_dict(cls, dikt) -> 'ModelPackagingConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelPackagingConfig of this ModelPackagingConfig.  # noqa: E501
        :rtype: ModelPackagingConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def enabled(self) -> bool:
        """Gets the enabled of this ModelPackagingConfig.

        Enable packaging API/operator  # noqa: E501

        :return: The enabled of this ModelPackagingConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool):
        """Sets the enabled of this ModelPackagingConfig.

        Enable packaging API/operator  # noqa: E501

        :param enabled: The enabled of this ModelPackagingConfig.
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def model_packager_image(self) -> str:
        """Gets the model_packager_image of this ModelPackagingConfig.


        :return: The model_packager_image of this ModelPackagingConfig.
        :rtype: str
        """
        return self._model_packager_image

    @model_packager_image.setter
    def model_packager_image(self, model_packager_image: str):
        """Sets the model_packager_image of this ModelPackagingConfig.


        :param model_packager_image: The model_packager_image of this ModelPackagingConfig.
        :type model_packager_image: str
        """

        self._model_packager_image = model_packager_image

    @property
    def namespace(self) -> str:
        """Gets the namespace of this ModelPackagingConfig.

        Kubernetes namespace, where model trainings will be deployed  # noqa: E501

        :return: The namespace of this ModelPackagingConfig.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str):
        """Sets the namespace of this ModelPackagingConfig.

        Kubernetes namespace, where model trainings will be deployed  # noqa: E501

        :param namespace: The namespace of this ModelPackagingConfig.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def node_selector(self) -> Dict[str, str]:
        """Gets the node_selector of this ModelPackagingConfig.

        Kubernetes node selectors for model packaging pods  # noqa: E501

        :return: The node_selector of this ModelPackagingConfig.
        :rtype: Dict[str, str]
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector: Dict[str, str]):
        """Sets the node_selector of this ModelPackagingConfig.

        Kubernetes node selectors for model packaging pods  # noqa: E501

        :param node_selector: The node_selector of this ModelPackagingConfig.
        :type node_selector: Dict[str, str]
        """

        self._node_selector = node_selector

    @property
    def output_connection_id(self) -> str:
        """Gets the output_connection_id of this ModelPackagingConfig.


        :return: The output_connection_id of this ModelPackagingConfig.
        :rtype: str
        """
        return self._output_connection_id

    @output_connection_id.setter
    def output_connection_id(self, output_connection_id: str):
        """Sets the output_connection_id of this ModelPackagingConfig.


        :param output_connection_id: The output_connection_id of this ModelPackagingConfig.
        :type output_connection_id: str
        """

        self._output_connection_id = output_connection_id

    @property
    def packager_integration_namespace(self) -> str:
        """Gets the packager_integration_namespace of this ModelPackagingConfig.


        :return: The packager_integration_namespace of this ModelPackagingConfig.
        :rtype: str
        """
        return self._packager_integration_namespace

    @packager_integration_namespace.setter
    def packager_integration_namespace(self, packager_integration_namespace: str):
        """Sets the packager_integration_namespace of this ModelPackagingConfig.


        :param packager_integration_namespace: The packager_integration_namespace of this ModelPackagingConfig.
        :type packager_integration_namespace: str
        """

        self._packager_integration_namespace = packager_integration_namespace

    @property
    def service_account(self) -> str:
        """Gets the service_account of this ModelPackagingConfig.


        :return: The service_account of this ModelPackagingConfig.
        :rtype: str
        """
        return self._service_account

    @service_account.setter
    def service_account(self, service_account: str):
        """Sets the service_account of this ModelPackagingConfig.


        :param service_account: The service_account of this ModelPackagingConfig.
        :type service_account: str
        """

        self._service_account = service_account

    @property
    def timeout(self) -> str:
        """Gets the timeout of this ModelPackagingConfig.

        Timeout for full training process  # noqa: E501

        :return: The timeout of this ModelPackagingConfig.
        :rtype: str
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout: str):
        """Sets the timeout of this ModelPackagingConfig.

        Timeout for full training process  # noqa: E501

        :param timeout: The timeout of this ModelPackagingConfig.
        :type timeout: str
        """

        self._timeout = timeout

    @property
    def toleration(self) -> Dict[str, str]:
        """Gets the toleration of this ModelPackagingConfig.

        Kubernetes tolerations for model packaging pods  # noqa: E501

        :return: The toleration of this ModelPackagingConfig.
        :rtype: Dict[str, str]
        """
        return self._toleration

    @toleration.setter
    def toleration(self, toleration: Dict[str, str]):
        """Sets the toleration of this ModelPackagingConfig.

        Kubernetes tolerations for model packaging pods  # noqa: E501

        :param toleration: The toleration of this ModelPackagingConfig.
        :type toleration: Dict[str, str]
        """

        self._toleration = toleration
