# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.auth_config import AuthConfig  # noqa: F401,E501
from odahuflow.sdk.models import util


class TrainerConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, auth: AuthConfig=None, model_training_id: str=None, mt_file: str=None, output_training_dir: str=None):  # noqa: E501
        """TrainerConfig - a model defined in Swagger

        :param auth: The auth of this TrainerConfig.  # noqa: E501
        :type auth: AuthConfig
        :param model_training_id: The model_training_id of this TrainerConfig.  # noqa: E501
        :type model_training_id: str
        :param mt_file: The mt_file of this TrainerConfig.  # noqa: E501
        :type mt_file: str
        :param output_training_dir: The output_training_dir of this TrainerConfig.  # noqa: E501
        :type output_training_dir: str
        """
        self.swagger_types = {
            'auth': AuthConfig,
            'model_training_id': str,
            'mt_file': str,
            'output_training_dir': str
        }

        self.attribute_map = {
            'auth': 'auth',
            'model_training_id': 'modelTrainingId',
            'mt_file': 'mtFile',
            'output_training_dir': 'outputTrainingDir'
        }

        self._auth = auth
        self._model_training_id = model_training_id
        self._mt_file = mt_file
        self._output_training_dir = output_training_dir

    @classmethod
    def from_dict(cls, dikt) -> 'TrainerConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TrainerConfig of this TrainerConfig.  # noqa: E501
        :rtype: TrainerConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def auth(self) -> AuthConfig:
        """Gets the auth of this TrainerConfig.


        :return: The auth of this TrainerConfig.
        :rtype: AuthConfig
        """
        return self._auth

    @auth.setter
    def auth(self, auth: AuthConfig):
        """Sets the auth of this TrainerConfig.


        :param auth: The auth of this TrainerConfig.
        :type auth: AuthConfig
        """

        self._auth = auth

    @property
    def model_training_id(self) -> str:
        """Gets the model_training_id of this TrainerConfig.

        ID of the model training  # noqa: E501

        :return: The model_training_id of this TrainerConfig.
        :rtype: str
        """
        return self._model_training_id

    @model_training_id.setter
    def model_training_id(self, model_training_id: str):
        """Sets the model_training_id of this TrainerConfig.

        ID of the model training  # noqa: E501

        :param model_training_id: The model_training_id of this TrainerConfig.
        :type model_training_id: str
        """

        self._model_training_id = model_training_id

    @property
    def mt_file(self) -> str:
        """Gets the mt_file of this TrainerConfig.

        The path to the configuration file for a user trainer.  # noqa: E501

        :return: The mt_file of this TrainerConfig.
        :rtype: str
        """
        return self._mt_file

    @mt_file.setter
    def mt_file(self, mt_file: str):
        """Sets the mt_file of this TrainerConfig.

        The path to the configuration file for a user trainer.  # noqa: E501

        :param mt_file: The mt_file of this TrainerConfig.
        :type mt_file: str
        """

        self._mt_file = mt_file

    @property
    def output_training_dir(self) -> str:
        """Gets the output_training_dir of this TrainerConfig.

        The path to the dir when a user trainer will save their result.  # noqa: E501

        :return: The output_training_dir of this TrainerConfig.
        :rtype: str
        """
        return self._output_training_dir

    @output_training_dir.setter
    def output_training_dir(self, output_training_dir: str):
        """Sets the output_training_dir of this TrainerConfig.

        The path to the dir when a user trainer will save their result.  # noqa: E501

        :param output_training_dir: The output_training_dir of this TrainerConfig.
        :type output_training_dir: str
        """

        self._output_training_dir = output_training_dir
