"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnInclude = void 0;
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class CfnInclude extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param props Initialization properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.CfnInclude = CfnInclude;
//# sourceMappingURL=data:application/json;base64,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