"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemovalPolicy = void 0;
var RemovalPolicy;
(function (RemovalPolicy) {
    /**
     * This is the default removal policy. It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    RemovalPolicy["DESTROY"] = "destroy";
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained
     * in the account, but orphaned from the stack.
     */
    RemovalPolicy["RETAIN"] = "retain";
    /**
     * This retention policy deletes the resource,
     * but saves a snapshot of its data before deleting,
     * so that it can be re-created later.
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    RemovalPolicy["SNAPSHOT"] = "snapshot";
})(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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