"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const sinon = require("sinon");
const fs_1 = require("../../lib/fs");
module.exports = {
    'tearDown'(callback) {
        sinon.restore();
        callback();
    },
    'tmpdir returns a real path and is cached'(test) {
        // Create symlink that points to /tmp
        const symlinkTmp = path.join(__dirname, 'tmp-link');
        fs.symlinkSync(os.tmpdir(), symlinkTmp);
        // Now stub os.tmpdir() to return this link instead of /tmp
        const tmpdirStub = sinon.stub(os, 'tmpdir').returns(symlinkTmp);
        test.ok(path.isAbsolute(fs_1.FileSystem.tmpdir));
        const p = path.join(fs_1.FileSystem.tmpdir, 'tmpdir-test.txt');
        fs.writeFileSync(p, 'tmpdir-test');
        test.equal(p, fs.realpathSync(p));
        test.equal(fs.readFileSync(p, 'utf8'), 'tmpdir-test');
        test.ok(tmpdirStub.calledOnce); // cached result
        fs.unlinkSync(p);
        fs.unlinkSync(symlinkTmp);
        test.done();
    },
    'mkdtemp creates a temporary directory in the system temp'(test) {
        const tmpdir = fs_1.FileSystem.mkdtemp('cdk-mkdtemp-');
        test.equal(path.dirname(tmpdir), fs_1.FileSystem.tmpdir);
        test.ok(fs.existsSync(tmpdir));
        fs.rmdirSync(tmpdir);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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