"use strict";
const lib_1 = require("../lib");
const construct_compat_1 = require("../lib/construct-compat");
class MyConstruct extends construct_compat_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
module.exports = {
    'Aspects are invoked only once'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        root.node.applyAspect(new VisitOnce());
        construct_compat_1.ConstructNode.prepare(root.node);
        test.deepEqual(root.visitCounter, 1);
        construct_compat_1.ConstructNode.prepare(root.node);
        test.deepEqual(root.visitCounter, 1);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hc3BlY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmFzcGVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQ0EsZ0NBQTZCO0FBRTdCLDhEQUErRTtBQUUvRSxNQUFNLFdBQVksU0FBUSw0QkFBUztJQUFuQzs7UUFJUyxpQkFBWSxHQUFXLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBSlEsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFNO1FBQ2hDLE9BQU8sQ0FBQyxDQUFDLFlBQVksS0FBSyxTQUFTLENBQUM7SUFDdEMsQ0FBQztDQUVGO0FBRUQsTUFBTSxTQUFTO0lBQ04sS0FBSyxDQUFDLElBQWdCO1FBQzNCLElBQUksV0FBVyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNuQyxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsQ0FBQztTQUN4QjtJQUNILENBQUM7Q0FDRjtBQUNELGlCQUFTO0lBQ1AsK0JBQStCLENBQUMsSUFBVTtRQUN4QyxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQUcsRUFBRSxDQUFDO1FBQ3RCLE1BQU0sSUFBSSxHQUFHLElBQUksV0FBVyxDQUFDLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUNqRCxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDdkMsZ0NBQWEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUMsQ0FBQztRQUNyQyxnQ0FBYSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDakMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCB7IEFwcCB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBJQXNwZWN0IH0gZnJvbSAnLi4vbGliL2FzcGVjdCc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIENvbnN0cnVjdE5vZGUsIElDb25zdHJ1Y3QgfSBmcm9tICcuLi9saWIvY29uc3RydWN0LWNvbXBhdCc7XG5cbmNsYXNzIE15Q29uc3RydWN0IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHN0YXRpYyBJc015Q29uc3RydWN0KHg6IGFueSk6IHggaXMgTXlDb25zdHJ1Y3Qge1xuICAgIHJldHVybiB4LnZpc2l0Q291bnRlciAhPT0gdW5kZWZpbmVkO1xuICB9XG4gIHB1YmxpYyB2aXNpdENvdW50ZXI6IG51bWJlciA9IDA7XG59XG5cbmNsYXNzIFZpc2l0T25jZSBpbXBsZW1lbnRzIElBc3BlY3Qge1xuICBwdWJsaWMgdmlzaXQobm9kZTogSUNvbnN0cnVjdCk6IHZvaWQge1xuICAgIGlmIChNeUNvbnN0cnVjdC5Jc015Q29uc3RydWN0KG5vZGUpKSB7XG4gICAgICBub2RlLnZpc2l0Q291bnRlciArPSAxO1xuICAgIH1cbiAgfVxufVxuZXhwb3J0ID0ge1xuICAnQXNwZWN0cyBhcmUgaW52b2tlZCBvbmx5IG9uY2UnKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgQXBwKCk7XG4gICAgY29uc3Qgcm9vdCA9IG5ldyBNeUNvbnN0cnVjdChhcHAsICdNeUNvbnN0cnVjdCcpO1xuICAgIHJvb3Qubm9kZS5hcHBseUFzcGVjdChuZXcgVmlzaXRPbmNlKCkpO1xuICAgIENvbnN0cnVjdE5vZGUucHJlcGFyZShyb290Lm5vZGUpO1xuICAgIHRlc3QuZGVlcEVxdWFsKHJvb3QudmlzaXRDb3VudGVyLCAxKTtcbiAgICBDb25zdHJ1Y3ROb2RlLnByZXBhcmUocm9vdC5ub2RlKTtcbiAgICB0ZXN0LmRlZXBFcXVhbChyb290LnZpc2l0Q291bnRlciwgMSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59O1xuIl19