"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.restoreStackTraceColection = exports.reEnableStackTraceCollection = exports.toCloudFormation = void 0;
const lib_1 = require("../lib");
function toCloudFormation(stack) {
    return lib_1.ConstructNode.synth(stack.node, { skipValidation: true }).getStackByName(stack.stackName).template;
}
exports.toCloudFormation = toCloudFormation;
function reEnableStackTraceCollection() {
    const previousValue = process.env.CDK_DISABLE_STACK_TRACE;
    process.env.CDK_DISABLE_STACK_TRACE = '';
    return previousValue;
}
exports.reEnableStackTraceCollection = reEnableStackTraceCollection;
function restoreStackTraceColection(previousValue) {
    process.env.CDK_DISABLE_STACK_TRACE = previousValue;
}
exports.restoreStackTraceColection = restoreStackTraceColection;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsZ0NBQThDO0FBRTlDLFNBQWdCLGdCQUFnQixDQUFDLEtBQVk7SUFDM0MsT0FBTyxtQkFBYSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQyxRQUFRLENBQUM7QUFDNUcsQ0FBQztBQUZELDRDQUVDO0FBRUQsU0FBZ0IsNEJBQTRCO0lBQzFDLE1BQU0sYUFBYSxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLENBQUM7SUFDMUQsT0FBTyxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsR0FBRyxFQUFFLENBQUM7SUFDekMsT0FBTyxhQUFhLENBQUM7QUFDdkIsQ0FBQztBQUpELG9FQUlDO0FBRUQsU0FBZ0IsMEJBQTBCLENBQUMsYUFBa0I7SUFDM0QsT0FBTyxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsR0FBRyxhQUFhLENBQUM7QUFDdEQsQ0FBQztBQUZELGdFQUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0Tm9kZSwgU3RhY2sgfSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgZnVuY3Rpb24gdG9DbG91ZEZvcm1hdGlvbihzdGFjazogU3RhY2spOiBhbnkge1xuICByZXR1cm4gQ29uc3RydWN0Tm9kZS5zeW50aChzdGFjay5ub2RlLCB7IHNraXBWYWxpZGF0aW9uOiB0cnVlIH0pLmdldFN0YWNrQnlOYW1lKHN0YWNrLnN0YWNrTmFtZSkudGVtcGxhdGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiByZUVuYWJsZVN0YWNrVHJhY2VDb2xsZWN0aW9uKCk6IGFueSB7XG4gIGNvbnN0IHByZXZpb3VzVmFsdWUgPSBwcm9jZXNzLmVudi5DREtfRElTQUJMRV9TVEFDS19UUkFDRTtcbiAgcHJvY2Vzcy5lbnYuQ0RLX0RJU0FCTEVfU1RBQ0tfVFJBQ0UgPSAnJztcbiAgcmV0dXJuIHByZXZpb3VzVmFsdWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiByZXN0b3JlU3RhY2tUcmFjZUNvbGVjdGlvbihwcmV2aW91c1ZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgcHJvY2Vzcy5lbnYuQ0RLX0RJU0FCTEVfU1RBQ0tfVFJBQ0UgPSBwcmV2aW91c1ZhbHVlO1xufVxuIl19