""" Rsna.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import ErrorCreatingStudy
from ambra_sdk.exceptions.service import ExamNotFound
from ambra_sdk.service.query import QueryO

class Rsna:
    """Rsna."""

    def __init__(self, api):
        self._api = api

    
    def phr_study(
        self,
        access_code,
        dob,
        exam_id,
        namespace,
        pin,
        clearinghouse=None,
    ):
        """Phr_study.
        :param access_code: RSNA-generated access code
        :param dob: Patient's date of birth YYYYMMDD
        :param exam_id: RSNA-generated exam ID/token/email (DEPRECATED June 2015 - use access_code)
        :param namespace: Namespace where retrieved exam will be stored
        :param pin: RSNA-generated PIN (DEPRECATED June 2015 - use access_code)
        :param clearinghouse: Clearinghouse to retrieve exam from: test or blank (optional)
        """
        request_data = {
           'access_code': access_code,
           'clearinghouse': clearinghouse,
           'dob': dob,
           'exam_id': exam_id,
           'namespace': namespace,
           'pin': pin,
        }
	
        errors_mapping = {}
        errors_mapping[('ERROR_CREATING_STUDY', None)] = ErrorCreatingStudy('An unknown error was received when study was added via /study/add')
        errors_mapping[('EXAM_NOT_FOUND', None)] = ExamNotFound('Exam cannot be found in designated RSNA Image Share clearinghouse')
        query_data = {
            'api': self._api,
            'url': '/rsna/phr_study',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    