"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferenceEvent = void 0;
const events = require("@aws-cdk/aws-events");
/**
 * Fields of CloudWatch Events that change references
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
class ReferenceEvent {
    /**
     * The type of reference event
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * Name of the CodeCommit repository
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * Id of the CodeCommit repository
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * Type of reference changed
     *
     * 'branch' or 'tag'
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * Name of reference changed (branch or tag name)
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * Full reference name
     *
     * For example, 'refs/tags/myTag'
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * Commit id this reference now points to
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
    constructor() {
    }
}
exports.ReferenceEvent = ReferenceEvent;
//# sourceMappingURL=data:application/json;base64,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