"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'comprehendmedical';
        this.accessLevelList = {
            Read: [
                'DescribeEntitiesDetectionV2Job',
                'DescribeICD10CMInferenceJob',
                'DescribePHIDetectionJob',
                'DescribeRxNormInferenceJob',
                'DescribeSNOMEDCTInferenceJob',
                'DetectEntitiesV2',
                'DetectPHI',
                'InferICD10CM',
                'InferRxNorm',
                'InferSNOMEDCT',
                'ListEntitiesDetectionV2Jobs',
                'ListICD10CMInferenceJobs',
                'ListPHIDetectionJobs',
                'ListRxNormInferenceJobs',
                'ListSNOMEDCTInferenceJobs'
            ],
            Write: [
                'StartEntitiesDetectionV2Job',
                'StartICD10CMInferenceJob',
                'StartPHIDetectionJob',
                'StartRxNormInferenceJob',
                'StartSNOMEDCTInferenceJob',
                'StopEntitiesDetectionV2Job',
                'StopICD10CMInferenceJob',
                'StopPHIDetectionJob',
                'StopRxNormInferenceJob',
                'StopSNOMEDCTInferenceJob'
            ]
        };
    }
    /**
     * Grants permission to describe the properties of a medical entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeEntitiesDetectionV2Job.html
     */
    toDescribeEntitiesDetectionV2Job() {
        return this.to('DescribeEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeICD10CMInferenceJob.html
     */
    toDescribeICD10CMInferenceJob() {
        return this.to('DescribeICD10CMInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a PHI entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribePHIDetectionJob.html
     */
    toDescribePHIDetectionJob() {
        return this.to('DescribePHIDetectionJob');
    }
    /**
     * Grants permission to describe the properties of an RxNorm linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeRxNormInferenceJob.html
     */
    toDescribeRxNormInferenceJob() {
        return this.to('DescribeRxNormInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a SNOMED-CT linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeSNOMEDCTInferenceJob.html
     */
    toDescribeSNOMEDCTInferenceJob() {
        return this.to('DescribeSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to detect the named medical entities, and their relationships and traits within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DetectEntitiesV2.html
     */
    toDetectEntitiesV2() {
        return this.to('DetectEntitiesV2');
    }
    /**
     * Grants permission to detect the protected health information (PHI) entities within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DetectPHI.html
     */
    toDetectPHI() {
        return this.to('DetectPHI');
    }
    /**
     * Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferICD10CM.html
     */
    toInferICD10CM() {
        return this.to('InferICD10CM');
    }
    /**
     * Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferRxNorm.html
     */
    toInferRxNorm() {
        return this.to('InferRxNorm');
    }
    /**
     * Grants permission to detect the medical condition, anatomy, and test, treatment, and procedure entities within the given text document and link them to SNOMED-CT codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferSNOMEDCT.html
     */
    toInferSNOMEDCT() {
        return this.to('InferSNOMEDCT');
    }
    /**
     * Grants permission to list the medical entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListEntitiesDetectionV2Jobs.html
     */
    toListEntitiesDetectionV2Jobs() {
        return this.to('ListEntitiesDetectionV2Jobs');
    }
    /**
     * Grants permission to list the ICD-10-CM linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListICD10CMInferenceJobs.html
     */
    toListICD10CMInferenceJobs() {
        return this.to('ListICD10CMInferenceJobs');
    }
    /**
     * Grants permission to list the PHI entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListPHIDetectionJobs.html
     */
    toListPHIDetectionJobs() {
        return this.to('ListPHIDetectionJobs');
    }
    /**
     * Grants permission to list the RxNorm linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListRxNormInferenceJobs.html
     */
    toListRxNormInferenceJobs() {
        return this.to('ListRxNormInferenceJobs');
    }
    /**
     * Grants permission to list the SNOMED-CT linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListSNOMEDCTInferenceJobs.html
     */
    toListSNOMEDCTInferenceJobs() {
        return this.to('ListSNOMEDCTInferenceJobs');
    }
    /**
     * Grants permission to start an asynchronous medical entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartEntitiesDetectionV2Job.html
     */
    toStartEntitiesDetectionV2Job() {
        return this.to('StartEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartICD10CMInferenceJob.html
     */
    toStartICD10CMInferenceJob() {
        return this.to('StartICD10CMInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous PHI entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartPHIDetectionJob.html
     */
    toStartPHIDetectionJob() {
        return this.to('StartPHIDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous RxNorm linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartRxNormInferenceJob.html
     */
    toStartRxNormInferenceJob() {
        return this.to('StartRxNormInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous SNOMED-CT linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartSNOMEDCTInferenceJob.html
     */
    toStartSNOMEDCTInferenceJob() {
        return this.to('StartSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to stop a medical entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopEntitiesDetectionV2Job.html
     */
    toStopEntitiesDetectionV2Job() {
        return this.to('StopEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to stop an ICD-10-CM linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopICD10CMInferenceJob.html
     */
    toStopICD10CMInferenceJob() {
        return this.to('StopICD10CMInferenceJob');
    }
    /**
     * Grants permission to stop a PHI entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopPHIDetectionJob.html
     */
    toStopPHIDetectionJob() {
        return this.to('StopPHIDetectionJob');
    }
    /**
     * Grants permission to stop an RxNorm linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopRxNormInferenceJob.html
     */
    toStopRxNormInferenceJob() {
        return this.to('StopRxNormInferenceJob');
    }
    /**
     * Grants permission to stop a SNOMED-CT linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopSNOMEDCTInferenceJob.html
     */
    toStopSNOMEDCTInferenceJob() {
        return this.to('StopSNOMEDCTInferenceJob');
    }
}
exports.Comprehendmedical = Comprehendmedical;
_a = JSII_RTTI_SYMBOL_1;
Comprehendmedical[_a] = { fqn: "iam-floyd.Comprehendmedical", version: "0.492.0" };
//# sourceMappingURL=data:application/json;base64,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