"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Omics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [omics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonomics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Omics extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [omics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonomics.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'omics';
        this.accessLevelList = {
            Write: [
                'BatchDeleteReadSet',
                'CancelAnnotationImportJob',
                'CancelRun',
                'CancelVariantImportJob',
                'CreateAnnotationStore',
                'CreateReferenceStore',
                'CreateRunGroup',
                'CreateSequenceStore',
                'CreateVariantStore',
                'CreateWorkflow',
                'DeleteAnnotationStore',
                'DeleteReference',
                'DeleteReferenceStore',
                'DeleteRun',
                'DeleteRunGroup',
                'DeleteSequenceStore',
                'DeleteVariantStore',
                'DeleteWorkflow',
                'StartAnnotationImportJob',
                'StartReadSetActivationJob',
                'StartReadSetExportJob',
                'StartReadSetImportJob',
                'StartReferenceImportJob',
                'StartRun',
                'StartVariantImportJob',
                'UpdateAnnotationStore',
                'UpdateRunGroup',
                'UpdateVariantStore',
                'UpdateWorkflow'
            ],
            Read: [
                'GetAnnotationImportJob',
                'GetAnnotationStore',
                'GetReadSet',
                'GetReadSetActivationJob',
                'GetReadSetExportJob',
                'GetReadSetImportJob',
                'GetReadSetMetadata',
                'GetReference',
                'GetReferenceImportJob',
                'GetReferenceMetadata',
                'GetReferenceStore',
                'GetRun',
                'GetRunGroup',
                'GetRunTask',
                'GetSequenceStore',
                'GetVariantImportJob',
                'GetVariantStore',
                'GetWorkflow'
            ],
            List: [
                'ListAnnotationImportJobs',
                'ListAnnotationStores',
                'ListReadSetActivationJobs',
                'ListReadSetExportJobs',
                'ListReadSetImportJobs',
                'ListReadSets',
                'ListReferenceImportJobs',
                'ListReferenceStores',
                'ListReferences',
                'ListRunGroups',
                'ListRunTasks',
                'ListRuns',
                'ListSequenceStores',
                'ListTagsForResource',
                'ListVariantImportJobs',
                'ListVariantStores',
                'ListWorkflows'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to batch delete Read Sets in the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_BatchDeleteReadSet.html
     */
    toBatchDeleteReadSet() {
        return this.to('BatchDeleteReadSet');
    }
    /**
     * Grants permission to cancel an Annotation Import Job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelAnnotationImportJob.html
     */
    toCancelAnnotationImportJob() {
        return this.to('CancelAnnotationImportJob');
    }
    /**
     * Grants permission to cancel a workflow run and stop all workflow tasks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelRun.html
     */
    toCancelRun() {
        return this.to('CancelRun');
    }
    /**
     * Grants permission to cancel a Variant Import Job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CancelVariantImportJob.html
     */
    toCancelVariantImportJob() {
        return this.to('CancelVariantImportJob');
    }
    /**
     * Grants permission to create an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateAnnotationStore.html
     */
    toCreateAnnotationStore() {
        return this.to('CreateAnnotationStore');
    }
    /**
     * Grants permission to create a Reference Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateReferenceStore.html
     */
    toCreateReferenceStore() {
        return this.to('CreateReferenceStore');
    }
    /**
     * Grants permission to create a new workflow run group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateRunGroup.html
     */
    toCreateRunGroup() {
        return this.to('CreateRunGroup');
    }
    /**
     * Grants permission to create a Sequence Store
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateSequenceStore.html
     */
    toCreateSequenceStore() {
        return this.to('CreateSequenceStore');
    }
    /**
     * Grants permission to create a Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateVariantStore.html
     */
    toCreateVariantStore() {
        return this.to('CreateVariantStore');
    }
    /**
     * Grants permission to create a new workflow with a workflow definition and template of workflow parameters
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_CreateWorkflow.html
     */
    toCreateWorkflow() {
        return this.to('CreateWorkflow');
    }
    /**
     * Grants permission to delete an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteAnnotationStore.html
     */
    toDeleteAnnotationStore() {
        return this.to('DeleteAnnotationStore');
    }
    /**
     * Grants permission to delete a Reference in the given Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteReference.html
     */
    toDeleteReference() {
        return this.to('DeleteReference');
    }
    /**
     * Grants permission to delete a Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteReferenceStore.html
     */
    toDeleteReferenceStore() {
        return this.to('DeleteReferenceStore');
    }
    /**
     * Grants permission to delete a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteRun.html
     */
    toDeleteRun() {
        return this.to('DeleteRun');
    }
    /**
     * Grants permission to delete a workflow run group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteRunGroup.html
     */
    toDeleteRunGroup() {
        return this.to('DeleteRunGroup');
    }
    /**
     * Grants permission to delete a Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteSequenceStore.html
     */
    toDeleteSequenceStore() {
        return this.to('DeleteSequenceStore');
    }
    /**
     * Grants permission to delete a Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteVariantStore.html
     */
    toDeleteVariantStore() {
        return this.to('DeleteVariantStore');
    }
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_DeleteWorkflow.html
     */
    toDeleteWorkflow() {
        return this.to('DeleteWorkflow');
    }
    /**
     * Grants permission to get the status of an Annotation Import Job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetAnnotationImportJob.html
     */
    toGetAnnotationImportJob() {
        return this.to('GetAnnotationImportJob');
    }
    /**
     * Grants permission to get detailed information about an Annotation Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetAnnotationStore.html
     */
    toGetAnnotationStore() {
        return this.to('GetAnnotationStore');
    }
    /**
     * Grants permission to get a Read Set in the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSet.html
     */
    toGetReadSet() {
        return this.to('GetReadSet');
    }
    /**
     * Grants permission to get details about a Read Set activation job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetActivationJob.html
     */
    toGetReadSetActivationJob() {
        return this.to('GetReadSetActivationJob');
    }
    /**
     * Grants permission to get details about a Read Set export job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetExportJob.html
     */
    toGetReadSetExportJob() {
        return this.to('GetReadSetExportJob');
    }
    /**
     * Grants permission to get details about a Read Set import job for the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetImportJob.html
     */
    toGetReadSetImportJob() {
        return this.to('GetReadSetImportJob');
    }
    /**
     * Grants permission to get details about a Read Set in the given Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReadSetMetadata.html
     */
    toGetReadSetMetadata() {
        return this.to('GetReadSetMetadata');
    }
    /**
     * Grants permission to get a Reference in the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReference.html
     */
    toGetReference() {
        return this.to('GetReference');
    }
    /**
     * Grants permission to get details about a Reference import job for the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceImportJob.html
     */
    toGetReferenceImportJob() {
        return this.to('GetReferenceImportJob');
    }
    /**
     * Grants permission to get details about a Reference in the given Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceMetadata.html
     */
    toGetReferenceMetadata() {
        return this.to('GetReferenceMetadata');
    }
    /**
     * Grants permission to get details about a Reference Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetReferenceStore.html
     */
    toGetReferenceStore() {
        return this.to('GetReferenceStore');
    }
    /**
     * Grants permission to retrieve workflow run details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRun.html
     */
    toGetRun() {
        return this.to('GetRun');
    }
    /**
     * Grants permission to retrieve workflow run group details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRunGroup.html
     */
    toGetRunGroup() {
        return this.to('GetRunGroup');
    }
    /**
     * Grants permission to retrieve workflow task details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetRunTask.html
     */
    toGetRunTask() {
        return this.to('GetRunTask');
    }
    /**
     * Grants permission to get details about a Sequence Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetSequenceStore.html
     */
    toGetSequenceStore() {
        return this.to('GetSequenceStore');
    }
    /**
     * Grants permission to get the status of a Variant Import Job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetVariantImportJob.html
     */
    toGetVariantImportJob() {
        return this.to('GetVariantImportJob');
    }
    /**
     * Grants permission to get detailed information about a Variant Store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetVariantStore.html
     */
    toGetVariantStore() {
        return this.to('GetVariantStore');
    }
    /**
     * Grants permission to retrieve workflow details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_GetWorkflow.html
     */
    toGetWorkflow() {
        return this.to('GetWorkflow');
    }
    /**
     * Grants permission to get a list of Annotation Import Jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListAnnotationImportJobs.html
     */
    toListAnnotationImportJobs() {
        return this.to('ListAnnotationImportJobs');
    }
    /**
     * Grants permission to retrieve a list of information about Annotation Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListAnnotationStores.html
     */
    toListAnnotationStores() {
        return this.to('ListAnnotationStores');
    }
    /**
     * Grants permission to list Read Set activation jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetActivationJobs.html
     */
    toListReadSetActivationJobs() {
        return this.to('ListReadSetActivationJobs');
    }
    /**
     * Grants permission to list Read Set export jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetExportJobs.html
     */
    toListReadSetExportJobs() {
        return this.to('ListReadSetExportJobs');
    }
    /**
     * Grants permission to list Read Set import jobs for the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSetImportJobs.html
     */
    toListReadSetImportJobs() {
        return this.to('ListReadSetImportJobs');
    }
    /**
     * Grants permission to list Read Sets in the given Sequence Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReadSets.html
     */
    toListReadSets() {
        return this.to('ListReadSets');
    }
    /**
     * Grants permission to list Reference import jobs for the given Reference Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferenceImportJobs.html
     */
    toListReferenceImportJobs() {
        return this.to('ListReferenceImportJobs');
    }
    /**
     * Grants permission to list Reference Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferenceStores.html
     */
    toListReferenceStores() {
        return this.to('ListReferenceStores');
    }
    /**
     * Grants permission to list References in the given Reference Store
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListReferences.html
     */
    toListReferences() {
        return this.to('ListReferences');
    }
    /**
     * Grants permission to retrieve a list of workflow run groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRunGroups.html
     */
    toListRunGroups() {
        return this.to('ListRunGroups');
    }
    /**
     * Grants permission to retrieve a list of tasks for a workflow run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRunTasks.html
     */
    toListRunTasks() {
        return this.to('ListRunTasks');
    }
    /**
     * Grants permission to retrieve a list of workflow runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListRuns.html
     */
    toListRuns() {
        return this.to('ListRuns');
    }
    /**
     * Grants permission to list Sequence Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListSequenceStores.html
     */
    toListSequenceStores() {
        return this.to('ListSequenceStores');
    }
    /**
     * Grants permission to retrieve a list of resource AWS tags
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to get a list of Variant Import Jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListVariantImportJobs.html
     */
    toListVariantImportJobs() {
        return this.to('ListVariantImportJobs');
    }
    /**
     * Grants permission to retrieve a list of metadata for Variant Stores
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListVariantStores.html
     */
    toListVariantStores() {
        return this.to('ListVariantStores');
    }
    /**
     * Grants permission to retrieve a list of available workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ListWorkflows.html
     */
    toListWorkflows() {
        return this.to('ListWorkflows');
    }
    /**
     * Grants permission to import a list of Annotation files to an Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartAnnotationImportJob.html
     */
    toStartAnnotationImportJob() {
        return this.to('StartAnnotationImportJob');
    }
    /**
     * Grants permission to start a Read Set activation job from the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetActivationJob.html
     */
    toStartReadSetActivationJob() {
        return this.to('StartReadSetActivationJob');
    }
    /**
     * Grants permission to start a Read Set export job from the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetExportJob.html
     */
    toStartReadSetExportJob() {
        return this.to('StartReadSetExportJob');
    }
    /**
     * Grants permission to start a Read Set import job into the given Sequence Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReadSetImportJob.html
     */
    toStartReadSetImportJob() {
        return this.to('StartReadSetImportJob');
    }
    /**
     * Grants permission to start a Reference import job into the given Reference Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartReferenceImportJob.html
     */
    toStartReferenceImportJob() {
        return this.to('StartReferenceImportJob');
    }
    /**
     * Grants permission to start a workflow run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartRun.html
     */
    toStartRun() {
        return this.to('StartRun');
    }
    /**
     * Grants permission to import a list of variant files to an Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_StartVariantImportJob.html
     */
    toStartVariantImportJob() {
        return this.to('StartVariantImportJob');
    }
    /**
     * Grants permission to add AWS tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove resource AWS tags
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update information about the Annotation Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateAnnotationStore.html
     */
    toUpdateAnnotationStore() {
        return this.to('UpdateAnnotationStore');
    }
    /**
     * Grants permission to update a workflow run group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateRunGroup.html
     */
    toUpdateRunGroup() {
        return this.to('UpdateRunGroup');
    }
    /**
     * Grants permission to update metadata about the Variant Store
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateVariantStore.html
     */
    toUpdateVariantStore() {
        return this.to('UpdateVariantStore');
    }
    /**
     * Grants permission to update workflow details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_UpdateWorkflow.html
     */
    toUpdateWorkflow() {
        return this.to('UpdateWorkflow');
    }
    /**
     * Adds a resource of type AnnotationImportJob to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AnnotationImportJobItem.html
     *
     * @param annotationImportJobId - Identifier for the annotationImportJobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAnnotationImportJobJobId()
     */
    onAnnotationImportJob(annotationImportJobId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:annotationImportJob/${annotationImportJobId}`);
    }
    /**
     * Adds a resource of type AnnotationStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_AnnotationStoreItem.html
     *
     * @param annotationStoreId - Identifier for the annotationStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAnnotationStoreName()
     */
    onAnnotationStore(annotationStoreId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:annotationStore/${annotationStoreId}`);
    }
    /**
     * Adds a resource of type readSet to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReadSetFiles.html
     *
     * @param sequenceStoreId - Identifier for the sequenceStoreId.
     * @param readSetId - Identifier for the readSetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReadSet(sequenceStoreId, readSetId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:sequenceStore/${sequenceStoreId}/readSet/${readSetId}`);
    }
    /**
     * Adds a resource of type reference to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReferenceFiles.html
     *
     * @param referenceStoreId - Identifier for the referenceStoreId.
     * @param referenceId - Identifier for the referenceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReference(referenceStoreId, referenceId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:referenceStore/${referenceStoreId}/reference/${referenceId}`);
    }
    /**
     * Adds a resource of type referenceStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_ReferenceStoreDetail.html
     *
     * @param referenceStoreId - Identifier for the referenceStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReferenceStore(referenceStoreId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:referenceStore/${referenceStoreId}`);
    }
    /**
     * Adds a resource of type run to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_RunListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRun(id, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:run/${id}`);
    }
    /**
     * Adds a resource of type runGroup to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_RunGroupListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRunGroup(id, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:runGroup/${id}`);
    }
    /**
     * Adds a resource of type sequenceStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_SequenceStoreDetail.html
     *
     * @param sequenceStoreId - Identifier for the sequenceStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSequenceStore(sequenceStoreId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:sequenceStore/${sequenceStoreId}`);
    }
    /**
     * Adds a resource of type TaggingResource to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TagResource.html
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTaggingResource(tagKey, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:tag/${tagKey}`);
    }
    /**
     * Adds a resource of type TaskResource to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_TaskListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTaskResource(id, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:task/${id}`);
    }
    /**
     * Adds a resource of type VariantImportJob to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_VariantImportJobItem.html
     *
     * @param variantImportJobId - Identifier for the variantImportJobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifVariantImportJobJobId()
     */
    onVariantImportJob(variantImportJobId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:variantImportJob/${variantImportJobId}`);
    }
    /**
     * Adds a resource of type VariantStore to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_VariantStoreItem.html
     *
     * @param variantStoreId - Identifier for the variantStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifVariantStoreName()
     */
    onVariantStore(variantStoreId, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:variantStore/${variantStoreId}`);
    }
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/omics/latest/api/API_WorkflowListItem.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(id, account, region, partition) {
        return this.on(`arn:${partition || Omics.defaultPartition}:omics:${region || '*'}:${account || '*'}:workflow/${id}`);
    }
    /**
     * Filters access by a unique resource identifier
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-annotation-import-job-id
     *
     * Applies to resource types:
     * - AnnotationImportJob
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAnnotationImportJobJobId(value, operator) {
        return this.if(`AnnotationImportJobJobId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the name of the store
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-annotation-store-name
     *
     * Applies to resource types:
     * - AnnotationStore
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAnnotationStoreName(value, operator) {
        return this.if(`AnnotationStoreName`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a unique resource identifier
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-variant-import-job-id
     *
     * Applies to resource types:
     * - VariantImportJob
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVariantImportJobJobId(value, operator) {
        return this.if(`VariantImportJobJobId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the name of the store
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-variant-store-name
     *
     * Applies to resource types:
     * - VariantStore
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVariantStoreName(value, operator) {
        return this.if(`VariantStoreName`, value, operator || 'StringLike');
    }
}
exports.Omics = Omics;
_a = JSII_RTTI_SYMBOL_1;
Omics[_a] = { fqn: "iam-floyd.Omics", version: "0.492.0" };
//# sourceMappingURL=data:application/json;base64,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