"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseOrders = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [purchase-orders](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class PurchaseOrders extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [purchase-orders](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspurchaseordersconsole.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'purchase-orders';
        this.accessLevelList = {
            Write: [
                'AddPurchaseOrder',
                'DeletePurchaseOrder',
                'ModifyPurchaseOrders',
                'UpdatePurchaseOrder',
                'UpdatePurchaseOrderStatus'
            ],
            Read: [
                'GetPurchaseOrder',
                'ViewPurchaseOrders'
            ],
            List: [
                'ListPurchaseOrderInvoices',
                'ListPurchaseOrders'
            ]
        };
    }
    /**
     * Allow or deny IAM users permission to add a new purchase order
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toAddPurchaseOrder() {
        return this.to('AddPurchaseOrder');
    }
    /**
     * Allow or deny IAM users permission to delete a purchase order
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toDeletePurchaseOrder() {
        return this.to('DeletePurchaseOrder');
    }
    /**
     * Allow or deny IAM users permission to get a purchase order
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toGetPurchaseOrder() {
        return this.to('GetPurchaseOrder');
    }
    /**
     * Allow or deny IAM users permission to list purchase order invoices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toListPurchaseOrderInvoices() {
        return this.to('ListPurchaseOrderInvoices');
    }
    /**
     * Allow or deny IAM users permission to get all available purchase orders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toListPurchaseOrders() {
        return this.to('ListPurchaseOrders');
    }
    /**
     * Grants permission to modify purchase orders and details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toModifyPurchaseOrders() {
        return this.to('ModifyPurchaseOrders');
    }
    /**
     * Allow or deny IAM users permission to update an existing purchase order
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toUpdatePurchaseOrder() {
        return this.to('UpdatePurchaseOrder');
    }
    /**
     * Allow or deny IAM users permission to set purchase order status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toUpdatePurchaseOrderStatus() {
        return this.to('UpdatePurchaseOrderStatus');
    }
    /**
     * Grants permission to view purchase orders and details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toViewPurchaseOrders() {
        return this.to('ViewPurchaseOrders');
    }
}
exports.PurchaseOrders = PurchaseOrders;
_a = JSII_RTTI_SYMBOL_1;
PurchaseOrders[_a] = { fqn: "iam-floyd.PurchaseOrders", version: "0.492.0" };
//# sourceMappingURL=data:application/json;base64,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