"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sagemaker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [sagemaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemaker.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Sagemaker extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sagemaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemaker.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sagemaker';
        this.accessLevelList = {
            Write: [
                'AddAssociation',
                'AssociateTrialComponent',
                'BatchPutMetrics',
                'CreateAction',
                'CreateAlgorithm',
                'CreateApp',
                'CreateAppImageConfig',
                'CreateArtifact',
                'CreateAutoMLJob',
                'CreateCodeRepository',
                'CreateCompilationJob',
                'CreateContext',
                'CreateDataQualityJobDefinition',
                'CreateDeviceFleet',
                'CreateDomain',
                'CreateEdgeDeploymentPlan',
                'CreateEdgeDeploymentStage',
                'CreateEdgePackagingJob',
                'CreateEndpoint',
                'CreateEndpointConfig',
                'CreateExperiment',
                'CreateFeatureGroup',
                'CreateFlowDefinition',
                'CreateHub',
                'CreateHumanTaskUi',
                'CreateHyperParameterTuningJob',
                'CreateImage',
                'CreateImageVersion',
                'CreateInferenceExperiment',
                'CreateInferenceRecommendationsJob',
                'CreateLabelingJob',
                'CreateLineageGroupPolicy',
                'CreateModel',
                'CreateModelBiasJobDefinition',
                'CreateModelCard',
                'CreateModelCardExportJob',
                'CreateModelExplainabilityJobDefinition',
                'CreateModelPackage',
                'CreateModelPackageGroup',
                'CreateModelQualityJobDefinition',
                'CreateMonitoringSchedule',
                'CreateNotebookInstance',
                'CreateNotebookInstanceLifecycleConfig',
                'CreatePipeline',
                'CreatePresignedDomainUrl',
                'CreatePresignedNotebookInstanceUrl',
                'CreateProcessingJob',
                'CreateProject',
                'CreateSharedModel',
                'CreateSpace',
                'CreateStudioLifecycleConfig',
                'CreateTrainingJob',
                'CreateTransformJob',
                'CreateTrial',
                'CreateTrialComponent',
                'CreateUserProfile',
                'CreateWorkforce',
                'CreateWorkteam',
                'DeleteAction',
                'DeleteAlgorithm',
                'DeleteApp',
                'DeleteAppImageConfig',
                'DeleteArtifact',
                'DeleteAssociation',
                'DeleteCodeRepository',
                'DeleteContext',
                'DeleteDataQualityJobDefinition',
                'DeleteDeviceFleet',
                'DeleteDomain',
                'DeleteEdgeDeploymentPlan',
                'DeleteEdgeDeploymentStage',
                'DeleteEndpoint',
                'DeleteEndpointConfig',
                'DeleteExperiment',
                'DeleteFeatureGroup',
                'DeleteFlowDefinition',
                'DeleteHub',
                'DeleteHubContent',
                'DeleteHumanLoop',
                'DeleteHumanTaskUi',
                'DeleteImage',
                'DeleteImageVersion',
                'DeleteInferenceExperiment',
                'DeleteLineageGroupPolicy',
                'DeleteModel',
                'DeleteModelBiasJobDefinition',
                'DeleteModelCard',
                'DeleteModelExplainabilityJobDefinition',
                'DeleteModelPackage',
                'DeleteModelPackageGroup',
                'DeleteModelPackageGroupPolicy',
                'DeleteModelQualityJobDefinition',
                'DeleteMonitoringSchedule',
                'DeleteNotebookInstance',
                'DeleteNotebookInstanceLifecycleConfig',
                'DeletePipeline',
                'DeleteProject',
                'DeleteRecord',
                'DeleteSpace',
                'DeleteStudioLifecycleConfig',
                'DeleteTrial',
                'DeleteTrialComponent',
                'DeleteUserProfile',
                'DeleteWorkforce',
                'DeleteWorkteam',
                'DeregisterDevices',
                'DisableSagemakerServicecatalogPortfolio',
                'DisassociateTrialComponent',
                'EnableSagemakerServicecatalogPortfolio',
                'ImportHubContent',
                'PutLineageGroupPolicy',
                'PutModelPackageGroupPolicy',
                'PutRecord',
                'RegisterDevices',
                'RetryPipelineExecution',
                'SendHeartbeat',
                'SendPipelineExecutionStepFailure',
                'SendPipelineExecutionStepSuccess',
                'SendSharedModelEvent',
                'StartEdgeDeploymentStage',
                'StartHumanLoop',
                'StartInferenceExperiment',
                'StartMonitoringSchedule',
                'StartNotebookInstance',
                'StartPipelineExecution',
                'StopAutoMLJob',
                'StopCompilationJob',
                'StopEdgeDeploymentStage',
                'StopEdgePackagingJob',
                'StopHumanLoop',
                'StopHyperParameterTuningJob',
                'StopInferenceExperiment',
                'StopInferenceRecommendationsJob',
                'StopLabelingJob',
                'StopMonitoringSchedule',
                'StopNotebookInstance',
                'StopPipelineExecution',
                'StopProcessingJob',
                'StopTrainingJob',
                'StopTransformJob',
                'UpdateAction',
                'UpdateAppImageConfig',
                'UpdateArtifact',
                'UpdateCodeRepository',
                'UpdateContext',
                'UpdateDeviceFleet',
                'UpdateDevices',
                'UpdateDomain',
                'UpdateEndpoint',
                'UpdateEndpointWeightsAndCapacities',
                'UpdateExperiment',
                'UpdateFeatureGroup',
                'UpdateFeatureMetadata',
                'UpdateHub',
                'UpdateImage',
                'UpdateImageVersion',
                'UpdateInferenceExperiment',
                'UpdateModelCard',
                'UpdateModelPackage',
                'UpdateMonitoringAlert',
                'UpdateMonitoringSchedule',
                'UpdateNotebookInstance',
                'UpdateNotebookInstanceLifecycleConfig',
                'UpdatePipeline',
                'UpdatePipelineExecution',
                'UpdateProject',
                'UpdateSharedModel',
                'UpdateSpace',
                'UpdateTrainingJob',
                'UpdateTrial',
                'UpdateTrialComponent',
                'UpdateUserProfile',
                'UpdateWorkforce',
                'UpdateWorkteam'
            ],
            Tagging: [
                'AddTags',
                'DeleteTags'
            ],
            Read: [
                'BatchDescribeModelPackage',
                'BatchGetMetrics',
                'BatchGetRecord',
                'DescribeAction',
                'DescribeAlgorithm',
                'DescribeApp',
                'DescribeAppImageConfig',
                'DescribeArtifact',
                'DescribeAutoMLJob',
                'DescribeCodeRepository',
                'DescribeCompilationJob',
                'DescribeContext',
                'DescribeDataQualityJobDefinition',
                'DescribeDevice',
                'DescribeDeviceFleet',
                'DescribeDomain',
                'DescribeEdgeDeploymentPlan',
                'DescribeEdgePackagingJob',
                'DescribeEndpoint',
                'DescribeEndpointConfig',
                'DescribeExperiment',
                'DescribeFeatureGroup',
                'DescribeFeatureMetadata',
                'DescribeFlowDefinition',
                'DescribeHub',
                'DescribeHubContent',
                'DescribeHumanLoop',
                'DescribeHumanTaskUi',
                'DescribeHyperParameterTuningJob',
                'DescribeImage',
                'DescribeImageVersion',
                'DescribeInferenceExperiment',
                'DescribeInferenceRecommendationsJob',
                'DescribeLabelingJob',
                'DescribeLineageGroup',
                'DescribeModel',
                'DescribeModelBiasJobDefinition',
                'DescribeModelCard',
                'DescribeModelCardExportJob',
                'DescribeModelExplainabilityJobDefinition',
                'DescribeModelPackage',
                'DescribeModelPackageGroup',
                'DescribeModelQualityJobDefinition',
                'DescribeMonitoringSchedule',
                'DescribeNotebookInstance',
                'DescribeNotebookInstanceLifecycleConfig',
                'DescribePipeline',
                'DescribePipelineDefinitionForExecution',
                'DescribePipelineExecution',
                'DescribeProcessingJob',
                'DescribeProject',
                'DescribeSharedModel',
                'DescribeSpace',
                'DescribeStudioLifecycleConfig',
                'DescribeSubscribedWorkteam',
                'DescribeTrainingJob',
                'DescribeTransformJob',
                'DescribeTrial',
                'DescribeTrialComponent',
                'DescribeUserProfile',
                'DescribeWorkforce',
                'DescribeWorkteam',
                'GetDeployments',
                'GetDeviceFleetReport',
                'GetDeviceRegistration',
                'GetLineageGroupPolicy',
                'GetModelPackageGroupPolicy',
                'GetRecord',
                'GetSagemakerServicecatalogPortfolioStatus',
                'GetSearchSuggestions',
                'InvokeEndpoint',
                'InvokeEndpointAsync',
                'RenderUiTemplate',
                'Search'
            ],
            List: [
                'ListActions',
                'ListAlgorithms',
                'ListAliases',
                'ListAppImageConfigs',
                'ListApps',
                'ListArtifacts',
                'ListAssociations',
                'ListAutoMLJobs',
                'ListCandidatesForAutoMLJob',
                'ListCodeRepositories',
                'ListCompilationJobs',
                'ListContexts',
                'ListDataQualityJobDefinitions',
                'ListDeviceFleets',
                'ListDevices',
                'ListDomains',
                'ListEdgeDeploymentPlans',
                'ListEdgePackagingJobs',
                'ListEndpointConfigs',
                'ListEndpoints',
                'ListExperiments',
                'ListFeatureGroups',
                'ListFlowDefinitions',
                'ListHubContentVersions',
                'ListHubContents',
                'ListHubs',
                'ListHumanLoops',
                'ListHumanTaskUis',
                'ListHyperParameterTuningJobs',
                'ListImageVersions',
                'ListImages',
                'ListInferenceExperiments',
                'ListInferenceRecommendationsJobSteps',
                'ListInferenceRecommendationsJobs',
                'ListLabelingJobs',
                'ListLabelingJobsForWorkteam',
                'ListLineageGroups',
                'ListModelBiasJobDefinitions',
                'ListModelCardExportJobs',
                'ListModelCardVersions',
                'ListModelCards',
                'ListModelExplainabilityJobDefinitions',
                'ListModelMetadata',
                'ListModelPackageGroups',
                'ListModelPackages',
                'ListModelQualityJobDefinitions',
                'ListModels',
                'ListMonitoringAlertHistory',
                'ListMonitoringAlerts',
                'ListMonitoringExecutions',
                'ListMonitoringSchedules',
                'ListNotebookInstanceLifecycleConfigs',
                'ListNotebookInstances',
                'ListPipelineExecutionSteps',
                'ListPipelineExecutions',
                'ListPipelineParametersForExecution',
                'ListPipelines',
                'ListProcessingJobs',
                'ListProjects',
                'ListSharedModelEvents',
                'ListSharedModelVersions',
                'ListSharedModels',
                'ListSpaces',
                'ListStageDevices',
                'ListStudioLifecycleConfigs',
                'ListSubscribedWorkteams',
                'ListTags',
                'ListTrainingJobs',
                'ListTrainingJobsForHyperParameterTuningJob',
                'ListTransformJobs',
                'ListTrialComponents',
                'ListTrials',
                'ListUserProfiles',
                'ListWorkforces',
                'ListWorkteams',
                'QueryLineage'
            ]
        };
    }
    /**
     * Grants permission to associate a lineage entity (artifact, context, action, experiment, experiment-trial-component) to each other
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddAssociation.html
     */
    toAddAssociation() {
        return this.to('AddAssociation');
    }
    /**
     * Grants permission to add or overwrite one or more tags for the specified Amazon SageMaker resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Grants permission to associate a trial component with a trial
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AssociateTrialComponent.html
     */
    toAssociateTrialComponent() {
        return this.to('AssociateTrialComponent');
    }
    /**
     * Grants permission to describe one or more ModelPackages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_BatchDescribeModelPackage.html
     */
    toBatchDescribeModelPackage() {
        return this.to('BatchDescribeModelPackage');
    }
    /**
     * Grants permission to retrieve metrics associated with SageMaker Resources such as Training Jobs or Trial Components. This API is not publicly exposed at this point, however admins can control this action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/
     */
    toBatchGetMetrics() {
        return this.to('BatchGetMetrics');
    }
    /**
     * Grants permission to get a batch of records from one or more feature groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_BatchGetRecord.html
     */
    toBatchGetRecord() {
        return this.to('BatchGetRecord');
    }
    /**
     * Grants permission to publish metrics associated with a SageMaker Resource such as a Training Job or Trial Component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/
     */
    toBatchPutMetrics() {
        return this.to('BatchPutMetrics');
    }
    /**
     * Grants permission to create an action
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAction.html
     */
    toCreateAction() {
        return this.to('CreateAction');
    }
    /**
     * Grants permission to create an algorithm
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAlgorithm.html
     */
    toCreateAlgorithm() {
        return this.to('CreateAlgorithm');
    }
    /**
     * Grants permission to create an App for a SageMaker UserProfile or Space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to create an AppImageConfig
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAppImageConfig.html
     */
    toCreateAppImageConfig() {
        return this.to('CreateAppImageConfig');
    }
    /**
     * Grants permission to create an artifact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateArtifact.html
     */
    toCreateArtifact() {
        return this.to('CreateArtifact');
    }
    /**
     * Grants permission to create an AutoML job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInterContainerTrafficEncryption()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html
     */
    toCreateAutoMLJob() {
        return this.to('CreateAutoMLJob');
    }
    /**
     * Grants permission to create a CodeRepository
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCodeRepository.html
     */
    toCreateCodeRepository() {
        return this.to('CreateCodeRepository');
    }
    /**
     * Grants permission to create a compilation job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html
     */
    toCreateCompilationJob() {
        return this.to('CreateCompilationJob');
    }
    /**
     * Grants permission to create a context
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateContext.html
     */
    toCreateContext() {
        return this.to('CreateContext');
    }
    /**
     * Grants permission to create a data quality job definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDataQualityJobDefinition.html
     */
    toCreateDataQualityJobDefinition() {
        return this.to('CreateDataQualityJobDefinition');
    }
    /**
     * Grants permission to create a device fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDeviceFleet.html
     */
    toCreateDeviceFleet() {
        return this.to('CreateDeviceFleet');
    }
    /**
     * Grants permission to create a Domain for SageMaker Studio
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAppNetworkAccessType()
     * - .ifInstanceTypes()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     * - .ifDomainSharingOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * Grants permission to create an edge deployment plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEdgeDeploymentPlan.html
     */
    toCreateEdgeDeploymentPlan() {
        return this.to('CreateEdgeDeploymentPlan');
    }
    /**
     * Grants permission to create an edge deployment stage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEdgeDeploymentStage.html
     */
    toCreateEdgeDeploymentStage() {
        return this.to('CreateEdgeDeploymentStage');
    }
    /**
     * Grants permission to create an edge packaging job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEdgePackagingJob.html
     */
    toCreateEdgePackagingJob() {
        return this.to('CreateEdgePackagingJob');
    }
    /**
     * Grants permission to create an endpoint using the endpoint configuration specified in the request
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html
     */
    toCreateEndpoint() {
        return this.to('CreateEndpoint');
    }
    /**
     * Grants permission to create an endpoint configuration that can be deployed using Amazon SageMaker hosting services
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAcceleratorTypes()
     * - .ifInstanceTypes()
     * - .ifModelArn()
     * - .ifVolumeKmsKey()
     * - .ifServerlessMaxConcurrency()
     * - .ifServerlessMemorySize()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html
     */
    toCreateEndpointConfig() {
        return this.to('CreateEndpointConfig');
    }
    /**
     * Grants permission to create an experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateExperiment.html
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a feature group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifFeatureGroupOnlineStoreKmsKey()
     * - .ifFeatureGroupOfflineStoreKmsKey()
     * - .ifFeatureGroupOfflineStoreS3Uri()
     * - .ifFeatureGroupEnableOnlineStore()
     * - .ifFeatureGroupOfflineStoreConfig()
     * - .ifFeatureGroupDisableGlueTableCreation()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFeatureGroup.html
     */
    toCreateFeatureGroup() {
        return this.to('CreateFeatureGroup');
    }
    /**
     * Grants permission to create a flow definition, which defines settings for a human workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifWorkteamArn()
     * - .ifWorkteamType()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFlowDefinition.html
     */
    toCreateFlowDefinition() {
        return this.to('CreateFlowDefinition');
    }
    /**
     * Grants permission to create a hub
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHub.html
     */
    toCreateHub() {
        return this.to('CreateHub');
    }
    /**
     * Grants permission to define the settings you will use for the human review workflow user interface
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHumanTaskUi.html
     */
    toCreateHumanTaskUi() {
        return this.to('CreateHumanTaskUi');
    }
    /**
     * Grants permission to create a hyper parameter tuning job that can be deployed using Amazon SageMaker
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifFileSystemAccessMode()
     * - .ifFileSystemDirectoryPath()
     * - .ifFileSystemId()
     * - .ifFileSystemType()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html
     */
    toCreateHyperParameterTuningJob() {
        return this.to('CreateHyperParameterTuningJob');
    }
    /**
     * Grants permission to create a SageMaker Image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateImage.html
     */
    toCreateImage() {
        return this.to('CreateImage');
    }
    /**
     * Grants permission to create a SageMaker ImageVersion
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateImageVersion.html
     */
    toCreateImageVersion() {
        return this.to('CreateImageVersion');
    }
    /**
     * Grants permission to create an inference experiment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceExperiment.html
     */
    toCreateInferenceExperiment() {
        return this.to('CreateInferenceExperiment');
    }
    /**
     * Grants permission to create an inference recommendations job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html
     */
    toCreateInferenceRecommendationsJob() {
        return this.to('CreateInferenceRecommendationsJob');
    }
    /**
     * Grants permission to start a labeling job. A labeling job takes unlabeled data in and produces labeled data as output, which can be used for training SageMaker models
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifWorkteamArn()
     * - .ifWorkteamType()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html
     */
    toCreateLabelingJob() {
        return this.to('CreateLabelingJob');
    }
    /**
     * Grants permission to create a lineage group policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/Welcome.html
     */
    toCreateLineageGroupPolicy() {
        return this.to('CreateLineageGroupPolicy');
    }
    /**
     * Grants permission to create a model in Amazon SageMaker. In the request, you specify a name for the model and describe one or more containers
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifNetworkIsolation()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html
     */
    toCreateModel() {
        return this.to('CreateModel');
    }
    /**
     * Grants permission to create a model bias job definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelBiasJobDefinition.html
     */
    toCreateModelBiasJobDefinition() {
        return this.to('CreateModelBiasJobDefinition');
    }
    /**
     * Grants permission to create a model card
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelCard.html
     */
    toCreateModelCard() {
        return this.to('CreateModelCard');
    }
    /**
     * Grants permission to create an export job for a model card
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelCardExportJob.html
     */
    toCreateModelCardExportJob() {
        return this.to('CreateModelCardExportJob');
    }
    /**
     * Grants permission to create a model explainability job definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelExplainabilityJobDefinition.html
     */
    toCreateModelExplainabilityJobDefinition() {
        return this.to('CreateModelExplainabilityJobDefinition');
    }
    /**
     * Grants permission to create a ModelPackage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifModelApprovalStatus()
     * - .ifCustomerMetadataProperties()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelPackage.html
     */
    toCreateModelPackage() {
        return this.to('CreateModelPackage');
    }
    /**
     * Grants permission to create a ModelPackageGroup
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelPackageGroup.html
     */
    toCreateModelPackageGroup() {
        return this.to('CreateModelPackageGroup');
    }
    /**
     * Grants permission to create a model quality job definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModelQualityJobDefinition.html
     */
    toCreateModelQualityJobDefinition() {
        return this.to('CreateModelQualityJobDefinition');
    }
    /**
     * Grants permission to create a monitoring schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateMonitoringSchedule.html
     */
    toCreateMonitoringSchedule() {
        return this.to('CreateMonitoringSchedule');
    }
    /**
     * Grants permission to create an Amazon SageMaker notebook instance. A notebook instance is an Amazon EC2 instance running on a Jupyter Notebook
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAcceleratorTypes()
     * - .ifDirectInternetAccess()
     * - .ifInstanceTypes()
     * - .ifMinimumInstanceMetadataServiceVersion()
     * - .ifRootAccess()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateNotebookInstance.html
     */
    toCreateNotebookInstance() {
        return this.to('CreateNotebookInstance');
    }
    /**
     * Grants permission to create a notebook instance lifecycle configuration that can be deployed using Amazon SageMaker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateNotebookInstanceLifecycleConfig.html
     */
    toCreateNotebookInstanceLifecycleConfig() {
        return this.to('CreateNotebookInstanceLifecycleConfig');
    }
    /**
     * Grants permission to create a pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePipeline.html
     */
    toCreatePipeline() {
        return this.to('CreatePipeline');
    }
    /**
     * Grants permission to return a URL that you can use from your browser to connect to the Domain as a specified UserProfile when AuthMode is 'IAM'
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedDomainUrl.html
     */
    toCreatePresignedDomainUrl() {
        return this.to('CreatePresignedDomainUrl');
    }
    /**
     * Grants permission to create a URL that you can use from your browser to connect to the Notebook Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html
     */
    toCreatePresignedNotebookInstanceUrl() {
        return this.to('CreatePresignedNotebookInstanceUrl');
    }
    /**
     * Grants permission to start a processing job. After processing completes, Amazon SageMaker saves the resulting artifacts and other optional output to an Amazon S3 location that you specify
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     * - .ifInterContainerTrafficEncryption()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html
     */
    toCreateProcessingJob() {
        return this.to('CreateProcessingJob');
    }
    /**
     * Grants permission to create a Project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProject.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to create a shared model in a SageMaker Studio application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toCreateSharedModel() {
        return this.to('CreateSharedModel');
    }
    /**
     * Grants permission to create a Space for a SageMaker Domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateSpace.html
     */
    toCreateSpace() {
        return this.to('CreateSpace');
    }
    /**
     * Grants permission to create a Studio Lifecycle Configuration that can be deployed using Amazon SageMaker
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateStudioLifecycleConfig.html
     */
    toCreateStudioLifecycleConfig() {
        return this.to('CreateStudioLifecycleConfig');
    }
    /**
     * Grants permission to start a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts and other optional output to an Amazon S3 location that you specify
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifFileSystemAccessMode()
     * - .ifFileSystemDirectoryPath()
     * - .ifFileSystemId()
     * - .ifFileSystemType()
     * - .ifInstanceTypes()
     * - .ifInterContainerTrafficEncryption()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     * - .ifKeepAlivePeriod()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
     */
    toCreateTrainingJob() {
        return this.to('CreateTrainingJob');
    }
    /**
     * Grants permission to start a transform job. After the results are obtained, Amazon SageMaker saves them to an Amazon S3 location that you specify
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifModelArn()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html
     */
    toCreateTransformJob() {
        return this.to('CreateTransformJob');
    }
    /**
     * Grants permission to create a trial
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html
     */
    toCreateTrial() {
        return this.to('CreateTrial');
    }
    /**
     * Grants permission to create a trial component
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html
     */
    toCreateTrialComponent() {
        return this.to('CreateTrialComponent');
    }
    /**
     * Grants permission to create a UserProfile for a SageMaker Domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcSecurityGroupIds()
     * - .ifInstanceTypes()
     * - .ifDomainSharingOutputKmsKey()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html
     */
    toCreateUserProfile() {
        return this.to('CreateUserProfile');
    }
    /**
     * Grants permission to create a workforce
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html
     */
    toCreateWorkforce() {
        return this.to('CreateWorkforce');
    }
    /**
     * Grants permission to create a workteam
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkteam.html
     */
    toCreateWorkteam() {
        return this.to('CreateWorkteam');
    }
    /**
     * Grants permission to delete an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteAction.html
     */
    toDeleteAction() {
        return this.to('DeleteAction');
    }
    /**
     * Grants permission to delete an algorithm
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteAlgorithm.html
     */
    toDeleteAlgorithm() {
        return this.to('DeleteAlgorithm');
    }
    /**
     * Grants permission to delete an App
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to delete an AppImageConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteAppImageConfig.html
     */
    toDeleteAppImageConfig() {
        return this.to('DeleteAppImageConfig');
    }
    /**
     * Grants permission to delete an artifact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteArtifact.html
     */
    toDeleteArtifact() {
        return this.to('DeleteArtifact');
    }
    /**
     * Grants permission to delete the association from a lineage entity (artifact, context, action, experiment, experiment-trial-component) to another
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteAssociation.html
     */
    toDeleteAssociation() {
        return this.to('DeleteAssociation');
    }
    /**
     * Grants permission to delete a CodeRepository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteCodeRepository.html
     */
    toDeleteCodeRepository() {
        return this.to('DeleteCodeRepository');
    }
    /**
     * Grants permission to delete a context
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteContext.html
     */
    toDeleteContext() {
        return this.to('DeleteContext');
    }
    /**
     * Grants permission to delete the data quality job definition created using the CreateDataQualityJobDefinition API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteDataQualityJobDefinition.html
     */
    toDeleteDataQualityJobDefinition() {
        return this.to('DeleteDataQualityJobDefinition');
    }
    /**
     * Grants permission to delete a device fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteDeviceFleet.html
     */
    toDeleteDeviceFleet() {
        return this.to('DeleteDeviceFleet');
    }
    /**
     * Grants permission to delete a Domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteDomain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete an edge deployment plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEdgeDeploymentPlan.html
     */
    toDeleteEdgeDeploymentPlan() {
        return this.to('DeleteEdgeDeploymentPlan');
    }
    /**
     * Grants permission to delete an edge deployment stage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEdgeDeploymentStage.html
     */
    toDeleteEdgeDeploymentStage() {
        return this.to('DeleteEdgeDeploymentStage');
    }
    /**
     * Grants permission to delete an endpoint. Amazon SageMaker frees up all the resources that were deployed when the endpoint was created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html
     */
    toDeleteEndpoint() {
        return this.to('DeleteEndpoint');
    }
    /**
     * Grants permission to delete the endpoint configuration created using the CreateEndpointConfig API. The DeleteEndpointConfig API deletes only the specified configuration. It does not delete any endpoints created using the configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpointConfig.html
     */
    toDeleteEndpointConfig() {
        return this.to('DeleteEndpointConfig');
    }
    /**
     * Grants permission to delete an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteExperiment.html
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a feature group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteFeatureGroup.html
     */
    toDeleteFeatureGroup() {
        return this.to('DeleteFeatureGroup');
    }
    /**
     * Grants permission to delete the specified flow definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteFlowDefinition.html
     */
    toDeleteFlowDefinition() {
        return this.to('DeleteFlowDefinition');
    }
    /**
     * Grants permission to delete hubs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteHub.html
     */
    toDeleteHub() {
        return this.to('DeleteHub');
    }
    /**
     * Grants permission to delete hub content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteHubContent.html
     */
    toDeleteHubContent() {
        return this.to('DeleteHubContent');
    }
    /**
     * Grants permission to delete a specified human loop
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteHumanLoop.html
     */
    toDeleteHumanLoop() {
        return this.to('DeleteHumanLoop');
    }
    /**
     * Grants permission to delete the specified human task user interface (worker task template)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteHumanTaskUi.html
     */
    toDeleteHumanTaskUi() {
        return this.to('DeleteHumanTaskUi');
    }
    /**
     * Grants permission to delete a SageMaker Image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteImage.html
     */
    toDeleteImage() {
        return this.to('DeleteImage');
    }
    /**
     * Grants permission to delete a SageMaker ImageVersion
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteImageVersion.html
     */
    toDeleteImageVersion() {
        return this.to('DeleteImageVersion');
    }
    /**
     * Grants permission to delete an inference experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteInferenceExperiment.html
     */
    toDeleteInferenceExperiment() {
        return this.to('DeleteInferenceExperiment');
    }
    /**
     * Grants permission to delete a lineage group policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/Welcome.html
     */
    toDeleteLineageGroupPolicy() {
        return this.to('DeleteLineageGroupPolicy');
    }
    /**
     * Grants permission to delete a model created using the CreateModel API. The DeleteModel API deletes only the model entry in Amazon SageMaker that you created by calling the CreateModel API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModel.html
     */
    toDeleteModel() {
        return this.to('DeleteModel');
    }
    /**
     * Grants permission to delete the model bias job definition created using the CreateModelBiasJobDefinition API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelBiasJobDefinition.html
     */
    toDeleteModelBiasJobDefinition() {
        return this.to('DeleteModelBiasJobDefinition');
    }
    /**
     * Grants permission to delete a model card
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelCard.html
     */
    toDeleteModelCard() {
        return this.to('DeleteModelCard');
    }
    /**
     * Grants permission to delete the model explainability job definition created using the CreateModelExplainabilityJobDefinition API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelExplainabilityJobDefinition.html
     */
    toDeleteModelExplainabilityJobDefinition() {
        return this.to('DeleteModelExplainabilityJobDefinition');
    }
    /**
     * Grants permission to delete a ModelPackage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelPackage.html
     */
    toDeleteModelPackage() {
        return this.to('DeleteModelPackage');
    }
    /**
     * Grants permission to delete a ModelPackageGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelPackageGroup.html
     */
    toDeleteModelPackageGroup() {
        return this.to('DeleteModelPackageGroup');
    }
    /**
     * Grants permission to delete a ModelPackageGroup policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelPackageGroupPolicy.html
     */
    toDeleteModelPackageGroupPolicy() {
        return this.to('DeleteModelPackageGroupPolicy');
    }
    /**
     * Grants permission to delete the model quality job definition created using the CreateModelQualityJobDefinition API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteModelQualityJobDefinition.html
     */
    toDeleteModelQualityJobDefinition() {
        return this.to('DeleteModelQualityJobDefinition');
    }
    /**
     * Grants permission to delete a monitoring schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteMonitoringSchedule.html
     */
    toDeleteMonitoringSchedule() {
        return this.to('DeleteMonitoringSchedule');
    }
    /**
     * Grants permission to delete a Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the StopNotebookInstance API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteNotebookInstance.html
     */
    toDeleteNotebookInstance() {
        return this.to('DeleteNotebookInstance');
    }
    /**
     * Grants permission to delete a notebook instance lifecycle configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteNotebookInstanceLifecycleConfig.html
     */
    toDeleteNotebookInstanceLifecycleConfig() {
        return this.to('DeleteNotebookInstanceLifecycleConfig');
    }
    /**
     * Grants permission to delete a pipeline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeletePipeline.html
     */
    toDeletePipeline() {
        return this.to('DeletePipeline');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to delete a record from a feature group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html
     */
    toDeleteRecord() {
        return this.to('DeleteRecord');
    }
    /**
     * Grants permission to delete a Space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteSpace.html
     */
    toDeleteSpace() {
        return this.to('DeleteSpace');
    }
    /**
     * Grants permission to delete a Studio Lifecycle Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteStudioLifecycleConfig.html
     */
    toDeleteStudioLifecycleConfig() {
        return this.to('DeleteStudioLifecycleConfig');
    }
    /**
     * Grants permission to delete the specified set of tags from an Amazon SageMaker resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        return this.to('DeleteTags');
    }
    /**
     * Grants permission to delete a trial
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteTrial.html
     */
    toDeleteTrial() {
        return this.to('DeleteTrial');
    }
    /**
     * Grants permission to delete a trial component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteTrialComponent.html
     */
    toDeleteTrialComponent() {
        return this.to('DeleteTrialComponent');
    }
    /**
     * Grants permission to delete a UserProfile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteUserProfile.html
     */
    toDeleteUserProfile() {
        return this.to('DeleteUserProfile');
    }
    /**
     * Grants permission to delete a workforce
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html
     */
    toDeleteWorkforce() {
        return this.to('DeleteWorkforce');
    }
    /**
     * Grants permission to delete a workteam
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html
     */
    toDeleteWorkteam() {
        return this.to('DeleteWorkteam');
    }
    /**
     * Grants permission to deregister a set of devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeregisterDevices.html
     */
    toDeregisterDevices() {
        return this.to('DeregisterDevices');
    }
    /**
     * Grants permission to get information about an action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAction.html
     */
    toDescribeAction() {
        return this.to('DescribeAction');
    }
    /**
     * Grants permission to describe an algorithm
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAlgorithm.html
     */
    toDescribeAlgorithm() {
        return this.to('DescribeAlgorithm');
    }
    /**
     * Grants permission to describe an App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeApp.html
     */
    toDescribeApp() {
        return this.to('DescribeApp');
    }
    /**
     * Grants permission to describe an AppImageConfig
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAppImageConfig.html
     */
    toDescribeAppImageConfig() {
        return this.to('DescribeAppImageConfig');
    }
    /**
     * Grants permission to get information about an artifact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeArtifact.html
     */
    toDescribeArtifact() {
        return this.to('DescribeArtifact');
    }
    /**
     * Grants permission to describe an AutoML job that was created via the CreateAutoMLJob API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html
     */
    toDescribeAutoMLJob() {
        return this.to('DescribeAutoMLJob');
    }
    /**
     * Grants permission to describe a CodeRepository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCodeRepository.html
     */
    toDescribeCodeRepository() {
        return this.to('DescribeCodeRepository');
    }
    /**
     * Grants permission to return information about a compilation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html
     */
    toDescribeCompilationJob() {
        return this.to('DescribeCompilationJob');
    }
    /**
     * Grants permission to get information about a context
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeContext.html
     */
    toDescribeContext() {
        return this.to('DescribeContext');
    }
    /**
     * Grants permission to return information about a data quality job definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeDataQualityJobDefinition.html
     */
    toDescribeDataQualityJobDefinition() {
        return this.to('DescribeDataQualityJobDefinition');
    }
    /**
     * Grants permission to access information about a device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeDevice.html
     */
    toDescribeDevice() {
        return this.to('DescribeDevice');
    }
    /**
     * Grants permission to access information about a device fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeDeviceFleet.html
     */
    toDescribeDeviceFleet() {
        return this.to('DescribeDeviceFleet');
    }
    /**
     * Grants permission to describe a Domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeDomain.html
     */
    toDescribeDomain() {
        return this.to('DescribeDomain');
    }
    /**
     * Grants permission to access information about an edge deployment plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEdgeDeploymentPlan.html
     */
    toDescribeEdgeDeploymentPlan() {
        return this.to('DescribeEdgeDeploymentPlan');
    }
    /**
     * Grants permission to access information about an edge packaging job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEdgePackagingJob.html
     */
    toDescribeEdgePackagingJob() {
        return this.to('DescribeEdgePackagingJob');
    }
    /**
     * Grants permission to return the description of an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html
     */
    toDescribeEndpoint() {
        return this.to('DescribeEndpoint');
    }
    /**
     * Grants permission to return the description of an endpoint configuration, which was created using the CreateEndpointConfig API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html
     */
    toDescribeEndpointConfig() {
        return this.to('DescribeEndpointConfig');
    }
    /**
     * Grants permission to return information about an experiment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html
     */
    toDescribeExperiment() {
        return this.to('DescribeExperiment');
    }
    /**
     * Grants permission to return information about a feature group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFeatureGroup.html
     */
    toDescribeFeatureGroup() {
        return this.to('DescribeFeatureGroup');
    }
    /**
     * Grants permission to return information about a feature metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFeatureMetadata.html
     */
    toDescribeFeatureMetadata() {
        return this.to('DescribeFeatureMetadata');
    }
    /**
     * Grants permission to return information about the specified flow definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeFlowDefinition.html
     */
    toDescribeFlowDefinition() {
        return this.to('DescribeFlowDefinition');
    }
    /**
     * Grants permission to describe hubs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeHub.html
     */
    toDescribeHub() {
        return this.to('DescribeHub');
    }
    /**
     * Grants permission to describe hub content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeHubContent.html
     */
    toDescribeHubContent() {
        return this.to('DescribeHubContent');
    }
    /**
     * Grants permission to return information about the specified human loop
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeHumanLoop.html
     */
    toDescribeHumanLoop() {
        return this.to('DescribeHumanLoop');
    }
    /**
     * Grants permission to return detailed information about the specified human review workflow user interface
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeHumanTaskUi.html
     */
    toDescribeHumanTaskUi() {
        return this.to('DescribeHumanTaskUi');
    }
    /**
     * Grants permission to describe a hyper parameter tuning job that was created via the CreateHyperParameterTuningJob API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeHyperParameterTuningJob.html
     */
    toDescribeHyperParameterTuningJob() {
        return this.to('DescribeHyperParameterTuningJob');
    }
    /**
     * Grants permission to return information about a SageMaker Image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeImage.html
     */
    toDescribeImage() {
        return this.to('DescribeImage');
    }
    /**
     * Grants permission to return information about a SageMaker ImageVersion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeImageVersion.html
     */
    toDescribeImageVersion() {
        return this.to('DescribeImageVersion');
    }
    /**
     * Grants permission to get information about an inference experiment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceExperiment.html
     */
    toDescribeInferenceExperiment() {
        return this.to('DescribeInferenceExperiment');
    }
    /**
     * Grants permission to get information about an inference recommendations job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeInferenceRecommendationsJob.html
     */
    toDescribeInferenceRecommendationsJob() {
        return this.to('DescribeInferenceRecommendationsJob');
    }
    /**
     * Grants permission to return information about a labeling job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeLabelingJob.html
     */
    toDescribeLabelingJob() {
        return this.to('DescribeLabelingJob');
    }
    /**
     * Grants permission to describe a lineage group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeLineageGroup.html
     */
    toDescribeLineageGroup() {
        return this.to('DescribeLineageGroup');
    }
    /**
     * Grants permission to describe a model that you created using the CreateModel API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModel.html
     */
    toDescribeModel() {
        return this.to('DescribeModel');
    }
    /**
     * Grants permission to return information about a model bias job definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelBiasJobDefinition.html
     */
    toDescribeModelBiasJobDefinition() {
        return this.to('DescribeModelBiasJobDefinition');
    }
    /**
     * Grants permission to get information about a model card
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelCard.html
     */
    toDescribeModelCard() {
        return this.to('DescribeModelCard');
    }
    /**
     * Grants permission to get information about a model card export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelCardExportJob.html
     */
    toDescribeModelCardExportJob() {
        return this.to('DescribeModelCardExportJob');
    }
    /**
     * Grants permission to return information about a model explainability job definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelExplainabilityJobDefinition.html
     */
    toDescribeModelExplainabilityJobDefinition() {
        return this.to('DescribeModelExplainabilityJobDefinition');
    }
    /**
     * Grants permission to describe a ModelPackage
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelPackage.html
     */
    toDescribeModelPackage() {
        return this.to('DescribeModelPackage');
    }
    /**
     * Grants permission to describe a ModelPackageGroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelPackageGroup.html
     */
    toDescribeModelPackageGroup() {
        return this.to('DescribeModelPackageGroup');
    }
    /**
     * Grants permission to return information about a model quality job definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeModelQualityJobDefinition.html
     */
    toDescribeModelQualityJobDefinition() {
        return this.to('DescribeModelQualityJobDefinition');
    }
    /**
     * Grants permission to return information about a monitoring schedule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeMonitoringSchedule.html
     */
    toDescribeMonitoringSchedule() {
        return this.to('DescribeMonitoringSchedule');
    }
    /**
     * Grants permission to return information about a notebook instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeNotebookInstance.html
     */
    toDescribeNotebookInstance() {
        return this.to('DescribeNotebookInstance');
    }
    /**
     * Grants permission to describe a notebook instance lifecycle configuration that was created via the CreateNotebookInstanceLifecycleConfig API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeNotebookInstanceLifecycleConfig.html
     */
    toDescribeNotebookInstanceLifecycleConfig() {
        return this.to('DescribeNotebookInstanceLifecycleConfig');
    }
    /**
     * Grants permission to get information about a pipeline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribePipeline.html
     */
    toDescribePipeline() {
        return this.to('DescribePipeline');
    }
    /**
     * Grants permission to get the pipeline definition for a pipeline execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribePipelineDefinitionForExecution.html
     */
    toDescribePipelineDefinitionForExecution() {
        return this.to('DescribePipelineDefinitionForExecution');
    }
    /**
     * Grants permission to get information about a pipeline execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribePipelineExecution.html
     */
    toDescribePipelineExecution() {
        return this.to('DescribePipelineExecution');
    }
    /**
     * Grants permission to return information about a processing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeProcessingJob.html
     */
    toDescribeProcessingJob() {
        return this.to('DescribeProcessingJob');
    }
    /**
     * Grants permission to describe a project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeProject.html
     */
    toDescribeProject() {
        return this.to('DescribeProject');
    }
    /**
     * Grants permission to describe a shared model in a SageMaker Studio application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toDescribeSharedModel() {
        return this.to('DescribeSharedModel');
    }
    /**
     * Grants permission to describe a Space
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeSpace.html
     */
    toDescribeSpace() {
        return this.to('DescribeSpace');
    }
    /**
     * Grants permission to describe a Studio Lifecycle Configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeStudioLifecycleConfig.html
     */
    toDescribeStudioLifecycleConfig() {
        return this.to('DescribeStudioLifecycleConfig');
    }
    /**
     * Grants permission to return information about a subscribed workteam
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeSubscribedWorkteam.html
     */
    toDescribeSubscribedWorkteam() {
        return this.to('DescribeSubscribedWorkteam');
    }
    /**
     * Grants permission to return information about a training job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrainingJob.html
     */
    toDescribeTrainingJob() {
        return this.to('DescribeTrainingJob');
    }
    /**
     * Grants permission to return information about a transform job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTransformJob.html
     */
    toDescribeTransformJob() {
        return this.to('DescribeTransformJob');
    }
    /**
     * Grants permission to return information about a trial
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html
     */
    toDescribeTrial() {
        return this.to('DescribeTrial');
    }
    /**
     * Grants permission to return information about a trial component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html
     */
    toDescribeTrialComponent() {
        return this.to('DescribeTrialComponent');
    }
    /**
     * Grants permission to describe a UserProfile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeUserProfile.html
     */
    toDescribeUserProfile() {
        return this.to('DescribeUserProfile');
    }
    /**
     * Grants permission to return information about a workforce
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeWorkforce.html
     */
    toDescribeWorkforce() {
        return this.to('DescribeWorkforce');
    }
    /**
     * Grants permission to return information about a workteam
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeWorkteam.html
     */
    toDescribeWorkteam() {
        return this.to('DescribeWorkteam');
    }
    /**
     * Grants permission to disable a SageMaker Service Catalog Portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisableSagemakerServicecatalogPortfolio.html
     */
    toDisableSagemakerServicecatalogPortfolio() {
        return this.to('DisableSagemakerServicecatalogPortfolio');
    }
    /**
     * Grants permission to disassociate a trial component from a trial
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html
     */
    toDisassociateTrialComponent() {
        return this.to('DisassociateTrialComponent');
    }
    /**
     * Grants permission to enable a SageMaker Service Catalog Portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_EnableSagemakerServicecatalogPortfolio.html
     */
    toEnableSagemakerServicecatalogPortfolio() {
        return this.to('EnableSagemakerServicecatalogPortfolio');
    }
    /**
     * Grants permission to get deployment plan for device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_edge_GetDeployments.html
     */
    toGetDeployments() {
        return this.to('GetDeployments');
    }
    /**
     * Grants permission to access a summary of the devices in a device fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetDeviceFleetReport.html
     */
    toGetDeviceFleetReport() {
        return this.to('GetDeviceFleetReport');
    }
    /**
     * Grants permission to get device registration. After you deploy a model onto edge devices this api is used to get current device registration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_edge_GetDeviceRegistration.html
     */
    toGetDeviceRegistration() {
        return this.to('GetDeviceRegistration');
    }
    /**
     * Grants permission to retreive a lineage group policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetLineageGroupPolicy.html
     */
    toGetLineageGroupPolicy() {
        return this.to('GetLineageGroupPolicy');
    }
    /**
     * Grants permission to get a ModelPackageGroup policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetModelPackageGroupPolicy.html
     */
    toGetModelPackageGroupPolicy() {
        return this.to('GetModelPackageGroupPolicy');
    }
    /**
     * Grants permission to get a record from a feature group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html
     */
    toGetRecord() {
        return this.to('GetRecord');
    }
    /**
     * Grants permission to get a SageMaker Service Catalog Portfolio
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetSagemakerServicecatalogPortfolioStatus.html
     */
    toGetSagemakerServicecatalogPortfolioStatus() {
        return this.to('GetSagemakerServicecatalogPortfolioStatus');
    }
    /**
     * Grants permission to get search suggestions when provided with a keyword
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetSearchSuggestions.html
     */
    toGetSearchSuggestions() {
        return this.to('GetSearchSuggestions');
    }
    /**
     * Grants permission to import hub content
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - sagemaker:AddTags
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ImportHubContent.html
     */
    toImportHubContent() {
        return this.to('ImportHubContent');
    }
    /**
     * Grants permission to invoke an endpoint. After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTargetModel()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html
     */
    toInvokeEndpoint() {
        return this.to('InvokeEndpoint');
    }
    /**
     * Grants permission to get inferences from the hosted model at the specified endpoint in an asynchronous manner
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html
     */
    toInvokeEndpointAsync() {
        return this.to('InvokeEndpointAsync');
    }
    /**
     * Grants permission to list actions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListActions.html
     */
    toListActions() {
        return this.to('ListActions');
    }
    /**
     * Grants permission to list Algorithms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListAlgorithms.html
     */
    toListAlgorithms() {
        return this.to('ListAlgorithms');
    }
    /**
     * Grants permission to list Aliases that belong to a SageMaker Image or Sagemaker ImageVersion
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListAliases.html
     */
    toListAliases() {
        return this.to('ListAliases');
    }
    /**
     * Grants permission to list the AppImageConfigs in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListAppImageConfigs.html
     */
    toListAppImageConfigs() {
        return this.to('ListAppImageConfigs');
    }
    /**
     * Grants permission to list the Apps in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListApps.html
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * Grants permission to list artifacts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListArtifacts.html
     */
    toListArtifacts() {
        return this.to('ListArtifacts');
    }
    /**
     * Grants permission to list associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListAssociations.html
     */
    toListAssociations() {
        return this.to('ListAssociations');
    }
    /**
     * Grants permission to list AutoML jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListAutoMLJobs.html
     */
    toListAutoMLJobs() {
        return this.to('ListAutoMLJobs');
    }
    /**
     * Grants permission to lists candidates for an AutoML job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCandidatesForAutoMLJob.html
     */
    toListCandidatesForAutoMLJob() {
        return this.to('ListCandidatesForAutoMLJob');
    }
    /**
     * Grants permission to list code repositories
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCodeRepositories.html
     */
    toListCodeRepositories() {
        return this.to('ListCodeRepositories');
    }
    /**
     * Grants permission to list compilation jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html
     */
    toListCompilationJobs() {
        return this.to('ListCompilationJobs');
    }
    /**
     * Grants permission to list contexts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListContexts.html
     */
    toListContexts() {
        return this.to('ListContexts');
    }
    /**
     * Grants permission to list data quality job definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListDataQualityJobDefinitions.html
     */
    toListDataQualityJobDefinitions() {
        return this.to('ListDataQualityJobDefinitions');
    }
    /**
     * Grants permission to list device fleets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListDeviceFleets.html
     */
    toListDeviceFleets() {
        return this.to('ListDeviceFleets');
    }
    /**
     * Grants permission to list devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListDevices.html
     */
    toListDevices() {
        return this.to('ListDevices');
    }
    /**
     * Grants permission to list the Domains in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list edge deployment plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEdgeDeploymentPlans.html
     */
    toListEdgeDeploymentPlans() {
        return this.to('ListEdgeDeploymentPlans');
    }
    /**
     * Grants permission to list edge packaging jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEdgePackagingJobs.html
     */
    toListEdgePackagingJobs() {
        return this.to('ListEdgePackagingJobs');
    }
    /**
     * Grants permission to list endpoint configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpointConfigs.html
     */
    toListEndpointConfigs() {
        return this.to('ListEndpointConfigs');
    }
    /**
     * Grants permission to list endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpoints.html
     */
    toListEndpoints() {
        return this.to('ListEndpoints');
    }
    /**
     * Grants permission to list experiments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html
     */
    toListExperiments() {
        return this.to('ListExperiments');
    }
    /**
     * Grants permission to list feature groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListFeatureGroups.html
     */
    toListFeatureGroups() {
        return this.to('ListFeatureGroups');
    }
    /**
     * Grants permission to return summary information about flow definitions, given the specified parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListFlowDefinitions.html
     */
    toListFlowDefinitions() {
        return this.to('ListFlowDefinitions');
    }
    /**
     * Grants permission to list all versions of hub content
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHubContentVersions.html
     */
    toListHubContentVersions() {
        return this.to('ListHubContentVersions');
    }
    /**
     * Grants permission to list newest versions of hub content
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHubContents.html
     */
    toListHubContents() {
        return this.to('ListHubContents');
    }
    /**
     * Grants permission to list hubs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHubs.html
     */
    toListHubs() {
        return this.to('ListHubs');
    }
    /**
     * Grants permission to return summary information about human loops, given the specified parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanLoops.html
     */
    toListHumanLoops() {
        return this.to('ListHumanLoops');
    }
    /**
     * Grants permission to return summary information about human review workflow user interfaces, given the specified parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html
     */
    toListHumanTaskUis() {
        return this.to('ListHumanTaskUis');
    }
    /**
     * Grants permission to list hyper parameter tuning jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHyperParameterTuningJobs.html
     */
    toListHyperParameterTuningJobs() {
        return this.to('ListHyperParameterTuningJobs');
    }
    /**
     * Grants permission to list ImageVersions that belong to a SageMaker Image
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListImageVersions.html
     */
    toListImageVersions() {
        return this.to('ListImageVersions');
    }
    /**
     * Grants permission to list SageMaker Images in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListImages.html
     */
    toListImages() {
        return this.to('ListImages');
    }
    /**
     * Grants permission to list inference experiments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceExperiments.html
     */
    toListInferenceExperiments() {
        return this.to('ListInferenceExperiments');
    }
    /**
     * Grants permission to list inference recommendations job steps
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceRecommendationsJobSteps.html
     */
    toListInferenceRecommendationsJobSteps() {
        return this.to('ListInferenceRecommendationsJobSteps');
    }
    /**
     * Grants permission to list inference recommendations jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceRecommendationsJobs.html
     */
    toListInferenceRecommendationsJobs() {
        return this.to('ListInferenceRecommendationsJobs');
    }
    /**
     * Grants permission to list labeling jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListLabelingJobs.html
     */
    toListLabelingJobs() {
        return this.to('ListLabelingJobs');
    }
    /**
     * Grants permission to list labeling jobs for workteam
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListLabelingJobs.html
     */
    toListLabelingJobsForWorkteam() {
        return this.to('ListLabelingJobsForWorkteam');
    }
    /**
     * Grants permission to list lineage groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListLineageGroups.html
     */
    toListLineageGroups() {
        return this.to('ListLineageGroups');
    }
    /**
     * Grants permission to list model bias job definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelBiasJobDefinitions.html
     */
    toListModelBiasJobDefinitions() {
        return this.to('ListModelBiasJobDefinitions');
    }
    /**
     * Grants permission to list export jobs for a model card
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelCardExportJobs.html
     */
    toListModelCardExportJobs() {
        return this.to('ListModelCardExportJobs');
    }
    /**
     * Grants permission to list versions of a model card
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelCardVersions.html
     */
    toListModelCardVersions() {
        return this.to('ListModelCardVersions');
    }
    /**
     * Grants permission to list model cards
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelCards.html
     */
    toListModelCards() {
        return this.to('ListModelCards');
    }
    /**
     * Grants permission to list model explainability job definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelExplainabilityJobDefinitions.html
     */
    toListModelExplainabilityJobDefinitions() {
        return this.to('ListModelExplainabilityJobDefinitions');
    }
    /**
     * Grants permission to list model metadata for inference recommendations jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelMetadata.html
     */
    toListModelMetadata() {
        return this.to('ListModelMetadata');
    }
    /**
     * Grants permission to list ModelPackageGroups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelPackageGroups.html
     */
    toListModelPackageGroups() {
        return this.to('ListModelPackageGroups');
    }
    /**
     * Grants permission to list ModelPackages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelPackages.html
     */
    toListModelPackages() {
        return this.to('ListModelPackages');
    }
    /**
     * Grants permission to list model quality job definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModelQualityJobDefinitions.html
     */
    toListModelQualityJobDefinitions() {
        return this.to('ListModelQualityJobDefinitions');
    }
    /**
     * Grants permission to list the models created with the CreateModel API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListModels.html
     */
    toListModels() {
        return this.to('ListModels');
    }
    /**
     * Grants permission to list the history of a monitoring alert
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListMonitoringHistory.html
     */
    toListMonitoringAlertHistory() {
        return this.to('ListMonitoringAlertHistory');
    }
    /**
     * Grants permission to list monitoring alerts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListMonitoringAlerts.html
     */
    toListMonitoringAlerts() {
        return this.to('ListMonitoringAlerts');
    }
    /**
     * Grants permission to list monitoring executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListMonitoringExecutions.html
     */
    toListMonitoringExecutions() {
        return this.to('ListMonitoringExecutions');
    }
    /**
     * Grants permission to list monitoring schedules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListMonitoringSchedules.html
     */
    toListMonitoringSchedules() {
        return this.to('ListMonitoringSchedules');
    }
    /**
     * Grants permission to list the notebook instance lifecycle configurations that can be deployed using Amazon SageMaker
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListNotebookInstanceLifecycleConfigs.html
     */
    toListNotebookInstanceLifecycleConfigs() {
        return this.to('ListNotebookInstanceLifecycleConfigs');
    }
    /**
     * Grants permission to list the Amazon SageMaker notebook instances in the requester's account in an AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListNotebookInstances.html
     */
    toListNotebookInstances() {
        return this.to('ListNotebookInstances');
    }
    /**
     * Grants permission to list steps for a pipeline execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListPipelineExecutionSteps.html
     */
    toListPipelineExecutionSteps() {
        return this.to('ListPipelineExecutionSteps');
    }
    /**
     * Grants permission to list executions for a pipeline
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListPipelineExecutions.html
     */
    toListPipelineExecutions() {
        return this.to('ListPipelineExecutions');
    }
    /**
     * Grants permission to list parameters for a pipeline execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListPipelineParametersForExecution.html
     */
    toListPipelineParametersForExecution() {
        return this.to('ListPipelineParametersForExecution');
    }
    /**
     * Grants permission to list pipelines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListPipelines.html
     */
    toListPipelines() {
        return this.to('ListPipelines');
    }
    /**
     * Grants permission to list processing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListProcessingJobs.html
     */
    toListProcessingJobs() {
        return this.to('ListProcessingJobs');
    }
    /**
     * Grants permission to list Projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListProjects.html
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to list shared model events
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toListSharedModelEvents() {
        return this.to('ListSharedModelEvents');
    }
    /**
     * Grants permission to list shared model versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toListSharedModelVersions() {
        return this.to('ListSharedModelVersions');
    }
    /**
     * Grants permission to list shared models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toListSharedModels() {
        return this.to('ListSharedModels');
    }
    /**
     * Grants permission to list the Spaces in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListSpaces.html
     */
    toListSpaces() {
        return this.to('ListSpaces');
    }
    /**
     * Grants permission to list stage devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListStageDevices.html
     */
    toListStageDevices() {
        return this.to('ListStageDevices');
    }
    /**
     * Grants permission to list the Studio Lifecycle Configurations that can be deployed using Amazon SageMaker
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListStudioLifecycleConfigs.html
     */
    toListStudioLifecycleConfigs() {
        return this.to('ListStudioLifecycleConfigs');
    }
    /**
     * Grants permission to list subscribed workteams
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListSubscribedWorkteams.html
     */
    toListSubscribedWorkteams() {
        return this.to('ListSubscribedWorkteams');
    }
    /**
     * Grants permission to list the tag set associated with the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTags.html
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Grants permission to list training jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrainingJobs.html
     */
    toListTrainingJobs() {
        return this.to('ListTrainingJobs');
    }
    /**
     * Grants permission to list training jobs for a hyper parameter tuning job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrainingJobsForHyperParameterTuningJob.html
     */
    toListTrainingJobsForHyperParameterTuningJob() {
        return this.to('ListTrainingJobsForHyperParameterTuningJob');
    }
    /**
     * Grants permission to list transform jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTransformJobs.html
     */
    toListTransformJobs() {
        return this.to('ListTransformJobs');
    }
    /**
     * Grants permission to list trial components
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrialComponents.html
     */
    toListTrialComponents() {
        return this.to('ListTrialComponents');
    }
    /**
     * Grants permission to list trials
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html
     */
    toListTrials() {
        return this.to('ListTrials');
    }
    /**
     * Grants permission to list the UserProfiles in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListUserProfiles.html
     */
    toListUserProfiles() {
        return this.to('ListUserProfiles');
    }
    /**
     * Grants permission to list workforces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListWorkforces.html
     */
    toListWorkforces() {
        return this.to('ListWorkforces');
    }
    /**
     * Grants permission to list workteams
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListWorkteams.html
     */
    toListWorkteams() {
        return this.to('ListWorkteams');
    }
    /**
     * Grants permission to put a lineage group policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/Welcome.html
     */
    toPutLineageGroupPolicy() {
        return this.to('PutLineageGroupPolicy');
    }
    /**
     * Grants permission to put a ModelPackageGroup policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PutModelPackageGroupPolicy.html
     */
    toPutModelPackageGroupPolicy() {
        return this.to('PutModelPackageGroupPolicy');
    }
    /**
     * Grants permission to put a record to a feature group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_PutRecord.html
     */
    toPutRecord() {
        return this.to('PutRecord');
    }
    /**
     * Grants permission to explore the lineage graph
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_QueryLineage.html
     */
    toQueryLineage() {
        return this.to('QueryLineage');
    }
    /**
     * Grants permission to register a set of devices
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RegisterDevices.html
     */
    toRegisterDevices() {
        return this.to('RegisterDevices');
    }
    /**
     * Grants permission to render a UI template used for a human annotation task
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RenderUiTemplate.html
     */
    toRenderUiTemplate() {
        return this.to('RenderUiTemplate');
    }
    /**
     * Grants permission to retry a pipeline execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RetryPipelineExecution.html
     */
    toRetryPipelineExecution() {
        return this.to('RetryPipelineExecution');
    }
    /**
     * Grants permission to search for SageMaker objects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
     */
    toSearch() {
        return this.to('Search');
    }
    /**
     * Grants permission to publish heartbeat data from devices. After you deploy a model onto edge devices this api is used to report device status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_edge_SendHeartbeat.html
     */
    toSendHeartbeat() {
        return this.to('SendHeartbeat');
    }
    /**
     * Grants permission to fail a pending callback step
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SendPipelineExecutionStepFailure.html
     */
    toSendPipelineExecutionStepFailure() {
        return this.to('SendPipelineExecutionStepFailure');
    }
    /**
     * Grants permission to succeed a pending callback step
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SendPipelineExecutionStepSuccess.html
     */
    toSendPipelineExecutionStepSuccess() {
        return this.to('SendPipelineExecutionStepSuccess');
    }
    /**
     * Grants permission to send a shared model event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toSendSharedModelEvent() {
        return this.to('SendSharedModelEvent');
    }
    /**
     * Grants permission to start an edge deployment stage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartEdgeDeploymentStage.html
     */
    toStartEdgeDeploymentStage() {
        return this.to('StartEdgeDeploymentStage');
    }
    /**
     * Grants permission to start a human loop
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartHumanLoop.html
     */
    toStartHumanLoop() {
        return this.to('StartHumanLoop');
    }
    /**
     * Grants permission to start an inference experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartInferenceExperiment.html
     */
    toStartInferenceExperiment() {
        return this.to('StartInferenceExperiment');
    }
    /**
     * Grants permission to start a monitoring schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartMonitoringSchedule.html
     */
    toStartMonitoringSchedule() {
        return this.to('StartMonitoringSchedule');
    }
    /**
     * Grants permission to start a notebook instance. This launches an EC2 instance with the latest version of the libraries and attaches your EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartNotebookInstance.html
     */
    toStartNotebookInstance() {
        return this.to('StartNotebookInstance');
    }
    /**
     * Grants permission to start a pipeline execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html
     */
    toStartPipelineExecution() {
        return this.to('StartPipelineExecution');
    }
    /**
     * Grants permission to stop a running AutoML job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopAutoMLJob.html
     */
    toStopAutoMLJob() {
        return this.to('StopAutoMLJob');
    }
    /**
     * Grants permission to stop a compilation job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html
     */
    toStopCompilationJob() {
        return this.to('StopCompilationJob');
    }
    /**
     * Grants permission to stop an edge deployment stage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopEdgeDeploymentStage.html
     */
    toStopEdgeDeploymentStage() {
        return this.to('StopEdgeDeploymentStage');
    }
    /**
     * Grants permission to stop an edge packaging job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopEdgePackagingJob.html
     */
    toStopEdgePackagingJob() {
        return this.to('StopEdgePackagingJob');
    }
    /**
     * Grants permission to stop a specified human loop
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopHumanLoop.html
     */
    toStopHumanLoop() {
        return this.to('StopHumanLoop');
    }
    /**
     * Grants permission to stop a running hyper parameter tuning job create via the CreateHyperParameterTuningJob
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopHyperParameterTuningJob.html
     */
    toStopHyperParameterTuningJob() {
        return this.to('StopHyperParameterTuningJob');
    }
    /**
     * Grants permission to stop an inference experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceExperiment.html
     */
    toStopInferenceExperiment() {
        return this.to('StopInferenceExperiment');
    }
    /**
     * Grants permission to stop an inference recommendations job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopInferenceRecommendationsJob.html
     */
    toStopInferenceRecommendationsJob() {
        return this.to('StopInferenceRecommendationsJob');
    }
    /**
     * Grants permission to stop a labeling job. Any labels already generated will be exported before stopping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopLabelingJob.html
     */
    toStopLabelingJob() {
        return this.to('StopLabelingJob');
    }
    /**
     * Grants permission to stop a monitoring schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopMonitoringSchedule.html
     */
    toStopMonitoringSchedule() {
        return this.to('StopMonitoringSchedule');
    }
    /**
     * Grants permission to stop a notebook instance. This terminates the EC2 instance. Before terminating the instance, Amazon SageMaker disconnects the EBS volume from it. Amazon SageMaker preserves the EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopNotebookInstance.html
     */
    toStopNotebookInstance() {
        return this.to('StopNotebookInstance');
    }
    /**
     * Grants permission to stop a pipeline execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopPipelineExecution.html
     */
    toStopPipelineExecution() {
        return this.to('StopPipelineExecution');
    }
    /**
     * Grants permission to stop a processing job. To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopProcessingJob.html
     */
    toStopProcessingJob() {
        return this.to('StopProcessingJob');
    }
    /**
     * Grants permission to stop a training job. To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopTrainingJob.html
     */
    toStopTrainingJob() {
        return this.to('StopTrainingJob');
    }
    /**
     * Grants permission to stop a transform job. When Amazon SageMaker receives a StopTransformJob request, the status of the job changes to Stopping. After Amazon SageMaker stops the job, the status is set to Stopped
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopTransformJob.html
     */
    toStopTransformJob() {
        return this.to('StopTransformJob');
    }
    /**
     * Grants permission to update an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateAction.html
     */
    toUpdateAction() {
        return this.to('UpdateAction');
    }
    /**
     * Grants permission to update an AppImageConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateAppImageConfig.html
     */
    toUpdateAppImageConfig() {
        return this.to('UpdateAppImageConfig');
    }
    /**
     * Grants permission to update an artifact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateArtifact.html
     */
    toUpdateArtifact() {
        return this.to('UpdateArtifact');
    }
    /**
     * Grants permission to update a CodeRepository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateCodeRepository.html
     */
    toUpdateCodeRepository() {
        return this.to('UpdateCodeRepository');
    }
    /**
     * Grants permission to update a context
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateContext.html
     */
    toUpdateContext() {
        return this.to('UpdateContext');
    }
    /**
     * Grants permission to update a device fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateDeviceFleet.html
     */
    toUpdateDeviceFleet() {
        return this.to('UpdateDeviceFleet');
    }
    /**
     * Grants permission to update a set of devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateDevices.html
     */
    toUpdateDevices() {
        return this.to('UpdateDevices');
    }
    /**
     * Grants permission to update a Domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcSecurityGroupIds()
     * - .ifInstanceTypes()
     * - .ifDomainSharingOutputKmsKey()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateDomain.html
     */
    toUpdateDomain() {
        return this.to('UpdateDomain');
    }
    /**
     * Grants permission to update an endpoint to use the endpoint configuration specified in the request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html
     */
    toUpdateEndpoint() {
        return this.to('UpdateEndpoint');
    }
    /**
     * Grants permission to update variant weight, capacity, or both of one or more variants associated with an endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html
     */
    toUpdateEndpointWeightsAndCapacities() {
        return this.to('UpdateEndpointWeightsAndCapacities');
    }
    /**
     * Grants permission to update an experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update a feature group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateFeatureGroup.html
     */
    toUpdateFeatureGroup() {
        return this.to('UpdateFeatureGroup');
    }
    /**
     * Grants permission to update a feature metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateFeatureMetadata.html
     */
    toUpdateFeatureMetadata() {
        return this.to('UpdateFeatureMetadata');
    }
    /**
     * Grants permission to update hubs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateHub.html
     */
    toUpdateHub() {
        return this.to('UpdateHub');
    }
    /**
     * Grants permission to update the properties of a SageMaker Image
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateImage.html
     */
    toUpdateImage() {
        return this.to('UpdateImage');
    }
    /**
     * Grants permission to update the properties of a SageMaker ImageVersion
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateImageVersion.html
     */
    toUpdateImageVersion() {
        return this.to('UpdateImageVersion');
    }
    /**
     * Grants permission to update an inference experiment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateInferenceExperiment.html
     */
    toUpdateInferenceExperiment() {
        return this.to('UpdateInferenceExperiment');
    }
    /**
     * Grants permission to update a model card
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateModelCard.html
     */
    toUpdateModelCard() {
        return this.to('UpdateModelCard');
    }
    /**
     * Grants permission to update a ModelPackage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifModelApprovalStatus()
     * - .ifCustomerMetadataProperties()
     * - .ifCustomerMetadataPropertiesToRemove()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateModelPackage.html
     */
    toUpdateModelPackage() {
        return this.to('UpdateModelPackage');
    }
    /**
     * Grants permission to update a monitoring alert
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateMonitoringAlert.html
     */
    toUpdateMonitoringAlert() {
        return this.to('UpdateMonitoringAlert');
    }
    /**
     * Grants permission to update a monitoring schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceTypes()
     * - .ifMaxRuntimeInSeconds()
     * - .ifNetworkIsolation()
     * - .ifOutputKmsKey()
     * - .ifVolumeKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     * - .ifInterContainerTrafficEncryption()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateMonitoringSchedule.html
     */
    toUpdateMonitoringSchedule() {
        return this.to('UpdateMonitoringSchedule');
    }
    /**
     * Grants permission to update a notebook instance. Notebook instance updates include upgrading or downgrading the EC2 instance used for your notebook instance to accommodate changes in your workload requirements
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAcceleratorTypes()
     * - .ifInstanceTypes()
     * - .ifMinimumInstanceMetadataServiceVersion()
     * - .ifRootAccess()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateNotebookInstance.html
     */
    toUpdateNotebookInstance() {
        return this.to('UpdateNotebookInstance');
    }
    /**
     * Grants permission to updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateNotebookInstanceLifecycleConfig.html
     */
    toUpdateNotebookInstanceLifecycleConfig() {
        return this.to('UpdateNotebookInstanceLifecycleConfig');
    }
    /**
     * Grants permission to update a pipeline
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdatePipeline.html
     */
    toUpdatePipeline() {
        return this.to('UpdatePipeline');
    }
    /**
     * Grants permission to update a pipeline execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdatePipelineExecution.html
     */
    toUpdatePipelineExecution() {
        return this.to('UpdatePipelineExecution');
    }
    /**
     * Grants permission to update a Project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateProject.html
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Grants permission to update a shared model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     */
    toUpdateSharedModel() {
        return this.to('UpdateSharedModel');
    }
    /**
     * Grants permission to update a Space
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceTypes()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateSpace.html
     */
    toUpdateSpace() {
        return this.to('UpdateSpace');
    }
    /**
     * Grants permission to update a training job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceTypes()
     * - .ifKeepAlivePeriod()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateTrainingJob.html
     */
    toUpdateTrainingJob() {
        return this.to('UpdateTrainingJob');
    }
    /**
     * Grants permission to update a trial
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateTrial.html
     */
    toUpdateTrial() {
        return this.to('UpdateTrial');
    }
    /**
     * Grants permission to update a trial component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateTrialComponent.html
     */
    toUpdateTrialComponent() {
        return this.to('UpdateTrialComponent');
    }
    /**
     * Grants permission to update a UserProfile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceTypes()
     * - .ifVpcSecurityGroupIds()
     * - .ifInstanceTypes()
     * - .ifDomainSharingOutputKmsKey()
     * - .ifImageArns()
     * - .ifImageVersionArns()
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateUserProfile.html
     */
    toUpdateUserProfile() {
        return this.to('UpdateUserProfile');
    }
    /**
     * Grants permission to update a workforce
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateWorkforce.html
     */
    toUpdateWorkforce() {
        return this.to('UpdateWorkforce');
    }
    /**
     * Grants permission to update a workteam
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateWorkteam.html
     */
    toUpdateWorkteam() {
        return this.to('UpdateWorkteam');
    }
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/neo-edge-devices.html
     *
     * @param deviceFleetName - Identifier for the deviceFleetName.
     * @param deviceName - Identifier for the deviceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onDevice(deviceFleetName, deviceName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:device-fleet/${deviceFleetName}/device/${deviceName}`);
    }
    /**
     * Adds a resource of type device-fleet to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/edge-device-fleet.html
     *
     * @param deviceFleetName - Identifier for the deviceFleetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onDeviceFleet(deviceFleetName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:device-fleet/${deviceFleetName}`);
    }
    /**
     * Adds a resource of type edge-packaging-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/edge-packaging-job.html
     *
     * @param edgePackagingJobName - Identifier for the edgePackagingJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onEdgePackagingJob(edgePackagingJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:edge-packaging-job/${edgePackagingJobName}`);
    }
    /**
     * Adds a resource of type edge-deployment-plan to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/edge.html
     *
     * @param edgeDeploymentPlanName - Identifier for the edgeDeploymentPlanName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onEdgeDeploymentPlan(edgeDeploymentPlanName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:edge-deployment/${edgeDeploymentPlanName}`);
    }
    /**
     * Adds a resource of type human-loop to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-start-human-loop.html
     *
     * @param humanLoopName - Identifier for the humanLoopName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHumanLoop(humanLoopName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:human-loop/${humanLoopName}`);
    }
    /**
     * Adds a resource of type flow-definition to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-create-flow-definition.html
     *
     * @param flowDefinitionName - Identifier for the flowDefinitionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onFlowDefinition(flowDefinitionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:flow-definition/${flowDefinitionName}`);
    }
    /**
     * Adds a resource of type human-task-ui to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-instructions-overview.html
     *
     * @param humanTaskUiName - Identifier for the humanTaskUiName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onHumanTaskUi(humanTaskUiName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:human-task-ui/${humanTaskUiName}`);
    }
    /**
     * Adds a resource of type hub to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-content-sharing.html
     *
     * @param hubName - Identifier for the hubName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHub(hubName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:hub/${hubName}`);
    }
    /**
     * Adds a resource of type hub-content to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-content-sharing.html
     *
     * @param hubName - Identifier for the hubName.
     * @param hubContentType - Identifier for the hubContentType.
     * @param hubContentName - Identifier for the hubContentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHubContent(hubName, hubContentType, hubContentName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:hub-content/${hubName}/${hubContentType}/${hubContentName}`);
    }
    /**
     * Adds a resource of type inference-recommendations-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/inference-recommender-recommendation-jobs.html
     *
     * @param inferenceRecommendationsJobName - Identifier for the inferenceRecommendationsJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onInferenceRecommendationsJob(inferenceRecommendationsJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:inference-recommendations-job/${inferenceRecommendationsJobName}`);
    }
    /**
     * Adds a resource of type inference-experiment to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/inference-experiment.html
     *
     * @param inferenceExperimentName - Identifier for the inferenceExperimentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onInferenceExperiment(inferenceExperimentName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:inference-experiment/${inferenceExperimentName}`);
    }
    /**
     * Adds a resource of type labeling-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms.html
     *
     * @param labelingJobName - Identifier for the labelingJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onLabelingJob(labelingJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:labeling-job/${labelingJobName}`);
    }
    /**
     * Adds a resource of type workteam to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html
     *
     * @param workteamName - Identifier for the workteamName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onWorkteam(workteamName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:workteam/${workteamName}`);
    }
    /**
     * Adds a resource of type workforce to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html
     *
     * @param workforceName - Identifier for the workforceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onWorkforce(workforceName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:workforce/${workforceName}`);
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-entity-status.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onDomain(domainId, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:domain/${domainId}`);
    }
    /**
     * Adds a resource of type user-profile to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-entity-status.html
     *
     * @param domainId - Identifier for the domainId.
     * @param userProfileName - Identifier for the userProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onUserProfile(domainId, userProfileName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:user-profile/${domainId}/${userProfileName}`);
    }
    /**
     * Adds a resource of type space to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-entity-status.html
     *
     * @param domainId - Identifier for the domainId.
     * @param spaceName - Identifier for the spaceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onSpace(domainId, spaceName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:space/${domainId}/${spaceName}`);
    }
    /**
     * Adds a resource of type app to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-entity-status.html
     *
     * @param domainId - Identifier for the domainId.
     * @param userProfileName - Identifier for the userProfileName.
     * @param appType - Identifier for the appType.
     * @param appName - Identifier for the appName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onApp(domainId, userProfileName, appType, appName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:app/${domainId}/${userProfileName}/${appType}/${appName}`);
    }
    /**
     * Adds a resource of type app-image-config to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi-create.html
     *
     * @param appImageConfigName - Identifier for the appImageConfigName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onAppImageConfig(appImageConfigName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:app-image-config/${appImageConfigName}`);
    }
    /**
     * Adds a resource of type studio-lifecycle-config to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-lcc.html
     *
     * @param studioLifecycleConfigName - Identifier for the studioLifecycleConfigName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onStudioLifecycleConfig(studioLifecycleConfigName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:studio-lifecycle-config/${studioLifecycleConfigName}`);
    }
    /**
     * Adds a resource of type notebook-instance to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/nbi.html
     *
     * @param notebookInstanceName - Identifier for the notebookInstanceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onNotebookInstance(notebookInstanceName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:notebook-instance/${notebookInstanceName}`);
    }
    /**
     * Adds a resource of type notebook-instance-lifecycle-config to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html
     *
     * @param notebookInstanceLifecycleConfigName - Identifier for the notebookInstanceLifecycleConfigName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNotebookInstanceLifecycleConfig(notebookInstanceLifecycleConfigName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:notebook-instance-lifecycle-config/${notebookInstanceLifecycleConfigName}`);
    }
    /**
     * Adds a resource of type code-repository to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html
     *
     * @param codeRepositoryName - Identifier for the codeRepositoryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onCodeRepository(codeRepositoryName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:code-repository/${codeRepositoryName}`);
    }
    /**
     * Adds a resource of type image to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html
     *
     * @param imageName - Identifier for the imageName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onImage(imageName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:image/${imageName}`);
    }
    /**
     * Adds a resource of type image-version to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html
     *
     * @param imageName - Identifier for the imageName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onImageVersion(imageName, version, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:image-version/${imageName}/${version}`);
    }
    /**
     * Adds a resource of type algorithm to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/algorithms-choose.html
     *
     * @param algorithmName - Identifier for the algorithmName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onAlgorithm(algorithmName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:algorithm/${algorithmName}`);
    }
    /**
     * Adds a resource of type training-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-training.html
     *
     * @param trainingJobName - Identifier for the trainingJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onTrainingJob(trainingJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:training-job/${trainingJobName}`);
    }
    /**
     * Adds a resource of type processing-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html
     *
     * @param processingJobName - Identifier for the processingJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onProcessingJob(processingJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:processing-job/${processingJobName}`);
    }
    /**
     * Adds a resource of type hyper-parameter-tuning-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html
     *
     * @param hyperParameterTuningJobName - Identifier for the hyperParameterTuningJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onHyperParameterTuningJob(hyperParameterTuningJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:hyper-parameter-tuning-job/${hyperParameterTuningJobName}`);
    }
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-projects-whatis.html
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onProject(projectName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:project/${projectName}`);
    }
    /**
     * Adds a resource of type model-package to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ModelPackage.html
     *
     * @param modelPackageName - Identifier for the modelPackageName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelPackage(modelPackageName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-package/${modelPackageName}`);
    }
    /**
     * Adds a resource of type model-package-group to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-model-group.html
     *
     * @param modelPackageGroupName - Identifier for the modelPackageGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelPackageGroup(modelPackageGroupName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-package-group/${modelPackageGroupName}`);
    }
    /**
     * Adds a resource of type model to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/realtime-endpoints.html
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModel(modelName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model/${modelName}`);
    }
    /**
     * Adds a resource of type endpoint-config to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/realtime-endpoints.html
     *
     * @param endpointConfigName - Identifier for the endpointConfigName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onEndpointConfig(endpointConfigName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:endpoint-config/${endpointConfigName}`);
    }
    /**
     * Adds a resource of type endpoint to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/realtime-endpoints.html
     *
     * @param endpointName - Identifier for the endpointName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onEndpoint(endpointName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:endpoint/${endpointName}`);
    }
    /**
     * Adds a resource of type transform-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TransformJob.html.html
     *
     * @param transformJobName - Identifier for the transformJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onTransformJob(transformJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:transform-job/${transformJobName}`);
    }
    /**
     * Adds a resource of type compilation-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CompilationJobSummary.html
     *
     * @param compilationJobName - Identifier for the compilationJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onCompilationJob(compilationJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:compilation-job/${compilationJobName}`);
    }
    /**
     * Adds a resource of type automl-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html
     *
     * @param autoMLJobJobName - Identifier for the autoMLJobJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onAutomlJob(autoMLJobJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:automl-job/${autoMLJobJobName}`);
    }
    /**
     * Adds a resource of type monitoring-schedule to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-scheduling.html
     *
     * @param monitoringScheduleName - Identifier for the monitoringScheduleName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onMonitoringSchedule(monitoringScheduleName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:monitoring-schedule/${monitoringScheduleName}`);
    }
    /**
     * Adds a resource of type monitoring-schedule-alert to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-scheduling.html
     *
     * @param monitoringScheduleName - Identifier for the monitoringScheduleName.
     * @param monitoringScheduleAlertName - Identifier for the monitoringScheduleAlertName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMonitoringScheduleAlert(monitoringScheduleName, monitoringScheduleAlertName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:monitoring-schedule/${monitoringScheduleName}/alert/${monitoringScheduleAlertName}`);
    }
    /**
     * Adds a resource of type data-quality-job-definition to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-quality.html
     *
     * @param dataQualityJobDefinitionName - Identifier for the dataQualityJobDefinitionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onDataQualityJobDefinition(dataQualityJobDefinitionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:data-quality-job-definition/${dataQualityJobDefinitionName}`);
    }
    /**
     * Adds a resource of type model-quality-job-definition to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality.html
     *
     * @param modelQualityJobDefinitionName - Identifier for the modelQualityJobDefinitionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelQualityJobDefinition(modelQualityJobDefinitionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-quality-job-definition/${modelQualityJobDefinitionName}`);
    }
    /**
     * Adds a resource of type model-bias-job-definition to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-detect-post-training-bias.html
     *
     * @param modelBiasJobDefinitionName - Identifier for the modelBiasJobDefinitionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelBiasJobDefinition(modelBiasJobDefinitionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-bias-job-definition/${modelBiasJobDefinitionName}`);
    }
    /**
     * Adds a resource of type model-explainability-job-definition to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-model-explainability.html
     *
     * @param modelExplainabilityJobDefinitionName - Identifier for the modelExplainabilityJobDefinitionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelExplainabilityJobDefinition(modelExplainabilityJobDefinitionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-explainability-job-definition/${modelExplainabilityJobDefinitionName}`);
    }
    /**
     * Adds a resource of type experiment to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Experiment.html
     *
     * @param experimentName - Identifier for the experimentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onExperiment(experimentName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:experiment/${experimentName}`);
    }
    /**
     * Adds a resource of type experiment-trial to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Trial.html
     *
     * @param trialName - Identifier for the trialName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onExperimentTrial(trialName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:experiment-trial/${trialName}`);
    }
    /**
     * Adds a resource of type experiment-trial-component to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrialComponent.html
     *
     * @param trialComponentName - Identifier for the trialComponentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onExperimentTrialComponent(trialComponentName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:experiment-trial-component/${trialComponentName}`);
    }
    /**
     * Adds a resource of type feature-group to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store.html
     *
     * @param featureGroupName - Identifier for the featureGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onFeatureGroup(featureGroupName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:feature-group/${featureGroupName}`);
    }
    /**
     * Adds a resource of type pipeline to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Pipeline.html
     *
     * @param pipelineName - Identifier for the pipelineName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onPipeline(pipelineName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:pipeline/${pipelineName}`);
    }
    /**
     * Adds a resource of type pipeline-execution to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PipelineExecution.html
     *
     * @param pipelineName - Identifier for the pipelineName.
     * @param randomString - Identifier for the randomString.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPipelineExecution(pipelineName, randomString, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:pipeline/${pipelineName}/execution/${randomString}`);
    }
    /**
     * Adds a resource of type artifact to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ArtifactSummary.html
     *
     * @param hashOfArtifactSource - Identifier for the hashOfArtifactSource.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onArtifact(hashOfArtifactSource, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:artifact/${hashOfArtifactSource}`);
    }
    /**
     * Adds a resource of type context to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContextSummary.html
     *
     * @param contextName - Identifier for the contextName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onContext(contextName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:context/${contextName}`);
    }
    /**
     * Adds a resource of type action to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ActionSummary.html
     *
     * @param actionName - Identifier for the actionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onAction(actionName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:action/${actionName}`);
    }
    /**
     * Adds a resource of type lineage-group to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_LineageGroupSummary.html
     *
     * @param lineageGroupName - Identifier for the lineageGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onLineageGroup(lineageGroupName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:lineage-group/${lineageGroupName}`);
    }
    /**
     * Adds a resource of type model-card to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ModelCard.html
     *
     * @param modelCardName - Identifier for the modelCardName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelCard(modelCardName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-card/${modelCardName}`);
    }
    /**
     * Adds a resource of type model-card-export-job to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ModelCardExportJob.html
     *
     * @param modelCardName - Identifier for the modelCardName.
     * @param exportJobName - Identifier for the exportJobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifResourceTag()
     */
    onModelCardExportJob(modelCardName, exportJobName, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:model-card/${modelCardName}/export-job/${exportJobName}`);
    }
    /**
     * Adds a resource of type shared-model to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     *
     * @param sharedModelId - Identifier for the sharedModelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSharedModel(sharedModelId, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:shared-model/${sharedModelId}`);
    }
    /**
     * Adds a resource of type shared-model-event to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-collaborate-permissions.html
     *
     * @param eventId - Identifier for the eventId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSharedModelEvent(eventId, account, region, partition) {
        return this.on(`arn:${partition || Sagemaker.defaultPartition}:sagemaker:${region || '*'}:${account || '*'}:shared-model-event/${eventId}`);
    }
    /**
     * Filters access by the list of all accelerator types associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateEndpointConfig()
     * - .toCreateNotebookInstance()
     * - .toUpdateNotebookInstance()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAcceleratorTypes(value, operator) {
        return this.if(`AcceleratorTypes`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the app network access type associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateDomain()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAppNetworkAccessType(value, operator) {
        return this.if(`AppNetworkAccessType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a metadata key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateModelPackage()
     * - .toUpdateModelPackage()
     *
     * @param metadataKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCustomerMetadataProperties(metadataKey, value, operator) {
        return this.if(`CustomerMetadataProperties/${metadataKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the list of metadata properties associated with the model-package resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toUpdateModelPackage()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCustomerMetadataPropertiesToRemove(value, operator) {
        return this.if(`CustomerMetadataPropertiesToRemove`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the direct internet access associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateNotebookInstance()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDirectInternetAccess(value, operator) {
        return this.if(`DirectInternetAccess`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the Domain sharing output KMS key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateDomain()
     * - .toCreateUserProfile()
     * - .toUpdateDomain()
     * - .toUpdateUserProfile()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifDomainSharingOutputKmsKey(value, operator) {
        return this.if(`DomainSharingOutputKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the DisableGlueTableCreation flag associated with the feature group resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifFeatureGroupDisableGlueTableCreation(value) {
        return this.if(`FeatureGroupDisableGlueTableCreation`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the EnableOnlineStore flag associated with feature group in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifFeatureGroupEnableOnlineStore(value) {
        return this.if(`FeatureGroupEnableOnlineStore`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the presence of an OfflineStoreConfig in the feature group resource in the request. This access filter only supports the null-conditional operator
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifFeatureGroupOfflineStoreConfig(value) {
        return this.if(`FeatureGroupOfflineStoreConfig`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the offline store kms key associated with the feature group resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFeatureGroupOfflineStoreKmsKey(value, operator) {
        return this.if(`FeatureGroupOfflineStoreKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the offline store s3 uri associated with the feature group resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFeatureGroupOfflineStoreS3Uri(value, operator) {
        return this.if(`FeatureGroupOfflineStoreS3Uri`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the online store kms key associated with the feature group resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFeatureGroup()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFeatureGroupOnlineStoreKmsKey(value, operator) {
        return this.if(`FeatureGroupOnlineStoreKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by a file system access mode associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateTrainingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFileSystemAccessMode(value, operator) {
        return this.if(`FileSystemAccessMode`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a file system directory path associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateTrainingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFileSystemDirectoryPath(value, operator) {
        return this.if(`FileSystemDirectoryPath`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a file system ID associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateTrainingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFileSystemId(value, operator) {
        return this.if(`FileSystemId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a file system type associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateTrainingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFileSystemType(value, operator) {
        return this.if(`FileSystemType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a key that is present in the request the user makes to the SageMaker service. This key is deprecated. It has been replaced by sagemaker:VolumeKmsKey
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifHomeEfsFileSystemKmsKey(value, operator) {
        return this.if(`HomeEfsFileSystemKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the list of all image arns associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateDomain()
     * - .toCreateSpace()
     * - .toCreateUserProfile()
     * - .toUpdateDomain()
     * - .toUpdateSpace()
     * - .toUpdateUserProfile()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImageArns(value, operator) {
        return this.if(`ImageArns`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the list of all image version arns associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateDomain()
     * - .toCreateSpace()
     * - .toCreateUserProfile()
     * - .toUpdateDomain()
     * - .toUpdateSpace()
     * - .toUpdateUserProfile()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImageVersionArns(value, operator) {
        return this.if(`ImageVersionArns`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the list of all instance types associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateApp()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateDomain()
     * - .toCreateEndpointConfig()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateNotebookInstance()
     * - .toCreateProcessingJob()
     * - .toCreateSpace()
     * - .toCreateTrainingJob()
     * - .toCreateTransformJob()
     * - .toCreateUserProfile()
     * - .toUpdateDomain()
     * - .toUpdateMonitoringSchedule()
     * - .toUpdateNotebookInstance()
     * - .toUpdateSpace()
     * - .toUpdateTrainingJob()
     * - .toUpdateUserProfile()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceTypes(value, operator) {
        return this.if(`InstanceTypes`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the inter container traffic encryption associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutoMLJob()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifInterContainerTrafficEncryption(value) {
        return this.if(`InterContainerTrafficEncryption`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the keep-alive period associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateTrainingJob()
     * - .toUpdateTrainingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifKeepAlivePeriod(value, operator) {
        return this.if(`KeepAlivePeriod`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the max runtime in seconds associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifMaxRuntimeInSeconds(value, operator) {
        return this.if(`MaxRuntimeInSeconds`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the minimum instance metadata service version used by the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateNotebookInstance()
     * - .toUpdateNotebookInstance()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMinimumInstanceMetadataServiceVersion(value, operator) {
        return this.if(`MinimumInstanceMetadataServiceVersion`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the model approval status with the model-package in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateModelPackage()
     * - .toUpdateModelPackage()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifModelApprovalStatus(value, operator) {
        return this.if(`ModelApprovalStatus`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the model arn associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateEndpointConfig()
     * - .toCreateTransformJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifModelArn(value, operator) {
        return this.if(`ModelArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the network isolation associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModel()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifNetworkIsolation(value) {
        return this.if(`NetworkIsolation`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters access by the output kms key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutoMLJob()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateLabelingJob()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toCreateTransformJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifOutputKmsKey(value, operator) {
        return this.if(`OutputKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the preface string for a tag key and value pair attached to a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTagExists(value, operator) {
        return this.if(`ResourceTag/`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - device
     * - device-fleet
     * - edge-packaging-job
     * - edge-deployment-plan
     * - flow-definition
     * - human-task-ui
     * - inference-recommendations-job
     * - inference-experiment
     * - labeling-job
     * - workteam
     * - workforce
     * - domain
     * - user-profile
     * - space
     * - app
     * - app-image-config
     * - studio-lifecycle-config
     * - notebook-instance
     * - code-repository
     * - image
     * - algorithm
     * - training-job
     * - processing-job
     * - hyper-parameter-tuning-job
     * - project
     * - model-package
     * - model-package-group
     * - model
     * - endpoint-config
     * - endpoint
     * - transform-job
     * - compilation-job
     * - automl-job
     * - monitoring-schedule
     * - data-quality-job-definition
     * - model-quality-job-definition
     * - model-bias-job-definition
     * - model-explainability-job-definition
     * - experiment
     * - experiment-trial
     * - experiment-trial-component
     * - feature-group
     * - pipeline
     * - artifact
     * - context
     * - action
     * - lineage-group
     * - model-card
     * - model-card-export-job
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTag(tagKey, value, operator) {
        return this.if(`ResourceTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the root access associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateNotebookInstance()
     * - .toUpdateNotebookInstance()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRootAccess(value, operator) {
        return this.if(`RootAccess`, value, operator || 'StringLike');
    }
    /**
     * Filters access by limiting maximum concurrency used for Serverless inference in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateEndpointConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifServerlessMaxConcurrency(value, operator) {
        return this.if(`ServerlessMaxConcurrency`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by limiting memory size used for Serverless inference in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateEndpointConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifServerlessMemorySize(value, operator) {
        return this.if(`ServerlessMemorySize`, value, operator || 'NumericEquals');
    }
    /**
     * Filters access by the target model associated with the Multi-Model Endpoint in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toInvokeEndpoint()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetModel(value, operator) {
        return this.if(`TargetModel`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the volume kms key associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutoMLJob()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateDomain()
     * - .toCreateEndpointConfig()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateLabelingJob()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateNotebookInstance()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toCreateTransformJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVolumeKmsKey(value, operator) {
        return this.if(`VolumeKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the list of all VPC security group ids associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutoMLJob()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateDomain()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModel()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateNotebookInstance()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toCreateUserProfile()
     * - .toUpdateDomain()
     * - .toUpdateMonitoringSchedule()
     * - .toUpdateUserProfile()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcSecurityGroupIds(value, operator) {
        return this.if(`VpcSecurityGroupIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the list of all VPC subnets associated with the resource in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutoMLJob()
     * - .toCreateDataQualityJobDefinition()
     * - .toCreateDomain()
     * - .toCreateHyperParameterTuningJob()
     * - .toCreateModel()
     * - .toCreateModelBiasJobDefinition()
     * - .toCreateModelExplainabilityJobDefinition()
     * - .toCreateModelQualityJobDefinition()
     * - .toCreateMonitoringSchedule()
     * - .toCreateNotebookInstance()
     * - .toCreateProcessingJob()
     * - .toCreateTrainingJob()
     * - .toUpdateMonitoringSchedule()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcSubnets(value, operator) {
        return this.if(`VpcSubnets`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the workteam arn associated to the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFlowDefinition()
     * - .toCreateLabelingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifWorkteamArn(value, operator) {
        return this.if(`WorkteamArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the workteam type associated to the request. This can be public-crowd, private-crowd or vendor-crowd
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to actions:
     * - .toCreateFlowDefinition()
     * - .toCreateLabelingJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkteamType(value, operator) {
        return this.if(`WorkteamType`, value, operator || 'StringLike');
    }
}
exports.Sagemaker = Sagemaker;
_a = JSII_RTTI_SYMBOL_1;
Sagemaker[_a] = { fqn: "iam-floyd.Sagemaker", version: "0.492.0" };
//# sourceMappingURL=data:application/json;base64,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