# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-25 10:42
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('filer', '0007_auto_20161016_1055'),
    ]

    operations = [
        migrations.CreateModel(
            name='BanFlaggedRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dateTime', models.DateTimeField(auto_now_add=True, verbose_name='Date and time')),
                ('ipAddress', models.GenericIPAddressField(blank=True, null=True, verbose_name='IP address')),
                ('flagCode', models.CharField(help_text='Search for this code for easier reference.', max_length=8, verbose_name='Flag code')),
                ('data', models.JSONField(default=dict, verbose_name='Session and form data')),
            ],
            options={
                'verbose_name_plural': 'Records of bans being flagged',
                'verbose_name': 'Record of ban being flagged',
                'ordering': ('-dateTime',),
            },
        ),
        migrations.CreateModel(
            name='BannedEmail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='Email address')),
            ],
            options={
                'verbose_name_plural': 'Banned email addresses',
                'verbose_name': 'Banned email address',
            },
        ),
        migrations.CreateModel(
            name='BannedPerson',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('firstName', models.CharField(max_length=30, verbose_name='First name')),
                ('lastName', models.CharField(max_length=30, verbose_name='First name')),
                ('notes', models.TextField(blank=True, null=True, verbose_name='Notes for internal purposes')),
                ('expirationDate', models.DateTimeField(blank=True, help_text='Leave blank for no expiration.', null=True, verbose_name='Expiration date')),
                ('disabled', models.BooleanField(default=False, help_text='<strong>Note:</strong>Checking this box will prevent this ban from being automatically enforced.', verbose_name='Disabled')),
                ('submissionDate', models.DateTimeField(auto_now_add=True, verbose_name='Submission date')),
                ('modifiedDate', models.DateTimeField(auto_now=True, verbose_name='Last updated')),
                ('photo', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='banned_person_image', to='filer.Image', verbose_name='Photo')),
            ],
            options={
                'permissions': (('view_banlist', 'Can view the list of banned individuals.'), ('ignore_ban', 'Can register users despite banned credentials')),
                'verbose_name_plural': 'Banned individuals',
                'verbose_name': 'Banned individual',
                'ordering': ('lastName', 'firstName'),
            },
        ),
        migrations.AddField(
            model_name='bannedemail',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='banlist.BannedPerson', verbose_name='Individual'),
        ),
        migrations.AddField(
            model_name='banflaggedrecord',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='banlist.BannedPerson', verbose_name='Person'),
        ),
    ]
