# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-25 00:09
from __future__ import unicode_literals

import danceschool.core.models
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import filer.fields.image
import multiselectfield.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('filer', '0007_auto_20161016_1055'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('cms', '0016_auto_20160608_1535'),
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClassDescription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('description', djangocms_text_ckeditor.fields.HTMLField(blank=True)),
                ('slug', models.SlugField(blank='True', help_text='This is used in the URL for the individual class pages.  You can override the default', max_length=100, unique=True)),
                ('oneTimeSeries', models.BooleanField(default=False, help_text='If checked, this class description will not show up in the dropdown menu when creating a new series.', verbose_name='One Time Series')),
            ],
            options={
                'ordering': ('-series__startTime',),
            },
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(max_length=30, verbose_name='last name')),
                ('email', models.EmailField(max_length=254, verbose_name='email address')),
                ('phone', models.CharField(blank=True, max_length=20, null=True, verbose_name='telephone')),
                ('data', models.JSONField(default=dict)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('last_name', 'first_name'),
                'permissions': (('can_autocomplete_users', 'Able to use customer and User autocomplete features (in various admin forms)'), ('view_other_user_profiles', 'Able to view other Customer and User profile pages')),
            },
        ),
        migrations.CreateModel(
            name='DanceRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
                ('pluralName', models.CharField(help_text='For the registration form.', max_length=50, unique=True)),
                ('order', models.FloatField(help_text='Lower numbers show up first when registering.')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='DanceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
                ('order', models.FloatField(help_text='Lower numbers show up first when choosing class types in the admin.  By default, this does not affect ordering on public-facing registration pages.')),
                ('roles', models.ManyToManyField(help_text='Select default roles used for registrations of this dance type (can be overriden for specific events).', to='core.DanceRole')),
            ],
            options={
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='DanceTypeLevel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('order', models.FloatField(help_text='This is used to order and look up dance types.')),
                ('requiresAudition', models.BooleanField(default=False)),
                ('displayColor', models.CharField(default=danceschool.core.models.get_defaultClassColor, help_text='Choose a color for the calendar display.', max_length=10, verbose_name='Display Color')),
                ('danceType', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.DanceType', verbose_name='Dance Type')),
            ],
            options={
                'verbose_name_plural': 'Levels of dance type',
                'ordering': ('danceType__order', 'order'),
                'verbose_name': 'Level of Dance Type',
            },
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('subject', models.CharField(blank=True, max_length=200, null=True)),
                ('content', models.TextField(blank=True, help_text='See the list of available variables for details on what information can be included with template tags.', null=True)),
                ('defaultFromName', models.CharField(blank=True, default=danceschool.core.models.get_defaultEmailName, max_length=100, null=True, verbose_name='From Name (default)')),
                ('defaultFromAddress', models.EmailField(blank=True, default=danceschool.core.models.get_defaultEmailFrom, max_length=100, null=True, verbose_name='From Address (default)')),
                ('defaultCC', models.CharField(blank=True, max_length=100, null=True, verbose_name='CC (default)')),
                ('hideFromForm', models.BooleanField(default=False, help_text='Check this box for templates that are used for automated emails.', verbose_name="Hide from 'Email Students' Form")),
                ('groupRequired', models.ForeignKey(blank=True, help_text='Some templates should only be visible to some users.', null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.Group', verbose_name='Group permissions required to use.')),
            ],
            options={
                'permissions': (('send_email', 'Can send emails using the SendEmailView'),),
            },
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('D', 'Registration disabled'), ('O', 'Registration enabled'), ('K', 'Registration held closed (override default behavior)'), ('H', 'Registration held open (override default)'), ('C', 'Hidden from registration page and registration closed, but visible on calendar.'), ('X', 'Event hidden and registration closed')], help_text='Set the registration status and visibility status of this event.', max_length=1)),
                ('registrationOpen', models.BooleanField(default=False)),
                ('closeAfterDays', models.SmallIntegerField(blank=True, default=danceschool.core.models.get_closeAfterDays, help_text='Enter positive values to close after first event occurrence, and negative values to close before first event occurrence.  Leave blank to keep registration open until the event has ended entirely.', null=True, verbose_name='Registration Closes Days From First Occurrence')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('capacity', models.PositiveIntegerField(blank=True, null=True)),
                ('month', models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(12)])),
                ('year', models.SmallIntegerField(blank=True, null=True)),
                ('startTime', models.DateTimeField(blank=True, null=True)),
                ('endTime', models.DateTimeField(blank=True, null=True)),
                ('duration', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)])),
            ],
            options={
                'verbose_name_plural': 'All Series/Events',
                'ordering': ('-year', '-month', '-startTime'),
                'verbose_name': 'Series/Event',
            },
        ),
        migrations.CreateModel(
            name='EventListPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_eventlistpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, default='Upcoming Events', max_length=250, verbose_name='Custom List Title')),
                ('eventType', models.CharField(blank=True, choices=[('S', 'Class Series'), ('P', 'Public Events')], help_text='Leave blank to include all Events.', max_length=1, null=True, verbose_name='Limit to Event Type')),
                ('limitTypeStart', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='E', max_length=1, verbose_name='Limit interval start by')),
                ('daysStart', models.SmallIntegerField(blank=True, help_text='(E.g. enter -30 for an interval that starts with 30 days prior to today) Leave blank for no limit, or enter 0 to limit to future events', null=True, verbose_name='Interval limited to __ days from present')),
                ('startDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval start date')),
                ('limitTypeEnd', models.CharField(choices=[('S', 'Event start date'), ('E', 'Event end date')], default='S', max_length=1, verbose_name='Limit interval end by')),
                ('daysEnd', models.SmallIntegerField(blank=True, help_text='(E.g. enter 30 for an interval that ends 30 days from today) Leave blank for no limit, or enter 0 to limit to past events', null=True, verbose_name='Interval limited to __ days from present')),
                ('endDate', models.DateField(blank=True, help_text='Leave blank for no limit (overrides relative interval limits)', null=True, verbose_name='Exact interval end date ')),
                ('limitToOpenRegistration', models.BooleanField(default=False, verbose_name='Limit to open for registration only')),
                ('weekday', models.PositiveSmallIntegerField(blank=True, choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], null=True, verbose_name='Limit to Weekday')),
                ('cssClasses', models.CharField(blank=True, help_text='Classes are applied to surrounding &lt;div&gt;', max_length=250, null=True, verbose_name='Custom CSS Classes')),
                ('template', models.CharField(blank=True, max_length=250, null=True)),
            ],
            options={
                'permissions': (('choose_custom_plugin_template', 'Can enter a custom plugin template for plugins with selectable template.'),),
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='EventOccurrence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('startTime', models.DateTimeField(verbose_name='Start Time')),
                ('endTime', models.DateTimeField(verbose_name='End Time')),
                ('cancelled', models.BooleanField(default=False, help_text='Check this box to mark that the class or event was cancelled.')),
            ],
        ),
        migrations.CreateModel(
            name='EventRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('checkedIn', models.BooleanField(default=False, help_text='Check to mark the individual as checked in.', verbose_name='Checked In')),
                ('dropIn', models.BooleanField(default=False, help_text='If true, this is a drop-in registration.', verbose_name='Drop-in registration')),
                ('cancelled', models.BooleanField(default=False, help_text='Mark as cancelled so that this registration is not counted in student/attendee counts.')),
                ('data', models.JSONField(default=dict)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='EventRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('capacity', models.PositiveIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='EventStaffCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
                ('defaultRate', models.FloatField(blank=True, help_text='If the financials app is enabled with automatic generation of expense items, then this is the rate that will be used for staff payments for staff of this type.', null=True, validators=[django.core.validators.MinValueValidator(0)])),
            ],
            options={
                'verbose_name_plural': 'Event staff categories',
            },
        ),
        migrations.CreateModel(
            name='EventStaffMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creationDate', models.DateTimeField(auto_now_add=True)),
                ('modifyDate', models.DateTimeField(auto_now=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.EventStaffCategory')),
            ],
        ),
        migrations.CreateModel(
            name='InstructorListPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_instructorlistpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('statusChoices', multiselectfield.db.fields.MultiSelectField(choices=[('R', 'Regular Instructor'), ('A', 'Assistant Instructor'), ('T', 'Instructor-in-training'), ('G', 'Guest Instructor'), ('Z', 'Former Guest Instructor'), ('X', 'Former/Retired Instructor'), ('H', 'Publicly Hidden')], default=['R', 'A', 'G'], max_length=13, verbose_name='Limit to Instructor Status')),
                ('orderChoice', models.CharField(choices=[('firstName', 'First Name'), ('lastName', 'Last Name'), ('status', 'Instructor Status'), ('random', 'Randomly Ordered')], max_length=10, verbose_name='Order By')),
                ('bioRequired', models.BooleanField(default=False, verbose_name='Exclude instructors with no bio')),
                ('photoRequired', models.BooleanField(default=False, verbose_name='Exclude instructors with no photo')),
                ('activeUpcomingOnly', models.BooleanField(default=False, verbose_name='Include only instructors with upcoming classes')),
                ('template', models.CharField(blank=True, max_length=250, null=True)),
                ('imageThumbnail', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='filer.ThumbnailOption', verbose_name='Image thumbnail option')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Give this location a name.', max_length=80, unique=True)),
                ('address', models.CharField(blank=True, help_text="Enter the location's street address.", max_length=50, null=True, verbose_name='street address')),
                ('city', models.CharField(default='Cambridge', max_length=30)),
                ('state', models.CharField(default='MA', max_length=12, verbose_name='2-digit state code')),
                ('zip', models.CharField(default='02138', max_length=12, verbose_name='ZIP/postal code')),
                ('directions', djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text='Insert any detailed directions that you would like here.  Use HTML to include videos, formatting, etc.', null=True)),
                ('status', models.CharField(choices=[('A', 'Active Location'), ('F', 'Former Location'), ('S', 'Special Event Location (not shown by default)')], default='A', help_text='Is this location used regularly, used for special events, or no longer used?', max_length=1)),
                ('orderNum', models.FloatField(default=0, help_text='This determines the order that the locations show up on the Locations page.')),
                ('rentalRate', models.FloatField(blank=True, help_text='When ExpenseItems are created for renting this location, this rental rate will be used to calculate the total cost of rental.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Hourly Rental Rate (optional)')),
                ('defaultCapacity', models.PositiveIntegerField(blank=True, default=danceschool.core.models.get_defaultEventCapacity, help_text='If set, this will be used to determine capacity for class series in this venue.', null=True, verbose_name='Default Venue Capacity')),
            ],
            options={
                'ordering': ('orderNum',),
            },
        ),
        migrations.CreateModel(
            name='LocationListPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_locationlistpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(blank=True, max_length=250, null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='LocationPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_locationpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(blank=True, max_length=250, null=True)),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Location')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='PricingTier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Give this pricing tier a name (e.g. 'Default 4-week series')", max_length=50, unique=True)),
                ('onlineStudentPrice', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('doorStudentPrice', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('onlineGeneralPrice', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('doorGeneralPrice', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)])),
                ('expired', models.BooleanField(default=False, help_text='If this box is checked, then this pricing tier will not show up as an option when creating new series.  Use this for old prices or custom pricing that will not be repeated.')),
            ],
        ),
        migrations.CreateModel(
            name='PublicEventCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Category name will be displayed.', max_length=100, unique=True)),
                ('description', models.TextField(blank=True, help_text='Add an optional description.', null=True)),
                ('displayColor', models.CharField(default='#0000FF', help_text='Choose a color for the calendar display.', max_length=10)),
            ],
            options={
                'verbose_name_plural': 'Public event categories',
                'verbose_name': 'Public event category',
            },
        ),
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('firstName', models.CharField(default='TBD', max_length=100)),
                ('lastName', models.CharField(default='TBD', max_length=100)),
                ('howHeardAboutUs', models.TextField(blank=True, default='', null=True, verbose_name='How they heard about us')),
                ('student', models.BooleanField(default=False)),
                ('payAtDoor', models.BooleanField(default=False)),
                ('comments', models.TextField(blank=True, default='', null=True)),
                ('paidOnline', models.BooleanField(default=False, verbose_name='Paid Online')),
                ('processingFee', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Processing Fees')),
                ('priceWithDiscount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price Net of Discounts')),
                ('amountPaid', models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Net Amount Paid')),
                ('dateTime', models.DateTimeField(blank=True, null=True, verbose_name='Date & Time')),
                ('invoiceNumber', models.CharField(blank=True, max_length=80, null=True, verbose_name='Invoice Number')),
                ('data', models.JSONField(blank=True, null=True)),
                ('collectedByUser', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='collectedregistrations', to=settings.AUTH_USER_MODEL, verbose_name='Collected by user')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer')),
                ('submissionUser', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='submittedregistrations', to=settings.AUTH_USER_MODEL, verbose_name='registered by user')),
            ],
            options={
                'ordering': ('-dateTime',),
                'permissions': (('view_registration_summary', 'Can access the series-level registration summary view'), ('checkin_customers', 'Can check-in customers using the summary view'), ('accept_door_payments', 'Can process door payments in the registration system'), ('send_invoices', 'Can send invoices to students requesting payment'), ('register_dropins', 'Can register students for drop-ins.'), ('override_register_closed', 'Can register students for series/events that are closed for registration by the public'), ('override_register_soldout', 'Can register students for series/events that are officially sold out'), ('override_register_dropins', 'Can register students for drop-ins even if the series does not allow drop-in registration.')),
            },
        ),
        migrations.CreateModel(
            name='StaffMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('firstName', models.CharField(blank=True, max_length=50, null=True, verbose_name='First Name')),
                ('lastName', models.CharField(blank=True, max_length=50, null=True, verbose_name='Last Name')),
                ('publicEmail', models.CharField(blank=True, help_text='This is the email address used on the site if the instructor is available for private lessons.', max_length=100, verbose_name='Public Email Address')),
                ('privateEmail', models.CharField(blank=True, help_text='This is the personal email address of the instructor for the instructor directory.', max_length=100, verbose_name='Private Email Address')),
                ('phone', models.CharField(blank=True, help_text='Instructor phone numbers are for the instructor directory only, and should not be given to students.', max_length=25, null=True)),
                ('bio', djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text="Insert the instructor's bio here.  Use HTML to include videos, formatting, etc.", null=True, verbose_name='Bio Text')),
                ('feedKey', models.UUIDField(default=uuid.uuid4, editable=False)),
            ],
            options={
                'permissions': (('view_staff_directory', 'Can access the staff directory view'), ('view_school_stats', "Can view statistics about the school's performance.")),
            },
        ),
        migrations.CreateModel(
            name='StaffMemberPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='core_staffmemberpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(blank=True, max_length=250, null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='TemporaryEventRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price', models.FloatField(validators=[django.core.validators.MinValueValidator(0)])),
                ('dropIn', models.BooleanField(default=False, help_text='If true, this is a drop-in registration.', verbose_name='Drop-in registration')),
                ('data', models.JSONField(default=dict)),
            ],
        ),
        migrations.CreateModel(
            name='TemporaryRegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('firstName', models.CharField(max_length=100)),
                ('lastName', models.CharField(max_length=100)),
                ('email', models.CharField(max_length=200)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('howHeardAboutUs', models.TextField(blank=True, default='', null=True, verbose_name='How they heard about us')),
                ('student', models.BooleanField(default=False)),
                ('payAtDoor', models.BooleanField(default=False)),
                ('comments', models.TextField(default='')),
                ('dateTime', models.DateTimeField(blank=True, null=True)),
                ('priceWithDiscount', models.FloatField(null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='price net of discounts')),
                ('data', models.JSONField(blank=True, null=True)),
                ('submissionUser', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='submittedtemporaryregistrations', to=settings.AUTH_USER_MODEL, verbose_name='registered by user')),
            ],
            options={
                'ordering': ('-dateTime',),
            },
        ),
        migrations.CreateModel(
            name='Instructor',
            fields=[
                ('staffmember_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.StaffMember')),
                ('status', models.CharField(choices=[('R', 'Regular Instructor'), ('A', 'Assistant Instructor'), ('T', 'Instructor-in-training'), ('G', 'Guest Instructor'), ('Z', 'Former Guest Instructor'), ('X', 'Former/Retired Instructor'), ('H', 'Publicly Hidden')], default='R', help_text='Instructor status affects the visibility of the instructor on the site and may also impact the pay rate of the instructor.', max_length=1)),
                ('availableForPrivates', models.BooleanField(default=True, help_text='Check this box if you would like to be listed as available for private lessons from students.', verbose_name='Available For Private Lessons')),
            ],
            options={
                'permissions': (('update_instructor_bio', "Can update instructors' bio information"), ('view_own_instructor_stats', "Can view one's own statistics (if an instructor)"), ('view_other_instructor_stats', "Can view other instructors' statistics"), ('view_own_instructor_finances', "Can view one's own financial/payment data (if an instructor)"), ('view_other_instructor_finances', "Can view other instructors' financial/payment data")),
            },
        ),
        migrations.CreateModel(
            name='PublicEvent',
            fields=[
                ('event_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Event')),
                ('title', models.CharField(help_text='Give the event a title', max_length=100)),
                ('slug', models.SlugField(help_text='This is for the event page URL, you can override the default.', max_length=100)),
                ('descriptionField', djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text='Describe the event for the event page.', null=True, verbose_name='Description')),
                ('link', models.URLField(blank=True, help_text="Optionally include the URL to a page for this Event.  If set, then the site's auto-generated Event page will instead redirect to this URL.", null=True)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PublicEventCategory')),
                ('pricingTier', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Pricing Tier')),
            ],
            options={
                'verbose_name': 'Public event',
            },
            bases=('core.event',),
        ),
        migrations.CreateModel(
            name='Series',
            fields=[
                ('event_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Event')),
                ('special', models.BooleanField(default=False, help_text='Special classes (e.g. one-offs, visiting instructors) may be listed separately on the class page.  Leave this unchecked for regular monthly series classes.', verbose_name='Special Class/Series')),
                ('allowDropins', models.BooleanField(default=False, help_text='If checked, then staff will be able to register students as drop-ins.', verbose_name='Allow Class Drop-ins')),
                ('dropinPrice', models.FloatField(blank=True, default=15, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Drop-in price')),
            ],
            options={
                'verbose_name_plural': 'Class series',
                'verbose_name': 'Class Series',
            },
            bases=('core.event',),
        ),
        migrations.AddField(
            model_name='temporaryeventregistration',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event'),
        ),
        migrations.AddField(
            model_name='temporaryeventregistration',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration'),
        ),
        migrations.AddField(
            model_name='temporaryeventregistration',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole'),
        ),
        migrations.AddField(
            model_name='staffmemberpluginmodel',
            name='staffMember',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.StaffMember'),
        ),
        migrations.AddField(
            model_name='staffmember',
            name='image',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='staff_image', to='filer.Image'),
        ),
        migrations.AddField(
            model_name='staffmember',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_core.staffmember_set+', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='staffmember',
            name='userAccount',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User Account'),
        ),
        migrations.AddField(
            model_name='registration',
            name='temporaryRegistration',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration'),
        ),
        migrations.AddField(
            model_name='eventstaffmember',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event'),
        ),
        migrations.AddField(
            model_name='eventstaffmember',
            name='occurrences',
            field=models.ManyToManyField(blank=True, to='core.EventOccurrence'),
        ),
        migrations.AddField(
            model_name='eventstaffmember',
            name='replacedStaffMember',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='replacementFor', to='core.EventStaffMember', verbose_name='Replacement for'),
        ),
        migrations.AddField(
            model_name='eventstaffmember',
            name='staffMember',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.StaffMember', verbose_name='Staff Member'),
        ),
        migrations.AddField(
            model_name='eventstaffmember',
            name='submissionUser',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Submission User'),
        ),
        migrations.AddField(
            model_name='eventrole',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event'),
        ),
        migrations.AddField(
            model_name='eventrole',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Registration'),
        ),
        migrations.AddField(
            model_name='eventregistration',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole'),
        ),
        migrations.AddField(
            model_name='eventoccurrence',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event'),
        ),
        migrations.AddField(
            model_name='eventlistpluginmodel',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location', verbose_name='Limit to Location'),
        ),
        migrations.AddField(
            model_name='event',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location'),
        ),
        migrations.AddField(
            model_name='event',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_core.event_set+', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='event',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='eventsubmissions', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='classdescription',
            name='danceTypeLevel',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel', verbose_name='Dance Type & Level'),
        ),
        migrations.CreateModel(
            name='SeriesTeacher',
            fields=[
            ],
            options={
                'proxy': True,
            },
            bases=('core.eventstaffmember',),
        ),
        migrations.CreateModel(
            name='SubstituteTeacher',
            fields=[
            ],
            options={
                'permissions': (('report_substitute_teaching', 'Can access the substitute teaching reporting form'),),
                'proxy': True,
            },
            bases=('core.eventstaffmember',),
        ),
        migrations.AlterUniqueTogether(
            name='staffmember',
            unique_together=set([('firstName', 'lastName')]),
        ),
        migrations.AddField(
            model_name='series',
            name='classDescription',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ClassDescription', verbose_name='Class Description'),
        ),
        migrations.AddField(
            model_name='series',
            name='pricingTier',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Pricing Tier'),
        ),
        migrations.AlterUniqueTogether(
            name='eventrole',
            unique_together=set([('event', 'role')]),
        ),
        migrations.AlterUniqueTogether(
            name='customer',
            unique_together=set([('last_name', 'first_name', 'email')]),
        ),
    ]
