# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-17 16:42
from __future__ import unicode_literals

import colorful.fields
import danceschool.core.models
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields
import filer.fields.image
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0007_auto_20170620_2146'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='classdescription',
            options={'ordering': ('-series__startTime',), 'verbose_name': 'Class series description', 'verbose_name_plural': 'Class series descriptions'},
        ),
        migrations.AlterModelOptions(
            name='customer',
            options={'ordering': ('last_name', 'first_name'), 'permissions': (('can_autocomplete_users', 'Able to use customer and User autocomplete features (in various admin forms)'), ('view_other_user_profiles', 'Able to view other Customer and User profile pages')), 'verbose_name': 'Customer', 'verbose_name_plural': 'Customers'},
        ),
        migrations.AlterModelOptions(
            name='dancerole',
            options={'ordering': ('order',), 'verbose_name': 'Dance role', 'verbose_name_plural': 'Dance roles'},
        ),
        migrations.AlterModelOptions(
            name='dancetype',
            options={'ordering': ('order',), 'verbose_name': 'Dance type', 'verbose_name_plural': 'Dance types'},
        ),
        migrations.AlterModelOptions(
            name='dancetypelevel',
            options={'ordering': ('danceType__order', 'order'), 'verbose_name': 'Level of dance type', 'verbose_name_plural': 'Levels of dance type'},
        ),
        migrations.AlterModelOptions(
            name='emailtemplate',
            options={'permissions': (('send_email', 'Can send emails using the SendEmailView'),), 'verbose_name': 'Email template', 'verbose_name_plural': 'Email templates'},
        ),
        migrations.AlterModelOptions(
            name='eventoccurrence',
            options={'verbose_name': 'Event occurrence', 'verbose_name_plural': 'Event occurrences'},
        ),
        migrations.AlterModelOptions(
            name='eventregistration',
            options={'verbose_name': 'Event registration', 'verbose_name_plural': 'Event registrations'},
        ),
        migrations.AlterModelOptions(
            name='eventrole',
            options={'verbose_name': 'Event dance role', 'verbose_name_plural': 'Event dance roles'},
        ),
        migrations.AlterModelOptions(
            name='eventstaffcategory',
            options={'verbose_name': 'Event staff category', 'verbose_name_plural': 'Event staff categories'},
        ),
        migrations.AlterModelOptions(
            name='eventstaffmember',
            options={'verbose_name': 'Event staff member', 'verbose_name_plural': 'Event staff members'},
        ),
        migrations.AlterModelOptions(
            name='instructor',
            options={'permissions': (('update_instructor_bio', "Can update instructors' bio information"), ('view_own_instructor_stats', "Can view one's own statistics (if an instructor)"), ('view_other_instructor_stats', "Can view other instructors' statistics"), ('view_own_instructor_finances', "Can view one's own financial/payment data (if an instructor)"), ('view_other_instructor_finances', "Can view other instructors' financial/payment data")), 'verbose_name': 'Instructor', 'verbose_name_plural': 'Instructors'},
        ),
        migrations.AlterModelOptions(
            name='invoice',
            options={'permissions': (('view_all_invoices', 'Can view invoices without passing the validation string.'), ('send_invoices', 'Can send invoices to students requesting payment'), ('process_refunds', 'Can refund customers for registrations and other invoice payments.')), 'verbose_name': 'Invoice', 'verbose_name_plural': 'Invoices'},
        ),
        migrations.AlterModelOptions(
            name='invoiceitem',
            options={'verbose_name': 'Invoice item', 'verbose_name_plural': 'Invoice items'},
        ),
        migrations.AlterModelOptions(
            name='location',
            options={'ordering': ('orderNum',), 'verbose_name': 'Location', 'verbose_name_plural': 'Locations'},
        ),
        migrations.AlterModelOptions(
            name='publicevent',
            options={'verbose_name': 'Public event', 'verbose_name_plural': 'Public events'},
        ),
        migrations.AlterModelOptions(
            name='registration',
            options={'ordering': ('-dateTime',), 'permissions': (('view_registration_summary', 'Can access the series-level registration summary view'), ('checkin_customers', 'Can check-in customers using the summary view'), ('accept_door_payments', 'Can process door payments in the registration system'), ('register_dropins', 'Can register students for drop-ins.'), ('override_register_closed', 'Can register students for series/events that are closed for registration by the public'), ('override_register_soldout', 'Can register students for series/events that are officially sold out'), ('override_register_dropins', 'Can register students for drop-ins even if the series does not allow drop-in registration.')), 'verbose_name': 'Registration', 'verbose_name_plural': 'Registrations'},
        ),
        migrations.AlterModelOptions(
            name='series',
            options={'verbose_name': 'Class series', 'verbose_name_plural': 'Class series'},
        ),
        migrations.AlterModelOptions(
            name='seriesteacher',
            options={'verbose_name': 'Series instructor', 'verbose_name_plural': 'Series instructors'},
        ),
        migrations.AlterModelOptions(
            name='staffmember',
            options={'permissions': (('view_staff_directory', 'Can access the staff directory view'), ('view_school_stats', "Can view statistics about the school's performance.")), 'verbose_name': 'Staff member', 'verbose_name_plural': 'Staff members'},
        ),
        migrations.AlterModelOptions(
            name='substituteteacher',
            options={'permissions': (('report_substitute_teaching', 'Can access the substitute teaching reporting form'),), 'verbose_name': 'Substitute instructor', 'verbose_name_plural': 'Substitute instructors'},
        ),
        migrations.AlterModelOptions(
            name='temporaryeventregistration',
            options={'verbose_name': 'Temporary event registration', 'verbose_name_plural': 'Temporary event registrations'},
        ),
        migrations.AlterModelOptions(
            name='temporaryregistration',
            options={'ordering': ('-dateTime',), 'verbose_name': 'Temporary registration', 'verbose_name_plural': 'Temporary registrations'},
        ),
        migrations.AlterField(
            model_name='classdescription',
            name='description',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='classdescription',
            name='slug',
            field=models.SlugField(blank='True', help_text='This is used in the URL for the individual class pages.  You can override the default', max_length=100, unique=True, verbose_name='Slug'),
        ),
        migrations.AlterField(
            model_name='classdescription',
            name='title',
            field=models.CharField(max_length=200, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='data',
            field=models.JSONField(default=dict, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='email',
            field=models.EmailField(max_length=254, verbose_name='Email address'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='first_name',
            field=models.CharField(max_length=30, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='last_name',
            field=models.CharField(max_length=30, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='phone',
            field=models.CharField(blank=True, max_length=20, null=True, verbose_name='Telephone'),
        ),
        migrations.AlterField(
            model_name='customer',
            name='user',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User account'),
        ),
        migrations.AlterField(
            model_name='dancerole',
            name='name',
            field=models.CharField(max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='dancerole',
            name='order',
            field=models.FloatField(help_text='Lower numbers show up first when registering.', verbose_name='Order number'),
        ),
        migrations.AlterField(
            model_name='dancerole',
            name='pluralName',
            field=models.CharField(help_text='For the registration form.', max_length=50, unique=True, verbose_name='Plural of name'),
        ),
        migrations.AlterField(
            model_name='dancetype',
            name='name',
            field=models.CharField(max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='dancetype',
            name='order',
            field=models.FloatField(help_text='Lower numbers show up first when choosing class types in the admin.  By default, this does not affect ordering on public-facing registration pages.', verbose_name='Order number'),
        ),
        migrations.AlterField(
            model_name='dancetype',
            name='roles',
            field=models.ManyToManyField(help_text='Select default roles used for registrations of this dance type (can be overriden for specific events).', to='core.DanceRole', verbose_name='Dance roles'),
        ),
        migrations.AlterField(
            model_name='dancetypelevel',
            name='name',
            field=models.CharField(max_length=50, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='dancetypelevel',
            name='order',
            field=models.FloatField(help_text='This is used to order and look up dance types.', verbose_name='Order number'),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='content',
            field=models.TextField(blank=True, help_text='See the list of available variables for details on what information can be included with template tags.', null=True, verbose_name='Content'),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='defaultFromAddress',
            field=models.EmailField(blank=True, default=danceschool.core.models.get_defaultEmailFrom, max_length=100, null=True, verbose_name='From address (default)'),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='defaultFromName',
            field=models.CharField(blank=True, default=danceschool.core.models.get_defaultEmailName, max_length=100, null=True, verbose_name='From name (default)'),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='hideFromForm',
            field=models.BooleanField(default=False, help_text='Check this box for templates that are used for automated emails.', verbose_name="Hide from 'Email Students' form"),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='name',
            field=models.CharField(max_length=100, unique=True, verbose_name='Template name'),
        ),
        migrations.AlterField(
            model_name='emailtemplate',
            name='subject',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Subject line'),
        ),
        migrations.AlterField(
            model_name='event',
            name='capacity',
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name='Event capacity'),
        ),
        migrations.AlterField(
            model_name='event',
            name='closeAfterDays',
            field=models.SmallIntegerField(blank=True, default=danceschool.core.models.get_closeAfterDays, help_text='Enter positive values to close after first event occurrence, and negative values to close before first event occurrence.  Leave blank to keep registration open until the event has ended entirely.', null=True, verbose_name='Registration closes days from first occurrence'),
        ),
        migrations.AlterField(
            model_name='event',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Creation date'),
        ),
        migrations.AlterField(
            model_name='event',
            name='duration',
            field=models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Duration in hours'),
        ),
        migrations.AlterField(
            model_name='event',
            name='endTime',
            field=models.DateTimeField(blank=True, null=True, verbose_name='End time (last occurrence)'),
        ),
        migrations.AlterField(
            model_name='event',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location', verbose_name='Location'),
        ),
        migrations.AlterField(
            model_name='event',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='Last modified date'),
        ),
        migrations.AlterField(
            model_name='event',
            name='month',
            field=models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(12)], verbose_name='Month'),
        ),
        migrations.AlterField(
            model_name='event',
            name='registrationOpen',
            field=models.BooleanField(default=False, verbose_name='Registration is open'),
        ),
        migrations.AlterField(
            model_name='event',
            name='startTime',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Start time (first occurrence)'),
        ),
        migrations.AlterField(
            model_name='event',
            name='status',
            field=models.CharField(choices=[('D', 'Registration disabled'), ('O', 'Registration enabled'), ('K', 'Registration held closed (override default behavior)'), ('H', 'Registration held open (override default)'), ('L', 'Registration open, but hidden from registration page and calendar (link required to register)'), ('C', 'Hidden from registration page and registration closed, but visible on calendar.'), ('X', 'Event hidden and registration closed')], help_text='Set the registration status and visibility status of this event.', max_length=1, verbose_name='Registration status'),
        ),
        migrations.AlterField(
            model_name='event',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='eventsubmissions', to=settings.AUTH_USER_MODEL, verbose_name='Submitted by user'),
        ),
        migrations.AlterField(
            model_name='event',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Unique link ID'),
        ),
        migrations.AlterField(
            model_name='event',
            name='year',
            field=models.SmallIntegerField(blank=True, null=True, verbose_name='Year'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='cssClasses',
            field=models.CharField(blank=True, help_text='Classes are applied to surrounding &lt;div&gt;', max_length=250, null=True, verbose_name='Custom CSS classes'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='eventType',
            field=models.CharField(blank=True, choices=[('S', 'Class Series'), ('P', 'Public Events')], help_text='Leave blank to include all Events.', max_length=1, null=True, verbose_name='Limit to event type'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location', verbose_name='Limit to location'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='template',
            field=models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='title',
            field=models.CharField(blank=True, default='Upcoming Events', max_length=250, verbose_name='Custom list title'),
        ),
        migrations.AlterField(
            model_name='eventlistpluginmodel',
            name='weekday',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'Monday'), (1, 'Tuesday'), (2, 'Wednesday'), (3, 'Thursday'), (4, 'Friday'), (5, 'Saturday'), (6, 'Sunday')], null=True, verbose_name='Limit to weekday'),
        ),
        migrations.AlterField(
            model_name='eventoccurrence',
            name='cancelled',
            field=models.BooleanField(default=False, help_text='Check this box to mark that the class or event was cancelled.', verbose_name='Cancelled'),
        ),
        migrations.AlterField(
            model_name='eventoccurrence',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Series/Event'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='cancelled',
            field=models.BooleanField(default=False, help_text='Mark as cancelled so that this registration is not counted in student/attendee counts.', verbose_name='Cancelled'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer', verbose_name='Customer'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='data',
            field=models.JSONField(default=dict, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='price',
            field=models.FloatField(default=0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price before discounts'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Registration', verbose_name='Registration'),
        ),
        migrations.AlterField(
            model_name='eventregistration',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole', verbose_name='Dance role'),
        ),
        migrations.AlterField(
            model_name='eventstaffcategory',
            name='defaultRate',
            field=models.FloatField(blank=True, help_text='If the financials app is enabled with automatic generation of expense items, then this is the rate that will be used for staff payments for staff of this type.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Default rate'),
        ),
        migrations.AlterField(
            model_name='eventstaffcategory',
            name='name',
            field=models.CharField(max_length=50, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='eventstaffmember',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.EventStaffCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='eventstaffmember',
            name='creationDate',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Creation date'),
        ),
        migrations.AlterField(
            model_name='eventstaffmember',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='eventstaffmember',
            name='modifyDate',
            field=models.DateTimeField(auto_now=True, verbose_name='Last modified date'),
        ),
        migrations.AlterField(
            model_name='eventstaffmember',
            name='occurrences',
            field=models.ManyToManyField(blank=True, to='core.EventOccurrence', verbose_name='Applicable event occurrences'),
        ),
        migrations.AlterField(
            model_name='instructor',
            name='availableForPrivates',
            field=models.BooleanField(default=True, help_text='Check this box if you would like to be listed as available for private lessons from students.', verbose_name='Available For private lessons'),
        ),
        migrations.AlterField(
            model_name='instructor',
            name='status',
            field=models.CharField(choices=[('R', 'Regular Instructor'), ('A', 'Assistant Instructor'), ('T', 'Instructor-in-training'), ('G', 'Guest Instructor'), ('Z', 'Former Guest Instructor'), ('X', 'Former/Retired Instructor'), ('H', 'Publicly Hidden')], default='R', help_text='Instructor status affects the visibility of the instructor on the site and may also impact the pay rate of the instructor.', max_length=1, verbose_name='Instructor status'),
        ),
        migrations.AlterField(
            model_name='invoice',
            name='data',
            field=models.JSONField(default=dict, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='invoice',
            name='id',
            field=models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='Invoice number'),
        ),
        migrations.AlterField(
            model_name='invoice',
            name='submissionUser',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='submittedinvoices', to=settings.AUTH_USER_MODEL, verbose_name='Registered by user'),
        ),
        migrations.AlterField(
            model_name='invoiceitem',
            name='id',
            field=models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='Invoice item number'),
        ),
        migrations.AlterField(
            model_name='location',
            name='address',
            field=models.CharField(blank=True, help_text="Enter the location's street address.", max_length=50, null=True, verbose_name='Street address'),
        ),
        migrations.AlterField(
            model_name='location',
            name='city',
            field=models.CharField(default='Cambridge', max_length=30, verbose_name='City'),
        ),
        migrations.AlterField(
            model_name='location',
            name='directions',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text='Insert any detailed directions that you would like here.  Use HTML to include videos, formatting, etc.', null=True, verbose_name='Directions'),
        ),
        migrations.AlterField(
            model_name='location',
            name='name',
            field=models.CharField(help_text='Give this location a name.', max_length=80, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='location',
            name='orderNum',
            field=models.FloatField(default=0, help_text='This determines the order that the locations show up on the Locations page.', verbose_name='Order number'),
        ),
        migrations.AlterField(
            model_name='location',
            name='status',
            field=models.CharField(choices=[('A', 'Active Location'), ('F', 'Former Location'), ('S', 'Special Event Location (not shown by default)')], default='A', help_text='Is this location used regularly, used for special events, or no longer used?', max_length=1, verbose_name='Status'),
        ),
        migrations.AlterField(
            model_name='locationlistpluginmodel',
            name='template',
            field=models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template'),
        ),
        migrations.AlterField(
            model_name='locationpluginmodel',
            name='template',
            field=models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template'),
        ),
        migrations.AlterField(
            model_name='publicevent',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PublicEventCategory', verbose_name='Category'),
        ),
        migrations.AlterField(
            model_name='publicevent',
            name='link',
            field=models.URLField(blank=True, help_text="Optionally include the URL to a page for this Event.  If set, then the site's auto-generated Event page will instead redirect to this URL.", null=True, verbose_name='External link to event (if applicable)'),
        ),
        migrations.AlterField(
            model_name='publicevent',
            name='slug',
            field=models.SlugField(help_text='This is for the event page URL, you can override the default.', max_length=100, verbose_name='Slug'),
        ),
        migrations.AlterField(
            model_name='publicevent',
            name='title',
            field=models.CharField(help_text='Give the event a title', max_length=100, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='publiceventcategory',
            name='description',
            field=models.TextField(blank=True, help_text='Add an optional description.', null=True, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='publiceventcategory',
            name='displayColor',
            field=colorful.fields.RGBColorField(default='#0000FF', verbose_name='Calendar display color'),
        ),
        migrations.AlterField(
            model_name='publiceventcategory',
            name='name',
            field=models.CharField(help_text='Category name will be displayed.', max_length=100, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='comments',
            field=models.TextField(blank=True, default='', null=True, verbose_name='Comments'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer', verbose_name='Customer'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='data',
            field=models.JSONField(blank=True, null=True, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='dateTime',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Registration date/time'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='firstName',
            field=models.CharField(default='TBD', max_length=100, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='lastName',
            field=models.CharField(default='TBD', max_length=100, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='payAtDoor',
            field=models.BooleanField(default=False, verbose_name='At-the-door registration'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='priceWithDiscount',
            field=models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price net of discounts'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='student',
            field=models.BooleanField(default=False, verbose_name='Eligible for student discount'),
        ),
        migrations.AlterField(
            model_name='registration',
            name='temporaryRegistration',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration', verbose_name='Associated temporary registration'),
        ),
        migrations.AlterField(
            model_name='series',
            name='allowDropins',
            field=models.BooleanField(default=False, help_text='If checked, then staff will be able to register students as drop-ins.', verbose_name='Allow class drop-ins'),
        ),
        migrations.AlterField(
            model_name='series',
            name='classDescription',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ClassDescription', verbose_name='Class description'),
        ),
        migrations.AlterField(
            model_name='series',
            name='pricingTier',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Pricing tier'),
        ),
        migrations.AlterField(
            model_name='series',
            name='special',
            field=models.BooleanField(default=False, help_text='Special classes (e.g. one-offs, visiting instructors) may be listed separately on the class page.  Leave this unchecked for regular monthly series classes.', verbose_name='Special class/series'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='bio',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, help_text="Insert the instructor's bio here.  Use HTML to include videos, formatting, etc.", null=True, verbose_name='Bio text'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='feedKey',
            field=models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Calendar/RSS feed key'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='firstName',
            field=models.CharField(blank=True, max_length=50, null=True, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='image',
            field=filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='staff_image', to='filer.Image', verbose_name='Staff photo'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='lastName',
            field=models.CharField(blank=True, max_length=50, null=True, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='phone',
            field=models.CharField(blank=True, help_text='Instructor phone numbers are for the instructor directory only, and should not be given to students.', max_length=25, null=True, verbose_name='Telephone'),
        ),
        migrations.AlterField(
            model_name='staffmember',
            name='userAccount',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User account'),
        ),
        migrations.AlterField(
            model_name='staffmemberpluginmodel',
            name='staffMember',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.StaffMember', verbose_name='Staff member'),
        ),
        migrations.AlterField(
            model_name='staffmemberpluginmodel',
            name='template',
            field=models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template'),
        ),
        migrations.AlterField(
            model_name='temporaryeventregistration',
            name='data',
            field=models.JSONField(default=dict, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='temporaryeventregistration',
            name='event',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Event', verbose_name='Event'),
        ),
        migrations.AlterField(
            model_name='temporaryeventregistration',
            name='price',
            field=models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price before discounts'),
        ),
        migrations.AlterField(
            model_name='temporaryeventregistration',
            name='registration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration', verbose_name='Associated temporary registration'),
        ),
        migrations.AlterField(
            model_name='temporaryeventregistration',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.DanceRole', verbose_name='Dance role'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='comments',
            field=models.TextField(default='', verbose_name='Comments'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='data',
            field=models.JSONField(blank=True, null=True, verbose_name='Additional data'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='dateTime',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Registration date/time'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='email',
            field=models.CharField(max_length=200, verbose_name='Email address'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='firstName',
            field=models.CharField(max_length=100, verbose_name='First name'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='lastName',
            field=models.CharField(max_length=100, verbose_name='Last name'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='payAtDoor',
            field=models.BooleanField(default=False, verbose_name='At-the-door registration'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='phone',
            field=models.CharField(blank=True, max_length=20, null=True, verbose_name='Telephone'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='priceWithDiscount',
            field=models.FloatField(null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price net of discounts'),
        ),
        migrations.AlterField(
            model_name='temporaryregistration',
            name='student',
            field=models.BooleanField(default=False, verbose_name='Eligible for student discount'),
        ),
    ]
