# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-25 00:10
from __future__ import unicode_literals

import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.file


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('filer', '0007_auto_20161016_1055'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExpenseCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Different types of tasks and payments should have different category names', max_length=50, unique=True)),
                ('defaultRate', models.FloatField(blank=True, help_text='This is the default hourly payment rate for this type of task.  For staff expenses and venue rentals, this will be overridden by the rate specified as default for the venue or staff type.', null=True, validators=[django.core.validators.MinValueValidator(0)])),
            ],
            options={
                'verbose_name_plural': 'Expense categories',
            },
        ),
        migrations.CreateModel(
            name='ExpenseItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submissionDate', models.DateTimeField(default=datetime.datetime.now)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('hours', models.FloatField(blank=True, help_text='Please indicate the number of hours to be paid for.', null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('wageRate', models.FloatField(blank=True, help_text='This should be filled automatically, but can be changed as needed.', null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('total', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)])),
                ('adjustments', models.FloatField(default=0, help_text='Record any ex-post adjustments to the amount (e.g. refunds) in this field. A positive amount increases the netExpense, a negative amount reduces the netExpense.')),
                ('fees', models.FloatField(default=0, help_text='The sum of any transaction fees (e.g. Paypal fees) that were paid <strong>by us</strong>, and should therefore be added to net expense.')),
                ('paymentMethod', models.IntegerField(blank=True, choices=[(None, '-----'), (1, 'Cash'), (2, 'Paypal'), (3, 'Venmo'), (4, 'Bank/Debit Card'), (5, 'Check')], null=True, verbose_name='Payment Method')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Comments/Notes')),
                ('payToName', models.CharField(blank=True, max_length=30, null=True)),
                ('reimbursement', models.BooleanField(default=False, help_text='Check to indicate that this is a reimbursement expense (i.e. not compensation).')),
                ('approved', models.BooleanField(default=False, help_text='Check to indicate that expense is approved for payment.')),
                ('paid', models.BooleanField(default=False, help_text='Check to indicate that payment has been made.')),
                ('approvalDate', models.DateTimeField(blank=True, null=True)),
                ('paymentDate', models.DateTimeField(blank=True, null=True)),
                ('accrualDate', models.DateTimeField()),
            ],
            options={
                'permissions': (('mark_expenses_paid', 'Mark expenses as paid at the time of submission'),),
                'ordering': ['-accrualDate'],
            },
        ),
        migrations.CreateModel(
            name='RevenueCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Different types of revenue fall under different categories.', max_length=50, unique=True)),
                ('defaultAmount', models.FloatField(blank=True, help_text='This is the default amount of revenue for items in this category.', null=True, validators=[django.core.validators.MinValueValidator(0)])),
            ],
            options={
                'verbose_name_plural': 'Revenue categories',
            },
        ),
        migrations.CreateModel(
            name='RevenueItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submissionDate', models.DateTimeField(default=datetime.datetime.now)),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('total', models.FloatField(help_text='The total revenue received, net of any discounts or voucher uses.  This is what we actually receive.', validators=[django.core.validators.MinValueValidator(0)])),
                ('grossTotal', models.FloatField(help_text='The gross total billed before the application of any discounts, or the use of any vouchers.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Gross Total')),
                ('adjustments', models.FloatField(default=0, help_text='Record any ex-post adjustments to the amount (e.g. refunds) in this field.  A positive amount increases the netRevenue, a negative amount reduces the netRevenue.')),
                ('fees', models.FloatField(default=0, help_text='The sum of any transaction fees (e.g. Paypal fees) that were paid <strong>by us</strong>, and should therefore be subtracted from net revenue.')),
                ('paymentMethod', models.IntegerField(choices=[(None, '-----'), (1, 'Cash'), (2, 'Paypal'), (3, 'Venmo'), (4, 'Bank/Debit Card'), (5, 'Check')], default=1, verbose_name='Payment Method')),
                ('invoiceNumber', models.CharField(blank=True, help_text='For Paypal payments, this will be the txn_id.  For cash payments, this will be automatically generated by the submission form.  More than one revenue item may have the same invoice number, because multiple events are paid for in one Paypal transaction.', max_length=80, null=True, verbose_name='Invoice Number')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Comments/Notes')),
                ('receivedFromName', models.CharField(blank=True, help_text='Enter who this revenue item was received from, if it is not associated with an existing registration.', max_length=50, null=True, verbose_name='Received From')),
                ('received', models.BooleanField(default=False, help_text='Check to indicate that payment has been received. Non-received payments are considered pending.')),
                ('receivedDate', models.DateTimeField(blank=True, null=True)),
                ('accrualDate', models.DateTimeField()),
                ('attachment', filer.fields.file.FilerFileField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='revenue_attachment', to='filer.File', verbose_name='Attach File (optional)')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='financial.RevenueCategory')),
                ('currentlyHeldBy', models.ForeignKey(blank=True, help_text='If cash has not yet been deposited, this indicates who to contact in order to collect the cash for deposit.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='revenuesheldby', to=settings.AUTH_USER_MODEL, verbose_name='Cash currently in possession of')),
                ('event', models.ForeignKey(blank=True, help_text='If this item is associated with an Event, enter it here.', null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Event')),
                ('eventregistration', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.EventRegistration')),
            ],
            options={
                'permissions': (('export_financial_data', 'Export detailed financial transaction information to CSV'), ('view_finances_bymonth', 'View school finances month-by-month'), ('view_finances_byevent', 'View school finances by Event'), ('view_finances_detail', 'View school finances as detailed statement'), ('process_registration_refunds', 'Process registration refunds')),
                'ordering': ['-accrualDate'],
            },
        ),
    ]
