# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-08-23 10:47
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0014_auto_20170821_1226'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('financial', '0006_auto_20170815_2235'),
    ]

    operations = [
        migrations.CreateModel(
            name='GenericRepeatedExpense',
            fields=[
                ('repeatedexpenserule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='financial.RepeatedExpenseRule')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='Give this expense generation rule a name')),
                ('payToName', models.CharField(blank=True, max_length=50, null=True, verbose_name='Pay to (enter name)')),
                ('markApproved', models.BooleanField(default=False, verbose_name='Automatically mark this expense as approved')),
                ('markPaid', models.BooleanField(default=False, verbose_name='Automatically mark this expense as paid')),
                ('paymentMethod', models.CharField(blank=True, help_text='This field is ignored unless you have chosen to automatically mark expenses as paid.', max_length=50, null=True, verbose_name='Payment method')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='financial.ExpenseCategory', verbose_name='Category')),
                ('payToLocation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Location', verbose_name='Pay to location')),
                ('payToUser', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Pay to user')),
            ],
            options={
                'verbose_name': 'Other repeated expense',
                'ordering': ('name',),
                'verbose_name_plural': 'Other repeated expenses',
            },
            bases=('financial.repeatedexpenserule',),
        ),
        migrations.AddField(
            model_name='repeatedexpenserule',
            name='disabled',
            field=models.BooleanField(default=False, help_text='It is recommended to disable expense rules rather than delete them for temporary purposes, to avoid the creation of duplicate expense items.', verbose_name='Disable autogeneration of expenses under this rule'),
        ),
        migrations.AddField(
            model_name='repeatedexpenserule',
            name='lastRun',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Last run time'),
        ),
        migrations.AlterField(
            model_name='repeatedexpenserule',
            name='applyRateRule',
            field=models.CharField(choices=[('H', 'Per hour'), ('D', 'Per day of scheduled events'), ('W', 'Per week'), ('M', 'Per month')], default='H', max_length=1, verbose_name='Apply this rate'),
        ),
        migrations.AlterField(
            model_name='repeatedexpenserule',
            name='endDate',
            field=models.DateField(blank=True, help_text='If specified, then expense items will not be generated after this date.  Leave blank for expenses to be generated indefinitely.', null=True, verbose_name='End date'),
        ),
    ]
