# Generated by Django 2.2.17 on 2021-02-04 00:49

import danceschool.merch.models
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('core', '0037_remove_registration_expirationdate'),
        ('cms', '0022_auto_20180620_1551'),
        ('register', '0006_doorregisterguestsearchpluginmodel'),
    ]

    operations = [
        migrations.CreateModel(
            name='MerchItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Give a descriptive name for this item.', max_length=100, verbose_name='Name')),
                ('description', models.TextField(blank=True, help_text='Provide a full item description for customers.', null=True, verbose_name='Item Description')),
                ('defaultPrice', models.FloatField(default=0, help_text='This price may be overridden by a particular item variant.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Default price')),
                ('salesTaxRate', models.FloatField(default=danceschool.merch.models.get_defaultSalesTaxRate, help_text="The sales tax percentage rate to be applied to this item (e.g. enter '10' to apply 10 percent sales tax).", validators=[django.core.validators.MinValueValidator(0)], verbose_name='Sales tax rate')),
                ('disabled', models.BooleanField(default=False, help_text='If checked, then this item will not be available for purchase, regardless of current inventory.', verbose_name='Item disabled')),
                ('creationDate', models.DateTimeField(auto_now_add=True, verbose_name='Creation Date')),
            ],
            options={
                'verbose_name': 'Merchandise item',
                'verbose_name_plural': 'Merchandise items',
            },
        ),
        migrations.CreateModel(
            name='MerchItemCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Give a descriptive name for this category.', max_length=100, verbose_name='Name')),
            ],
            options={
                'verbose_name': 'Merchandise category',
                'verbose_name_plural': 'Merchandise category',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MerchItemVariant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sku', models.CharField(help_text='The SKU for this item variant.', max_length=100, unique=True, validators=[django.core.validators.RegexValidator(regex='^[a-zA-Z\\-_0-9]+$')], verbose_name='SKU')),
                ('name', models.CharField(blank=True, help_text='Give a unique name for this variant (e.g. "Size Medium")', max_length=100, null=True, verbose_name='Name')),
                ('price', models.FloatField(blank=True, help_text='If specified, then price supercedes the item default price.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Price')),
                ('originalQuantity', models.PositiveIntegerField(help_text='For inventory purposes, enter an initial quantity here', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Original Quantity')),
                ('soldOut', models.BooleanField(default=False, verbose_name='Sold out')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='item_variant', to='merch.MerchItem', verbose_name='Item')),
                ('photo', filer.fields.image.FilerImageField(blank=True, help_text='A photo specific to this variant, if applicable.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='itemvariant_photo', to=settings.FILER_IMAGE_MODEL, verbose_name='Photo')),
            ],
            options={
                'verbose_name': 'Item variant',
                'verbose_name_plural': 'Item variants',
                'unique_together': {('item', 'name')},
            },
        ),
        migrations.CreateModel(
            name='MerchOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('UN', 'Not yet submitted'), ('SU', 'Submitted'), ('AP', 'Approved for fulfillment'), ('F', 'Fulfilled'), ('C', 'Cancelled'), ('R', 'Refunded in full')], default='UN', help_text='Use the order status to keep track of submission, processing, shipment (if applicable), and fulfillment.', max_length=2, verbose_name='Order status')),
                ('creationDate', models.DateTimeField(auto_now_add=True, verbose_name='Creation Date')),
                ('lastModified', models.DateTimeField(auto_now=True, verbose_name='Last Modified Date')),
                ('invoice', models.OneToOneField(help_text='All merchandise orders must be associated with an invoice.', on_delete=django.db.models.deletion.CASCADE, related_name='merchOrder', to='core.Invoice')),
            ],
            options={
                'verbose_name': 'Merchandise order',
                'verbose_name_plural': 'Merchandise orders',
            },
        ),
        migrations.CreateModel(
            name='MerchQuantityAdjustment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.IntegerField(default=0, verbose_name='Change in inventory quantity')),
                ('submissionDate', models.DateTimeField(auto_now_add=True, verbose_name='Submission Date')),
                ('variant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='quantity_adjustments', to='merch.MerchItemVariant')),
            ],
        ),
        migrations.CreateModel(
            name='MerchOrderItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.PositiveIntegerField(default=1, verbose_name='Quantity')),
                ('invoiceItem', models.OneToOneField(help_text='All merchandise orders must be associated with an invoice.', on_delete=django.db.models.deletion.CASCADE, to='core.InvoiceItem')),
                ('item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orders', to='merch.MerchItemVariant', verbose_name='Item')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='merch.MerchOrder')),
            ],
            options={
                'verbose_name': 'Merchandise order item',
                'verbose_name_plural': 'Merchandise order items',
            },
        ),
        migrations.AddField(
            model_name='merchitem',
            name='category',
            field=models.ForeignKey(help_text='Used on product pages to determine what items to list.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='merch.MerchItemCategory'),
        ),
        migrations.AddField(
            model_name='merchitem',
            name='photo',
            field=filer.fields.image.FilerImageField(blank=True, help_text='Individual item variants may have their own photos.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='item_photo', to=settings.FILER_IMAGE_MODEL, verbose_name='Photo'),
        ),
        migrations.CreateModel(
            name='DoorRegisterMerchPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='merch_doorregistermerchpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(blank=True, default='Merchandise', max_length=250, verbose_name='Custom list title')),
                ('separateVariants', models.BooleanField(default=False, verbose_name='Display item variants as separate items')),
                ('displaySoldOut', models.BooleanField(default=False, verbose_name='Display items and variants that are sold out')),
                ('requireFullRegistration', models.BooleanField(blank=True, default=True, help_text='If checked, then the user will be sent to the second page of the registration process to provide name and email. Particular payment methods may also require the full registration process.', verbose_name='Require full registration')),
                ('template', models.CharField(blank=True, max_length=250, null=True, verbose_name='Plugin template')),
                ('cssClasses', models.CharField(blank=True, help_text='Classes are applied to surrounding &lt;div&gt;', max_length=250, null=True, verbose_name='Custom CSS classes')),
                ('categories', models.ManyToManyField(blank=True, help_text='Leave blank for no restriction', to='merch.MerchItemCategory', verbose_name='Limit to merchandise categories')),
                ('paymentMethods', models.ManyToManyField(blank=True, help_text='If you would like separate buttons for individual payment methods, then select them here.  If left blank, a single button will be shown and no payment method will be specified.', to='register.DoorRegisterPaymentMethod', verbose_name='Payment Methods')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
